<?php

namespace Market\ZodacoBundle;

class VNGate {

    //For Gateway VN
    //Bao Kim
    const BAO_KIM_ID = "";
    const BAO_KIM_PASSPHARSE = "";
    const BAO_KIM_EMAIL = "";
    //Ngan Luong
    const NGAN_LUONG_ID = "";
    const NGAN_LUONG_PASSPHARSE = "";
    const NGAN_LUONG_EMAIL = "";
    // URL chheckout của nganluong.vn
    const nganluong_url = 'https://www.nganluong.vn/checkout.php';
    // URL checkout của baokim.vn
    const baokim_url = 'https://www.baokim.vn/payment/customize_payment/order';

    /**
     * Hàm xây dựng url chuyển đến BaoKim.vn thực hiện thanh toán, trong đó có tham số mã hóa (còn gọi là public key)
     * @param $order_id				Mã đơn hàng
     * @param $business 			Email tài khoản người bán
     * @param $total_amount			Giá trị đơn hàng
     * @param $shipping_fee			Phí vận chuyển
     * @param $tax_fee				Thuế
     * @param $order_description	Mô tả đơn hàng
     * @param $url_success			Url trả về khi thanh toán thành công
     * @param $url_cancel			Url trả về khi hủy thanh toán
     * @param $url_detail			Url chi tiết đơn hàng
     * @return url cần tạo
     */
    public static function createRequestUrl($order_id, $total_amount, $shipping_fee, $tax_fee, $order_description, $url_success, $url_cancel, $url_detail) {
        // Mảng các tham số chuyển tới baokim.vn
        $params = array(
            'merchant_id' => strval(self::BAO_KIM_ID),
            'order_id' => strval($order_id),
            'business' => strval(self::BAO_KIM_EMAIL),
            'total_amount' => strval($total_amount),
            'shipping_fee' => strval($shipping_fee),
            'tax_fee' => strval($tax_fee),
            'order_description' => strval($order_description),
            'url_success' => strtolower($url_success),
            'url_cancel' => strtolower($url_cancel),
            'url_detail' => strtolower($url_detail)
        );
        ksort($params);

        $str_combined = self::BAO_KIM_PASSPHARSE . implode('', $params);
        $params['checksum'] = strtoupper(md5($str_combined));

        //Kiểm tra  biến $redirect_url xem có '?' không, nếu không có thì bổ sung vào
        $redirect_url = self::baokim_url;
        if (strpos($redirect_url, '?') === false) {
            $redirect_url .= '?';
        } else if (substr($redirect_url, strlen($redirect_url) - 1, 1) != '?' && strpos($redirect_url, '&') === false) {
            // Nếu biến $redirect_url có '?' nhưng không kết thúc bằng '?' và có chứa dấu '&' thì bổ sung vào cuối
            $redirect_url .= '&';
        }

        // Tạo đoạn url chứa tham số
        $url_params = '';
        foreach ($params as $key => $value) {
            if ($url_params == '')
                $url_params .= $key . '=' . urlencode($value);
            else
                $url_params .= '&' . $key . '=' . urlencode($value);
        }
//        return $redirect_url . $url_params;
        
        header("Location: " . $redirect_url . $url_params);
    }

    /**
     * Hàm thực hiện xác minh tính chính xác thông tin trả về từ BaoKim.vn
     * @param $_GET chứa tham số trả về trên url
     * @return true nếu thông tin là chính xác, false nếu thông tin không chính xác
     */
    public function verifyResponseUrl2($GET = array()) {
        $checksum = $GET['checksum'];
        unset($GET['checksum']);

        ksort($GET);
        $str_combined = self::BAO_KIM_PASSPHARSE . implode('', $GET);

        // Mã hóa các tham số
        $verify_checksum = strtoupper(md5($str_combined));

        // Xác thực mã của chủ web với mã trả về từ baokim.vn
        if ($verify_checksum === $checksum)
            return true;

        return false;
    }
    
    public static function sendPostRequest($ipnLink, $postData) {
        $ch = curl_init($ipnLink);
        //'http://sandbox.baokim.vn/bpn/verify'
        curl_setopt($ch, CURLOPT_POST, 1);
//        $postData = "created_on=1287729470&customer_address=Dia+Chi+Khach+Hang&customer_email=khoinm%40baokim.vn&customer_name=Nguyen+Minh+Khoi&customer_phone=84987654321&fee_amount=1000&merchant_address=Dia+Chi+Cong+Ty&merchant_email=hangntt%40baokim.vn&merchant_id=8&merchant_name=Nguyen+Thi+Thu+Hang&merchant_phone=84981234567&net_amount=99000&order_id=100139&payment_type=2&total_amount=100000.00&transaction_id=2506B4F7E6E6C&transaction_status=4&resend=true&verify_sign=2IsQX54QVnYrU2wpsaWJCusC1veXr0vu2auZ451trdoA6";
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $res = curl_exec($ch);
        curl_close($ch);

        return trim($res);
    }
    
     public static function verifyResponseUrl($url_params = array()) {
        if (empty($url_params['checksum'])) {
            echo "invalid parameters: checksum is missing";
            return FALSE;
        }

        $checksum = $url_params['checksum'];
        unset($url_params['checksum']);

        ksort($url_params);

        if (strcasecmp($checksum, hash_hmac('SHA1', implode('', $url_params), self::secure_pass)) === 0)
            return TRUE;
        else
            return FALSE;
    }

    public static function buildCheckoutUrl($return_url, $transaction_info, $order_code, $price) {

        // Mảng các tham số chuyển tới nganluong.vn
        $arr_param = array(
            'merchant_site_code' => strval(self::NGAN_LUONG_ID),
            'return_url' => strtolower(urlencode($return_url)),
            'receiver' => strval(self::NGAN_LUONG_EMAIL),
            'transaction_info' => strval($transaction_info),
            'order_code' => strval($order_code),
            'price' => strval($price)
        );
        $secure_code = '';
        $secure_code = implode(' ', $arr_param) . ' ' . self::NGAN_LUONG_PASSPHARSE;
        $arr_param['secure_code'] = md5($secure_code);

        /* Bước 2. Kiểm tra  biến $redirect_url xem có '?' không, nếu không có thì bổ sung vào */
        $redirect_url = self::nganluong_url;
        if (strpos($redirect_url, '?') === false) {
            $redirect_url .= '?';
        } else if (substr($redirect_url, strlen($redirect_url) - 1, 1) != '?' && strpos($redirect_url, '&') === false) {
            // Nếu biến $redirect_url có '?' nhưng không kết thúc bằng '?' và có chứa dấu '&' thì bổ sung vào cuối
            $redirect_url .= '&';
        }

        /* Bước 3. tạo url */
        $url = '';
        foreach ($arr_param as $key => $value) {
            if ($url == '')
                $url .= $key . '=' . $value;
            else
                $url .= '&' . $key . '=' . $value;
        }

        header("Location: " . $redirect_url . $url);

        //return $redirect_url . $url;
    }

    /* Hàm thực hiện xác minh tính đúng đắn của các tham số trả về từ nganluong.vn */

    public static function verifyPaymentUrl($transaction_info, $order_code, $price, $payment_id, $payment_type, $error_text, $secure_code) {
        // Tạo mã xác thực từ chủ web
        $str = '';
        $str .= ' ' . strval($transaction_info);
        $str .= ' ' . strval($order_code);
        $str .= ' ' . strval($price);
        $str .= ' ' . strval($payment_id);
        $str .= ' ' . strval($payment_type);
        $str .= ' ' . strval($error_text);
        $str .= ' ' . strval(self::NGAN_LUONG_ID);
        $str .= ' ' . strval(self::NGAN_LUONG_PASSPHARSE);

        // Mã hóa các tham số
        $verify_secure_code = '';
        $verify_secure_code = md5($str);

        // Xác thực mã của chủ web với mã trả về từ nganluong.vn
        if ($verify_secure_code === $secure_code)
            return true;

        return false;
    }

}
