<?php
$view->extend('MarketZodacoBundle::base.html.php');

$view['slots']->set('title', $view['translator']->trans("Portfolio") . " - " . $cat->getUsername() . " | " . $view['translator']->trans("Zodaco Market"));
?>
<div class="col-sm-12 col-lg-12 main" id="mainContents">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 no-padding">
                <?php if ($error) { ?>
                    <div class="col-lg-12">
                        <?php if ($error == 1) { ?>
                            <div class="alert bg-danger" role="alert">
                                <ul>
                                    <li><?php echo $view['translator']->trans("Error! Please try again."); ?></li>
                                </ul>
                            </div>
                        <?php } ?>
                        <?php if ($error == 2) { ?>
                            <div class="alert bg-success" role="alert">
                                <ul>
                                    <li><?php echo $view['translator']->trans("Send contact success!"); ?></li>
                                </ul>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
                <?php
                if ($list) {
                    foreach ($list as $value1) {
                        $url = $view['router']->generate('view_products', array('id' => $value1->getId(), 'title' => Market\ZodacoBundle\System::_reString($value1->getTitle())), true);
                        ?>
                        <div class="col-lg-4">
                            <div class="panel panel-default itemBorder">
                                <div class="panel-body itemList">
                                    <div class="preview">
                                        <a href="<?php echo $url; ?>"><img class="tool" title="<?php echo $value1->getShortDetails(); ?>" src="<?php echo $view->escape('/uploads/items/'); ?><?php echo $value1->getPreview(); ?>" ></a>
                                    </div>
                                    <div class="thumbnail1">
                                        <a href="<?php echo $url; ?>"><img class="tool" title="<?php echo $value1->getTitle(); ?>" src="<?php echo $view->escape('/uploads/items/'); ?><?php echo $value1->getIcon(); ?>" ></a>
                                    </div>
                                    <div class="details">
                                        <a href="<?php echo $url; ?>"><?php echo $value1->getTitle(); ?></a>
                                    </div>
                                    <div class="short_details">
                                        <?php echo $value1->getShortDetails(); ?>
                                    </div>
                                    <div class="sub_category">
                                        <a href="<?php echo $view['router']->generate('view_categories', array('id' => $value1->getCategories()->getId(), 'title' => Market\ZodacoBundle\System::_reString($value1->getCategories()->getShortTitle())), true); ?>"><img src="<?php echo $view->escape('/uploads/categories/'); ?><?php echo $value1->getCategories()->getSmallIcon(); ?>" class="tool" title="<?php echo $value1->getCategories()->getTitle() . " : " . $value1->getCategories()->getShortTitle(); ?>"></a>
                                        <p><?php echo $view['translator']->trans("$"); ?><?php echo number_format($value1->getPrice(), 2); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    ?>
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <center><?php echo $view['translator']->trans("No Data"); ?></center>
                        </div>
                    </div>
                <?php }
                ?>
                <?php
                if ($page["NextPage"] > 1):
                    $urlNext = $view['router']->generate('portfolio', array('title' => $cat->getUsername()), true);
                    ?>
                    <div class="pull-right pagination" style="width: 100%; display: block;">
                        <ul class="pagination">
                            <?php if ($page["PreviousPage"] != $page["Page"]): ?>
                                <li class="page-pre"><a href="<?php echo $urlNext . '?p=' . $page["PreviousPage"]; ?>">&lt;</a></li>
                            <?php endif; ?>
                            <li class="page-number"><a href="javascript:void(0)"><?php echo $page["Page"] ?></a></li>
                            <?php if ($page["LastPage"] > $page["Page"]): ?>
                                <li class="page-next"><a href="<?php echo $urlNext . '?p=' . $page["NextPage"]; ?>">&gt;</a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-lg-3 no-padding">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-body detailProducts"> 
                            <div class="avatar" style="width: 80px; height: 80px; float: left;padding: 0px;">
                                <a><img src="<?php echo $view->escape('/assetic/images/default-user.jpg'); ?>" style="min-height: 100%;"/></a>
                            </div> 
                            <div class="nameUser" style="float: left; margin-left: 10px;font-size: 18px;">
                                <a style="display: block;font-size: 14px;"><?php echo $cat->getFname() . " " . $cat->getLname(); ?></a>
                                <a style="display: block;">@<?php echo $cat->getUsername(); ?></a>
                            </div>
                        </div>
                    </div>
                    <div class="panel panel-default">
                        <div class="panel-body detailProducts"> 
                            <div class="total_sale">
                                <i class="fa fa-calendar"></i> <?php echo $view['translator']->trans("Join"); ?> <?php
                                echo $cat->getCreatedAt()->format("Y");
                                ;
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="panel panel-default">
                        <div class="panel-body detailProducts"> 
                            <div class="total_sale">
                                <i class="fa fa-shopping-cart"></i> <span><?php echo number_format($cat->getTotalSale()); ?></span> <?php echo $view['translator']->trans("Sales"); ?>
                            </div>
                        </div>
                    </div>
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <form role="form" method="POST" action="">
                                <fieldset>
                                    <div class="form-group">
                                        <?php echo $view['translator']->trans("Email"); ?> <?php echo $cat->getUsername(); ?>
                                    </div>
                                    <hr>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("From"); ?></label>
                                        <input class="form-control" id="emm" name="emm" type="text" required <?php if ($login && $login->getEmail()) { ?>readonly <?php } ?>  value="<?php echo ($login && $login->getEmail()) ? $login->getEmail() : ""; ?>">
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Message"); ?></label>
                                        <textarea class="form-control" type="text" id="details" name="details" rows="6"></textarea>
                                    </div>
                                    <button type="submit" class="btn btn-primary"><?php echo $view['translator']->trans("Send"); ?> <i class="fa fa-envelope-o"></i></button>
                                </fieldset>
                            </form>
                        </div>
                    </div>

                </div>
            </div><!--/.row-->
        </div>
    </div>
</div>