<?php
$view->extend('MarketZodacoBundle::base.html.php');

$view['slots']->set('title', $view['translator']->trans("My Products") . " | " . $view['translator']->trans("Zodaco Market"));
?>
<div class="col-sm-12 col-lg-12 main" id="mainContents">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 no-padding">
                <?php if ($done) { ?>
                    <div class="col-lg-12">
                        <div class="alert bg-warning" role="alert">
                            <ul style="list-style: none;padding-left: 0px;">
                                <li><i class="fa fa-flag"></i> <?php echo $view['translator']->trans("Congratulation! You've upload successfully your product, we'll review it soon."); ?></li>
                            </ul>
                        </div>
                    </div>
                <?php } ?>
                <?php
                if ($list) {
                    foreach ($list as $value1) {
                        $url = $view['router']->generate('view_products', array('id' => $value1->getId(), 'title' => Market\ZodacoBundle\System::_reString($value1->getTitle())), true);
                        ?>
                        <div class="col-lg-4">
                            <div class="panel panel-default itemBorder">
                                <div class="panel-body itemList">
                                    <div class="preview">
                                        <a href="<?php echo ($value1->getActive() == 1) ? $url : ""; ?>"><img class="tool" title="<?php echo $value1->getShortDetails(); ?>" src="<?php echo ($value1->getActive() == 1) ? $view->escape('/uploads/items/') : $view->escape('/uploads/tmp/'); ?><?php echo $value1->getPreview(); ?>" ></a>
                                    </div>
                                    <div class="thumbnail1">
                                        <a href="<?php echo ($value1->getActive() == 1) ? $url : ""; ?>"><img class="tool" title="<?php echo $value1->getTitle(); ?>" src="<?php echo ($value1->getActive() == 1) ? $view->escape('/uploads/items/') : $view->escape('/uploads/tmp/'); ?><?php echo $value1->getIcon(); ?>" ></a>
                                    </div>
                                    <div class="details">
                                        <a href="<?php echo ($value1->getActive() == 1) ? $url : ""; ?>"><?php echo $value1->getTitle(); ?></a>
                                    </div>
                                    <div class="short_details">
                                        <?php if ($value1->getActive() == 0 && $value1->getStatus() == 0) { ?>
                                            <a class="btn btn-default"><?php echo $view['translator']->trans("Reviewing"); ?></a>
                                        <?php } else if ($value1->getActive() == 1) { ?>
                                            <a class="btn btn-success"><?php echo $view['translator']->trans("Approved"); ?></a>
                                            <?php if ($value1->getStatus() == 1) { ?>
                                                <a class="btn btn-default"><?php echo $view['translator']->trans("Reviewing"); ?></a>
                                            <?php } else { ?>
                                                <a href="<?php echo $view['router']->generate('edit_products', array('id' => $value1->getId()), true); ?>" class="btn btn-warning"><?php echo $view['translator']->trans("Update"); ?></a>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <a class="btn btn-danger"><?php echo $view['translator']->trans("Rejected"); ?></a>
                                        <?php } ?>
                                    </div>
                                    <div class="sub_category">
                                        <a href="<?php echo $view['router']->generate('view_categories', array('id' => $value1->getCategories()->getId(), 'title' => Market\ZodacoBundle\System::_reString($value1->getCategories()->getShortTitle())), true); ?>"><img src="<?php echo $view->escape('/uploads/categories/'); ?><?php echo $value1->getCategories()->getSmallIcon(); ?>" class="tool" title="<?php echo $value1->getCategories()->getTitle() . " : " . $value1->getCategories()->getShortTitle(); ?>"></a>
                                        <?php if ($value1->getActive() == 1) { ?>
                                            <p><?php echo $view['translator']->trans("$"); ?><?php echo number_format($value1->getPrice(), 2); ?></p>
                                            <p style="color: red;font-size: 14px;margin-right: 10px;"><?php echo number_format($value1->getTotalSale()); ?> <?php echo $view['translator']->trans("Sales"); ?></p>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    ?>
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <center><?php echo $view['translator']->trans("No Data"); ?></center>
                        </div>
                    </div>
                <?php }
                ?>
                <?php
                if ($page["NextPage"] > 1):
                    $urlNext = $view['router']->generate('my_products', array(), true);
                    ?>
                    <div class="pull-right pagination" style="width: 100%; display: block;">
                        <ul class="pagination">
                            <?php if ($page["PreviousPage"] != $page["Page"]): ?>
                                <li class="page-pre"><a href="<?php echo $urlNext . '?p=' . $page["PreviousPage"]; ?>">&lt;</a></li>
                            <?php endif; ?>
                            <li class="page-number"><a href="javascript:void(0)"><?php echo $page["Page"] ?></a></li>
                            <?php if ($page["LastPage"] > $page["Page"]): ?>
                                <li class="page-next"><a href="<?php echo $urlNext . '?p=' . $page["NextPage"]; ?>">&gt;</a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-lg-3 no-padding">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <h4><?php echo $view['translator']->trans("Trouble Uploading?"); ?></h4>
                            <span style="text-align: justify;"><?php echo $view['translator']->trans("If you have problems uploading your work have a look at our upload help page. If this doesn't solve your problem, don't be afraid to contact us."); ?></span>
                        </div>    
                    </div>
                </div>
            </div><!--/.row-->
        </div>
    </div>
</div>