<?php
$view->extend('MarketZodacoBundle::base.html.php');
?>
<?php $view['slots']->set('title', $view['translator']->trans("Upload your work") . " | " . $view['translator']->trans("Zodaco Market")) ?>
<div class="col-sm-12 col-lg-12 main" id="mainContents">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 no-padding">
                <div class="col-lg-12 no-padding-right">
                    <?php if ($error) { ?>
                        <div class="alert bg-danger" role="alert">
                            <ul>
                                <?php if ($error) { ?>
                                    <li><?php echo $view['translator']->trans("Error! Please try again."); ?></li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                    <form role="form" method="POST" action="">

                        <div class="panel panel-default">
                            <div class="panel-heading"><?php echo $view['translator']->trans("Upload your work"); ?></div>
                            <div class="panel-body">
                                <fieldset>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Title"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Title"); ?>" id="title" name="title" type="text" autofocus="" maxlength="50" required>
                                        <?php echo $view['translator']->trans("Maximum 50 characters."); ?>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Short Description"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Short Description"); ?>" id="short_title" name="short_title" type="text" maxlength="130" required>
                                        <?php echo $view['translator']->trans("Maximum 130 characters."); ?>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Description"); ?></label>
                                        <textarea class="ckeditor" type="text" id="details" name="details"></textarea>
                                        <?php echo $view['translator']->trans("Please include a detailed description with a features list, list of requirements and instructions how to use it."); ?>
                                    </div>
                                </fieldset>
                            </div>
                        </div>


                        <div class="panel panel-default">
                            <div class="panel-body">
                                <fieldset>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Icon"); ?></label>
                                        <input name="upanh" type="text" id="upanh" style="display: none;" value="" required>
                                        <?php echo $view['translator']->trans("200 x 200px icon image (.JPG or .PNG)"); ?>
                                        <br>
                                        <label id="fileContainer2" class="fileContainer">
                                            <input class="uploadImg" data-bind="200-200" type="file" name="images2" id="images2" style="display: none;"/>
                                            <?php echo $view['translator']->trans("Upload"); ?>
                                        </label>
                                        <div style="display: inline;">
                                            <img id="small_img" src="" style="display: inline; width: 36px; min-height: 36px; height: 36px; margin-bottom: 0px;">
                                        </div>
                                        <div id="response2"></div>
                                        <hr>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Image Preview"); ?></label>
                                        <?php echo $view['translator']->trans("640 x 320 preview image (.JPG or .PNG)"); ?>
                                        <input name="licon" type="text" id="licon" style="display: none;" value="" required>
                                        <br>
                                        <label id="fileContainer3" class="fileContainer">
                                            <input class="uploadImg" data-bind="640-320" type="file" name="large_icon" id="large_icon" style="display: none;"/>
                                            <?php echo $view['translator']->trans("Upload"); ?>
                                        </label>
                                        <div style="display: inline;">
                                            <img id="large_img" src="" style="display: inline; width: 80px; min-height: 40px; height: 40px; margin-bottom: 0px;">
                                        </div>
                                        <div id="response3"></div>
                                        <hr>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Screen Shoot"); ?></label>
                                        <select name="screenshot" id="screenshot" class="form-control" required>
                                            <option value="" selected="selected">---</option>
                                        </select>
                                        <?php echo $view['translator']->trans(".ZIP file with screenshot images"); ?>
                                        <br>
                                        <label id="fileContainer4" class="fileContainer">
                                            <input class="uploadScreenshot" data-bind="preview" type="file" name="uploadScreenshot" id="uploadScreenshot" style="display: none;"/>
                                            <?php echo $view['translator']->trans("Upload"); ?>
                                        </label>
                                        <div id="response4"></div>
                                        <hr>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Main File"); ?></label>
                                        <select name="main_file" id="main_file" class="form-control" required>
                                            <option value="" selected="selected">---</option>
                                        </select>
                                        <?php echo $view['translator']->trans(".ZIP file - Contains all files for buyers (don't include screenshots etc)."); ?>
                                        <br>
                                        <label id="fileContainer5" class="fileContainer">
                                            <input class="uploadMainFile" type="file" data-bind="main" name="uploadMainFile" id="uploadMainFile" style="display: none;"/>
                                            <?php echo $view['translator']->trans("Upload"); ?>
                                        </label>
                                        <div id="response5"></div>
                                        <hr>
                                    </div>
                                </fieldset>
                            </div>
                        </div>


                        <div class="panel panel-default">
                            <div class="panel-body">
                                <fieldset>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Categories"); ?></label>
                                        <select name="cid" id="cid" class="form-control" required>
                                            <option value="" selected="selected">---</option> 
                                            <?php
                                            if ($check) {
                                                foreach ($check as $key => $value) {
                                                    ?>
                                                    <option value="<?php echo $value->getId(); ?>"><?php echo $value->getTitle(); ?></option>
                                                    <?php
                                                }
                                            }
                                            ?>                            
                                        </select>
                                        <?php echo $view['translator']->trans("Don't worry if you can't find the correct category. If necessary we will create a category for your item."); ?>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Demo Url"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Demo Url"); ?>" id="demo_url" name="demo_url" type="text">
                                        <?php echo $view['translator']->trans("*Optional* link to a live preview on your own hosting (i.e. http://mysite.com/demo/)."); ?>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Video Url"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Video Url"); ?>" id="video_url" name="video_url" type="text">
                                        <?php echo $view['translator']->trans("*Optional* link to a video on Youtube (i.e. https://www.youtube.com/watch?v=QXXzCUW5U14)."); ?>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Tags"); ?></label>
                                        <textarea class="form-control" type="text" id="tags" name="tags" rows="5" required></textarea>
                                        <?php echo $view['translator']->trans("Keywords covering features, options, and style. Keywords should all be in lowercase and separated by commas. e.g. web template, photo gallery, dark, simple, real estate"); ?>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Regular license Price"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Regular license Price"); ?>" id="price" name="price" type="text" required>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Extended license Price"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Extended license Price"); ?>" id="price2" name="price2" type="text" required>
                                    </div>
                                    <div class="form-group checkbox">
                                        <label>
                                            <input id="not_own" name="not_own" type="checkbox" required>
                                            <?php echo $view['translator']->trans("Any images, sounds, video, code, flash, or other assets that are not my own work, have been appropriately licensed for use in the file preview or main download. Other than these items, this work is entirely my own and I have full rights to sell it on Marketplace."); ?>
                                        </label>
                                    </div>
                                    <button type="submit" class="btn btn-success"><?php echo $view['translator']->trans("Submit"); ?></button>
                                </fieldset>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <h4><?php echo $view['translator']->trans("Trouble Uploading?"); ?></h4>
                        <span style="text-align: justify;"><?php echo $view['translator']->trans("If you have problems uploading your work have a look at our upload help page. If this doesn't solve your problem, don't be afraid to contact us."); ?></span>
                    </div>    
                </div>
            </div>
        </div><!--/.row-->
    </div>
</div>