<?php
$view->extend('MarketZodacoBundle::base.html.php');
?>
<?php $view['slots']->set('title', $view['translator']->trans("Edit Product") . " | " . $view['translator']->trans("Update New Version") . " | " . $view['translator']->trans("Zodaco Market")) ?>
<div class="col-sm-12 col-lg-12 main" id="mainContents">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 no-padding">
                <div class="col-lg-12 no-padding-right">
                    <?php if ($error) { ?>
                        <div class="alert bg-danger" role="alert">
                            <ul>
                                <?php if ($error) { ?>
                                    <li><?php echo $view['translator']->trans("Error! Please try again."); ?></li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                    <form role="form" method="POST" action="">
                        <input name="type" type="number" value="0" style="display: none;">
                        <div class="panel panel-default">
                            <div class="panel-heading"><?php echo $view['translator']->trans("Edit Product"); ?></div>
                            <div class="panel-body">
                                <fieldset>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Short Description"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Short Description"); ?>" id="short_title" name="short_title" type="text" maxlength="130" required value="<?php echo $product->getShortDetails(); ?>">
                                        <?php echo $view['translator']->trans("Maximum 130 characters."); ?>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Description"); ?></label>
                                        <textarea class="ckeditor" type="text" id="details" name="details"><?php echo $product->getDetails(); ?></textarea>
                                        <?php echo $view['translator']->trans("Please include a detailed description with a features list, list of requirements and instructions how to use it."); ?>
                                    </div><div class="form-group">
                                        <label><?php echo $view['translator']->trans("Demo Url"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Demo Url"); ?>" id="demo_url" name="demo_url" type="text" value="<?php echo $product->getDemoUrl(); ?>">
                                        <?php echo $view['translator']->trans("*Optional* link to a live preview on your own hosting (i.e. http://mysite.com/demo/)."); ?>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Video Url"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Video Url"); ?>" id="video_url" name="video_url" type="text" value="<?php echo $product->getVideoUrl(); ?>">
                                        <?php echo $view['translator']->trans("*Optional* link to a video on Youtube (i.e. https://www.youtube.com/watch?v=QXXzCUW5U14)."); ?>
                                    </div>
                                    <button type="submit" class="btn btn-success" style="float: right;"><?php echo $view['translator']->trans("Save Change"); ?></button>
                                </fieldset>
                            </div>
                        </div>
                    </form>


                    <form role="form" method="POST" action="">
                        <input name="type" type="number" value="1" style="display: none;">
                        <div class="panel panel-default">
                            <div class="panel-heading"><?php echo $view['translator']->trans("Update New Version"); ?></div>
                            <div class="panel-body">
                                <fieldset>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Title"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Title"); ?>" id="title" name="title" type="text" maxlength="50" required value="<?php echo $product->getTitle(); ?>">
                                        <?php echo $view['translator']->trans("Maximum 50 characters."); ?>
                                    </div>

                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Icon"); ?></label>
                                        <input name="upanh" type="text" id="upanh" style="display: none;" value="">
                                        <?php echo $view['translator']->trans("200 x 200px icon image (.JPG or .PNG)"); ?>
                                        <br>
                                        <label id="fileContainer2" class="fileContainer">
                                            <input class="uploadImg" data-bind="200-200" type="file" name="images2" id="images2" style="display: none;"/>
                                            <?php echo $view['translator']->trans("Upload"); ?>
                                        </label>
                                        <div style="display: inline;">
                                            <img id="small_img" src="" style="display: inline; width: 36px; min-height: 36px; height: 36px; margin-bottom: 0px;">
                                        </div>
                                        <hr>
                                        <div id="response2"></div>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Image Preview"); ?></label>
                                        <?php echo $view['translator']->trans("640 x 320 preview image (.JPG or .PNG)"); ?>
                                        <input name="licon" type="text" id="licon" style="display: none;" value="">
                                        <br>
                                        <label id="fileContainer3" class="fileContainer">
                                            <input class="uploadImg" data-bind="640-320" type="file" name="large_icon" id="large_icon" style="display: none;"/>
                                            <?php echo $view['translator']->trans("Upload"); ?>
                                        </label>
                                        <div style="display: inline;">
                                            <img id="large_img" src="" style="display: inline; width: 80px; min-height: 40px; height: 40px; margin-bottom: 0px;">
                                        </div>
                                        <hr>
                                        <div id="response3"></div>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Screen Shoot"); ?></label>
                                        <select name="screenshot" id="screenshot" class="form-control">
                                            <option value="" selected="selected">---</option>
                                        </select>
                                        <?php echo $view['translator']->trans(".ZIP file with screenshot images"); ?>
                                        <br>
                                        <label id="fileContainer4" class="fileContainer">
                                            <input class="uploadScreenshot" data-bind="preview" type="file" name="uploadScreenshot" id="uploadScreenshot" style="display: none;"/>
                                            <?php echo $view['translator']->trans("Upload"); ?>
                                        </label>
                                        <hr>
                                        <div id="response4"></div>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Main File"); ?></label>
                                        <select name="main_file" id="main_file" class="form-control">
                                            <option value="" selected="selected">---</option>
                                        </select>
                                        <?php echo $view['translator']->trans(".ZIP file - Contains all files for buyers (don't include screenshots etc)."); ?>
                                        <br>
                                        <label id="fileContainer5" class="fileContainer">
                                            <input class="uploadMainFile" type="file" data-bind="main" name="uploadMainFile" id="uploadMainFile" style="display: none;"/>
                                            <?php echo $view['translator']->trans("Upload"); ?>
                                        </label>
                                        <hr>
                                        <div id="response5"></div>
                                    </div>
                                    <button type="submit" class="btn btn-danger" style="float: right;"><?php echo $view['translator']->trans("Submit Review"); ?></button>
                                </fieldset>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <h4><?php echo $view['translator']->trans("Trouble Uploading?"); ?></h4>
                        <span style="text-align: justify;"><?php echo $view['translator']->trans("If you have problems uploading your work have a look at our upload help page. If this doesn't solve your problem, don't be afraid to contact us."); ?></span>
                    </div>    
                </div>
            </div>
        </div><!--/.row-->
    </div>
</div>