<?php
$view->extend('MarketZodacoBundle::base.html.php');
?>
<link href="<?php echo $view->escape('/assetic/css/bootstrap-table.css'); ?>" rel="stylesheet">
<?php $view['slots']->set('title', $view['translator']->trans("Withdrawal") . " | " . $view['translator']->trans("Zodaco Market")) ?>
<div class="col-sm-12 col-lg-12 main" id="mainContents">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 no-padding">
                <div class="col-lg-12 no-padding-right">
                    <?php if ($error) { ?>
                        <div class="alert bg-danger" role="alert">
                            <ul style="list-style: none; padding-left: 0px;">
                                <li><i class="fa fa-frown-o"></i> <?php echo $view['translator']->trans("Error! Please try again."); ?></li>
                            </ul>
                        </div>
                    <?php } ?>
                    <?php if ($status) { ?>
                        <div class="alert bg-success" role="alert">
                            <ul style="list-style: none; padding-left: 0px;">
                                <li><i class="fa fa-clock-o"></i> <?php echo $view['translator']->trans("You have an Withdrawal Processing."); ?></li>
                            </ul>
                        </div>
                    <?php } else { ?>
                        <form role="form" method="POST" action="">
                            <div class="panel panel-default">
                                <div class="panel-body">
                                    <h2><?php echo $view['translator']->trans("Make a Payment Request"); ?></h2>
                                    <div style="color: red;">
                                        <?php echo $view['translator']->trans("Amount minimum to request"); ?> <?php echo $view['translator']->trans("$") . number_format($min); ?>, 
                                        <?php echo $view['translator']->trans("Withdrawal fee"); ?> <?php echo number_format($fee, 2) . $view['translator']->trans("%"); ?>
                                    </div>
                                    <br>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Amount"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("0.00"); ?>" type="text" id="amount" name="amount" required>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Email Receive Money"); ?></label>
                                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Email Receive Money"); ?>" type="email" id="email" name="email" required>
                                    </div>

                                    <div class="form-group">
                                        <label><?php echo $view['translator']->trans("Select your preferred payment method:"); ?></label>
                                        <ul style="list-style: none;">
                                            <li>  
                                                <label>
                                                    <input checked="checked" class="" name="paymentOption" type="radio" value="paypal">
                                                    <img title="<?php echo $view['translator']->trans("Pay with PayPal"); ?>" alt="<?php echo $view['translator']->trans("Pay with PayPal"); ?>" src="<?php echo $view->escape('/assetic/images/card_paypal.png'); ?>" style="width:87px; height:32px; min-height:32px; display: inline-block; margin-bottom: 0px;">
                                                </label>
                                            </li>
                                            <li>
                                                <label>
                                                    <input class="" name="paymentOption" type="radio" value="baokim">
                                                    <img title="<?php echo $view['translator']->trans("Pay with Bao Kim"); ?>" alt="<?php echo $view['translator']->trans("Pay with Bao Kim"); ?>" src="<?php echo $view->escape('/assetic/images/card_baokim.png'); ?>" style="width:87px; height:32px; min-height:32px; display: inline-block; margin-bottom: 0px;">
                                                </label>
                                            </li>
                                            <li>
                                                <label>
                                                    <input class="" name="paymentOption" type="radio" value="nganluong">
                                                    <img title="<?php echo $view['translator']->trans("Pay with Ngan Luong"); ?>" alt="<?php echo $view['translator']->trans("Pay with Ngan Luong"); ?>" src="<?php echo $view->escape('/assetic/images/card_nganluong.png'); ?>" style="width:87px; height:32px; min-height:32px; display: inline-block; margin-bottom: 0px;">
                                                </label>
                                            </li>
                                        </ul>
                                    </div>
                                    <hr>
                                    <button type="submit" class="btn btn-success"><?php echo $view['translator']->trans("Send Request"); ?></button>
                                </div>
                            </div>
                        </form>
                    <?php } ?>
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <h2><?php echo $view['translator']->trans("Withdrawal History"); ?></h2>
                            <?php if ($list) { ?>
                                <table class="table">
                                    <thead>
                                        <tr> 
                                            <th><?php echo $view['translator']->trans("Date Request"); ?></th> 
                                            <th><?php echo $view['translator']->trans("Amount"); ?></th> 
                                            <th><?php echo $view['translator']->trans("Method"); ?></th>  
                                            <th><?php echo $view['translator']->trans("Email"); ?></th>  
                                            <th><?php echo $view['translator']->trans("Status"); ?></th> 
                                            <th><?php echo $view['translator']->trans("Date Process"); ?></th>                      
                                        </tr>
                                    </thead>   
                                    <tbody>
                                        <?php foreach ($list as $key => $value) { ?>
                                            <tr>
                                                <td><?php echo $value->getDateRequest()->format('d/m/Y H:i:s'); ?></td> 
                                                <td><?php echo number_format($value->getAmount(), 2); ?></td> 
                                                <td><?php
                                                    $data = json_decode($value->getDatas());
                                                    echo @$data->method;
                                                    ?></td> 
                                                <td><?php
                                                    echo @$data->email;
                                                    ?></td> 
                                                <td>
                                                    <?php
                                                    if ($value->getStatus() == 1) {
                                                        echo "<font color='green'>" . $view['translator']->trans("Paid") . "</font>";
                                                    } else {
                                                        echo "<font color='red'>" . $view['translator']->trans("Pending") . "</font>";
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    if ($value->getStatus() == 1) {
                                                        echo $value->getDateProcess()->format('d/m/Y H:i:s');
                                                    }
                                                    ?>
                                                </td>
                                            </tr> 
                                        <?php } ?>
                                    </tbody> 
                                </table>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <h4><?php echo $view['translator']->trans("Current Credit Balance"); ?></h4>
                        <span class="current-balance"><?php echo $view['translator']->trans("$"); ?><?php echo number_format($check->getMoney(), 2); ?></span>
                    </div>    
                </div>
            </div>
        </div><!--/.row-->
    </div>
</div>
<script src="<?php echo $view->escape('/assetic/js/bootstrap-table.js'); ?>"></script>