<?php
$view->extend('MarketZodacoBundle::base.html.php');
?>
<?php $view['slots']->set('title', $view['translator']->trans("Add prepaid credit") . " | " . $view['translator']->trans("Zodaco Market")) ?>
<div class="col-sm-12 col-lg-12 main" id="mainContents">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 no-padding">
                <div class="col-lg-12 no-padding-right">
                    <?php if ($error) { ?>
                        <div class="alert bg-danger" role="alert">
                            <ul>
                                <?php if ($error) { ?>
                                    <li><?php echo $view['translator']->trans("Error! Please try again."); ?></li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                    <form role="form" method="POST" action="">
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <h2><?php echo $view['translator']->trans("Add prepaid credit"); ?></h2>
                                <label style="padding-right:100px;"><?php echo $view['translator']->trans("How much prepaid credit would you like to deposit?"); ?></label>      
                                <select class="form-control" name="deposit" id="deposit">
                                    <option value="20" selected>$20</option>
                                    <option value="30">$30</option>
                                    <option value="40">$40</option>
                                    <option value="50">$50</option>
                                    <option value="60">$60</option>
                                    <option value="70">$70</option>
                                    <option value="80">$80</option>
                                    <option value="90">$90</option>
                                    <option value="100">$100</option>
                                    <option value="150">$150</option>
                                    <option value="200">$200</option>
                                    <option value="250">$250</option>
                                    <option value="300">$300</option>
                                    <option value="400">$400</option>
                                    <option value="500">$500</option>
                                </select>
                                <br><br>
                                <?php echo $view['translator']->trans("Select your preferred payment method:"); ?>
                                <br><br>
                                <ul style="list-style: none;">
                                    <li>  
                                        <label>
                                            <input checked="checked" class="" name="paymentOption" type="radio" value="paypal">
                                            <img title="<?php echo $view['translator']->trans("Pay with PayPal"); ?>" alt="<?php echo $view['translator']->trans("Pay with PayPal"); ?>" src="<?php echo $view->escape('/assetic/images/card_paypal.png'); ?>" style="width:87px; height:32px; min-height:32px; display: inline-block; margin-bottom: 0px;">
                                        </label>
                                    </li>
                                    <li>
                                        <label>
                                            <input class="" name="paymentOption" type="radio" value="baokim">
                                            <img title="<?php echo $view['translator']->trans("Pay with Bao Kim"); ?>" alt="<?php echo $view['translator']->trans("Pay with Bao Kim"); ?>" src="<?php echo $view->escape('/assetic/images/card_baokim.png'); ?>" style="width:87px; height:32px; min-height:32px; display: inline-block; margin-bottom: 0px;">
                                        </label>
                                    </li>
                                    <li>
                                        <label>
                                            <input class="" name="paymentOption" type="radio" value="nganluong">
                                            <img title="<?php echo $view['translator']->trans("Pay with Ngan Luong"); ?>" alt="<?php echo $view['translator']->trans("Pay with Ngan Luong"); ?>" src="<?php echo $view->escape('/assetic/images/card_nganluong.png'); ?>" style="width:87px; height:32px; min-height:32px; display: inline-block; margin-bottom: 0px;">
                                        </label>
                                    </li>
                                </ul>
                                <p style="clear:left;"><?php echo $view['translator']->trans("* For larger amounts"); ?> <?php echo $view['translator']->trans("Contact Us"); ?>.
                                    <?php //echo $view['translator']->trans("* Please keep in mind deposits are not refundable and will expire one year after the last deposit."); ?>
                                </p>
                                <button type="submit" class="btn btn-danger"><?php echo $view['translator']->trans("Continue"); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <h4><?php echo $view['translator']->trans("Current Credit Balance"); ?></h4>
                        <span class="current-balance"><?php echo $view['translator']->trans("$"); ?><?php echo number_format($check->getMoney(), 2); ?></span>
                    </div>    
                </div>
            </div>
        </div><!--/.row-->
    </div>
</div>