<?php
$view->extend('MarketZodacoBundle::base.html.php');

$view['slots']->set('title', $view['translator']->trans("Sales History")." | ".$view['translator']->trans("Zodaco Market"));
?>
<link href="<?php echo $view->escape('/assetic/css/bootstrap-table.css'); ?>" rel="stylesheet">
<div class="col-sm-12 col-lg-12 main" id="mainContents">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 no-padding">
                <div class="col-lg-12 no-padding-right">
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <h2><?php echo $view['translator']->trans("Sales History"); ?></h2>
                            <?php if ($list) { ?>
                                <table class="table">
                                    <thead>
                                        <tr> 
                                            <th><?php echo $view['translator']->trans("Item"); ?></th> 
                                            <th><?php echo $view['translator']->trans("Status"); ?></th>
                                            <th><?php echo $view['translator']->trans("Amount"); ?></th>                    
                                        </tr>
                                    </thead>   
                                    <tbody>
                                        <?php
                                        foreach ($list as $value) {
                                            $url = $view['router']->generate('view_products', array('id' => $value->getPId(), 'title' => Market\ZodacoBundle\System::_reString($value->getTitle())), true);
                                            ?>
                                            <tr>
                                                <td><?php if($value->getPId()){ ?><a href="<?php echo $url; ?>"><?php } ?><?php echo $value->getTitle(); ?><?php if($value->getPId()){ ?></a><?php } ?></td> 
                                                <td><?php echo ($value->getStatus() == 1) ? $view['translator']->trans("Paid") : $view['translator']->trans("Refund"); ?></td> 
                                                <td><?php echo $view['translator']->trans("$"); ?> <?php echo $value->getNetMoney(); ?></td>
                                            </tr>
                                            <?php
                                        }
                                        ?>
                                    </tbody> 
                                </table>
                                <?php
                            } else {
                                ?>
                                <center><?php echo $view['translator']->trans("No Data"); ?></center>
                            <?php }
                            ?>
                            <?php
                            if ($page["NextPage"] > 1):
                                $urlNext = $view['router']->generate('sale', array(), true);
                                ?>
                                <div class="pull-right pagination" style="width: 100%; display: block;">
                                    <ul class="pagination">
                                        <?php if ($page["PreviousPage"] != $page["Page"]): ?>
                                            <li class="page-pre"><a href="<?php echo $urlNext . '?p=' . $page["PreviousPage"]; ?>">&lt;</a></li>
                                        <?php endif; ?>
                                        <li class="page-number"><a href="javascript:void(0)"><?php echo $page["Page"] ?></a></li>
                                        <?php if ($page["LastPage"] > $page["Page"]): ?>
                                            <li class="page-next"><a href="<?php echo $urlNext . '?p=' . $page["NextPage"]; ?>">&gt;</a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <h4><?php echo $view['translator']->trans("Current Credit Balance"); ?></h4>
                        <span class="current-balance"><?php echo $view['translator']->trans("$"); ?><?php echo number_format($check->getMoney(), 2); ?></span>
                    </div>    
                </div>
            </div>
        </div><!--/.row-->
    </div>
</div>
<script src="<?php echo $view->escape('/assetic/js/bootstrap-table.js'); ?>"></script>