<?php
$view->extend('MarketZodacoBundle::base.html.php');

$view['slots']->set('title', $view['translator']->trans("Comments") . " " . $view['translator']->trans("Item") . " : " . $product->getTitle() . " | " . $view['translator']->trans("Zodaco Market")); //." - ".$product->getShortDetails());
$url = $view['router']->generate('view_products', array('id' => $product->getId(), 'title' => Market\ZodacoBundle\System::_reString($product->getTitle())), true);
?>

<div class="col-sm-12 col-lg-12 main" id="bggg" style="color: #FFF;height: 160px; background: #A93C3C;">
    <div class="container" style="color: #FFF;padding: 0px;margin-top: 20px;position: relative;z-index: 1;">
        <div class="float-left">
            <a class="item-image" href="<?php echo $url; ?>"><img src="<?php echo $view->escape('/uploads/items/'); ?><?php echo $product->getIcon(); ?>" height="80" width="80" alt="<?php echo $product->getTitle(); ?>"></a>
        </div>
        <div class="float-left item-header-info">
            <h1><?php echo $product->getTitle(); ?></h1>
            <span class="desc-short"><?php echo $product->getShortDetails(); ?></span>
        </div>
        <div class="float-right item-header-specs">
            <div class="row">
                <div class="left-col"><i class="fa fa-calendar"></i> <?php echo $view['translator']->trans("Release Date"); ?>:</div><div class="right-col"><?php echo $product->getCreatedAt()->format("d/m/Y"); ?></div>
            </div>
            <div class="row">
                <div class="left-col"><i class="fa fa-folder"></i> <?php echo $view['translator']->trans("Category"); ?>:</div>
                <div class="right-col">
                    <a href="<?php echo $view['router']->generate('view_categories', array('id' => $product->getCategories()->getId(), 'title' => Market\ZodacoBundle\System::_reString($product->getCategories()->getShortTitle())), true); ?>" title="<?php echo $product->getCategories()->getShortTitle(); ?>"><?php echo $product->getCategories()->getShortTitle(); ?></a>
                </div>
            </div>
        </div>
        <div class="col-lg-12 no-padding">
            <div class="col-lg-12 no-padding" style="position: absolute;
                 width: 100%;
                 display: inline;
                 top: 25px;">
                <div class="btn-group" style="width: 100%;">
                    <a class="btn btn-default" style="margin-left: 1px;width: 11%;" href="<?php echo $view['router']->generate('view_products', array('id' => $product->getId(), 'title' => Market\ZodacoBundle\System::_reString($product->getTitle())), true); ?>"><?php echo $view['translator']->trans("Details"); ?></a>
                    <a class="btn btn-default disabled" style="margin-left: 1px;width: 11%;" href=""><?php echo $view['translator']->trans("Comments"); ?></a>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="col-sm-12 col-lg-12 main" id="mainContents">
    <div class="container">
        <div class="row">
            <div class="col-lg-7 no-padding">
                
                <div class="panel panel-default">
                    <div class="panel-body">
                        <?php echo $product->getDetails(); ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 no-padding">
                <div class="col-lg-12">
                    <?php if ($login && $login->getId() == $product->getUsers()->getId()) { ?>
                        <div class="alert bg-warning" role="alert">
                            <ul style="list-style: none;padding-left: 0px;">
                                <li><i class="fa fa-flag"></i> <?php echo $view['translator']->trans("This is one of your items."); ?></li>
                            </ul>
                        </div>
                    <?php } ?>
                    <form role="form" method="POST" action="">
                        <fieldset>
                            <div class="panel panel-default">
                                <div class="panel-body detailProducts"> 
                                    <select class="form-control" name="licensetype" id="licensetype" style="width: 50%;float: left;" onchange="changelicense()">
                                        <?php if ($product->getPrice() > 0) { ?>
                                            <option value="0"><?php echo $view['translator']->trans("Regular license"); ?></option>
                                            <?php
                                        }
                                        ?>
                                        <?php if ($product->getPricePlus() > 0) { ?>
                                            <option value="1"><?php echo $view['translator']->trans("Extended license"); ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                    <p id="priceLicense"><?php echo $view['translator']->trans("$"); ?><?php echo number_format($product->getPrice(), 2); ?></p>
                                    <img src="<?php echo $view->escape('/assetic/images/payment-methods.png'); ?>" style="width: 100%; min-height: 100%;padding-top: 23px;"/>
                                    <button type="submit" class="btn btn-danger" style="width: 100%;height: 60px;font-size: 24px;"><?php echo $view['translator']->trans("Buy Now"); ?></button>
                                </div>
                            </div>
                        </fieldset>
                    </form>
                    <div class="panel panel-default">
                        <div class="panel-body detailProducts"> 
                            <div class="avatar" style="width: 80px; height: 80px; float: left;padding: 0px;">
                                <a href="<?php echo $view['router']->generate('portfolio', array("title" => $product->getUsers()->getUsername()), true); ?>"><img src="<?php echo $view->escape('/assetic/images/default-user.jpg'); ?>" style="min-height: 100%;"/></a>
                            </div> 
                            <div class="nameUser" style="float: left; margin-left: 10px;font-size: 18px;">
                                <a href="<?php echo $view['router']->generate('portfolio', array("title" => $product->getUsers()->getUsername()), true); ?>" style="display: block;"><?php echo $product->getUsers()->getUsername(); ?></a>
                                <a href="<?php echo $view['router']->generate('portfolio', array("title" => $product->getUsers()->getUsername()), true); ?>" class="btn btn-default" style="display: block; margin-top: 10px; border: 1px solid #dddddd; background: #f9f9f9 !important;"><?php echo $view['translator']->trans("View Portfolio"); ?></a>
                            </div>
                        </div>
                    </div>
                    <div class="panel panel-default">
                        <div class="panel-body detailProducts"> 
                            <div class="total_sale">
                                <i class="fa fa-shopping-cart"></i> <span><?php echo number_format($product->getTotalSale()); ?></span> <?php echo $view['translator']->trans("Sales"); ?>
                            </div>
                        </div>
                    </div>
                    <div style="font-size: 13px;color: #fff; margin-bottom: 5px;"><a style="color: red; text-decoration: underline;" href="<?php echo $view['router']->generate('support', array(), true); ?>"><?php echo $view['translator']->trans("Report this item") ?></a></div>
                        <?php /*
                          <div class="panel panel-default">
                          <div class="panel-body detailProducts">
                          <div class="total_comment">
                          <i class="fa fa-comment"></i> <span><?php echo number_format($product->getTotalComment()); ?></span> <?php echo $view['translator']->trans("Comments"); ?>
                          </div>
                          </div>
                          </div>
                         */ ?>
                </div>
            </div>
        </div><!--/.row-->
    </div>
</div>
<script type="text/javascript">
    function changelicense() {
        var licensetype = document.getElementById("licensetype").value;
        if (licensetype == 0) {
            $("#priceLicense").html('<?php echo $view['translator']->trans("$"); ?><?php echo number_format($product->getPrice(), 2); ?>');
        }
        if (licensetype == 1) {
            $("#priceLicense").html('<?php echo $view['translator']->trans("$"); ?><?php echo number_format($product->getPricePlus(), 2); ?>');
        }
    }
</script>