<?php
$view->extend('MarketZodacoBundle::base.html.php');
?>
<?php $view['slots']->set('title', $view['translator']->trans("Shopping Cart")." | ".$view['translator']->trans("Zodaco Market")) ?>
<link href="<?php echo $view->escape('/assetic/css/bootstrap-table.css'); ?>" rel="stylesheet">
<div class="col-sm-12 col-lg-12 main" id="mainContents">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 no-padding">
                <div class="col-lg-12 no-padding-right">
                    <?php if ($error) { ?>
                        <div class="alert bg-danger" role="alert">
                            <ul style="list-style: none; padding-left: 0px;">
                                <li><i class="fa fa-frown-o"></i> <?php echo $view['translator']->trans("Checkout fail. Try again!"); ?></li>
                            </ul>
                        </div>
                        <?php
                    }
                    ?>
                    <?php if ((floatval($check->getMoney()) < floatval($product->getPrice()) && $type == 0) || ($type == 1 && floatval($check->getMoney()) < floatval($product->getPricePlus()))) { ?>
                        <div class="alert bg-warning" role="alert">
                            <ul style="list-style: none; padding-left: 0px;">
                                <li><i class="fa fa-frown-o"></i> <?php echo $view['translator']->trans("Your balance is low. Please, Deposit more."); ?></li>
                            </ul>
                        </div>
                        <?php
                    }
                    if ($type == 0) {
                        $price = $product->getPrice();
                    } else {
                        $price = $product->getPricePlus();
                    }
                    $url = $view['router']->generate('view_products', array('id' => $product->getId(), 'title' => Market\ZodacoBundle\System::_reString($view['translator']->trans($product->getTitle()))), true);
                    ?>
                    <form role="form" method="POST" action="">
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <h2><?php echo $view['translator']->trans("Your cart"); ?></h2>
                                <table class="table">
                                    <thead>
                                        <tr> 
                                            <th><?php echo $view['translator']->trans("Item"); ?></th> 
                                            <th><?php echo $view['translator']->trans("Amount"); ?></th>                    
                                        </tr>
                                    </thead>   
                                    <tbody>
                                        <tr>
                                            <td><a href="<?php echo $url; ?>"><?php echo $product->getTitle(); ?></a></td> 
                                            <td><?php echo number_format($price, 2); ?></td>
                                        </tr>
                                    </tbody> 
                                </table>
                                <button type="submit" class="btn btn-danger"><?php echo $view['translator']->trans("Checkout"); ?></button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
            <div class="col-lg-3">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <h4><?php echo $view['translator']->trans("Current Credit Balance"); ?></h4>
                        <span class="current-balance"><?php echo $view['translator']->trans("$"); ?><?php echo number_format($check->getMoney(), 2); ?></span>
                    </div>    
                </div>
            </div>
        </div><!--/.row-->
    </div>
</div>
<script src="<?php echo $view->escape('/assetic/js/bootstrap-table.js'); ?>"></script>