<?php
$view->extend('MarketZodacoBundle::base_admin.html.php');
?>
<div class="col-lg-12">
    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header"><?php echo $view['translator']->trans("Search User"); ?></h1>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <form role="search" action="<?php echo $view['router']->generate('admin_view_user', array(), true); ?>" method="GET">
                <div class="form-group">
                    <input id="s" name="s" type="text" class="form-control" placeholder="<?php echo $view['translator']->trans("Input Username and hit Enter"); ?>" style="font-size: 30px;height: 60px;">
                </div>
            </form>
        </div>
    </div>

    <?php if ($error) { ?>
        <div class="alert bg-danger" role="alert">
            <ul>
                <?php if ($error) { ?>
                    <li><?php echo $view['translator']->trans("Error! Please try again."); ?></li>
                <?php } ?>
            </ul>
        </div>
    <?php } ?>
    <?php if ($login) { ?>
        <form role="form" method="POST" action="">
            <div class="panel panel-default">
                <div class="panel-heading"><?php echo $view['translator']->trans("View User"); ?></div>
                <div class="panel-body">
                    <fieldset>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("First Name"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("First Name"); ?>" disabled type="text" autofocus="" value="<?php echo $login->getFname(); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Last Name"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("Last Name"); ?>" disabled type="text"  value="<?php echo $login->getLname(); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("UserName"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("UserName"); ?>" type="text" disabled  value="<?php echo $login->getUsername(); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Email"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("Email"); ?>" disabled type="text"  value="<?php echo $login->getEmail(); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Money"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("Money"); ?>" disabled type="text"  value="<?php echo number_format($login->getMoney(), 2); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Total File"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("Total File"); ?>" disabled type="text"  value="<?php echo number_format($login->getTotalFile()); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Address"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("Address"); ?>" disabled type="text"  value="<?php echo $login->getAdd1(); ?>">
                            <br>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("Address"); ?>" disabled type="text"  value="<?php echo $login->getAdd2(); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("City"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("City"); ?>" disabled type="text"  value="<?php echo $login->getCity(); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Country"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("Country"); ?>" disabled type="text"  value="<?php echo $login->getCountry(); ?>">
                        </div>
                        <button type="submit" class="btn btn-danger"><?php echo ($login->getActive())?$view['translator']->trans("Disable this User"):$view['translator']->trans("Enable this User"); ?></button>
                    </fieldset>
                </div>
            </div>
        </form>
    <?php } else { ?>
        <center><h1><?php echo $view['translator']->trans("Not Found"); ?></h1></center>
    <?php } ?>
</div>