<?php
$view->extend('MarketZodacoBundle::base_admin.html.php');
?>
<div class="col-lg-12">
    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header"><?php echo $view['translator']->trans("Search Product"); ?></h1>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <form role="search" action="<?php echo $view['router']->generate('admin_view_products', array(), true); ?>" method="GET">
                <div class="form-group">
                    <input id="s" name="s" type="text" class="form-control" placeholder="<?php echo $view['translator']->trans("Input ID and hit Enter"); ?>" style="font-size: 30px;height: 60px;">
                </div>
            </form>
        </div>
    </div>

    <?php if ($error) { ?>
        <div class="alert bg-danger" role="alert">
            <ul>
                <?php if ($error) { ?>
                    <li><?php echo $view['translator']->trans("Error! Please try again."); ?></li>
                <?php } ?>
            </ul>
        </div>
    <?php } ?>
    <?php if ($product) { ?>
        <form role="form" method="POST" action="">
            <div class="panel panel-default">
                <div class="panel-heading"><?php echo $view['translator']->trans("View Product"); ?></div>
                <div class="panel-body">
                    <fieldset>
                            <div class="form-group">
                                <label><?php echo $view['translator']->trans("Author"); ?></label>
                                <input class="form-control" disabled placeholder="<?php echo $view['translator']->trans("Author"); ?>" type="text" required value="<?php echo $product->getUsers()->getUsername(); ?>">
                            </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Title"); ?></label>
                            <input class="form-control" disabled placeholder="<?php echo $view['translator']->trans("Title"); ?>" id="title" name="title" type="text" maxlength="50" required value="<?php echo $product->getTitle(); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Short Description"); ?></label>
                            <input class="form-control" disabled placeholder="<?php echo $view['translator']->trans("Short Description"); ?>" id="short_title" name="short_title" type="text" maxlength="130" required value="<?php echo $product->getShortDetails(); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Description"); ?></label>
                            <textarea class="ckeditor" disabled type="text" id="details" name="details"><?php echo $product->getDetails(); ?></textarea>
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Icon"); ?></label>
                            <br>
                            <div style="display: inline;">
                                <img id="small_img" src="<?php echo $view->escape('/uploads/items/'); ?><?php echo $product->getIcon(); ?>" style="display: inline; width: 200px; min-height: 200px; height: 200px; margin-bottom: 0px;">
                            </div>
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Image Preview"); ?></label>
                            <br>
                            <div style="display: inline;">
                                <img id="large_img" src="<?php echo $view->escape('/uploads/items/'); ?><?php echo $product->getPreview(); ?>" style="display: inline; width: 640px; min-height: 320px; height: 320px; margin-bottom: 0px;">
                            </div>
                        </div>
                            <div class="form-group">
                                <label><?php echo $view['translator']->trans("Regular license Price"); ?></label>
                                <input class="form-control" disabled placeholder="<?php echo $view['translator']->trans("Regular license Price"); ?>" id="price" name="price" type="text" required value="<?php echo number_format($product->getPrice(), 2); ?>">
                            </div>
                            <div class="form-group">
                                <label><?php echo $view['translator']->trans("Extended license Price"); ?></label>
                                <input class="form-control" disabled placeholder="<?php echo $view['translator']->trans("Extended license Price"); ?>" id="price2" name="price2" type="text" required value="<?php echo number_format($product->getPricePlus(), 2); ?>">
                            </div>
                        <button type="submit" class="btn btn-danger" style="float: right;"><?php echo $view['translator']->trans("Disable this Item"); ?></button>
                    </fieldset>
                </div>
            </div>
        </form>
    <?php } ?>
</div>