<?php
$view->extend('MarketZodacoBundle::base_admin.html.php');
?>
<div class="col-lg-12">
    <?php if ($error) { ?>
        <div class="alert bg-danger" role="alert">
            <ul>
                <?php if ($error) { ?>
                    <li><?php echo $view['translator']->trans("Error! Please try again."); ?></li>
                <?php } ?>
            </ul>
        </div>
    <?php } ?>
    <form role="form" method="POST" action="">
        <input name="type" type="number" value="0" style="display: none;">
        <div class="panel panel-default">
            <div class="panel-heading"><?php echo $view['translator']->trans("Review Product"); ?></div>
            <div class="panel-body">
                <fieldset>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Title"); ?></label>
                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Title"); ?>" id="title" name="title" type="text" maxlength="50" required value="<?php echo ($update && $product->getUpdateTitle() != "") ? $product->getUpdateTitle() : $product->getTitle(); ?>">
                        <?php echo $view['translator']->trans("Maximum 50 characters."); ?>
                    </div>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Short Description"); ?></label>
                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Short Description"); ?>" id="short_title" name="short_title" type="text" maxlength="130" required value="<?php echo $product->getShortDetails(); ?>">
                        <?php echo $view['translator']->trans("Maximum 130 characters."); ?>
                    </div>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Description"); ?></label>
                        <textarea class="ckeditor" type="text" id="details" name="details"><?php echo $product->getDetails(); ?></textarea>
                        <?php echo $view['translator']->trans("Please include a detailed description with a features list, list of requirements and instructions how to use it."); ?>
                    </div><div class="form-group">
                        <label><?php echo $view['translator']->trans("Demo Url"); ?></label>
                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Demo Url"); ?>" id="demo_url" name="demo_url" type="text" value="<?php echo $product->getDemoUrl(); ?>">
                        <?php echo $view['translator']->trans("*Optional* link to a live preview on your own hosting (i.e. http://mysite.com/demo/)."); ?>
                    </div>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Video Url"); ?></label>
                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Video Url"); ?>" id="video_url" name="video_url" type="text" value="<?php echo $product->getVideoUrl(); ?>">
                        <?php echo $view['translator']->trans("*Optional* link to a video on Youtube (i.e. https://www.youtube.com/watch?v=QXXzCUW5U14)."); ?>
                    </div>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Icon"); ?></label>
                        <?php echo $view['translator']->trans("200 x 200px icon image (.JPG or .PNG)"); ?>
                        <br>
                        <div style="display: inline;">
                            <img id="small_img" src="<?php echo (($product->getStatus() == 1 && $product->getUpdateIcon() != "") || $product->getActive() == 0) ? $view->escape('/uploads/tmp/') : $view->escape('/uploads/items/'); ?><?php echo ($update && $product->getUpdateIcon() != "") ? $product->getUpdateIcon() : $product->getIcon(); ?>" style="display: inline; width: 200px; min-height: 200px; height: 200px; margin-bottom: 0px;">
                        </div>
                    </div>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Image Preview"); ?></label>
                        <?php echo $view['translator']->trans("640 x 320 preview image (.JPG or .PNG)"); ?>
                        <br>
                        <div style="display: inline;">
                            <img id="large_img" src="<?php echo (($product->getStatus() == 1 && $product->getUpdateIcon() != "") || $product->getActive() == 0) ? $view->escape('/uploads/tmp/') : $view->escape('/uploads/items/'); ?><?php echo ($update && $product->getUpdatePreview() != "") ? $product->getUpdatePreview() : $product->getPreview(); ?>" style="display: inline; width: 640px; min-height: 320px; height: 320px; margin-bottom: 0px;">
                        </div>
                    </div>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Screen Shoot"); ?></label>
                        <?php echo $view['translator']->trans(".ZIP file with screenshot images"); ?>
                        <br>
                        <?php if (!$update || ($update && $product->getUpdateScreenshots() != "")) { ?>
                            <div style="display: inline;">
                                <a class="btn btn-default" href="<?php echo $view->escape('/uploads/tmp/'); ?><?php echo ($update) ? $product->getUpdateScreenshots() : $product->getScreenshots(); ?>" style="display: inline; margin-bottom: 0px;"><?php echo $view['translator']->trans("screenshot file"); ?></a>
                            </div>
                        <?php } else { ?>
                            <?php echo $view['translator']->trans("No Update"); ?>
                        <?php } ?>
                    </div>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Main File"); ?></label>
                        <?php echo $view['translator']->trans(".ZIP file - Contains all files for buyers (don't include screenshots etc)."); ?>
                        <br>
                        <?php if (!$update || ($update && $product->getUpdateMainFile() != "")) { ?>
                            <div style="display: inline;">
                                <a class="btn btn-default" href="<?php echo $view->escape('/uploads/tmp/'); ?><?php echo ($update) ? $product->getUpdateMainFile() : $product->getMainFile(); ?>" style="display: inline; margin-bottom: 0px;"><?php echo $view['translator']->trans("main file"); ?></a>
                            </div>
                        <?php } else { ?>
                            <?php echo $view['translator']->trans("No Update"); ?>
                        <?php } ?>
                    </div>
                    <?php if (!$update) { ?>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Regular license Price"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("Regular license Price"); ?>" id="price" name="price" type="text" required value="<?php echo $product->getPrice(); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo $view['translator']->trans("Extended license Price"); ?></label>
                            <input class="form-control" placeholder="<?php echo $view['translator']->trans("Extended license Price"); ?>" id="price2" name="price2" type="text" required value="<?php echo $product->getPricePlus(); ?>">
                        </div>
                    <?php } ?>
                    <button type="submit" class="btn btn-success" style="float: right;"><?php echo $view['translator']->trans("Approve"); ?></button>
                </fieldset>
            </div>
        </div>
    </form>


    <form role="form" method="POST" action="">
        <input name="type" type="number" value="1" style="display: none;">
        <div class="panel panel-default">
            <div class="panel-heading"><?php echo $view['translator']->trans("Reject Product"); ?></div>
            <div class="panel-body">
                <fieldset>


                    <button type="submit" class="btn btn-danger" style="float: right;"><?php echo $view['translator']->trans("Reject"); ?></button>
                </fieldset>
            </div>
        </div>

    </form>
</div>