<?php
$view->extend('MarketZodacoBundle::base_admin.html.php');
?>
<div class="col-lg-12">
    <form role="form" method="POST" action="">

        <div class="panel panel-default">
            <div class="panel-heading"><?php echo $view['translator']->trans("New Product"); ?></div>
            <div class="panel-body">
                <fieldset>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Title"); ?></label>
                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Title"); ?>" id="title" name="title" type="text" autofocus="" maxlength="50" required>
                        <?php echo $view['translator']->trans("Maximum 50 characters."); ?>
                    </div>

                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Short Description"); ?></label>
                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Short Description"); ?>" id="short_title" name="short_title" type="text" maxlength="130" required>
                        <?php echo $view['translator']->trans("Maximum 130 characters."); ?>
                    </div>

                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Description"); ?></label>
                        <textarea class="ckeditor" type="text" id="details" name="details"></textarea>
                        <?php echo $view['translator']->trans("Please include a detailed description with a features list, list of requirements and instructions how to use it."); ?>
                    </div>

                </fieldset>

            </div>

        </div>


        <div class="panel panel-default">
            <div class="panel-body">
                <fieldset>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Icon"); ?></label>
                        <input name="upanh" type="text" id="upanh" style="display: none;" value="">
                        <?php echo $view['translator']->trans("200 x 200px icon image (.JPG or .PNG)"); ?>
                        <br>
                        <label id="fileContainer2" class="fileContainer">
                            <input class="uploadImg" data-bind="200-200" type="file" name="images2" id="images2" style="display: none;"/>
                            <?php echo $view['translator']->trans("Upload"); ?>
                        </label>
                        <div style="display: inline;">
                            <img id="small_img" src="" style="display: inline; width: 36px; min-height: 36px; height: 36px; margin-bottom: 0px;">
                            <div id="response2">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Image Preview"); ?></label>
                        <?php echo $view['translator']->trans("640 x 320 preview image (.JPG or .PNG)"); ?>
                        <input name="licon" type="text" id="licon" style="display: none;" value="">
                        <br>
                        <label id="fileContainer3" class="fileContainer">
                            <input class="uploadImg" data-bind="640-320" type="file" name="large_icon" id="large_icon" style="display: none;"/>
                            <?php echo $view['translator']->trans("Upload"); ?>
                        </label>
                        <div style="display: inline;">
                            <img id="large_img" src="" style="display: inline; width: 100px; min-height: 40px; height: 40px; margin-bottom: 0px;">
                            <div id="response3">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Screen Shoot"); ?></label>
                        <select name="screenshot" id="screenshot" class="form-control">
                            <option value="" selected="selected">---</option>
                        </select>
                        <?php echo $view['translator']->trans(".ZIP file with screenshot images"); ?>
                        <br>
                        <label id="fileContainer4" class="fileContainer">
                            <input class="uploadScreenshot" type="file" name="uploadScreenshot" id="uploadScreenshot" style="display: none;"/>
                            <?php echo $view['translator']->trans("Upload"); ?>
                        </label>
                        <div style="display: inline;">
                            <div id="response4"></div>
                        </div>
                    </div>


                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Main File"); ?></label>
                        <select name="main_file" id="main_file" class="form-control">
                            <option value="" selected="selected">---</option>
                        </select>
                        <?php echo $view['translator']->trans(".ZIP file - Contains all files for buyers (don't include screenshots etc)."); ?>
                        <br>
                        <label id="fileContainer5" class="fileContainer">
                            <input class="uploadMainFile" type="file" name="uploadMainFile" id="uploadMainFile" style="display: none;"/>
                            <?php echo $view['translator']->trans("Upload"); ?>
                        </label>
                        <div style="display: inline;">
                            <div id="response5"></div>
                        </div>
                    </div>

                </fieldset>

            </div>

        </div>


        <div class="panel panel-default">
            <div class="panel-body">
                <fieldset>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Categories"); ?></label>
                        <?php echo $view['translator']->trans("Don't worry if you can't find the correct category. If necessary we will create a category for your item."); ?>
                        <select name="cid" id="cid" class="form-control">
                            <option value="0" selected="selected">---</option> 
                            <?php
                            if (count(@$list) > 0) {
                                foreach ($list as $key => $value) {
                                    ?>
                                    <option <?php
                                    if ($value->getMid() == 0) {
                                        // echo "disabled";
                                    }
                                    ?> value="<?php echo $value->getId(); ?>"><?php echo $value->getTitle(); ?></option>
                                        <?php
                                    }
                                }
                                ?>                            
                        </select>
                    </div>

                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Demo Url"); ?></label>
                        <?php echo $view['translator']->trans("*Optional* link to a live preview on your own hosting (i.e. http://mysite.com/demo/)."); ?>
                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Demo Url"); ?>" id="demo_url" name="demo_url" type="text">
                    </div>

                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Video Url"); ?></label>
                        <?php echo $view['translator']->trans("*Optional* link to a video on Youtube (i.e. https://www.youtube.com/watch?v=hMP644ZBFsM)."); ?>
                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Video Url"); ?>" id="video_url" name="video_url" type="text">
                    </div>

                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Tags"); ?></label>
                        <textarea class="form-control" type="text" id="tags" name="tags" rows="5"></textarea>
                        <?php echo $view['translator']->trans("Maximum of 15 keywords covering features, options, and style. Keywords should all be in lowercase and separated by commas. e.g. web template, photo gallery, dark, simple, real estate"); ?>
                    </div>

                </fieldset>

            </div>

        </div>

        <div class="panel panel-default">
            <div class="panel-body">
                <fieldset>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Users"); ?></label>
                        <select name="cid" id="cid" class="form-control">
                            <option value="0" selected="selected">---</option> 
                            <?php
                            if (count(@$listUser) > 0) {
                                foreach ($listUser as $key => $value) {
                                    ?>
                                    <option value="<?php echo $value->getId(); ?>"><?php echo $value->getUsername(); ?></option>
                                        <?php
                                    }
                                }
                                ?>                            
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Active"); ?></label>
                        <div class="radio">
                            <label>
                                <input type="radio" name="active" value="0"><?php echo $view['translator']->trans("No"); ?>
                            </label>
                        </div>
                        <div class="radio">
                            <label>
                                <input type="radio" name="active" value="1" checked><?php echo $view['translator']->trans("Yes"); ?>
                            </label>
                        </div>
                    </div>
                </fieldset>

            </div>

        </div>

        <div class="panel panel-default">
            <div class="panel-body">
                <fieldset>
                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Message to item reviewed"); ?></label>
                        <textarea class="form-control" type="text" id="tags" name="tags" rows="5"></textarea>
                        <?php echo $view['translator']->trans("Maximum of 15 keywords covering features, options, and style. Keywords should all be in lowercase and separated by commas. e.g. web template, photo gallery, dark, simple, real estate"); ?>
                    </div>

                    <div class="form-group">
                        <label><?php echo $view['translator']->trans("Price"); ?></label>
                        <input class="form-control" placeholder="<?php echo $view['translator']->trans("Price"); ?>" id="price" name="price" type="number" required>
                    </div>


                    <div class="form-group checkbox">
                        <label>
                            <input id="not_own" name="not_own" type="checkbox">
                            <?php echo $view['translator']->trans("Any images, sounds, video, code, flash, or other assets that are not my own work, have been appropriately licensed for use in the file preview or main download. Other than these items, this work is entirely my own and I have full rights to sell it on Marketplace."); ?>
                        </label>
                    </div>
                    <button type="submit" class="btn btn-success"><?php echo $view['translator']->trans("Submit"); ?></button>

                </fieldset>

            </div>

        </div>

    </form>
</div>

