<?php

namespace Market\ZodacoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Market\ZodacoBundle\Entity\Notifications;

class TermsController extends BaseController {

    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();
        $list = array();
        $listFooter = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findBy(array("total" => 1, "active" => 1, "mid" => 0));
        if ($listFooter) {
            foreach ($listFooter as $value) {
                $list[$value->getId()] = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findBy(array("total" => 1, "active" => 1, "mid" => $value->getId()));
            }
        }

        $a = array("listFooter" => $listFooter, "list" => $list);
        return $this->render('MarketZodacoBundle:Terms:index.html.php', $a);
    }

    public function fanPageAction() {
        $pageID = $this->container->getParameter('fancePage');
        //$info = json_decode(@file_get_contents('http://graph.facebook.com/?id=' . $pageID));
        //
        $a = array("info" => 0); //$info->likes);
        return $this->render('MarketZodacoBundle:Terms:fanPage.html.php', $a);
    }

    public function infoAction(Request $request, $id = 0, $title = null) {
        $em = $this->getDoctrine()->getManager();
        $list = array();
        $id = (int) $id;

        $listFooter = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findBy(array("active" => 1, "mid" => 0));
        if ($listFooter) {
            foreach ($listFooter as $value) {
                $list[$value->getId()] = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findBy(array("active" => 1, "mid" => $value->getId()));
            }
        }

        $listInfo = $em->getRepository('MarketZodacoBundle:Informations')->findBy(array("c_id" => $id));
        if (!$listInfo) {
            return $this->redirect($this->generateUrl("_homepage"));
        }

        $a = array("listFooter" => $listFooter, "list" => $list, "listInfo" => $listInfo, "category" => $id);
        return $this->render('MarketZodacoBundle:Terms:info.html.php', $a);
    }

    public function popularAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $list = $em->getRepository('MarketZodacoBundle:Categories')->getPopular(1, 5);

        $a = array("list" => $list);
        return $this->render('MarketZodacoBundle:Terms:popular.html.php', $a);
    }

    public function supportAction(Request $request) {
        $em = $this->getDoctrine()->getManager();
        $list = array();

        $listFooter = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findBy(array("active" => 1, "mid" => 0));
        if ($listFooter) {
            foreach ($listFooter as $value) {
                $list[$value->getId()] = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findBy(array("active" => 1, "mid" => $value->getId()));
            }
        }

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password));

        $error = 0;
        if ($request->getMethod() == 'POST') {

            $email = $request->request->get("email", "");
            $issue_id = (int) $request->request->get("issue_id", 7);
            $details = $request->request->get("details", "");

            if (filter_var($email, FILTER_VALIDATE_EMAIL) && $issue_id && $details) {
                try {
                    $em->getConnection()->beginTransaction();
                    $sub = $this->get('translator')->trans("Support Ticket") . " : ";

                    switch ($issue_id) {
                        case 1:
                            $sub .= $this->get('translator')->trans("File Issue");
                            break;
                        case 2:
                            $sub .= $this->get('translator')->trans("Payment Issue");
                            break;
                        case 3:
                            $sub .= $this->get('translator')->trans("License Inquiry");
                            break;
                        case 4:
                            $sub .= $this->get('translator')->trans("Copyright");
                            break;
                        case 5:
                            $sub .= $this->get('translator')->trans("Large Deposit");
                            break;
                        case 6:
                            $sub .= $this->get('translator')->trans("Suggestion");
                            break;
                        default:
                            $sub .= $this->get('translator')->trans("Other");
                            break;
                    }
                    
                    $noti = new Notifications();
                    $noti->setEmail($email);
                    $noti->setTitle($sub);
                    $noti->setReplyEmail($email);
                    $noti->setContent($details);
                    $em->persist($noti);

                    $em->flush();
                    $em->getConnection()->commit();
                    $error = 2;
                } catch (\Exception $e) {
                    $error = 1;
                    $em->getConnection()->rollback();
                }
            } else {
                $error = 1;
            }
        }


        $a = array("listFooter" => $listFooter, "list" => $list, "check" => $checkw, "category" => 1000, 'error' => $error);
        return $this->render('MarketZodacoBundle:Terms:support.html.php', $a);
    }

}
