<?php

namespace Market\ZodacoBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Request;

class BaseController extends Controller {

    public function __construct() {
        $session = new Session();
        $request = new Request();

        $referer = isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : "";
        $remote = $_SERVER["REMOTE_ADDR"];
        $host = $_SERVER["HTTP_HOST"];
        $uri = $_SERVER["REQUEST_URI"];
        $time = $_SERVER["REQUEST_TIME"];

        if (stripos($referer, $host) === FALSE && $referer) {
            $session->set("referers", array("referer" => $referer, "remote" => $remote, "host" => $host, "uri" => $uri, "time" => $time));
        }
        else{
            $session->remove("referers");
        }

        $locale = isset($_REQUEST['lang']) ? $_REQUEST['lang'] : "";
        if(!$locale){
            $locale = $session->get("_locale", "en");
        }
        $session->set("_locale", $locale);
        $request->setLocale($locale);

        //Set Affiliate Id
        $ref = $request->get("ref", "");
        if ($ref) {
            $session->set("ref", $ref);
        }
    }
}
