<?php

namespace Market\ZodacoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Market\ZodacoBundle\Entity\Categories;
use Market\ZodacoBundle\Entity\InformationsCategories;
use Market\ZodacoBundle\Entity\Informations;
use Market\ZodacoBundle\Entity\Products;
use Market\ZodacoBundle\Entity\Notifications;

class AdminController extends BaseController {

    //dashBoard
    public function dashBoardAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        $report = $em->getRepository('MarketZodacoBundle:Reports')->todayReport();


        $arr1 = array('report' => $report, "checkw" => $checkw);

        return $this->render('MarketZodacoBundle:Admin:dashBoard.html.php', $arr1);
    }

    //Information
    public function infoIndexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        if ($request->getMethod() == 'POST') {
            if ("demo" == $checkw->getUsername()) {
                return $this->redirect($this->generateUrl("_admin_homepage"));
            }
            $order_id = $request->request->get("order_id", 0);
            $order_id_sub = $request->request->get("order_id_sub");
            $id = $request->request->get("id");
            $id_sub = $request->request->get("id_sub");

            $lap = count($order_id);
            for ($i = 0; $i < $lap; $i++) {
                $post_id = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findOneById($id[$i]);
                $post_id->setSort($order_id[$i]);
                $em->persist($post_id);
                $em->flush();
            }

            $lap1 = count($order_id_sub);
            for ($i = 0; $i < $lap1; $i++) {
                $post_sub_id = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findOneById($id_sub[$i]);
                $post_sub_id->setSort($order_id_sub[$i]);
                $em->persist($post_sub_id);
                $em->flush();
            }
            return $this->redirect($this->generateUrl("_admin_info"));
        } else {
            $arr_0 = array();
            $list = $em->getRepository('MarketZodacoBundle:InformationsCategories')->_getAdminCatlist();
            foreach ($list as $key => $value) {
                $tmp = $em->getRepository('MarketZodacoBundle:InformationsCategories')->_getSublist($value->getId());
                if ($tmp) {
                    $arr_0[$value->getId()] = $tmp;
                } else {
                    $arr_0[$value->getId()] = 0;
                }
            }
            $arr = $arr_0;
        }

        $arr1 = array('arr' => $arr, 'list' => $list);

        return $this->render('MarketZodacoBundle:Admin:infoIndex.html.php', $arr1);
    }

    public function infoAddAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        if ($request->getMethod() == 'POST') {
            if ("demo" == $checkw->getUsername()) {
                return $this->redirect($this->generateUrl("_admin_homepage"));
            }

            $cid = $request->request->get("cid", 0);
            $title = $request->request->get("title", "");
            $shortTitle = $request->request->get("short_title", "");
            $footer = $request->request->get("footer", 0);
            $active = $request->request->get("active", 0);
            if ($title != "" && $shortTitle != "") {
                $new_cat = new InformationsCategories();
                $new_cat->setMid(intval($cid));
                $new_cat->setTitle($title);
                $new_cat->setActive($active);
                $new_cat->setShortTitle($shortTitle);
                $new_cat->setTotal($footer);
                $new_cat->setSort(0);
                $a = new \Datetime();
                $new_cat->setCreatedAt($a);
                $new_cat->setUpdatedAt($a);
                $em->persist($new_cat);
                $em->flush();
            }
            return $this->redirect($this->generateUrl("_admin_info"));
        }
        $list = $em->getRepository('MarketZodacoBundle:InformationsCategories')->_getAdminCatlist();
        $arr = array('list' => $list);

        return $this->render('MarketZodacoBundle:Admin:infoAdd.html.php', $arr);
    }

    public function infoEditAction(Request $request, $id = 0) {

        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        $id = intval($id);
        if (!$id) {
            return $this->redirect($this->generateUrl("_admin_info"));
        }
        $list = $em->getRepository('MarketZodacoBundle:InformationsCategories')->_getAdminCatlist();

        $viewT = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findOneById($id);
        if (!$viewT) {
            return $this->redirect($this->generateUrl("_admin_info"));
        }

        if ($request->getMethod() == 'POST') {
            if ("demo" == $checkw->getUsername()) {
                return $this->redirect($this->generateUrl("_admin_homepage"));
            }

            $cid = $request->request->get("cid");
            if (intval($cid) == $viewT->getId()) {
                return $this->redirect($this->generateUrl("_admin_info"));
            }

            $title = $request->request->get("title", "");
            $shortTitle = $request->request->get("short_title", "");
            $footer = $request->request->get("footer", 0);
            $active = $request->request->get("active", 0);
            if ($title != "" && $shortTitle != "") {
                try {
                    $viewT->setMid(intval($cid));
                    $viewT->setTitle($title);
                    $viewT->setActive($active);
                    $viewT->setTotal($footer);
                    $viewT->setShortTitle($shortTitle);
                    $em->persist($viewT);
                    $em->flush();
                } catch (Exception $ex) {
                    
                }
                return $this->redirect($this->generateUrl("_admin_info"));
            }
        }
        $arr = array('viewT' => $viewT, "list" => $list);
        return $this->render('MarketZodacoBundle:Admin:infoEdit.html.php', $arr);
    }

    public function infoDeleteAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        if ("demo" == $checkw->getUsername()) {
            return $this->redirect($this->generateUrl("_admin_homepage"));
        }

        if (!$id) {
            return $this->redirect($this->generateUrl("_admin_info"));
        }

        $viewT = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findOneById((int) $id);
        if ($viewT) {
            try {
                $em->remove($viewT);
                $em->flush();
            } catch (Exception $ex) {
                
            }
        }
        return $this->redirect($this->generateUrl("_admin_info"));
    }

    //Help
    public function helpIndexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $list = $em->getRepository('MarketZodacoBundle:Informations')->_getAdminCatlist();


        $arr1 = array('list' => $list);

        return $this->render('MarketZodacoBundle:Admin:helpIndex.html.php', $arr1);
    }

    public function helpAddAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        if ($request->getMethod() == 'POST') {
            if ("demo" == $checkw->getUsername()) {
                return $this->redirect($this->generateUrl("_admin_homepage"));
            }
            $cid = $request->request->get("cid", 0);
            $checkC = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findOneBy(array("id" => $cid));
            if (!$checkC) {
                return $this->redirect($this->generateUrl("_admin_detail_info"));
            }

            $title = $request->request->get("title", "");
            $details = $request->request->get("detail", "");
            $vn_details = $request->request->get("vn_detail", "");
            if ($title != "" && $details != "") {
                $new_cat = new Informations();
                $new_cat->setInformationsCategories($checkC);
                $new_cat->setTitle($title);
                $new_cat->setDetails($details);
                $new_cat->setVnDetails($vn_details);
                $a = new \Datetime();
                $new_cat->setCreatedAt($a);
                $new_cat->setUpdatedAt($a);
                $em->persist($new_cat);
                $em->flush();
            }
            return $this->redirect($this->generateUrl("_admin_detail_info"));
        }
        $list = $em->getRepository('MarketZodacoBundle:InformationsCategories')->_getAdminCatlist2();
        $arr = array('list' => $list);

        return $this->render('MarketZodacoBundle:Admin:helpAdd.html.php', $arr);
    }

    public function helpEditAction(Request $request, $id = 0) {

        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        $id = intval($id);
        if (!$id) {
            return $this->redirect($this->generateUrl("_admin_detail_info"));
        }
        $list = $em->getRepository('MarketZodacoBundle:InformationsCategories')->_getAdminCatlist2();

        $viewT = $em->getRepository('MarketZodacoBundle:Informations')->findOneById($id);
        if (!$viewT) {
            return $this->redirect($this->generateUrl("_admin_detail_info"));
        }

        if ($request->getMethod() == 'POST') {
            if ("demo" == $checkw->getUsername()) {
                return $this->redirect($this->generateUrl("_admin_homepage"));
            }
            $cid = $request->request->get("cid");
            $checkC = $em->getRepository('MarketZodacoBundle:InformationsCategories')->findOneById($cid);
            if (!$checkC) {
                return $this->redirect($this->generateUrl("_admin_detail_info"));
            }

            $title = $request->request->get("title", "");
            $details = $request->request->get("detail", "");
            $vn_details = $request->request->get("vn_detail", "");
            if ($title != "" && $details != "") {
                try {
                    $viewT->setInformationsCategories($checkC);
                    $viewT->setTitle($title);
                    $viewT->setDetails($details);
                    $viewT->setVnDetails($vn_details);
                    $em->persist($viewT);
                    $em->flush();
                } catch (Exception $ex) {
                    
                }
                return $this->redirect($this->generateUrl("_admin_detail_info"));
            }
        }
        $arr = array('viewT' => $viewT, "list" => $list);
        return $this->render('MarketZodacoBundle:Admin:helpEdit.html.php', $arr);
    }

    public function helpDeleteAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        if ("demo" == $checkw->getUsername()) {
            return $this->redirect($this->generateUrl("_admin_homepage"));
        }

        if (!$id) {
            return $this->redirect($this->generateUrl("_admin_detail_info"));
        }

        $viewT = $em->getRepository('MarketZodacoBundle:Informations')->findOneById((int) $id);
        if ($viewT) {
            try {
                $em->remove($viewT);
                $em->flush();
            } catch (Exception $ex) {
                
            }
        }
        return $this->redirect($this->generateUrl("_admin_detail_info"));
    }

    //Categories
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        if ($request->getMethod() == 'POST') {
            if ("demo" == $checkw->getUsername()) {
                return $this->redirect($this->generateUrl("_admin_homepage"));
            }
            $order_id = $request->request->get("order_id", 0);
            $order_id_sub = $request->request->get("order_id_sub");
            $id = $request->request->get("id");
            $id_sub = $request->request->get("id_sub");

            $lap = count($order_id);
            for ($i = 0; $i < $lap; $i++) {
                $post_id = $em->getRepository('MarketZodacoBundle:Categories')->findOneById($id[$i]);
                $post_id->setSort($order_id[$i]);
                $em->persist($post_id);
                $em->flush();
            }

            $lap1 = count($order_id_sub);
            for ($i = 0; $i < $lap1; $i++) {
                $post_sub_id = $em->getRepository('MarketZodacoBundle:Categories')->findOneById($id_sub[$i]);
                $post_sub_id->setSort($order_id_sub[$i]);
                $em->persist($post_sub_id);
                $em->flush();
            }
            return $this->redirect($this->generateUrl("_admin_categories"));
        } else {
            $arr_0 = array();
            $list = $em->getRepository('MarketZodacoBundle:Categories')->_getAdminCatlist();
            foreach ($list as $key => $value) {
                $tmp = $em->getRepository('MarketZodacoBundle:Categories')->_getSublist($value->getId());
                if ($tmp) {
                    $arr_0[$value->getId()] = $tmp;
                } else {
                    $arr_0[$value->getId()] = 0;
                }
            }
            $arr = $arr_0;
        }

        $arr1 = array('arr' => $arr, 'list' => $list);

        return $this->render('MarketZodacoBundle:Admin:categoriesIndex.html.php', $arr1);
    }

    public function categoriesAddAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        if ($request->getMethod() == 'POST') {
            if ("demo" == $checkw->getUsername()) {
                return $this->redirect($this->generateUrl("_admin_homepage"));
            }
            $cid = $request->request->get("cid", 0);
            $title = $request->request->get("title", "");
            $smallIcon = $request->request->get("upanh", "");
            $largeIcon = $request->request->get("licon", "");
            $shortTitle = $request->request->get("short_title", "");
            $longTitle = $request->request->get("details", "");
            $active = $request->request->get("active", 0);
            if ($title != "" && $smallIcon != "" && $largeIcon != "" && $shortTitle != "" && $longTitle != "") {
                $new_cat = new Categories();
                $new_cat->setMid(intval($cid));
                $new_cat->setTitle($title);
                $new_cat->setActive($active);
                $new_cat->setLargeIcon($largeIcon);
                $new_cat->setSmallIcon($smallIcon);
                $new_cat->setLongTitle($longTitle);
                $new_cat->setShortTitle($shortTitle);
                $new_cat->setTotal(0);
                $new_cat->setSort(0);
                $a = new \Datetime();
                $new_cat->setCreatedAt($a);
                $new_cat->setUpdatedAt($a);
                $em->persist($new_cat);
                $em->flush();
                if ($largeIcon) {
                    @copy('uploads/tmp/' . $largeIcon, 'uploads/categories/' . $largeIcon);
                    @unlink('uploads/tmp/' . $largeIcon);
                }
                if ($smallIcon) {
                    @copy('uploads/tmp/' . $smallIcon, 'uploads/categories/' . $smallIcon);
                    @unlink('uploads/tmp/' . $smallIcon);
                }
            }
            return $this->redirect($this->generateUrl("_admin_categories"));
        }
        $list = $em->getRepository('MarketZodacoBundle:Categories')->_getAdminCatlist();
        $arr = array('list' => $list);

        return $this->render('MarketZodacoBundle:Admin:categoriesAdd.html.php', $arr);
    }

    public function categoriesEditAction(Request $request, $id = 0) {

        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        $id = intval($id);
        if (!$id) {
            return $this->redirect($this->generateUrl("_admin_categories"));
        }
        $list = $em->getRepository('MarketZodacoBundle:Categories')->_getAdminCatlist();

        $viewT = $em->getRepository('MarketZodacoBundle:Categories')->findOneById($id);
        if (!$viewT) {
            return $this->redirect($this->generateUrl("_admin_categories"));
        }

        if ($request->getMethod() == 'POST') {
            if ("demo" == $checkw->getUsername()) {
                return $this->redirect($this->generateUrl("_admin_homepage"));
            }
            $cid = $request->request->get("cid");
            if (intval($cid) == $viewT->getId()) {
                return $this->redirect($this->generateUrl("_admin_categories"));
            }

            $title = $request->request->get("title", "");
            $smallIcon = $request->request->get("upanh", "");
            $largeIcon = $request->request->get("licon", "");
            $shortTitle = $request->request->get("short_title", "");
            $longTitle = $request->request->get("details", "");

            $largeIcon2 = $viewT->getLargeIcon();
            $smallIcon2 = $viewT->getSmallIcon();

            $active = $request->request->get("active", 0);
            if ($title != "" && $smallIcon != "" && $largeIcon != "" && $shortTitle != "" && $longTitle != "") {
                try {
                    $viewT->setMid(intval($cid));
                    $viewT->setTitle($title);
                    $viewT->setActive($active);
                    $viewT->setLargeIcon($largeIcon);
                    $viewT->setSmallIcon($smallIcon);
                    $viewT->setLongTitle($longTitle);
                    $viewT->setShortTitle($shortTitle);
                    $em->persist($viewT);
                    $em->flush();
                    if ($largeIcon2 != $largeIcon) {
                        @copy('uploads/tmp/' . $largeIcon, 'uploads/categories/' . $largeIcon);
                        @unlink('uploads/tmp/' . $largeIcon);
                        @unlink('uploads/categories/' . $largeIcon2);
                    }
                    if ($smallIcon2 != $smallIcon) {
                        @copy('uploads/tmp/' . $smallIcon, 'uploads/categories/' . $smallIcon);
                        @unlink('uploads/tmp/' . $smallIcon);
                        @unlink('uploads/categories/' . $smallIcon2);
                    }
                } catch (Exception $ex) {
                    
                }
                return $this->redirect($this->generateUrl("_admin_categories"));
            }
        }
        $arr = array('viewT' => $viewT, "list" => $list);
        return $this->render('MarketZodacoBundle:Admin:categoriesEdit.html.php', $arr);
    }

    public function deleteAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        if ("demo" == $checkw->getUsername()) {
            return $this->redirect($this->generateUrl("_admin_homepage"));
        }

        if (!$id) {
            return $this->redirect($this->generateUrl("_admin_categories"));
        }

        $viewT = $em->getRepository('MarketZodacoBundle:Categories')->findOneById((int) $id);
        if ($largeIcon = $viewT->getLargeIcon()) {
            @unlink('uploads/categories/' . $largeIcon);
        }
        if ($smallIcon = $viewT->getSmallIcon()) {
            @unlink('uploads/categories/' . $smallIcon);
        }

        $em->getRepository('MarketZodacoBundle:Categories')->_delId((int) $id);
        return $this->redirect($this->generateUrl("_admin_categories"));
    }

    //Products
    public function newProductsAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        $page = isset($_REQUEST["p"]) ? (int) $_REQUEST["p"] : 1;
        if (!$page || $page < 1) {
            $page = 1;
        }
        $limit = 20;

        $total = $em->getRepository('MarketZodacoBundle:Products')->_getCountCondition(1);
        $list = $em->getRepository('MarketZodacoBundle:Products')->_getProCondition(1, $page, $limit);

        $pager2 = array();
        $pager2['PreviousPage'] = ($page > 1) ? ($page - 1) : $page;
        $pager2['NextPage'] = (ceil($total / $limit) > $page) ? ($page + 1) : $page;
        $pager2['LastPage'] = ceil($total / $limit);
        $pager2['Page'] = $page;

        $arr1 = array('pager2' => $pager2, 'list' => $list, 'total' => $total, 'page' => $page, "urlN" => "new_products");
        return $this->render('MarketZodacoBundle:Admin:productsNew.html.php', $arr1);
    }

    public function updateProductsAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        $page = isset($_REQUEST["p"]) ? (int) $_REQUEST["p"] : 1;
        if (!$page || $page < 1) {
            $page = 1;
        }
        $limit = 20;

        $total = $em->getRepository('MarketZodacoBundle:Products')->_getCountCondition(0);
        $list = $em->getRepository('MarketZodacoBundle:Products')->_getProCondition(0, $page, $limit);

        $pager2 = array();
        $pager2['PreviousPage'] = ($page > 1) ? ($page - 1) : $page;
        $pager2['NextPage'] = (ceil($total / $limit) > $page) ? ($page + 1) : $page;
        $pager2['LastPage'] = ceil($total / $limit);
        $pager2['Page'] = $page;

        $arr1 = array('pager2' => $pager2, 'list' => $list, 'total' => $total, 'page' => $page, "urlN" => "update_products");
        return $this->render('MarketZodacoBundle:Admin:productsNew.html.php', $arr1);
    }

    public function reviewProductsAction(Request $request, $id = 0) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        $error = 0;

        $product = $em->getRepository('MarketZodacoBundle:Products')->findOneBy(array("id" => (int) $id));
        if (!$product) {
            throw new NotFoundHttpException("Not found");
        }


        $pre2 = "";
        $main2 = "";
        $icon2 = "";
        $scre2 = "";

        if (($product->getActive() == 1 && $product->getStatus() == 1) || ($product->getActive() == 0 && $product->getStatus() == 0)) {
            if ($request->getMethod() == 'POST') {
                if ("demo" == $checkw->getUsername()) {
                    return $this->redirect($this->generateUrl("_admin_homepage"));
                }
                $type = $request->request->get("type", 0);
                try {

                    $em->getConnection()->beginTransaction();

                    $path = dirname(dirname(dirname(dirname(dirname(__FILE__)))));
                    $tmp = $path . "/web/uploads/tmp/";
                    $disImg = $path . "/web/uploads/items/";
                    $disFile = $path . "/items/";


                    if ($type == 0) {

                        $title = $request->request->get("title", "");
                        $short_title = $request->request->get("short_title", "");
                        $details = $request->request->get("details", "");
                        $demoUrl = $request->request->get("demo_url", "");
                        $videoUrl = $request->request->get("video_url", "");

                        $price = floatval($request->request->get("price", ""));
                        $price2 = floatval($request->request->get("price2", ""));
                        if ($price > 0){
                            $product->setPrice($price);
                        }
                        if($price2 >= 0){
                            $product->setPricePlus($price2);
                        }
                        if ($title) {
                            $product->setTitle($title);
                        }
                        if ($short_title) {
                            $product->setShortDetails($short_title);
                        }
                        if ($details) {
                            $product->setDetails($details);
                        }
                        $product->setDemoUrl($demoUrl);
                        $product->setVideoUrl($videoUrl);

                        if ($product->getStatus() == 1 && $product->getActive() == 1) {
                            $pre = $product->getUpdatePreview();
                            $main = $product->getUpdateMainFile();
                            $icon = $product->getUpdateIcon();
                            $scre = $product->getUpdateScreenshots();

                            $a = 0;

                            $product->setUpdateTitle("");
                            $product->setUpdateMainFile("");
                            $product->setUpdateScreenshots("");
                            $product->setUpdatePreview("");
                            $product->setUpdateIcon("");

                            if ($main) {
                                $main2 = $product->getMainFile();
                                $product->setMainFile($main);
                            }
                            if ($scre) {
                                $scre2 = $product->getScreenshots();
                                $product->setScreenshots($scre);
                            }
                            if ($pre) {
                                $pre2 = $product->getPreview();
                                $product->setPreview($pre);
                            }
                            if ($icon) {
                                $icon2 = $product->getIcon();
                                $product->setIcon($icon);
                            }

                            $content = $this->get('translator')->trans('Dear') . ' ' . $product->getUsers()->getUsername() . ',<br><br>' .
                                    $this->get('translator')->trans('The update you submitted for') . ' "' . $product->getTitle() . '" ' . $this->get('translator')->trans('has been approved by the review team.') . '<br>' .
                                    $this->get('translator')->trans('The new release has replaced the old version of your product.') . '<br><br>' .
                                    $this->get('translator')->trans('The Zodaco Support team wishes you success on Zodaco Marketplace!') . '<br><br>' .
                                    $this->get('translator')->trans('Regards') . ',<br>' .
                                    $this->get('translator')->trans('Zodaco Marketplace // Support team') . '<br>http://www.' . $request->getHost();
                            $sub = $this->get('translator')->trans("Product update approved");
                        } else if ($product->getStatus() == 0 && $product->getActive() == 0) {

                            $pre = $product->getPreview();
                            $main = $product->getMainFile();
                            $icon = $product->getIcon();
                            $scre = $product->getScreenshots();

                            $a = 1;

                            $checkowner = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("id" => $product->getUsers()->getId()));
                            if ($checkowner) {
                                $checkowner->setTotalFile($checkowner->getTotalFile() + 1);
                                $em->persist($checkowner);
                            }
                            $em->getRepository('MarketZodacoBundle:Categories')->updateTotal("c.total", $product->getCategories()->getId());
                            $em->getRepository('MarketZodacoBundle:Categories')->updateTotal("c.total", $product->getCategories()->getMid());

                            $rate = floatval($this->container->getParameter('netMoney'));
                            $netMoney1 = round($product->getPrice() * $rate, 2);
                            $netMoney2 = round($product->getPricePlus() * $rate, 2);
                            $rate = $rate * 100;
                            $url = $this->generateUrl('view_products', array('id' => $product->getId(), 'title' => \Market\ZodacoBundle\System::_reString($product->getTitle())), true);


                            $content = $this->get('translator')->trans("Congratulations") . ' ' . $product->getUsers()->getUsername() . ',<br>' .
                                    $this->get('translator')->trans("Your item") . ' "' . $product->getTitle() . '" ' . $this->get('translator')->trans("has been approved and is now visible on Zodaco Marketplace.") .
                                    '<br><br>' .
                                    $this->get('translator')->trans("This is your app download page:") . ' ' . $url .
                                    '<br><br>' .
                                    $this->get('translator')->trans("This page will help you promote your app on the web and social channels, do not hesitate to share this link with your friends through twitter, facebook, blog, website.") . '<br><br>' .
                                    $this->get('translator')->trans("The sales price for the Regular License is:") . ' $' . number_format($product->getPrice(), 2) . '.<br><br>' .
                                    $this->get('translator')->trans("The sales price for the Extended License is:") . ' $' . number_format($product->getPricePlus(), 2) . '.<br><br>' .
                                    $this->get('translator')->trans("Your commission for this App is") . ' ' . $rate . '%.<br><br>' .
                                    $this->get('translator')->trans("Your profit for each sale made will be:") . '<br><br>' .
                                    '$' . $netMoney1 . ' - ' . $this->get('translator')->trans("Regular License") . '<br><br>' .
                                    '$' . $netMoney2 . ' - ' . $this->get('translator')->trans("Extended License") . '<br><br>' .
                                    $this->get('translator')->trans("Sincerely") . ',<br>' .
                                    $this->get('translator')->trans("Zodaco Marketplace") . '<br>http://www.' . $request->getHost();
                            $sub = $this->get('translator')->trans("Product approved");
                        }

                        $product->setStatus(0);
                        $product->setActive(1);
                        $em->persist($product);

                        $noti = new Notifications();
                        $noti->setEmail($product->getUsers()->getEmail());
                        $noti->setReplyEmail('');
                        $noti->setTitle($sub);
                        $noti->setContent($content);
                        $em->persist($noti);

                        $em->flush();
                        $em->getConnection()->commit();

                        if ($pre) {
                            @copy($tmp . $pre, $disImg . $pre);
                            @unlink($tmp . $pre);
                        }
                        if ($main) {
                            @copy($tmp . $main, $disFile . $main);
                            @unlink($tmp . $main);
                        }
                        if ($icon) {
                            @copy($tmp . $icon, $disImg . $icon);
                            @unlink($tmp . $icon);
                        }
                        if ($scre) {
                            @copy($tmp . $scre, $disFile . $scre);
                            @unlink($tmp . $scre);
                        }
                        if ($pre2) {
                            @unlink($disImg . $pre2);
                        }
                        if ($main2) {
                            @unlink($disFile . $main2);
                        }
                        if ($icon2) {
                            @unlink($disImg . $icon2);
                        }
                        if ($scre2) {
                            @unlink($disFile . $scre2);
                        }


                        if ($a == 0) {
                            return $this->redirect($this->generateUrl("update_products"));
                        } else {
                            return $this->redirect($this->generateUrl("new_products"));
                        }
                    } else {

                        $content = $this->get('translator')->trans('Hi') . ' ' . $product->getUsers()->getUsername() . ',<br>' .
                                $this->get('translator')->trans('Unfortunately your submission') . ' ' . $product->getTitle() . ' ' .
                                $this->get('translator')->trans("isn't ready for Zodaco Marketplace and cannot be resubmitted as it did not meet our minimum requirements for quality and/or Zodaco Market policies.") . '<br>' .
                                $this->get('translator')->trans('If you have any question, please do not hesitate to contact us.') . '<br><br>' .
                                $this->get('translator')->trans('Thanks for your submission!') . '<br>' .
                                $this->get('translator')->trans('Regards,') . '<br>' .
                                $this->get('translator')->trans('Zodaco Marketplace') . '<br>';


                        if ($product->getStatus() == 0 && $product->getActive() == 0) {

                            $pre2 = $product->getPreview();
                            $main2 = $product->getMainFile();
                            $icon2 = $product->getIcon();
                            $scre2 = $product->getScreenshots();

                            $sub = $this->get('translator')->trans('Your uploaded item rejected');

                            $noti = new Notifications();
                            $noti->setEmail($product->getUsers()->getEmail());
                            $noti->setReplyEmail('');
                            $noti->setTitle($sub);
                            $noti->setContent($content);
                            $em->persist($noti);

                            $em->remove($product);
                            $em->flush();

                            $em->getConnection()->commit();

                            if ($pre2) {
                                @unlink($tmp . $pre2);
                            }
                            if ($main2) {
                                @unlink($tmp . $main2);
                            }
                            if ($icon2) {
                                @unlink($tmp . $icon2);
                            }
                            if ($scre2) {
                                @unlink($tmp . $scre2);
                            }
                            return $this->redirect($this->generateUrl("new_products"));
                        } else {

                            $pre2 = $product->getUpdatePreview();
                            $main2 = $product->getUpdateMainFile();
                            $icon2 = $product->getUpdateIcon();
                            $scre2 = $product->getUpdateScreenshots();

                            $product->setUpdateTitle("");
                            $product->setUpdateMainFile("");
                            $product->setUpdateScreenshots("");
                            $product->setUpdatePreview("");
                            $product->setUpdateIcon("");

                            $product->setStatus(0);
                            $product->setActive(1);
                            $em->persist($product);

                            $sub = $this->get('translator')->trans('Your updated item rejected');

                            $noti = new Notifications();
                            $noti->setEmail($product->getUsers()->getEmail());
                            $noti->setReplyEmail('');
                            $noti->setTitle($sub);
                            $noti->setContent($content);
                            $em->persist($noti);


                            $em->flush();
                            $em->getConnection()->commit();


                            if ($pre2) {
                                @unlink($tmp . $pre2);
                            }
                            if ($main2) {
                                @unlink($tmp . $main2);
                            }
                            if ($icon2) {
                                @unlink($tmp . $icon2);
                            }
                            if ($scre2) {
                                @unlink($tmp . $scre2);
                            }

                            return $this->redirect($this->generateUrl("update_products"));
                        }
                    }

                    $em->getConnection()->commit();
                } catch (Exception $ex) {
                    $em->getConnection()->rollback();
                    $error = 1;
                }
            }
        }

        $update = 0;
        if ($product->getActive() == 1 && $product->getStatus() == 1) {
            $update = 1;
        }
        $arr1 = array('product' => $product, "error" => $error, "update" => $update);
        return $this->render('MarketZodacoBundle:Admin:reviewProducts.html.php', $arr1);
    }

    public function searchUserAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        return $this->render('MarketZodacoBundle:Admin:searchUser.html.php', array());
    }

    public function viewUserAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        $error = 0;

        $id = isset($_REQUEST["s"]) ? $_REQUEST["s"] : "";

        $product = $em->getRepository('MarketZodacoBundle:Users')->findOneByUsername($id);

        if ($product) {
            if ($request->getMethod() == 'POST') {
                if ("demo" == $checkw->getUsername()) {
                    return $this->redirect($this->generateUrl("_admin_homepage"));
                }
                try {
                    $em->getConnection()->beginTransaction();
                    if ($product->getActive() == 1) {
                        $product->setActive(0);

                        $content = $this->get('translator')->trans('Hi') . ' ' . $product->getUsername() . ',<br>' .
                                $this->get('translator')->trans('Unfortunately!') .
                                $this->get('translator')->trans("Your account disabled") . '<br><br>' .
                                $this->get('translator')->trans('Regards,') . '<br>' .
                                $this->get('translator')->trans('Zodaco Marketplace') . '<br>';

                        $sub = $this->get('translator')->trans('Your account disabled');
                    } else {
                        $product->setActive(1);

                        $content = $this->get('translator')->trans('Hi') . ' ' . $product->getUsername() . ',<br>' .
                                $this->get('translator')->trans("Your account enabled") . '<br><br>' .
                                $this->get('translator')->trans('Regards,') . '<br>' .
                                $this->get('translator')->trans('Zodaco Marketplace') . '<br>';


                        $sub = $this->get('translator')->trans('Your account enabled');
                    }

                    $noti = new Notifications();
                    $noti->setEmail($product->getEmail());
                    $noti->setReplyEmail('');
                    $noti->setTitle($sub);
                    $noti->setContent($content);
                    $em->persist($noti);

                    $em->persist($product);
                    $em->flush();
                    $em->getConnection()->commit();
                } catch (Exception $ex) {
                    $em->getConnection()->rollback();
                    $error = 1;
                }
            }
        }
        $arr1 = array('login' => $product, "error" => $error);
        return $this->render('MarketZodacoBundle:Admin:viewUser.html.php', $arr1);
    }

    public function searchProductsAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        return $this->render('MarketZodacoBundle:Admin:searchProducts.html.php', array());
    }

    public function viewProductsAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }

        $error = 0;

        $id = isset($_REQUEST["s"]) ? intval($_REQUEST["s"]) : 0;

        $product = $em->getRepository('MarketZodacoBundle:Products')->findOneById((int) $id);

        if ($product) {
            if ($request->getMethod() == 'POST') {
                if ("demo" == $checkw->getUsername()) {
                    return $this->redirect($this->generateUrl("_admin_homepage"));
                }
                try {
                    $em->getConnection()->beginTransaction();
//                    if ($product->getActive() == 0 && $product->getStatus() == 3) {
//                        $product->setStatus(0);
//                        $product->setActive(1);
//                    } else if ($product->getActive() == 0 && $product->getStatus() == 3) {
                    $product->setStatus(3);
                    $product->setActive(0);

                    $content = $this->get('translator')->trans('Hi') . ' ' . $product->getUsers()->getUsername() . ',<br>' .
                            $this->get('translator')->trans('Unfortunately your item') . ' ' . $product->getTitle() . ' ' .
                            $this->get('translator')->trans("isn't ready for Zodaco Marketplace.") . '<br>' .
                            $this->get('translator')->trans('If you have any question, please do not hesitate to contact us.') . '<br><br>' .
                            $this->get('translator')->trans('Thanks for your submission!') . '<br>' .
                            $this->get('translator')->trans('Regards,') . '<br>' .
                            $this->get('translator')->trans('Zodaco Marketplace') . '<br>';

                    $sub = $this->get('translator')->trans('Your item rejected');

                    $noti = new Notifications();
                    $noti->setEmail($product->getUsers()->getEmail());
                    $noti->setReplyEmail('');
                    $noti->setTitle($sub);
                    $noti->setContent($content);
                    $em->persist($noti);


//                    }
                    $em->persist($product);
                    $em->flush();
                    $em->getConnection()->commit();
                } catch (Exception $ex) {
                    $em->getConnection()->rollback();
                    $error = 1;
                }
            }
        }
        $arr1 = array('product' => $product, "error" => $error);
        return $this->render('MarketZodacoBundle:Admin:viewProducts.html.php', $arr1);
    }

    public function newsletterAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $session = $request->getSession();
        $username = $session->get('username', "");
        $password = $session->get('password', "");
        if (!$username || !$password) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $checkw = $em->getRepository('MarketZodacoBundle:Users')->findOneBy(array("email" => $username, "password" => $password, "supper" => 1, "active" => 1));
        if (!$checkw) {
            $session->clear();
            return $this->redirect($this->generateUrl("login"));
        }
        $error = 0;
        if ($request->getMethod() == 'POST') {
            if ("demo" == $checkw->getUsername()) {
                return $this->redirect($this->generateUrl("_admin_homepage"));
            }
            $title = $request->request->get("title", "");
            $details = $request->request->get("details", "");
            if ($title && $details) {
                try {
                    $query = "INSERT INTO Notifications (email, title, content, reply_email) SELECT email, :title, :details, '' FROM `NewsLetters` WHERE active = :active";
                    $connection = $em->getConnection();
                    $statement = $connection->prepare($query);
                    $statement->bindValue('active', 1);
                    $statement->bindValue('title', $title);
                    $statement->bindValue('details', $details);
                    $statement->execute();
                    $error = 2;
                } catch (\Exception $e) {
                    $error = 1;
                }
            } else {
                $error = 1;
            }
        }
        $a = array('error' => $error);
        return $this->render('MarketZodacoBundle:Admin:newsletter.html.php', $a);
    }

}
