<?php
/**
 * Zombify Twitch Class
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
    die( 'No direct script access allowed' );
}

if( !class_exists("Zombify_Twitch_Embed") ) {

    class Zombify_Twitch_Embed extends Zombify_Embed {

        public static function createEmbed( $url, $host, $cached_data, $view, $ajax, $post_id )
        {
        	$embed         = [];
            $iframe_url    = '';

        	if( !$cached_data ) {

                $url        = trim( $url );
                $url        = rtrim($url, '/');
	        	$url_array 	= explode( '/', $url );
	        	$video_id 	= end( $url_array );
	        	$video_type = 'Twitch';

	        } else {

	        	$embed_variables    = zf_decode_data($cached_data['embed_variables']);
	        	$video_id          	= $embed_variables['video_id'];
	        	$video_type 		= $cached_data['embed_type'];

	        }

            if( strpos($url, '/videos/') !== false ) {

                $iframe_url = 'https://player.twitch.tv/?video=v' . $video_id . '&autoplay=false';

            } else {

                $iframe_url = 'https://player.twitch.tv/?channel=' . $video_id;

            }

            $embed['html']          = '<div class="zf-embed-cont"><iframe width="600px" height="400px" src="' . $iframe_url . '" frameborder="0" allowfullscreen></iframe></div>';
        	$embed['thumbnail'] 	= 'https://static-cdn.jtvnw.net/previews-ttv/live_user_' . $video_id . '-320x180.jpg';
        	$embed['type'] 			= $video_type;
        	$embed['variables']     = zf_encode_data( ['video_id' => $video_id] );
        	$embed['url']		 	= $url;

        	if( !$cached_data && $view ) parent::saveEmbedCode( $embed );

        	return $embed;
        }

    }

}