<?php
/**
 * Zombify Facebook Class
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
    die( 'No direct script access allowed' );
}

if( !class_exists("Zombify_Facebook_Embed") ) {

    class Zombify_Facebook_Embed extends Zombify_Embed {

        public static $unique_html = false;

        public static function createEmbed( $url, $host, $cached_data, $view, $ajax, $post_id )
        {
            $embed          = [];
            $thumbnail      = '';
            $parse_script   = '';

            $url            = trim( $url );
            $url            = rtrim($url, '/');
            $url_array      = explode( '/', $url );
            $locale         = get_locale();

            if( isset($url_array[4]) ) {
                $post_type  = $url_array[4];
            } else {
                $post_type  = 'post';
            }

            $video_id       = end( $url_array );
            $type           = 'Facebook';

            if( trim( $video_id ) === '' ) {
                $video_id  = $url_array[sizeof( $url_array ) - 2];
            }

            $video_id = trim( $video_id );

            if( strpos($url, 'fbid') !== false )
                $post_type = 'post';


            if( $post_type === 'videos' ) {

                $post_type = 'video';

            } else if( $post_type === 'posts' || $post_type === 'photos' ) {

                $post_type = 'post';

            }

            if( !self::$unique_html ) {

                $parse_script = "<script>
                                    window.fbAsyncInit = function() {
                                        FB.init({
                                            xfbml      : true,
                                            version    : 'v2.5'
                                        });
                                        }; (function(d, s, id){
                                            var js, fjs = d.getElementsByTagName(s)[0];
                                            if (d.getElementById(id)) {FB.XFBML.parse(); return;}
                                            js = d.createElement(s); js.id = id;
                                            js.src = \"//connect.facebook.net/" . $locale . "/sdk.js\";
                                            fjs.parentNode.insertBefore(js, fjs);
                                    }(document, 'script', 'facebook-jssdk'));
                                </script>";

                self::$unique_html = true;

            }


            if( !$view ) {

                $embed['html'] = $parse_script . "<div class='fb-" . $post_type . "' data-href='" . $url . "'></div>";

            } else {

                $embed['html'] = $parse_script . '<div class="zf-embed-cont">' . parent::getWpEmbedCode( $url, $ajax, $post_id, $view ) . '</div>';

            }


            if( $ajax ) {

                $thumbnail = 'https://graph.facebook.com/' . $video_id . '/picture';
                $response  = wp_remote_head($thumbnail);
                $thumbnail = wp_remote_retrieve_header( $response, 'location' );

            }

            $embed['thumbnail']     = $thumbnail;
            $embed['type']          = $type;
            $embed['variables']     = '';
            $embed['url']           = $url;


            return $embed;
        }

    }

}