<?php
$zf_config = [
	'zf_post_types' => [
		"personality" => array(
            'name'          => esc_html__("Personality quiz", "zombify"),
            'description'   => esc_html__("Series of questions that intends to reveal something about the personality", "zombify"),
            'order'         => 1,
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 1,
        ),
        "trivia" => array(
            'name'          => esc_html__("Trivia quiz", "zombify"),
            'description'   => esc_html__("Series of questions with right and wrong answers that intends to check knowledge", "zombify"),
            'order'         => 2,
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 1,
        ),
        "poll" => array(
            'name'          => esc_html__("Poll", "zombify"),
            'description'   => esc_html__("Voting to make decisions or determine opinions", "zombify"),
            'order'         => 3,
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 1,
        ),
        "story" => array(
            'name'          => esc_html__("Story", "zombify"),
            'description'   => esc_html__("Formatted Text with Embeds and Visuals", "zombify"),
            'order'         => 4,
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 1,
        ),
        "list" => array(
            'name'          => esc_html__("List", "zombify"),
            'description'   => esc_html__("The Classic Internet Listicles", "zombify"),
            'order'         => 5,
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 1,
        ),
		"countdown" => array(
            'name'          => esc_html__("Countdown", "zombify"),
            'description'   => esc_html__("The Classic Internet Countdowns", "zombify"),
            'order'         => 6,
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 1,
        ),
        "openlist" => array(
            'name'          => esc_html__("Open List", "zombify"),
            'description'   => esc_html__("Submit your own item and vote up for the best submission", "zombify"),
            'order'         => 7,
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 1,
        ),
        "rankedlist" => array(
            'name'          => esc_html__("Ranked List", "zombify"),
            'description'   => esc_html__("Upvote or downvote to decide the best list item", "zombify"),
            'order'         => 8,
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 1,
        ),
        "meme" => array(
            'name'          => esc_html__("Meme", "zombify"),
            'description'   => esc_html__("Upload your own images to make custom memes", "zombify"),
            'order'         => 9,
            'excerpt'       => 1,
            'preface'       => 1,
            'show'          => 1,
        ),
        "video" => array(
            'name'          => esc_html__("Video", "zombify"),
            'description'   => esc_html__("Youtube, Vimeo or Vine Embeds", "zombify"),
            'order'         => 10,
            'excerpt'       => 1,
            'preface'       => 1,
            'show'          => 1,
        ),
        "audio" => array(
            'name'          => esc_html__("Audio", "zombify"),
            'description'   => esc_html__("Soundcloud or Mixcloud Embeds", "zombify"),
            'order'         => 11,
            'excerpt'       => 1,
            'preface'       => 1,
            'show'          => 1,
        ),
        "image" => array(
            'name'          => esc_html__("Image", "zombify"),
            'description'   => esc_html__("Photo or GIF", "zombify"),
            'order'         => 12,
            'excerpt'       => 1,
            'preface'       => 1,
            'show'          => 1,
        ),
        "gif" => array(
            'name'          => esc_html__("Gif", "zombify"),
            'description'   => esc_html__("GIF format", "zombify"),
            'order'         => 13,
            'excerpt'       => 1,
            'preface'       => 1,
            'show'          => 1,
        ),
	],
    'zf_editor' => [
        'zf_editor_adv_height'              => 250,
        'zf_editor_lt_height'               => 175,
        'zf_editor_adv_char_counter_max'    => 25000,
        'zf_editor_lt_char_counter_max'     => 25000,
        'zf_editor_paragraphs'              => [
            'N'     => 'Normal',
            'H2'    => 'Heading 2',
            'H3'    => 'Heading 3',
            'H4'    => 'Heading 4',
            'H5'    => 'Heading 5',
            'H6'    => 'Heading 6',
        ],
        'zf_editor_adv_toolbar'             => ['paragraphFormat','bold', 'italic', 'underline', 'strikeThrough', 'align', 'formatOL', 'formatUL', 'insertTable', 'insertImage', 'insertLink', 'undo', 'redo', 'quote', 'html'],
        'zf_editor_adv_mobile_toolbar'      => ['paragraphFormat','bold', 'italic', 'underline', 'strikeThrough', 'align', 'formatOL', 'formatUL', 'insertTable', 'insertImage', 'insertLink', 'undo', 'redo', 'quote', 'html'],
        'zf_editor_lt_toolbar'              => ['bold', 'italic', 'underline', 'strikeThrough', 'align', 'formatOL', 'formatUL', 'insertLink', 'undo', 'redo'],
        'zf_editor_lt_mobile_toolbar'       => ['bold', 'italic', 'underline', 'strikeThrough', 'align', 'formatOL', 'formatUL', 'insertLink', 'undo', 'redo'],
        'zf_editor_adv_image_default_width' => 0,
        'zf_editor_lt_image_default_width'  => 0,
        'zf_editor_adv_placeholder'         => '',
        'zf_editor_lt_placeholder'          => '',
        'zf_editor_loader'                  => plugins_url('zombify') . '/assets/images/loading.gif',
        'zf_editor_paste_plain'             => false,
        'zf_spellcheck'                     => false,
        'zf_rtg_options'                    => false,

    ],
    'zf_excerpt_characters_limit' => 165,
    'sub_groups_labels' => array(
        "text" => __("Text", "zombify"),
        "image" => __("Image", "zombify"),
        "embedd" => __("Embed", "zombify"),
        "link" => __("Link", "zombify"),
        "poll" => __("Poll", "zombify"),
        "personality" => __("Personality Quiz", "zombify"),
        "trivia" => __("Trivia", "zombify"),
        "story_list" => __("Listicle", "zombify"),
        "story_countdown" => __("Countdown", "zombify"),
        "audio" => __("Audio", "zombify"),
        "video" => __("Video", "zombify"),
        "gif" => __("Gif", "zombify"),
    ),
    "post_sub_types" => array(
        "main" => array(
            "name"     => esc_html__("Story", "zombify"),
            "description"     => esc_html__("Formatted Text with Embeds and Visuals", "zombify"),
            "formats"   => array(),
            "icon" => "story",
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 0,
            'first_group'   => '',
            'order'         => 1,
        ),
        "personality" => array(
            "name"     => esc_html__("Personality quiz", "zombify"),
            "description"     => "",
            "formats"   => array(),
            "icon" => "personality",
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 0,
            'first_group'   => 'personality',
            'order'         => 2,
        ),
        "trivia" => array(
            "name"     => esc_html__("Trivia quiz", "zombify"),
            "description"     => "",
            "formats"   => array(),
            "icon" => "trivia",
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 0,
            'first_group'   => 'trivia',
            'order'         => 3,
        ),
        "poll" => array(
            "name"     => esc_html__("Poll", "zombify"),
            "description"     => "",
            "formats"   => array(),
            "icon" => "poll",
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 0,
            'first_group'   => 'poll',
            'order'         => 4,
        ),
        "list" => array(
            "name"     => esc_html__("List", "zombify"),
            "description"     => "",
            "formats"   => array(),
            "icon" => "list",
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 0,
            'first_group'   => 'story_list',
            'order'         => 5,
        ),
        "video" => array(
            "name"     => esc_html__("Video", "zombify"),
            "description"     => "",
            "formats"   => array(),
            "icon" => "video",
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 0,
            'first_group'   => 'video',
            'order'         => 6,
        ),
        "audio" => array(
            "name"     => esc_html__("Audio", "zombify"),
            "description"     => "",
            "formats"   => array(),
            "icon" => "audio",
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 0,
            'first_group'   => 'audio',
            'order'         => 7,
        ),
        "image" => array(
            "name"     => esc_html__("Image", "zombify"),
            "description"     => "",
            "formats"   => array(),
            "icon" => "image",
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 0,
            'first_group'   => 'image',
            'order'         => 8,
        ),
        "gif" => array(
            "name"     => esc_html__("Gif", "zombify"),
            "description"     => "",
            "formats"   => array(),
            "icon" => "gif",
            'excerpt'       => 0,
            'preface'       => 0,
            'show'          => 0,
            'first_group'   => 'gif',
            'order'         => 9,
        ),
    ),
];