<?php
/**
 * Library configuration
 *
 * @package "All In One Meta" library
 * @since   1.0.0
 * @version 1.0.0
 */

// Prevent direct script access.
if ( !defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( ! class_exists( 'AIOM_Config' ) ) {

	/**
	 * Class AIOM_Config
	 */
	final class AIOM_Config {

		/**
		 * Holds meta key name for post
		 * @var string
		 */
		private static $post_meta_key = 'aiom';

		/**
		 * Holds meta key name for taxonomy
		 * @var string
		 */
		private static $tax_meta_key = 'aiom';
		
		/**
		 * Holds meta key name for user
		 * @var string
		 */
		private static $user_meta_key = 'aiom';

		/**
		 * Setup configuration
		 *
		 * @param array $args         Configuration array
		 *
		 * @throws Exception
		 */
		public static function setup( $args ) {
			$args = wp_parse_args( $args, array(
				'post_meta_key' => 'aiom',
				'tax_meta_key'  => 'aiom',
				'user_meta_key' => 'aiom',
			) );

			if ( ! $args[ 'post_meta_key' ] ) {
				echo __( 'post_meta_key is required', 'aiom' ); die;
			}

			if ( ! $args[ 'tax_meta_key' ] ) {
				echo __( 'tax_meta_key is required', 'aiom' ); die;
			}
			
			if ( ! $args[ 'user_meta_key' ] ) {
				echo __( 'user_meta_key is required', 'aiom' ); die;
			}

			static::$post_meta_key = $args[ 'post_meta_key' ];
			static::$tax_meta_key = $args[ 'tax_meta_key' ];
			static::$user_meta_key = $args[ 'user_meta_key' ];
		}

		/**
		 * Get post meta key
		 * @return string
		 */
		public static function get_post_meta_key() {
			return static::$post_meta_key;
		}

		/**
		 * Get taxonomy meta key
		 * @return string
		 */
		public static function get_tax_meta_key() {
			return static::$tax_meta_key;
		}
		
		/**
		 * Get user meta key
		 * @return string
		 */
		public static function get_user_meta_key() {
			return static::$user_meta_key;
		}

	}

}