
CREATE TABLE IF NOT EXISTS `approved_inventory` (
  `inventory_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `element_name` varchar(300) CHARACTER SET utf8 NOT NULL,
  `element_id` bigint(20) NOT NULL,
  `ota_id` bigint(20) NOT NULL,
  `ota_priority` varchar(5) CHARACTER SET utf8 NOT NULL,
  `element_type` varchar(100) CHARACTER SET utf8 NOT NULL,
  `top_destination` tinyint(1) NOT NULL,
  `topdestination_type` int(11) NOT NULL DEFAULT '0',
  `hot_deal` tinyint(1) NOT NULL DEFAULT '0',
  `city_id` bigint(20) NOT NULL,
  `state_province_code` char(2) CHARACTER SET utf8 DEFAULT NULL,
  `country_code` varchar(3) CHARACTER SET utf8 NOT NULL,
  `image_path` varchar(1000) CHARACTER SET utf8 NOT NULL,
  `image_topdestination` varchar(1000) CHARACTER SET utf8 NOT NULL,
  `microsite_inventory_code` bigint(20) NOT NULL,
  `active` int(11) NOT NULL DEFAULT '1',
  `publish` tinyint(1) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`inventory_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

INSERT INTO `approved_inventory` (`inventory_id`, `element_name`, `element_id`, `ota_id`, `ota_priority`, `element_type`, `top_destination`, `topdestination_type`, `hot_deal`, `city_id`, `state_province_code`, `country_code`, `image_path`, `image_topdestination`, `microsite_inventory_code`, `active`, `publish`, `deleted`) VALUES
(1, 'Las Vegas', 1, 1, 'NA', '2', 1, 2, 0, 1, 'NV', 'US', '/images/city.jpg', 'LasVegasStrip-1_1.jpg', 1, 1, 1, 0),
(2, 'Cancun', 2, 2, 'NA', '2', 1, 1, 0, 2, '', 'MX', '/images/city.jpg', 'news20100302193136.jpg', 1, 1, 1, 0),
(3, 'New York-New York Hotel & Casino', 1, 1, 'BK', '1', 0, 0, 0, 1, 'NV', 'US', '/images/hotel.png', 'top-destination.jpg', 1, 1, 1, 0),
(4, 'Gran Caribe', 2, 2, 'BK', '1', 0, 0, 0, 2, '', 'MX', '/images/hotel.png', 'top-destination.jpg', 1, 1, 1, 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `as_comments` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `posted_by` int(11) NOT NULL,
  `posted_by_name` varchar(30) NOT NULL,
  `comment` text NOT NULL,
  `post_time` datetime NOT NULL,
  PRIMARY KEY (`comment_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=14 ;

-- --------------------------------------------------------

INSERT INTO `as_comments` (`comment_id`, `posted_by`, `posted_by_name`, `comment`, `post_time`) VALUES
(1, 1, 'admin', 'Test', '2013-08-20 22:10:26'),
(2, 1, 'admin', 'ddd', '2013-08-21 21:01:02'),
(3, 1, 'admin', 'f', '2013-08-21 21:04:22'),
(4, 1, 'admin', 'Test', '2013-08-21 21:12:37'),
(5, 1, 'admin', 'probando', '2013-08-21 21:13:34'),
(6, 1, 'admin', 'comentario 2', '2013-08-21 22:23:13'),
(7, 1, 'admin', 'nuevo comentario', '2013-08-21 22:30:09'),
(8, 1, 'admin', 'numero 8', '2013-08-21 22:31:21'),
(9, 1, 'admin', 'y el numero 9', '2013-08-21 22:31:49'),
(10, 1, 'admin', 'yeah', '2013-08-22 17:57:30'),
(11, 1, 'admin', 'mensaje de hoteles', '2013-08-29 15:12:02'),
(12, 1, 'admin', 'hoÃ±a\n', '2013-09-23 10:48:46'),
(13, 1, 'admin', 'fdfsafsdf', '2013-09-23 10:49:16');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `as_login_attempts` (
  `id_login_attempts` int(11) NOT NULL AUTO_INCREMENT,
  `ip_addr` varchar(20) NOT NULL,
  `attempt_number` int(11) NOT NULL DEFAULT '1',
  `date` date NOT NULL,
  PRIMARY KEY (`id_login_attempts`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=32 ;

-- --------------------------------------------------------

INSERT INTO `as_login_attempts` (`id_login_attempts`, `ip_addr`, `attempt_number`, `date`) VALUES
(1, '127.0.0.1', 1, '2013-08-19'),
(2, '127.0.0.1', 1, '2013-08-21'),
(3, '127.0.0.1', 1, '2013-08-22'),
(4, '127.0.0.1', 5, '2013-08-23'),
(5, '127.0.0.1', 1, '2013-08-28'),
(6, '127.0.0.1', 1, '2013-09-09'),
(7, '190.148.185.253', 1, '2013-09-24'),
(8, '186.151.53.89', 1, '2013-09-25'),
(9, '190.148.108.223', 1, '2013-11-04'),
(10, '190.148.114.102', 3, '2013-11-11'),
(11, '190.148.114.102', 3, '2013-11-12'),
(12, '186.151.95.239', 1, '2013-11-13'),
(13, '190.56.11.229', 1, '2013-11-13'),
(14, '186.151.53.156', 1, '2013-11-14'),
(15, '186.151.53.184', 1, '2013-11-18'),
(16, '186.151.148.3', 2, '2013-11-20'),
(17, '190.148.115.210', 1, '2013-11-26'),
(18, '186.151.199.147', 2, '2013-11-27'),
(19, '96.44.189.74', 1, '2014-01-13'),
(20, '190.56.117.179', 1, '2014-01-14'),
(21, '186.151.61.231', 5, '2014-02-04'),
(22, '186.151.61.231', 1, '2014-02-05'),
(23, '186.151.73.202', 2, '2014-02-05'),
(24, '186.151.199.147', 5, '2014-02-05'),
(25, '216.104.32.43', 1, '2014-02-25'),
(26, '186.151.199.147', 1, '2014-02-26'),
(27, '186.151.199.147', 1, '2014-02-27'),
(28, '186.151.199.147', 1, '2014-02-28'),
(29, '190.148.117.245', 3, '2014-03-11'),
(30, '186.151.199.147', 1, '2014-03-28'),
(31, '186.151.61.4', 1, '2014-04-28');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `as_users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(40) NOT NULL,
  `username` varchar(250) NOT NULL,
  `password` varchar(250) NOT NULL,
  `confirmation_key` varchar(40) NOT NULL,
  `confirmed` enum('Y','N') NOT NULL DEFAULT 'N',
  `password_reset_key` varchar(250) NOT NULL DEFAULT '',
  `password_reset_confirmed` enum('Y','N') NOT NULL DEFAULT 'N',
  `register_date` date NOT NULL,
  `user_role` int(4) NOT NULL DEFAULT '1',
  `last_login` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=18 ;

-- --------------------------------------------------------

INSERT INTO `as_users` (`user_id`, `email`, `username`, `password`, `confirmation_key`, `confirmed`, `password_reset_key`, `password_reset_confirmed`, `register_date`, `user_role`, `last_login`) VALUES
(1, 'webmasterdsx@gmail.com', 'admin', '$2a$13$s9fwZ7NiirpOVcmRM/mNlOlpHNkE3XVVPyWEP1XGtfnygwQ9htuse', '', 'Y', '891509436f45240d799e8099556cd7c5', 'Y', '2013-08-19', 3, '2014-04-29 18:35:23'),
(13, 'demo@bookingo.net', 'demo', '$2a$13$s9fwZ7NiirpOVcmRM/mNlOlpHNkE3XVVPyWEP1XGtfnygwQ9htuse', '72ef333155696081a4ce6f913cce84ba', 'Y', '', 'N', '2013-11-27', 1, '0000-00-00 00:00:00'),
(14, 'test@bookingo.net', 'hotel', '$2a$13$s9fwZ7NiirpOVcmRM/mNlOlpHNkE3XVVPyWEP1XGtfnygwQ9htuse', '430576fb0e6e2606f0bf85aea83783f4', 'Y', '', 'N', '2014-02-04', 4, '2014-04-29 17:55:23'),
(17, 'temporada@bookingo.net', 'temporada', '$2a$13$s9fwZ7NiirpOVcmRM/mNlOUtVYfGHXU5Wt5DD4ORh2IhFgbQvGjEG', '63e6554057e4f0bbf32f3a7465c2d3b9', 'Y', '', 'N', '2014-03-26', 4, '2014-03-26 14:03:17');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `as_user_details` (
  `id_user_details` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `first_name` varchar(35) NOT NULL DEFAULT '',
  `last_name` varchar(35) NOT NULL DEFAULT '',
  `phone` varchar(30) NOT NULL DEFAULT '',
  `address` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_user_details`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

INSERT INTO `as_user_details` (`id_user_details`, `user_id`, `first_name`, `last_name`, `phone`, `address`) VALUES
(1, 1, 'James', 'Custom', '55451411', 'Guatemala');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `as_user_roles` (
  `role_id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(10) NOT NULL,
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

INSERT INTO `as_user_roles` (`role_id`, `role`) VALUES
(1, 'user'),
(2, 'editor'),
(3, 'admin'),
(4, 'hotel');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `booking_check_avilability` (
  `check_availability_id` bigint(11) NOT NULL AUTO_INCREMENT,
  `check_in_date` date DEFAULT NULL,
  `check_out_date` date DEFAULT NULL,
  `room_type_id` int(11) NOT NULL DEFAULT '0',
  `total_room` int(3) NOT NULL DEFAULT '0',
  `blocked_inventory` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`check_availability_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=58 ;

-- --------------------------------------------------------

INSERT INTO `booking_check_avilability` (`check_availability_id`, `check_in_date`, `check_out_date`, `room_type_id`, `total_room`, `blocked_inventory`) VALUES
(1, '2014-02-28', '2014-03-01', 3, 1, 0),
(2, '2014-02-28', '2014-03-01', 4, 0, 13),
(3, '2014-03-06', '2014-03-07', 2, 1, 0),
(4, '2014-03-06', '2014-03-07', 3, 2, 0),
(5, '2014-03-10', '2014-03-11', 6, 0, 1),
(6, '2014-03-10', '2014-03-11', 8, 0, 0),
(7, '2014-03-11', '2014-03-12', 2, 0, 1),
(8, '2014-03-12', '2014-03-13', 2, 1, 1),
(9, '2014-03-13', '2014-03-14', 2, 0, 0),
(10, '2014-03-14', '2014-03-15', 2, 0, 0),
(11, '2014-03-15', '2014-03-16', 2, 0, 1),
(12, '2014-03-16', '2014-03-17', 2, 0, 1),
(13, '2014-03-17', '2014-03-18', 2, 0, 1),
(14, '2014-03-18', '2014-03-19', 2, 0, 1),
(15, '2014-03-19', '2014-03-20', 2, 0, 1),
(16, '2014-03-20', '2014-03-21', 2, 0, 1),
(17, '2014-03-21', '2014-03-22', 2, 0, 1),
(18, '2014-03-22', '2014-03-23', 2, 0, 1),
(19, '2014-03-23', '2014-03-24', 2, 0, 1),
(20, '2014-03-24', '2014-03-25', 2, 0, 1),
(21, '2014-03-25', '2014-03-26', 2, 0, 1),
(22, '2014-03-26', '2014-03-27', 2, 0, 1),
(23, '2014-03-27', '2014-03-28', 2, 0, 1),
(24, '2014-03-28', '2014-03-29', 2, 0, 1),
(25, '2014-03-29', '2014-03-30', 2, 0, 1),
(26, '2014-03-30', '2014-03-31', 2, 0, 1),
(27, '2014-03-31', '2014-04-01', 2, 0, 1),
(28, '2014-04-01', '2014-04-02', 2, 0, 1),
(29, '2014-04-02', '2014-04-03', 2, 0, 1),
(30, '2014-04-03', '2014-04-04', 2, 0, 1),
(31, '2014-04-04', '2014-04-05', 2, 0, 1),
(32, '2014-04-05', '2014-04-06', 2, 0, 1),
(33, '2014-04-06', '2014-04-07', 2, 0, 1),
(34, '2014-04-07', '2014-04-08', 2, 0, 1),
(35, '2014-04-08', '2014-04-09', 2, 0, 1),
(36, '2014-04-09', '2014-04-10', 2, 0, 1),
(37, '2014-04-10', '2014-04-11', 2, 0, 1),
(38, '2014-04-11', '2014-04-12', 2, 0, 1),
(39, '2014-04-12', '2014-04-13', 2, 0, 1),
(40, '2014-04-13', '2014-04-14', 2, 0, 1),
(41, '2014-04-14', '2014-04-15', 2, 0, 1),
(42, '2014-04-15', '2014-04-16', 2, 0, 1),
(43, '2014-04-16', '2014-04-17', 2, 0, 1),
(44, '2014-04-17', '2014-04-18', 2, 0, 1),
(45, '2014-04-18', '2014-04-19', 2, 0, 1),
(46, '2014-04-19', '2014-04-20', 2, 0, 1),
(47, '2014-03-11', '2014-03-12', 3, 0, 4),
(48, '2014-03-12', '2014-03-13', 3, 0, 4),
(49, '2014-03-13', '2014-03-14', 3, 0, 4),
(50, '2014-03-11', '2014-03-12', 1, 1, 9),
(51, '2014-03-12', '2014-03-13', 1, 1, 9),
(52, '2014-03-14', '2014-03-15', 4, 0, 12),
(53, '2014-03-14', '2014-03-15', 1, 0, 7),
(54, '2014-03-26', '2014-03-27', 10, 0, 5),
(55, '2014-03-29', '2014-03-30', 10, 0, 4),
(56, '2014-03-27', '2014-03-28', 10, 0, 4),
(57, '2014-04-29', '2014-04-30', 1, 0, 8);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `booking_master` (
  `booking_id` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
  `ota_priority` char(2) CHARACTER SET utf8 NOT NULL,
  `hotel_id` bigint(20) NOT NULL DEFAULT '0',
  `check_in_date` date NOT NULL,
  `check_out_date` date NOT NULL,
  `booking_date` datetime NOT NULL,
  `room_type_id` int(8) NOT NULL,
  `total_guest` int(11) NOT NULL,
  `adults` int(11) NOT NULL,
  `kids` int(11) NOT NULL,
  `total_price` decimal(10,2) NOT NULL,
  `nights` int(11) NOT NULL DEFAULT '0',
  `tax_night` decimal(10,2) NOT NULL DEFAULT '0.00',
  `price_night` decimal(10,2) NOT NULL DEFAULT '0.00',
  `first_name_owner` varchar(300) CHARACTER SET utf8 NOT NULL,
  `last_name_owner` varchar(300) CHARACTER SET utf8 NOT NULL,
  `preferences_owner` varchar(1000) CHARACTER SET utf8 NOT NULL,
  `email_owner` varchar(300) CHARACTER SET utf8 NOT NULL,
  `phone_owner` varchar(100) CHARACTER SET utf8 NOT NULL,
  `room_preference` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `pillow_preference` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `crib_preference` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `location_preference` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `early_check` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `extra_towels` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `feather_free_room` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `anticipated_arrival` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `reason_trip` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `comments` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `transaction_id` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `itinerary_id` bigint(20) NOT NULL,
  `itinerary_approved` bigint(20) NOT NULL,
  `booking_status` int(11) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `razon` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`booking_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=73208 ;

-- --------------------------------------------------------

INSERT INTO `booking_master` (`booking_id`, `ota_priority`, `hotel_id`, `check_in_date`, `check_out_date`, `booking_date`, `room_type_id`, `total_guest`, `adults`, `kids`, `total_price`, `nights`, `tax_night`, `price_night`, `first_name_owner`, `last_name_owner`, `preferences_owner`, `email_owner`, `phone_owner`, `room_preference`, `pillow_preference`, `crib_preference`, `location_preference`, `early_check`, `extra_towels`, `feather_free_room`, `anticipated_arrival`, `reason_trip`, `comments`, `transaction_id`, `itinerary_id`, `itinerary_approved`, `booking_status`, `deleted`, `razon`, `ip_address`) VALUES
(73201, 'BK', 2, '2014-02-28', '2014-03-01', '2014-02-28 18:43:10', 3, 2, 2, 0, '54.00', 0, '0.00', '0.00', 'Sidney', 'Custom', '', 'demo@demo.com', '123-8967896', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '73101', 73201, 73201, 1, 0, NULL, '186.151.95.14'),
(73202, 'BK', 2, '2014-03-06', '2014-03-07', '2014-03-06 12:54:44', 2, 2, 2, 0, '78.00', 0, '0.00', '0.00', 'James', 'Sisney', '', 'demo@demo.com', '653-8965986', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '73102', 73202, 73202, 1, 0, NULL, '186.151.148.3'),
(73203, 'BK', 2, '2014-03-06', '2014-03-07', '2014-03-06 13:51:10', 3, 2, 2, 0, '54.00', 0, '0.00', '0.00', 'Sidney', 'Sinor', '', 'demo@demo.com', '123-8967896', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '73103', 73203, 73203, 1, 0, NULL, '186.151.148.3');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `cities` (
  `city_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `city_name` varchar(300) CHARACTER SET utf8 NOT NULL,
  `city_searchs` bigint(20) NOT NULL DEFAULT '0',
  `state_id` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `country_code` char(2) CHARACTER SET utf8 NOT NULL,
  `city_image` varchar(1000) CHARACTER SET utf8 NOT NULL DEFAULT 'top-destination.jpg',
  `min_amount` int(10) NOT NULL DEFAULT '0',
  `image_path` varchar(300) CHARACTER SET utf8 NOT NULL,
  `gallery_id` bigint(20) NOT NULL DEFAULT '0',
  `city_active` tinyint(1) NOT NULL DEFAULT '1',
  `city_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`city_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

INSERT INTO `cities` (`city_id`, `city_name`, `city_searchs`, `state_id`, `country_code`, `city_image`, `min_amount`, `image_path`, `gallery_id`, `city_active`, `city_deleted`) VALUES
(1, 'Las Vegas', 0, 'NV', 'US', 'LasVegasStrip-1_1.jpg', 50, '/images/city.jpg', 0, 1, 0),
(2, 'Cancun', 0, '', 'MX', 'news20100302193136.jpg', 39, '/images/city.jpg', 0, 1, 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `countries` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `country` varchar(30) NOT NULL,
  `countrycode` varchar(2) NOT NULL,
  `phonecode` int(3) NOT NULL,
  `tax` double(5,2) DEFAULT '0.00',
  `taxname` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=252 ;

-- --------------------------------------------------------

INSERT INTO `countries` (`id`, `country`, `countrycode`, `phonecode`, `tax`, `taxname`) VALUES
(1, 'Afganistan', 'AF', 93, 0.00, NULL),
(2, 'Albania', 'AL', 355, 0.00, NULL),
(3, 'Germany', 'DE', 49, 0.00, NULL),
(4, 'American Samoa', 'AS', 1, 0.00, NULL),
(5, 'Andorra', 'AD', 376, 0.00, NULL),
(6, 'Angola', 'AO', 244, 0.00, NULL),
(7, 'Anguila', 'AI', 1, 0.00, NULL),
(8, 'Antigua and Barbuda', 'AG', 1, 0.00, NULL),
(9, 'Netherlands Antilles', 'AN', 599, 0.00, NULL),
(10, 'Antarctica', 'AQ', 672, 0.00, NULL),
(11, 'Saudi Arabia', 'SA', 966, 0.00, NULL),
(12, 'Argelia', 'DZ', 213, 0.00, NULL),
(13, 'Argentina', 'AR', 54, 0.00, NULL),
(14, 'Armenia', 'AM', 374, 0.00, NULL),
(15, 'Aruba', 'AW', 297, 0.00, NULL),
(16, 'France, Metropolitan', 'FX', 0, 0.00, NULL),
(17, 'Australia', 'AU', 61, 0.00, NULL),
(18, 'Austria', 'AT', 43, 0.00, NULL),
(19, 'Azerbaijan', 'AZ', 994, 0.00, NULL),
(20, 'Bahamas', 'BS', 1, 0.00, NULL),
(21, 'Bahrein', 'BH', 973, 0.00, NULL),
(22, 'Bangladesh', 'BD', 880, 0.00, NULL),
(23, 'Barbados', 'BB', 1, 0.00, NULL),
(24, 'Belice', 'BZ', 501, 0.00, NULL),
(25, 'Benin', 'BJ', 229, 0.00, NULL),
(26, 'Bermuda', 'BM', 1, 0.00, NULL),
(27, 'Belarus', 'BY', 375, 0.00, NULL),
(28, 'Bolivia', 'BO', 591, 0.00, NULL),
(29, 'Bosnia and Herzegovina', 'BA', 387, 0.00, NULL),
(30, 'Botswana', 'BW', 267, 0.00, NULL),
(31, 'Bouvet Island', 'BV', 0, 0.00, NULL),
(32, 'Brasil', 'BR', 55, 0.00, NULL),
(33, 'British Indian Ocean Territory', 'IO', 0, 0.00, NULL),
(34, 'Brunei Darussalam', 'BN', 673, 0.00, NULL),
(35, 'Bulgaria', 'BG', 359, 0.00, NULL),
(36, 'Burkina Faso', 'BF', 226, 0.00, NULL),
(37, 'Burundi', 'BI', 257, 0.00, NULL),
(38, 'Bhutan', 'BT', 975, 0.00, NULL),
(39, 'Belgium', 'BE', 32, 0.00, NULL),
(40, 'Cape Verde', 'CV', 238, 0.00, NULL),
(41, 'Camboya', 'KH', 855, 0.00, NULL),
(42, 'Cameroon', 'CM', 237, 0.00, NULL),
(43, 'Reunion', 'RE', 0, 0.00, NULL),
(44, 'Canada', 'CA', 1, 0.00, NULL),
(45, 'Chad', 'TD', 235, 0.00, NULL),
(46, 'Chile', 'CL', 56, 0.00, NULL),
(47, 'China', 'CN', 86, 0.00, NULL),
(48, 'Cyprus', 'CY', 357, 0.00, NULL),
(49, 'Colombia', 'CO', 57, 0.00, NULL),
(50, 'Comoros', 'KM', 269, 0.00, NULL),
(51, 'Congo', 'CG', 242, 0.00, NULL),
(52, 'North Korea', 'KP', 850, 0.00, NULL),
(53, 'South Korea', 'KR', 82, 0.00, NULL),
(54, 'Costa Rica', 'CR', 506, 0.00, NULL),
(55, 'Cote D Ivoire', 'CI', 225, 0.00, NULL),
(56, 'Croatia', 'HR', 385, 0.00, NULL),
(57, 'Cuba', 'CU', 53, 0.00, NULL),
(58, 'Denmark', 'DK', 45, 0.00, NULL),
(59, 'Djibouti', 'DJ', 253, 0.00, NULL),
(60, 'Dominica', 'DM', 1, 0.00, NULL),
(61, 'East Timor', 'TP', 0, 0.00, NULL),
(62, 'Ecuador', 'EC', 593, 0.00, NULL),
(63, 'Egypt', 'EG', 20, 0.00, NULL),
(64, 'El Salvador', 'SV', 503, 0.00, NULL),
(65, 'Vatican City State', 'VA', 39, 0.00, NULL),
(66, 'United Arab Emirate', 'AE', 971, 0.00, NULL),
(67, 'Eritrea', 'ER', 291, 0.00, NULL),
(68, 'Slovakia', 'SK', 421, 0.00, NULL),
(69, 'Slovenia', 'SI', 386, 0.00, NULL),
(70, 'Espa&ntilde;a', 'ES', 34, 0.00, NULL),
(71, 'United States', 'US', 1, 0.00, NULL),
(72, 'Estonia', 'EE', 372, 0.00, NULL),
(73, 'Ethiopia', 'ET', 251, 0.00, NULL),
(74, 'Fiji', 'FJ', 679, 0.00, NULL),
(75, 'Philippines', 'PH', 63, 0.00, NULL),
(76, 'Finland', 'FI', 358, 0.00, NULL),
(77, 'France', 'FR', 33, 0.00, NULL),
(78, 'French Guyana', 'GF', 0, 0.00, NULL),
(79, 'French Polynesia', 'PF', 689, 0.00, NULL),
(80, 'French Southern Territories', 'TF', 0, 0.00, NULL),
(81, 'Gabon', 'GA', 241, 0.00, NULL),
(82, 'Gambia', 'GM', 220, 0.00, NULL),
(83, 'Georgia', 'GE', 995, 0.00, NULL),
(84, 'Ghana', 'GH', 233, 0.00, NULL),
(85, 'Gibraltar', 'GI', 350, 0.00, NULL),
(86, 'Grenada', 'GD', 1, 0.00, NULL),
(87, 'Greece', 'GR', 30, 0.00, NULL),
(88, 'Greenland', 'GL', 299, 0.00, NULL),
(89, 'Guadalupe', 'GP', 0, 0.00, NULL),
(90, 'Guam', 'GU', 1, 0.00, NULL),
(91, 'Guatemala', 'GT', 502, 0.00, NULL),
(92, 'Guinea', 'GN', 224, 0.00, NULL),
(93, 'Equatorial Guinea', 'GQ', 240, 0.00, NULL),
(94, 'Guinea-Bissau', 'GW', 245, 0.00, NULL),
(95, 'Guyana', 'GY', 592, 0.00, NULL),
(96, 'Haiti', 'HT', 509, 0.00, NULL),
(97, 'Heard and McDonald Islands', 'HM', 0, 0.00, NULL),
(98, 'Netherlands', 'NL', 31, 0.00, NULL),
(99, 'Honduras', 'HN', 504, 0.00, NULL),
(100, 'Hong Kong', 'HK', 852, 0.00, NULL),
(101, 'Hungary', 'HU', 36, 0.00, NULL),
(102, 'India', 'IN', 91, 0.00, NULL),
(103, 'Indonesia', 'ID', 62, 0.00, NULL),
(104, 'Iraq', 'IQ', 964, 0.00, NULL),
(105, 'Ireland', 'IE', 353, 0.00, NULL),
(106, 'Cocos Islands', 'CC', 61, 0.00, NULL),
(107, 'Christmas Island', 'CX', 61, 0.00, NULL),
(108, 'Islandia (Iceland)', 'IS', 354, 0.00, NULL),
(109, 'Cayman Islands', 'KY', 1, 0.00, NULL),
(110, 'Cook Islands', 'CK', 682, 0.00, NULL),
(111, 'Faroe Islands', 'FO', 298, 0.00, NULL),
(112, 'Falkland Islands (Malvinas)', 'FK', 500, 0.00, NULL),
(113, 'Marshall Islands', 'MH', 692, 0.00, NULL),
(114, 'Mauritius', 'MU', 230, 0.00, NULL),
(115, 'Solomon Islands', 'SB', 677, 0.00, NULL),
(116, 'South Georgia South Sandwidch ', 'GS', 0, 0.00, NULL),
(117, 'Turks and Caicos Islands', 'TC', 1, 0.00, NULL),
(118, 'Wallis and Futuna Islands', 'WF', 681, 0.00, NULL),
(119, 'Israel', 'IL', 972, 0.00, NULL),
(120, 'Italia', 'IT', 39, 0.00, NULL),
(121, 'Jamaica', 'JM', 1, 0.00, NULL),
(122, 'Japan', 'JP', 81, 0.00, NULL),
(123, 'Jordan', 'JO', 962, 0.00, NULL),
(124, 'Kazakhstan', 'KZ', 7, 0.00, NULL),
(125, 'Kenya', 'KE', 254, 0.00, NULL),
(126, 'Kiribati', 'KI', 686, 0.00, NULL),
(127, 'Kuwait', 'KW', 965, 0.00, NULL),
(128, 'Kyrgyzstan', 'KG', 996, 0.00, NULL),
(129, 'Laos', 'LA', 856, 0.00, NULL),
(130, 'Latvia', 'LV', 371, 0.00, NULL),
(131, 'Lesoto', 'LS', 266, 0.00, NULL),
(132, 'Liberia', 'LR', 231, 0.00, NULL),
(133, 'Libya', 'LY', 218, 0.00, NULL),
(134, 'Liechtenstein', 'LI', 423, 0.00, NULL),
(135, 'Lithuania', 'LT', 370, 0.00, NULL),
(136, 'Luxembourg', 'LU', 352, 0.00, NULL),
(137, 'Lebanon', 'LB', 961, 0.00, NULL),
(138, 'Macao', 'MO', 853, 0.00, NULL),
(139, 'Macedonia', 'MK', 389, 0.00, NULL),
(140, 'Madagascar', 'MG', 261, 0.00, NULL),
(141, 'Malaysia', 'MY', 60, 0.00, NULL),
(142, 'Malawi', 'MW', 265, 0.00, NULL),
(143, 'Maldives', 'MV', 960, 0.00, NULL),
(144, 'Malta', 'MT', 356, 0.00, NULL),
(145, 'Mali', 'ML', 223, 0.00, NULL),
(146, 'Morocco', 'MA', 212, 0.00, NULL),
(147, 'Martinique', 'MQ', 0, 0.00, NULL),
(148, 'Mauritania', 'MR', 222, 0.00, NULL),
(149, 'Mayotte', 'TY', 0, 0.00, NULL),
(150, 'Micronesia', 'FM', 691, 0.00, NULL),
(151, 'Moldova', 'MD', 373, 0.00, NULL),
(152, 'Mongolia', 'MN', 976, 0.00, NULL),
(153, 'Montserrat', 'MS', 1, 0.00, NULL),
(154, 'Mozambique', 'MZ', 258, 0.00, NULL),
(155, 'Myanmar', 'MM', 95, 0.00, NULL),
(156, 'Mexico', 'MX', 52, 0.00, NULL),
(157, 'Monaco', 'MC', 377, 0.00, NULL),
(158, 'Namibia', 'NA', 264, 0.00, NULL),
(159, 'Nauru', 'NR', 674, 0.00, NULL),
(160, 'Nepal', 'NP', 977, 0.00, NULL),
(161, 'Nicaragua', 'NI', 505, 0.00, NULL),
(162, 'Nigeria', 'NG', 234, 0.00, NULL),
(163, 'Niue', 'NU', 683, 0.00, NULL),
(164, 'Norfolk Island', 'NF', 0, 0.00, NULL),
(165, 'Northern Mariana Islands', 'MP', 1, 0.00, NULL),
(166, 'Norway', 'NO', 47, 0.00, NULL),
(167, 'New Caledonia', 'NC', 687, 0.00, NULL),
(168, 'New Zealand', 'NZ', 64, 0.00, NULL),
(169, 'Niger', 'NE', 227, 0.00, NULL),
(170, 'Oman', 'OM', 968, 0.00, NULL),
(171, 'Pakistan', 'PK', 92, 0.00, NULL),
(172, 'Palau', 'PW', 680, 0.00, NULL),
(173, 'Palestinian Territory', 'PS', 0, 0.00, NULL),
(174, 'Panama', 'PA', 507, 0.00, NULL),
(175, 'Papua New Guinea', 'PG', 675, 0.00, NULL),
(176, 'Paraguay', 'PY', 595, 0.00, NULL),
(177, 'Peru', 'PE', 51, 0.00, NULL),
(178, 'Pitcairn', 'PN', 870, 0.00, NULL),
(179, 'Poland', 'PL', 48, 0.00, NULL),
(180, 'Portugal', 'PT', 351, 0.00, NULL),
(181, 'Puerto Rico', 'PR', 1, 0.00, NULL),
(182, 'Qatar', 'QA', 974, 0.00, NULL),
(183, 'United Kingdom', 'GB', 44, 0.00, NULL),
(184, 'Central African Republic', 'CF', 236, 0.00, NULL),
(185, 'Czech Republic', 'CZ', 420, 0.00, NULL),
(186, 'Congo Democratic', 'CD', 243, 0.00, NULL),
(187, 'Republica Dominicana', 'DO', 1, 0.00, NULL),
(188, 'Iran', 'IR', 98, 0.00, NULL),
(189, 'Rwanda', 'RW', 250, 0.00, NULL),
(190, 'Romania', 'RO', 40, 0.00, NULL),
(191, 'Russia', 'RU', 7, 0.00, NULL),
(192, 'Saint Kitts and Nevis', 'KN', 1, 0.00, NULL),
(193, 'St. Pierre and Miquelon', 'PM', 508, 0.00, NULL),
(194, 'Samoa', 'WS', 685, 0.00, NULL),
(195, 'San Marino', 'SM', 378, 0.00, NULL),
(196, 'Saint Vincent and the Grenadin', 'VC', 1, 0.00, NULL),
(197, 'St. Helena', 'SH', 290, 0.00, NULL),
(198, 'Saint Lucia', 'LC', 1, 0.00, NULL),
(199, 'Sao Tome and Principe', 'ST', 239, 0.00, NULL),
(200, 'Senegal', 'SN', 221, 0.00, NULL),
(201, 'Serbia y Montenegro', 'RS', 381, 0.00, NULL),
(202, 'Seychelles', 'SC', 248, 0.00, NULL),
(203, 'Sierra Leone', 'SL', 232, 0.00, NULL),
(204, 'Singapore', 'SG', 65, 0.00, NULL),
(205, 'Syria', 'SY', 963, 0.00, NULL),
(206, 'Somalia', 'SO', 252, 0.00, NULL),
(207, 'Sri Lanka', 'LK', 94, 0.00, NULL),
(208, 'Swaziland', 'SZ', 268, 0.00, NULL),
(209, 'South Africa', 'ZA', 27, 0.00, NULL),
(210, 'Sudan', 'SD', 249, 0.00, NULL),
(211, 'Sweden', 'SE', 46, 0.00, NULL),
(212, 'Switzerland', 'CH', 41, 0.00, NULL),
(213, 'Suriname', 'SR', 597, 0.00, NULL),
(214, 'Svalbarn and Jan Mayen Islands', 'SJ', 0, 0.00, NULL),
(215, 'Thailand', 'TH', 66, 0.00, NULL),
(216, 'Taiwan', 'TW', 886, 0.00, NULL),
(217, 'Tajikistan', 'TJ', 992, 0.00, NULL),
(218, 'Tanzania', 'TZ', 255, 0.00, NULL),
(219, 'Togo', 'TG', 228, 0.00, NULL),
(220, 'Tonga', 'TO', 676, 0.00, NULL),
(221, 'Tokelau', 'TK', 690, 0.00, NULL),
(222, 'Trinidad y Tobago', 'TT', 1, 0.00, NULL),
(223, 'Turkmenistan', 'TM', 993, 0.00, NULL),
(224, 'Turkey', 'TR', 90, 0.00, NULL),
(225, 'Tuvalu', 'TV', 688, 0.00, NULL),
(226, 'Tunisia', 'TN', 216, 0.00, NULL),
(227, 'Ukraine', 'UA', 380, 0.00, NULL),
(228, 'Uganda', 'UG', 256, 0.00, NULL),
(229, 'US Minor Outlying Islands', 'UM', 0, 0.00, NULL),
(230, 'Uruguay', 'UY', 598, 0.00, ''),
(231, 'Uzbekistan', 'UZ', 998, 0.00, NULL),
(232, 'Vanuatu', 'VU', 678, 0.00, NULL),
(233, 'Venezuela', 'VE', 58, 0.00, NULL),
(234, 'Vietnam', 'VN', 84, 0.00, NULL),
(235, 'Virgin Islands British', 'VG', 1, 0.00, NULL),
(236, 'Virgin Islands U.S.', 'VI', 1, 0.00, NULL),
(237, 'Western Sahara', 'EH', 0, 0.00, NULL),
(238, 'Yemen', 'YE', 967, 0.00, NULL),
(239, 'Zaire', 'ZR', 0, 0.00, NULL),
(240, 'Zambia', 'ZM', 260, 0.00, NULL),
(241, 'Zimbabwe', 'ZW', 263, 0.00, NULL),
(242, 'Yugoslavia', 'YU', 0, 0.00, NULL),
(243, 'Aland Islands', 'AX', 0, 0.00, NULL),
(244, 'Guernsey', 'GG', 0, 0.00, NULL),
(245, 'Isle of Man', 'IM', 44, 0.00, NULL),
(246, 'Jersey', 'JE', 0, 0.00, NULL),
(247, 'Mayotte', 'YT', 262, 0.00, NULL),
(248, 'Montenegro', 'ME', 382, 0.00, NULL),
(249, 'Saint Barthélemy', 'BL', 590, 0.00, NULL),
(250, 'Saint Martin', 'MF', 1, 0.00, NULL),
(251, 'Timor-Leste', 'TL', 670, 0.00, NULL);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `css_list` (
  `css_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `css_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `css_link` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`css_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

-- --------------------------------------------------------

INSERT INTO `css_list` (`css_id`, `css_name`, `css_link`) VALUES
(1, 'Default', 'project.css'),
(2, 'Blue', 'projectBlue.css'),
(3, 'Brown', 'projectBrown.css'),
(4, 'Green', 'projectGreen.css'),
(5, 'Red', 'projectRed.css'),
(6, 'Purple', 'projectPurple.css');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `css_textures` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `texture_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `texture_link` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

-- --------------------------------------------------------

INSERT INTO `css_textures` (`id`, `texture_name`, `texture_link`) VALUES
(1, 'Texture 1', 't1.png'),
(2, 'Texture 2', 't2.png'),
(3, 'Texture 3', 't3.png'),
(4, 'Texture 4', 't4.png'),
(5, 'Texture 5', 't5.png'),
(6, 'Texture 6', 't6.png');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=154 ;

-- --------------------------------------------------------

INSERT INTO `currency` (`id`, `code`) VALUES
(1, 'USD'),
(2, 'EUR'),
(3, 'GBP'),
(4, 'CAD'),
(5, 'AUD'),
(6, 'JPY'),
(7, 'CHF'),
(8, 'SEK'),
(9, 'AED'),
(10, 'ALL'),
(11, 'ANG'),
(12, 'ARS'),
(13, 'AWG'),
(14, 'BBD'),
(15, 'BDT'),
(16, 'BGN'),
(17, 'BHD'),
(18, 'BIF'),
(19, 'BMD'),
(20, 'BND'),
(21, 'BOB'),
(22, 'BRL'),
(23, 'BSD'),
(24, 'BTN'),
(25, 'BWP'),
(26, 'BYR'),
(27, 'BZD'),
(28, 'CLP'),
(29, 'CNY'),
(30, 'COP'),
(31, 'CRC'),
(32, 'CUP'),
(33, 'CVE'),
(34, 'CZK'),
(35, 'DJF'),
(36, 'DKK'),
(37, 'DOP'),
(38, 'DZD'),
(39, 'ECS'),
(40, 'EEK'),
(41, 'EGP'),
(42, 'ERN'),
(43, 'ETB'),
(44, 'FJD'),
(45, 'FKP'),
(46, 'GHC'),
(47, 'GIP'),
(48, 'GMD'),
(49, 'GNF'),
(50, 'GTQ'),
(51, 'GYD'),
(52, 'HKD'),
(53, 'HNL'),
(54, 'HRK'),
(55, 'HTG'),
(56, 'HUF'),
(57, 'IDR'),
(58, 'ILS'),
(59, 'INR'),
(60, 'IQD'),
(61, 'IRR'),
(62, 'ISK'),
(63, 'JMD'),
(64, 'JOD'),
(65, 'KES'),
(66, 'KHR'),
(67, 'KMF'),
(68, 'KPW'),
(69, 'KRW'),
(70, 'KWD'),
(71, 'KYD'),
(72, 'KZT'),
(73, 'LAK'),
(74, 'LBP'),
(75, 'LKR'),
(76, 'LRD'),
(77, 'LSL'),
(78, 'LTL'),
(79, 'LVL'),
(80, 'LYD'),
(81, 'MAD'),
(82, 'MDL'),
(83, 'MKD'),
(84, 'MMK'),
(85, 'MNT'),
(86, 'MOP'),
(87, 'MRO'),
(88, 'MTL'),
(89, 'MUR'),
(90, 'MVR'),
(91, 'MWK'),
(92, 'MXN'),
(93, 'MYR'),
(94, 'NAD'),
(95, 'NGN'),
(96, 'NIO'),
(97, 'NOK'),
(98, 'NPR'),
(99, 'NZD'),
(100, 'OMR'),
(101, 'PAB'),
(102, 'PEN'),
(103, 'PGK'),
(104, 'PHP'),
(105, 'PKR'),
(106, 'PLN'),
(107, 'PYG'),
(108, 'QAR'),
(109, 'RON'),
(110, 'RUB'),
(111, 'RWF'),
(112, 'SAR'),
(113, 'SBD'),
(114, 'SCR'),
(115, 'SDG'),
(116, 'SGD'),
(117, 'SHP'),
(118, 'SIT'),
(119, 'SKK'),
(120, 'SLL'),
(121, 'SOS'),
(122, 'STD'),
(123, 'SVC'),
(124, 'SYP'),
(125, 'SZL'),
(126, 'THB'),
(127, 'TND'),
(128, 'TOP'),
(129, 'TRY'),
(130, 'TTD'),
(131, 'TWD'),
(132, 'TZS'),
(133, 'UAH'),
(134, 'UGX'),
(135, 'UYU'),
(136, 'VEF'),
(137, 'VND'),
(138, 'VUV'),
(139, 'WST'),
(140, 'XAF'),
(141, 'XAG'),
(142, 'XAL'),
(143, 'XAU'),
(144, 'XCD'),
(145, 'XCP'),
(146, 'XOF'),
(147, 'XPD'),
(148, 'XPF'),
(149, 'XPT'),
(150, 'YER'),
(151, 'ZAR'),
(152, 'ZMK'),
(153, 'ZWD');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `elements_type` (
  `element_id` int(11) NOT NULL AUTO_INCREMENT,
  `element_name` varchar(300) CHARACTER SET utf8 NOT NULL,
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`element_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

INSERT INTO `elements_type` (`element_id`, `element_name`, `active`) VALUES
(1, 'hotel', 1),
(2, 'city', 1);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `email_recipients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_address` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `site_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `reply_email` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `from_email` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

INSERT INTO `email_recipients` (`id`, `email_address`, `site_name`, `reply_email`, `from_email`, `active`, `deleted`) VALUES
(1, 'webmaster@bookingo.net', 'Bookingo Multi Hotel', 'noreply@bookingo.net', 'reservations@bookingo.net', 1, 0),
(2, 'demo@bookingo.net', '', '', '', 1, 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `email_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) CHARACTER SET latin1 NOT NULL,
  `email_subject` varchar(200) CHARACTER SET latin1 NOT NULL,
  `email_message` text CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

-- --------------------------------------------------------

INSERT INTO `email_template` (`id`, `email_type`, `email_subject`, `email_message`) VALUES
(1, 'booking_request_notification', 'You have a new order from Bookingo', '<p>Hello Administrator:<br /> We have successfully received a new reservation in the website.<br /> The details about the reservation are:<br /><br /> <strong>Booking Details:</strong><br /><br /> Itinerary ID(s):&nbsp; {itinerario_id}<br /> Check In:&nbsp; {checkin}<br /> Check Out:&nbsp; {checkout}<br /> Room Type:&nbsp; {room_name}<br /> Guests for Room:&nbsp; {guestsroom}<br /><br /> <strong>Contact Info:</strong><br /><br /> First Name:&nbsp; {firstname0}<br /> Last Name:&nbsp; {lastname0}<br /> Phone:&nbsp; {phone}, {workphone}<br /> Email: {email}<br /><br /> <strong>Transaction Info:</strong><br /><br /> Total to Pay: {currencysymbol}{roompricetotal}</p>\r\n<div>Card First Name: {cardfirstname}</div>\r\n<div>Card Last Name: {cardlastname}</div>\r\n<div>Card Number: {nocard}</div>\r\n<div>Card Type: {cardname}</div>\r\n<div>Card Exp: {card_exp_month} - {card_exp_year}</div>\r\n<div>Card CVV: {codeno}</div>\r\n<div>Address: {billaddress}</div>\r\n<div>City: {city}</div>\r\n<div>State: {state}</div>\r\n<div>Country: {country}</div>\r\n<div>Zip Code: {zip}</div>\r\n<p>This message was sent from the IP Address: {ipaddress} on {date} at {time}</p>'),
(3, 'booking_request_payment', 'Your Reservation Has Been Confirmed', '<p>Hello {firstname0} {lastname0}:<br /> Thank you, we have successfully received your reservation.<br /> If you have any questions, please email us at orders@bookingo.net<br /> We will be happy to help.<br /><br /> <strong>Booking Details:</strong><br /><br /> Itinerary ID(s):&nbsp; {itinerario_id}<br /> Check In:&nbsp; {checkin}<br /> Check Out:&nbsp; {checkout}<br /> Room Type:&nbsp; {room_name}<br /> Guests for Room:&nbsp; {guestsroom}<br /><br /> <strong>Contact Info:</strong><br /><br /> First Name:&nbsp; {firstname0}<br /> Last Name:&nbsp; {lastname0}<br /> Phone:&nbsp; {phone}, {workphone}<br /> Email: {email}<br /><br /> <strong>Transaction Info:</strong><br /><br /> Total: ${roompricetotal}<br /> Transaction ID: {txn_id}<br /><br /> <strong>Reservation Details:</strong><br /><br /> For more information, login with your Itinerary number and email at: {site_url}</p>'),
(2, 'new_booking_confirmed', 'Your Reservation Has Been Confirmed', '<p>Hello {firstname0} {lastname0}:<br /> Thank you, we have successfully received your reservation.<br /> If you have any questions, please email us at orders@bookingo.net<br /> We will be happy to help.<br /><br /> <strong>Booking Details:</strong><br /><br /> Itinerary ID(s):&nbsp; {itinerario_id}<br /> Check In:&nbsp; {checkin}<br /> Check Out:&nbsp; {checkout}<br /> Room Type:&nbsp; {room_name}<br /> Guests for Room:&nbsp; {guestsroom}<br /><br /> <strong>Contact Info:</strong><br /><br /> First Name:&nbsp; {firstname0}<br /> Last Name:&nbsp; {lastname0}<br /> Phone:&nbsp; {phone}, {workphone}<br /> Email: {email}<br /><br /> <strong>Transaction Info:</strong><br /><br /> Total to Pay: {currencysymbol}{roompricetotal}<br /><br /> <strong>Reservation Details:</strong><br /><br /> For more information, login with your Itinerary number and email at: {site_url}</p>'),
(5, 'booking_cancel_request', 'Cancel Reservation', '<p>Hello {firstname0} {lastname0}:<br /> Thank you, we have successfully received your cancelation request, the administrator will review the request to see if apply to the cancelation terms.<br /> If you have any questions, please email us at orders@bookingo.net<br /> We will be happy to help.<br /><br /> <strong>Booking Details:</strong><br /><br /> Itinerary ID(s):&nbsp; {itinerario_id}<br /> Check In:&nbsp; {checkin}<br /> Check Out:&nbsp; {checkout}<br /> Room Type:&nbsp; {room_name}<br /> Guests for Room:&nbsp; {guestsroom}<br /><br /> <strong>Contact Info:</strong><br /><br /> First Name:&nbsp; {firstname0}<br /> Last Name:&nbsp; {lastname0}<br /> Phone:&nbsp; {phone}, {workphone}<br /> Email: {email}<br /><br /></p>\r\n<p><span>Message: {itinerary_cancel}</span></p>'),
(6, 'booking_cancel_admin', 'Cancel Reservation Request', '<p>Hello Administrator:<br /> We have received a reservation cancelation request in the website.<br /> The details about the reservation are:<br /><br /> <strong>Booking Details:</strong><br /><br /> Itinerary ID(s):&nbsp; {itinerario_id}<br /> Check In:&nbsp; {checkin}<br /> Check Out:&nbsp; {checkout}<br /> Room Type:&nbsp; {room_name}<br /> Guests for Room:&nbsp; {guestsroom}<br /><br /> <strong>Contact Info:</strong><br /><br /> First Name:&nbsp; {firstname0}<br /> Last Name:&nbsp; {lastname0}<br /> Phone:&nbsp; {phone}, {workphone}<br /> Email: {email}<br /><br /></p>\r\n<p><span>Message: {itinerary_cancel}</span></p>\r\n<p>This message was sent from the IP Address: {ipaddress} on {date} at {time}</p>'),
(4, 'new_booking_paypal', 'You have a new order from Bookingo', '<p>Hello Administrator:<br /> We have successfully received a new reservation in the website.<br /> The details about the reservation are:<br /><br /> <strong>Booking Details:</strong><br /><br /> Itinerary ID(s):&nbsp; {itinerario_id}<br /> Check In:&nbsp; {checkin}<br /> Check Out:&nbsp; {checkout}<br /> Room Type:&nbsp; {room_name}<br /> Guests for Room:&nbsp; {guestsroom}<br /><br /> <strong>Contact Info:</strong><br /><br /> First Name:&nbsp; {firstname0}<br /> Last Name:&nbsp; {lastname0}<br /> Phone:&nbsp; {phone}, {workphone}<br /> Email: {email}<br /><br /> <strong>Transaction Info:</strong><br /><br /> Total Payment: ${roompricetotal}</p>\r\n<p>Payment Method: Paypal</p>\r\n<p>This message was sent from the IP Address: {ipaddress} on {date} at {time}</p>');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `general_settings` (
  `settings_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `settings_logo` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_icon` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_css` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `settings_css_texture` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_phone` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_script` text COLLATE utf8_unicode_ci NOT NULL,
  `settings_copyright` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `settings_twitter` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_facebook` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `settings_google` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `settings_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_from_mail` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_banner` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `settings_banner_title` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `settings_banner_txt` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `special_offer` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `special_offer_txt` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `settings_slide1` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_slide1_link` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `settings_slide2` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_slide2_link` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `settings_slide3` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_slide3_link` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `settings_slide4` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `settings_slide4_link` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `settings_map` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`settings_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

INSERT INTO `general_settings` (`settings_id`, `settings_logo`, `settings_icon`, `settings_css`, `settings_css_texture`, `settings_phone`, `settings_script`, `settings_copyright`, `settings_twitter`, `settings_facebook`, `settings_google`, `settings_email`, `settings_from_mail`, `settings_banner`, `settings_banner_title`, `settings_banner_txt`, `special_offer`, `special_offer_txt`, `settings_slide1`, `settings_slide1_link`, `settings_slide2`, `settings_slide2_link`, `settings_slide3`, `settings_slide3_link`, `settings_slide4`, `settings_slide4_link`, `settings_map`, `date`) VALUES
(1, 'headerbookingologo.png', 'favicon.ico', 'project.css', 'none', '123 986-9865', '', 'Copyright 2013 <b>Bookingo.net</b><br />All rights reserved.', '', '', '', 'demo@bookingo.net', 'noreply@bookingo.net', 'source-2.jpg', 'lorem impulsoum loremo pu?', 'lorem impulsom lomop sump lorempuls pusem lorem lorem lorem', 'sophoto.jpg', 'Frech Riviera<br>For under $85', 'tdfototl.jpg', 'hotel-list.php?sort=pricelow&typesort=price&destino=Las%20Vegas,%20NV,%20US&city_id=1', 'tdfototr.jpg', 'hotel-list.php?sort=pricelow&typesort=price&destino=Las%20Vegas,%20NV,%20US&city_id=1', 'tdfotobl.jpg', 'hotel-list.php?sort=pricelow&typesort=price&destino=Las%20Vegas,%20NV,%20US&city_id=1', 'tdfotobr.jpg', 'hotel-list.php?sort=pricelow&typesort=price&destino=Las%20Vegas,%20NV,%20US&city_id=1', '', '0000-00-00');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `hotels` (
  `hotel_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `account_id` varchar(64) CHARACTER SET utf8 NOT NULL,
  `ota_default` varchar(5) CHARACTER SET utf8 NOT NULL,
  `hotel_name` varchar(300) COLLATE utf8_unicode_ci NOT NULL,
  `hotel_short_description` text CHARACTER SET utf8,
  `hotel_information` text CHARACTER SET utf8,
  `hotel_low_price` decimal(10,2) NOT NULL,
  `hotel_country` char(2) CHARACTER SET utf8 NOT NULL,
  `hotel_state` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `hotel_city` int(11) NOT NULL,
  `hotel_address` varchar(500) CHARACTER SET utf8 NOT NULL,
  `hotel_beach` int(11) NOT NULL,
  `hotel_zipcode` int(11) NOT NULL,
  `longitud` varchar(100) CHARACTER SET utf8 NOT NULL,
  `latitud` varchar(100) CHARACTER SET utf8 NOT NULL,
  `hotel_stars` decimal(10,1) NOT NULL,
  `hotel_reviews` bigint(20) NOT NULL DEFAULT '0',
  `hotel_review_score` decimal(10,1) NOT NULL DEFAULT '0.0',
  `max_adults` int(11) NOT NULL,
  `max_children` int(11) NOT NULL,
  `max_guests` int(11) NOT NULL,
  `max_rooms` int(11) NOT NULL,
  `policy_cancel` text COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `promo` tinyint(1) NOT NULL DEFAULT '0',
  `limited` tinyint(1) NOT NULL DEFAULT '0',
  `developer` tinyint(4) NOT NULL DEFAULT '0',
  `searchs` bigint(20) NOT NULL DEFAULT '0',
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `hotel_main_image` varchar(1000) COLLATE utf8_unicode_ci DEFAULT 'hotel_default.jpg',
  `hotel_image_path` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `hotel_email` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hotel_tax` decimal(10,2) NOT NULL DEFAULT '0.00',
  `version` varchar(100) CHARACTER SET utf8 NOT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`hotel_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

INSERT INTO `hotels` (`hotel_id`, `account_id`, `ota_default`, `hotel_name`, `hotel_short_description`, `hotel_information`, `hotel_low_price`, `hotel_country`, `hotel_state`, `hotel_city`, `hotel_address`, `hotel_beach`, `hotel_zipcode`, `longitud`, `latitud`, `hotel_stars`, `hotel_reviews`, `hotel_review_score`, `max_adults`, `max_children`, `max_guests`, `max_rooms`, `policy_cancel`, `active`, `featured`, `promo`, `limited`, `developer`, `searchs`, `hits`, `hotel_main_image`, `hotel_image_path`, `hotel_email`, `hotel_tax`, `version`, `deleted`) VALUES
(1, '14', 'BK', 'New York-New York Hotel & Casino', 'With a stay at New York-New York Hotel & Casino in Las Vegas (The Strip).', '<p><strong>Property Location</strong>&nbsp;<br />With a stay at New York-New York Hotel &amp; Casino in Las Vegas (The Strip), you''ll be convenient to Crystals at City Center and University of Nevada-Las Vegas. This 4-star resort is within close proximity of Sands Expo Convention Center and Welcome to Fabulous Las Vegas Sign.</p>\r\n<p><strong>Rooms</strong>&nbsp;<br />Make yourself at home in one of the 2023 air-conditioned guestrooms. Complimentary wireless Internet access is available to keep you connected. Bathrooms have complimentary toiletries and hair dryers. Conveniences include safes and a turndown service, and you can also request refrigerators.</p>\r\n<p><strong>Rec, Spa, Premium Amenities</strong>&nbsp;<br />Take time to pamper yourself with a visit to the full-service spa. Gambling sorts can try their luck at the casino, while others may prefer a nightclub or a spa tub. Additional amenities include complimentary wireless Internet access, an arcade/game room, and gift shops/newsstands.</p>\r\n<p><strong>Dining</strong>&nbsp;<br />Enjoy a meal at a restaurant, or stay in and take advantage of the resort''s 24-hour room service. Relax with your favorite drink at a bar/lounge or a poolside bar.</p>\r\n<p><strong>Business, Other Amenities</strong>&nbsp;<br />Featured amenities include a business center, limo/town car service, and a technology helpdesk. Event facilities at this resort consist of conference/meeting rooms, small meeting rooms, and a ballroom. Free self parking is available onsite.</p>', '59.49', 'US', 'NV', 1, '3790 Las Vegas Blvd S', 0, 89109, '37.805406', '-122.423433', '4.0', 0, '0.0', 5, 2, 7, 10, 'Test', 1, 0, 0, 0, 0, 0, 0, 'hotel_default.jpg', '41080_144_t.jpg', NULL, '12.00', '', 0),
(2, '15', 'BK', 'Gran Caribe', 'Satisfy your appetite at one of the resort''s 6 restaurants. A complimentary evening social is served', '<p><strong>Rooms</strong>&nbsp;<br />Make yourself at home in one of the 487 air-conditioned rooms featuring minibars and DVD players. Complimentary wireless Internet access keeps you connected, while CD players help you enjoy your music in the comfort of your room. Bathrooms have makeup/shaving mirrors and complimentary toiletries. Conveniences include direct-dial phones, as well as safes and desks.</p>\r\n<p><strong>Rec, Spa, Premium Amenities</strong>&nbsp;<br />Pamper yourself with onsite body treatments and facials. After dipping into one of the 2 outdoor swimming pools, you can spend some time at the private beach. Additional features include complimentary wireless Internet access, supervised childcare/activities, and babysitting/childcare.</p>\r\n<p><strong>Dining</strong>&nbsp;<br />Satisfy your appetite at one of the resort''s 6 restaurants. A complimentary evening social is served for your convenience. Relax with your favorite drink at a bar/lounge or a poolside bar.</p>', '150.00', 'MX', '', 2, 'Boulevard Kukulkan, Km. 11.5', 0, 77500, '37.788794', '-122.41019', '4.0', 0, '0.0', 6, 4, 9, 15, 'Policy Cancel Edited', 1, 0, 0, 0, 0, 0, 0, 'hotel_default.jpg', '28108_119_t.jpg', NULL, '20.00', '', 0),
(3, '1', 'BK', 'Las Vegas Superfast', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean m', '<p><span>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc,</span></p>', '300.00', 'US', 'NV', 1, 'Las Vegas', 0, 12345, '', '', '4.0', 0, '0.0', 2, 3, 5, 1, '', 1, 0, 0, 0, 0, 0, 0, 'hotel_default.jpg', 'city_hotel_icon70x70.png', NULL, '10.00', '', 0),
(4, '1', 'BK', 'Vegita', '', '', '0.00', 'US', 'NV', 1, '', 0, 0, '', '', '4.0', 0, '0.0', 3, 2, 5, 0, '', 1, 0, 0, 0, 0, 0, 0, 'hotel_default.jpg', 'city_hotel_icon70x70.png', NULL, '0.00', '', 0),
(5, '17', 'BK', 'Nuevos Precios de Temporada', 'Ever needed custom formatted sample / test data, like, bad? Well, that''s the idea of this script. It', '<p><span>Ever needed custom formatted sample / test data, like, bad? Well, that''s the idea of this script. It''s a free, open source tool written in JavaScript, PHP and MySQL that lets you quickly generate large volumes of custom data in a variety of formats for use in testing software, populating databases, and... so on and so forth.</span></p>', '200.00', 'MX', '', 1, 'Zona 10', 0, 11111, '1', '1', '4.0', 0, '0.0', 4, 2, 6, 1, '', 1, 0, 0, 0, 0, 0, 0, 'hotel_default.jpg', 'city_hotel_icon70x70.png', NULL, '10.00', '', 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `hotel_amenities` (
  `amenity_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hotel_id` bigint(20) NOT NULL,
  `amen_description` varchar(500) CHARACTER SET utf8 NOT NULL,
  `amen_active` tinyint(1) NOT NULL DEFAULT '1',
  `amen_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`amenity_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=20 ;

-- --------------------------------------------------------

INSERT INTO `hotel_amenities` (`amenity_id`, `hotel_id`, `amen_description`, `amen_active`, `amen_deleted`) VALUES
(1, 1, 'Accessible bathroom', 1, 0),
(2, 1, 'Air-conditioned public areas', 1, 0),
(3, 1, 'Babysitting or childcare', 1, 0),
(4, 1, 'Beauty services', 1, 0),
(5, 1, 'Designated smoking areas', 1, 0),
(6, 1, 'Hair salon', 1, 0),
(7, 1, 'Laundry facilities', 1, 0),
(8, 1, 'Television in lobby', 1, 0),
(9, 2, '24-hour front desk', 1, 0),
(10, 2, 'Accessible parking', 1, 0),
(11, 2, 'Beach umbrellas', 1, 0),
(12, 2, 'Concierge desk', 1, 0),
(13, 2, 'Free parking', 1, 0),
(14, 2, 'Health club', 1, 0),
(15, 2, 'On private beach', 1, 0),
(16, 2, 'Rooftop terrace', 1, 0),
(17, 2, 'Shopping on site', 1, 0),
(18, 2, 'Tennis on site', 1, 0),
(19, 2, 'Room service', 1, 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `hotel_images` (
  `hotel_image_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hotel_id` bigint(20) NOT NULL,
  `hotel_image_url` varchar(500) CHARACTER SET utf8 DEFAULT NULL,
  `hotel_ima_active` tinyint(1) NOT NULL DEFAULT '1',
  `hotel_ima_status` tinyint(1) NOT NULL DEFAULT '1',
  `hotel_ima_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`hotel_image_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

-- --------------------------------------------------------

INSERT INTO `hotel_images` (`hotel_image_id`, `hotel_id`, `hotel_image_url`, `hotel_ima_active`, `hotel_ima_status`, `hotel_ima_deleted`) VALUES
(1, 1, '41080_144_b-1385589312.jpg', 1, 1, 0),
(2, 1, '41080_145_b-1385589316.jpg', 1, 1, 0),
(3, 1, '41080_153_b-1385589320.jpg', 1, 1, 0),
(4, 1, '', 1, 1, 1),
(5, 1, '41080_173_b-1385589407.jpg', 1, 1, 0),
(6, 2, 'show-1385590833.jpg', 1, 1, 0),
(7, 2, 'show_(4)-1385590845.jpg', 1, 1, 0),
(8, 2, 'show_(3)-1385590854.jpg', 1, 1, 0),
(9, 2, 'show_(1)-1385590868.jpg', 1, 1, 0),
(10, 2, 'show_(2)-1385590889.jpg', 1, 1, 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `hotel_room_price` (
  `price_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `price_description` varchar(500) CHARACTER SET utf8 DEFAULT NULL,
  `room_type_id` bigint(20) NOT NULL,
  `room_person` bigint(20) NOT NULL,
  `room_price` decimal(10,0) NOT NULL,
  `priority` varchar(100) CHARACTER SET utf8 NOT NULL,
  `price_status` char(1) CHARACTER SET utf8 NOT NULL DEFAULT 'Y',
  `created` datetime NOT NULL,
  `price_deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`price_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=31 ;

-- --------------------------------------------------------

INSERT INTO `hotel_room_price` (`price_id`, `price_description`, `room_type_id`, `room_person`, `room_price`, `priority`, `price_status`, `created`, `price_deleted`) VALUES
(1, '1 Person', 1, 1, '39', '', 'Y', '2013-11-27 15:59:30', 0),
(2, '2 Person', 1, 2, '45', '', 'Y', '2013-11-27 15:59:51', 0),
(3, '3 Person', 1, 3, '50', '', 'Y', '2013-11-27 16:00:06', 0),
(4, '4 Person', 1, 4, '60', '', 'Y', '2013-11-27 16:00:26', 0),
(5, '5 Person', 1, 5, '70', '', 'Y', '2013-11-27 16:00:40', 0),
(6, '6 Person', 1, 6, '75', '', 'Y', '2013-11-27 16:01:00', 0),
(7, '1 Person', 2, 1, '50', '', 'Y', '2013-11-27 16:14:43', 0),
(8, '2 Person', 2, 65, '60', '', 'Y', '2013-11-27 16:14:55', 1),
(9, '1 Person', 3, 1, '39', '', 'Y', '2013-11-27 16:15:23', 0),
(10, '2 Person', 3, 2, '45', '', 'Y', '2013-11-27 16:15:41', 0),
(11, '3 Person', 3, 3, '65', '', 'Y', '2013-11-27 16:16:42', 0),
(12, '4 Person', 3, 4, '70', '', 'Y', '2013-11-27 16:16:54', 0),
(13, '5 Person', 3, 5, '75', '', 'Y', '2013-11-27 16:17:04', 0),
(14, '6 Person', 3, 6, '85', '', 'Y', '2013-11-27 16:17:30', 0),
(15, '7 Person', 3, 7, '100', '', 'Y', '2013-11-27 16:17:54', 0),
(16, '2 Person', 2, 2, '65', '', 'Y', '2013-11-27 16:28:52', 0),
(17, 'Uno', 4, 1, '100', '', 'Y', '2014-02-11 17:09:59', 0),
(18, 'Dos', 4, 2, '150', '', 'Y', '2014-02-11 17:10:08', 0),
(19, 'Tres', 4, 3, '175', '', 'Y', '2014-02-11 17:10:15', 0),
(20, 'Cuatro', 4, 4, '160', '', 'Y', '2014-02-11 17:10:23', 0),
(21, '3 Personas', 2, 3, '80', '', 'N', '2014-03-12 11:56:24', 0),
(22, 'Prueba Viernes 14', 8, 2, '250', '', 'Y', '2014-03-14 13:13:27', 0),
(23, 'ONE', 10, 1, '200', '', 'Y', '2014-03-24 11:48:51', 1),
(24, 'ONE', 10, 1, '200', '', 'Y', '2014-03-24 11:48:51', 1),
(25, 'ONE', 10, 1, '200', '', 'Y', '2014-03-24 11:49:18', 1),
(26, 'General', 10, 1, '200', '', 'Y', '2014-03-26 13:06:59', 0),
(27, 'Regular', 10, 5, '420', '', 'Y', '2014-03-26 13:31:18', 0),
(28, 'Regular', 10, 2, '300', '', 'Y', '2014-03-26 13:31:34', 0),
(29, 'Regular', 10, 3, '350', '', 'Y', '2014-03-26 18:50:52', 0),
(30, 'Regular', 10, 4, '400', '', 'Y', '2014-03-26 18:50:57', 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `hotel_room_type` (
  `room_type_id` int(8) NOT NULL AUTO_INCREMENT,
  `hotel_id` bigint(20) NOT NULL,
  `account_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL,
  `room_type_name` varchar(500) CHARACTER SET utf8 DEFAULT NULL,
  `room_type_short_description` varchar(500) CHARACTER SET utf8 DEFAULT NULL,
  `room_type_description` text CHARACTER SET utf8,
  `room_type_code` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `room_type_capacity` int(5) NOT NULL DEFAULT '0',
  `max_adults` int(11) NOT NULL DEFAULT '0',
  `max_kids` int(11) NOT NULL DEFAULT '0',
  `room_type_inventory` int(6) NOT NULL DEFAULT '0',
  `room_type_status` int(1) NOT NULL DEFAULT '1',
  `max_age_kids` int(11) NOT NULL DEFAULT '9',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`room_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

-- --------------------------------------------------------

INSERT INTO `hotel_room_type` (`room_type_id`, `hotel_id`, `account_id`, `room_type_name`, `room_type_short_description`, `room_type_description`, `room_type_code`, `room_type_capacity`, `max_adults`, `max_kids`, `room_type_inventory`, `room_type_status`, `max_age_kids`, `active`, `deleted`) VALUES
(1, 1, '1', 'Standar Room2', 'Standar Room2', 'Standar Room2', NULL, 3, 4, 0, 10, 1, 9, 1, 0),
(2, 2, '1', 'Standar Room', 'Standar Room', 'Standar Room', NULL, 2, 2, 2, 2, 1, 9, 1, 0),
(3, 2, '1', 'Deluxe Room', 'Deluxe Room', 'Deluxe Room', NULL, 9, 9, 8, 15, 1, 9, 1, 0),
(4, 1, '1', 'Deluxe Room', 'Deluxe', 'Deluxe', NULL, 7, 4, 3, 15, 1, 9, 1, 0),
(5, 1, '1', 'Premium Room', 'Premium', 'Premium', NULL, 8, 6, 4, 20, 1, 9, 1, 0),
(6, 3, '1', 'General', '', '', NULL, 3, 2, 1, 3, 1, 9, 0, 1),
(7, 3, '1', 'Superman', '', '', NULL, 5, 2, 3, 2, 1, 9, 1, 1),
(8, 3, '1', 'General', '', '', NULL, 5, 3, 2, 5, 1, 9, 1, 0),
(9, 3, '1', 'Tresa', '', '', NULL, 6, 4, 2, 3, 1, 9, 0, 0),
(10, 5, '1', 'MICKEY', '', '', NULL, 6, 5, 3, 10, 1, 9, 1, 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `hotel_seasonal_price` (
  `seasonal_price_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `room_type_id` bigint(20) NOT NULL DEFAULT '0',
  `room_person` int(11) NOT NULL DEFAULT '0',
  `seasonal_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `seasonal_from` date DEFAULT NULL,
  `seasonal_to` date DEFAULT NULL,
  `seasonal_price_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`seasonal_price_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=18 ;

-- --------------------------------------------------------

INSERT INTO `hotel_seasonal_price` (`seasonal_price_id`, `room_type_id`, `room_person`, `seasonal_price`, `seasonal_from`, `seasonal_to`, `seasonal_price_deleted`) VALUES
(1, 10, 1, '235.00', '2014-03-29', '2014-03-30', 1),
(2, 10, 1, '300.00', '2014-03-26', '2014-03-27', 1),
(3, 10, 1, '350.00', '2014-03-27', '2014-03-28', 0),
(4, 10, 1, '421.00', '2014-03-28', '2014-03-29', 0),
(5, 10, 2, '360.00', '2014-03-27', '2014-03-28', 0),
(6, 10, 2, '420.00', '2014-03-28', '2014-03-29', 0),
(7, 10, 2, '420.00', '2014-03-29', '2014-03-30', 0),
(8, 10, 2, '420.00', '2014-03-30', '2014-03-31', 0),
(9, 10, 4, '700.65', '2014-03-29', '2014-03-30', 0),
(10, 10, 4, '700.00', '2014-03-30', '2014-03-31', 0),
(11, 1, 1, '777.00', '2014-04-30', '2014-05-01', 0),
(12, 1, 1, '777.00', '2014-05-01', '2014-05-02', 0),
(13, 1, 1, '777.00', '2014-05-02', '2014-05-03', 0),
(14, 1, 1, '777.00', '2014-05-03', '2014-05-04', 0),
(15, 1, 1, '777.00', '2014-05-04', '2014-05-05', 0),
(16, 1, 1, '777.00', '2014-05-05', '2014-05-06', 0),
(17, 1, 1, '777.00', '2014-05-06', '2014-05-07', 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `hotel_stars` (
  `star_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `star_name` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`star_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=10 ;

-- --------------------------------------------------------

INSERT INTO `hotel_stars` (`star_id`, `star_name`) VALUES
(1, '1.0'),
(2, '1.5'),
(3, '2.0'),
(4, '2.5'),
(5, '3.0'),
(6, '3.5'),
(7, '4.0'),
(8, '4.5'),
(9, '5.0');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `inventory` (
  `inventory_id` bigint(11) NOT NULL AUTO_INCREMENT,
  `inve_name` varchar(300) CHARACTER SET utf8 NOT NULL,
  `inve_code` varchar(5) CHARACTER SET utf8 DEFAULT NULL,
  `inve_active` tinyint(1) NOT NULL DEFAULT '0',
  `inve_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`inventory_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

INSERT INTO `inventory` (`inventory_id`, `inve_name`, `inve_code`, `inve_active`, `inve_deleted`) VALUES
(1, 'DemoInventory', NULL, 1, 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `itineraries` (
  `itinerary_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itinerary_description` varchar(200) CHARACTER SET utf8 NOT NULL DEFAULT 'Itinerary Inactive',
  `check_in_date` date NOT NULL,
  `check_out_date` date NOT NULL,
  `ota_code` char(2) CHARACTER SET utf8 NOT NULL,
  `hotel_id` bigint(20) NOT NULL,
  `room_type_id` bigint(20) NOT NULL,
  `rooms_number` int(11) NOT NULL,
  `total_adults` int(11) NOT NULL DEFAULT '0',
  `total_children` int(11) NOT NULL DEFAULT '0',
  `total_amount` decimal(10,2) NOT NULL,
  `first_name_owner` varchar(300) CHARACTER SET utf8 NOT NULL,
  `last_name_owner` varchar(300) CHARACTER SET utf8 NOT NULL,
  `phone_owner` varchar(30) CHARACTER SET utf8 NOT NULL,
  `email_owner` varchar(300) CHARACTER SET utf8 NOT NULL,
  `key_time` varchar(100) CHARACTER SET utf8 NOT NULL,
  `key_access` varchar(100) CHARACTER SET utf8 NOT NULL,
  `itinerary_status` tinyint(1) NOT NULL DEFAULT '0',
  `itinerary_type` int(11) NOT NULL DEFAULT '0',
  `inventory_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `itinerary_date` datetime NOT NULL,
  PRIMARY KEY (`itinerary_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=73208 ;

-- --------------------------------------------------------

INSERT INTO `itineraries` (`itinerary_id`, `itinerary_description`, `check_in_date`, `check_out_date`, `ota_code`, `hotel_id`, `room_type_id`, `rooms_number`, `total_adults`, `total_children`, `total_amount`, `first_name_owner`, `last_name_owner`, `phone_owner`, `email_owner`, `key_time`, `key_access`, `itinerary_status`, `itinerary_type`, `inventory_deleted`, `itinerary_date`) VALUES
(73201, 'Itinerary Inactive', '2014-02-28', '2014-03-01', 'BK', 2, 3, 1, 2, 0, '54.00', 'Landon', 'Custom', '22543190', 'demo@bookingo.net', '18615195141393634590ea3c89a0', '858dba5d', 1, 0, 0, '2014-02-28 18:43:10'),
(73207, 'Itinerary Inactive', '2014-03-12', '2014-03-13', 'BK', 2, 2, 1, 2, 0, '78.00', 'Test', 'test', '22543190', 'demo@bookingo.net', '19014811724513946440294b53f8dd', '7aec6bad', 1, 0, 0, '2014-03-12 12:07:09');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `newsletter` (
  `id_mail` bigint(20) NOT NULL AUTO_INCREMENT,
  `news_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `news_ip` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `date` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '00-00-0000',
  `time` time NOT NULL,
  PRIMARY KEY (`id_mail`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `page_map` (
  `map_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `latitude` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `longitude` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `address` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `zoom` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `zoom_clic` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`map_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

INSERT INTO `page_map` (`map_id`, `latitude`, `longitude`, `address`, `zoom`, `zoom_clic`) VALUES
(1, '-25.292647', '134.051088', '<strong>New York Office</strong><br>New York, NY 10017', '12', '16');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `page_settings` (
  `page_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `page_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `page_link` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `page_title` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `page_keywords` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `page_meta_desc` text COLLATE utf8_unicode_ci NOT NULL,
  `page_script` text COLLATE utf8_unicode_ci NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`page_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=14 ;

-- --------------------------------------------------------

INSERT INTO `page_settings` (`page_id`, `page_name`, `page_link`, `page_title`, `page_keywords`, `page_meta_desc`, `page_script`, `date`) VALUES
(1, 'Home', 'index.php', 'Bookingo', 'hotels', 'Bookingo Hotels, is the best place to find Cacun hotels!', '', '2013-07-26'),
(2, 'Hotel List', 'hotel-list.php', 'Bookingo - Hotel List', 'hotels', 'Bookingo Hotels, is the best place to find hotels!', '', '0000-00-00'),
(3, 'Hotel', 'hotel.php', 'Bookingo - Hotel', '', 'Bookingo Hotels, is the best place to find hotels!', '', '0000-00-00'),
(4, 'Checkout', 'checkout.php', 'Bookingo - Checkout', '', 'Bookingo Hotels, is the best place to find hotels!', '', '0000-00-00'),
(5, 'Confirmation', 'confirmation.php', 'Bookingo - Confirmation', '', 'Bookingo Hotels, is the best place to find hotels!', '', '0000-00-00'),
(6, 'Itinerary', 'itinerario.php', 'Bookingo - Itinerary', '', 'Bookingo Hotels, is the best place to find hotels!', '', '0000-00-00'),
(7, 'Contact Us', 'contact.php', 'Bookingo - Contact Us', '', 'Bookingo Hotels, is the best place to find hotels!', '', '0000-00-00'),
(8, 'About Us', 'about-us.php', 'Bookingo - About Us', '', 'Bookingo Hotels, is the best place to find hotels!', '', '0000-00-00'),
(10, 'Faqs', 'faqs.php', 'Bookingo - Faq', '', 'Bookingo Hotels, is the best place to find hotels!', '', '0000-00-00'),
(11, 'Terms', 'terms.php', 'Bookingo - Terms and Conditions', '', 'Bookingo Hotels, is the best place to find hotels!', '', '2013-07-29'),
(12, 'Privacy Policy', 'privacy.php', 'Bookingo - Privacy Policy', '', 'Bookingo Hotels, is the best place to find hotels!', '', '2013-07-29'),
(13, 'My Reservation', 'reservation.php', 'Bookingo - My Reservation', '', 'Bookingo Hotels, is the best place to find hotels!', '', '2013-07-29');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `payment_currency` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `currency_code` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

-- --------------------------------------------------------

INSERT INTO `payment_currency` (`id`, `currency_code`) VALUES
(1, 'USD'),
(2, 'AUD'),
(3, 'CAD'),
(4, 'DKK'),
(5, 'EUR'),
(6, 'HKD'),
(7, 'MXN'),
(8, 'NZD'),
(9, 'RUB'),
(10, 'SEK');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `payment_gateway` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `gateway_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

INSERT INTO `payment_gateway` (`id`, `gateway_name`, `active`) VALUES
(1, 'paypal', 1),
(2, 'hotel', 1);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `paypal_gateway` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paypal_email` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `currency_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

INSERT INTO `paypal_gateway` (`id`, `paypal_email`, `currency_code`) VALUES
(1, 'demo@bookingo.net', 'USD');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `reviews` (
  `review_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hotelid` varchar(100) CHARACTER SET utf8 NOT NULL,
  `quality` int(11) NOT NULL,
  `nickname` varchar(300) CHARACTER SET utf8 NOT NULL,
  `review` text COLLATE utf8_unicode_ci NOT NULL,
  `date_review` datetime NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`review_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

-- --------------------------------------------------------

INSERT INTO `reviews` (`review_id`, `hotelid`, `quality`, `nickname`, `review`, `date_review`, `active`, `deleted`) VALUES
(4, '2', 3, 'James', 'Great hotel, I like the service.', '2013-12-04 17:51:45', 1, 0),
(6, '1', 4, 'James', 'test', '2014-03-17 18:57:54', 1, 0);

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `states` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) COLLATE utf8_unicode_ci NOT NULL,
  `abbrev` char(2) COLLATE utf8_unicode_ci NOT NULL,
  `country` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=79 ;

-- --------------------------------------------------------

INSERT INTO `states` (`id`, `name`, `abbrev`, `country`) VALUES
(1, 'Alaska', 'AK', 'US'),
(2, 'Alabama', 'AL', 'US'),
(3, 'American Samoa', 'AS', 'US'),
(4, 'Arizona', 'AZ', 'US'),
(5, 'Arkansas', 'AR', 'US'),
(6, 'California', 'CA', 'US'),
(7, 'Colorado', 'CO', 'US'),
(8, 'Connecticut', 'CT', 'US'),
(9, 'Delaware', 'DE', 'US'),
(10, 'District of Columbia', 'DC', 'US'),
(11, 'Federated States of Micronesia', 'FM', 'US'),
(12, 'Florida', 'FL', 'US'),
(13, 'Georgia', 'GA', 'US'),
(14, 'Guam', 'GU', 'US'),
(15, 'Hawaii', 'HI', 'US'),
(16, 'Idaho', 'ID', 'US'),
(17, 'Illinois', 'IL', 'US'),
(18, 'Indiana', 'IN', 'US'),
(19, 'Iowa', 'IA', 'US'),
(20, 'Kansas', 'KS', 'US'),
(21, 'Kentucky', 'KY', 'US'),
(22, 'Louisiana', 'LA', 'US'),
(23, 'Maine', 'ME', 'US'),
(24, 'Marshall Islands', 'MH', 'US'),
(25, 'Maryland', 'MD', 'US'),
(26, 'Massachusetts', 'MA', 'US'),
(27, 'Michigan', 'MI', 'US'),
(28, 'Minnesota', 'MN', 'US'),
(29, 'Mississippi', 'MS', 'US'),
(30, 'Missouri', 'MO', 'US'),
(31, 'Montana', 'MT', 'US'),
(32, 'Nebraska', 'NE', 'US'),
(33, 'Nevada', 'NV', 'US'),
(34, 'New Hampshire', 'NH', 'US'),
(35, 'New Jersey', 'NJ', 'US'),
(36, 'New Mexico', 'NM', 'US'),
(37, 'New York', 'NY', 'US'),
(38, 'North Carolina', 'NC', 'US'),
(39, 'North Dakota', 'ND', 'US'),
(40, 'Northern Mariana Islands', 'MP', 'US'),
(41, 'Ohio', 'OH', 'US'),
(42, 'Oklahoma', 'OK', 'US'),
(43, 'Oregon', 'OR', 'US'),
(44, 'Palau', 'PW', 'US'),
(45, 'Pennsylvania', 'PA', 'US'),
(46, 'Puerto Rico', 'PR', 'US'),
(47, 'Rhode Island', 'RI', 'US'),
(48, 'South Carolina', 'SC', 'US'),
(49, 'South Dakota', 'SD', 'US'),
(50, 'Tennessee', 'TN', 'US'),
(51, 'Texas', 'TX', 'US'),
(52, 'Utah', 'UT', 'US'),
(53, 'Vermont', 'VT', 'US'),
(54, 'Virgin Islands', 'VI', 'US'),
(55, 'Virginia', 'VA', 'US'),
(56, 'Washington', 'WA', 'US'),
(57, 'West Virginia', 'WV', 'US'),
(58, 'Wisconsin', 'WI', 'US'),
(59, 'Wyoming', 'WY', 'US'),
(60, 'Armed Forces Africa', 'AE', 'US'),
(61, 'Armed Forces Americas (except Canada)', 'AA', 'US'),
(62, 'Armed Forces Canada', 'AE', 'US'),
(63, 'Armed Forces Europe', 'AE', 'US'),
(64, 'Armed Forces Middle East', 'AE', 'US'),
(65, 'Armed Forces Pacific', 'AP', 'US'),
(66, 'Alberta', 'AB', 'CA'),
(67, 'British Columbia', 'BC', 'CA'),
(68, 'Manitoba', 'MB', 'CA'),
(69, 'New Brunswick', 'NB', 'CA'),
(70, 'Newfoundland and Labrador', 'NL', 'CA'),
(71, 'Northwest Territories', 'NT', 'CA'),
(72, 'Nova Scotia', 'NS', 'CA'),
(73, 'Nunavut', 'NU', 'CA'),
(74, 'Ontario', 'ON', 'CA'),
(75, 'Prince Edward Island', 'PE', 'CA'),
(76, 'Quebec', 'QC', 'CA'),
(77, 'Saskatchewan', 'SK', 'CA'),
(78, 'Yukon', 'YT', 'CA');

-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `transactions` (
  `transaction_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itinerario_id` bigint(20) NOT NULL,
  `hotel_id` int(11) NOT NULL DEFAULT '0',
  `operator_transaction_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL,
  `pp_payment` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `cardholder_first_name` varchar(150) CHARACTER SET utf8 NOT NULL,
  `cardholder_last_name` varchar(150) CHARACTER SET utf8 NOT NULL,
  `country` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `state` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `city` varchar(300) CHARACTER SET utf8 DEFAULT NULL,
  `address` varchar(1000) CHARACTER SET utf8 DEFAULT NULL,
  `zipcode` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `phone` varchar(20) CHARACTER SET utf8 NOT NULL,
  `email` varchar(100) CHARACTER SET utf8 NOT NULL,
  `ip` varchar(16) CHARACTER SET utf8 NOT NULL,
  `random_transaction` varchar(64) CHARACTER SET utf8 NOT NULL,
  `cantidad` int(11) NOT NULL,
  `precio_individual` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `impuestos` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_total` decimal(10,2) NOT NULL,
  `type_transaction` varchar(20) CHARACTER SET utf8 NOT NULL,
  `auth_code` int(11) NOT NULL,
  `void` varchar(20) CHARACTER SET utf8 NOT NULL,
  `completed` tinyint(4) NOT NULL,
  `success` tinyint(4) NOT NULL,
  `message` varchar(200) CHARACTER SET utf8 NOT NULL,
  `pp_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `null` tinyint(4) NOT NULL,
  `transaction_process` int(1) NOT NULL DEFAULT '0',
  `cancelled` tinyint(4) NOT NULL,

  `cancelled_code` int(11) NOT NULL,
  `deleted` tinyint(4) NOT NULL,
  `fantom` tinyint(4) DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=73108 ;

-- --------------------------------------------------------

INSERT INTO `transactions` (`transaction_id`, `itinerario_id`, `hotel_id`, `operator_transaction_id`, `pp_payment`, `cardholder_first_name`, `cardholder_last_name`, `country`, `state`, `city`, `address`, `zipcode`, `phone`, `email`, `ip`, `random_transaction`, `cantidad`, `precio_individual`, `impuestos`, `precio_total`, `type_transaction`, `auth_code`, `void`, `completed`, `success`, `message`, `pp_email`, `null`, `transaction_process`, `cancelled`, `cancelled_code`, `deleted`, `fantom`, `created`) VALUES
(73103, 73203, 2, '9L701973S6312024R', 'YES', 'Cyrus', 'Custom', 'Australia', '', 'Australia', 'Australia', '01002', '1236598', 'demo@bookingo.net', '186.151.148.3', '18615114831394135470373d4224', 1, NULL, '0.00', '78.00', 'sale', 1, 'NO', 1, 1, 'Completed', 'YES', 0, 2, 0, 0, 0, NULL, '2014-03-06 13:51:10');