<?php
//General Settings
require_once('../db.php');

$general_settings = mysqli_query($conn, "SELECT settings_email, settings_from_mail FROM general_settings WHERE settings_id = 1");
$settings_Data    = mysqli_fetch_array($general_settings);

//Variables
$settings_email     = $settings_Data['settings_email'];
$settings_from_mail = $settings_Data['settings_from_mail'];

//ADD THE EMAIL YOU WANT TO RECEIVE MESSAGES
$custom_email = $settings_email;

//ADD THE EMAIL YOU WANT TO SHOW IN FROM AREA
$from_email = $settings_from_mail;

//ADD THE SUBJECT TO SHOW
$subjectmail = 'New Enquiry';


if (!empty($_POST)) {
    
    //form validation vars
    $formok = true;
    $errors = array();
    
    //sumbission data
    $ipaddress = $_SERVER['REMOTE_ADDR'];
    $date      = date('d/m/Y');
    $time      = date('H:i:s');
    
    //form data
    $name      = $_POST['name'];
    $email     = $_POST['contactemail'];
    $telephone = $_POST['phone'];
    $itinerary = $_POST['itinerary'];
    $message   = $_POST['comments'];
    
    //validate form data
    
    //validate name is not empty
    if (empty($name)) {
        $formok   = false;
        $errors[] = "You have not entered a name";
    }
    
    //validate email address is not empty
    if (empty($email)) {
        $formok   = false;
        $errors[] = "You have not entered an email address";
        //validate email address is valid
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $formok   = false;
        $errors[] = "You have not entered a valid email address";
    }
    
    //validate message is not empty
    if (empty($message)) {
        $formok   = false;
        $errors[] = "You have not entered a message";
    }
    //validate message is greater than 10 charcters
    elseif (strlen($message) < 10) {
        $formok   = false;
        $errors[] = "Your message must be greater than 10 characters";
    }
    
    //send email if all is ok
    if ($formok) {
        $headers = "From:  {$from_email}" . "\r\n";
        $headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
        
        $emailbody = "<p>You have recieved a new message from the enquiries form on your website.</p>
					  <p><strong>Name: </strong> {$name} </p>
					  <p><strong>Email Address: </strong> {$email} </p>
					  <p><strong>Telephone: </strong> {$telephone} </p>
					  <p><strong>Itinerary: </strong> {$itinerary} </p>
					  <p><strong>Message: </strong> {$message} </p>
					  <p>This message was sent from the IP Address: {$ipaddress} on {$date} at {$time}</p>";
        
        mail($custom_email, $subjectmail, $emailbody, $headers);
        
    }
    
    //what we need to return back to our form
    $returndata = array(
        'posted_form_data' => array(
            'name' => $name,
            'email' => $email,
            'telephone' => $telephone,
            'itinerary' => $itinerary,
            'message' => $message
        ),
        'form_ok' => $formok,
        'errors' => $errors
    );
    
    
    //if this is not an ajax request
    if (empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        //set session variables
        session_start();
        $_SESSION['cf_returndata'] = $returndata;
        
        //redirect back to form
        header('location: ' . $_SERVER['HTTP_REFERER']);
    }
}
?>