<?php
//Bookingo Multi Hotel v1.6

//------------------------------- FRONT END CONFIGURATION -------------------------------//
//------------------------------- ----------------------- -------------------------------//


//Front End URL PATH
function siteURL()
{
  $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
  $domainName = $_SERVER['HTTP_HOST'].'/'; // /foldername is subdirectory
  return $protocol.$domainName;
}


//Page Path Information
define("DS", "/");
define('ROOTPATH', $_SERVER['DOCUMENT_ROOT']);
define("THEME_NAME", "default");
define('ABSPATH', dirname(__FILE__) . DS);
define('SITE', siteURL() );
define('WIDGETS', ABSPATH . "widget" . DS);
define('PLUGINS', ABSPATH . "plugins" . DS);
define('SIDEBAR', ABSPATH . "template" . DS . THEME_NAME . DS . "pages" . DS . "sidebar" . DS);
define('THEME', ABSPATH . "template" . DS . THEME_NAME . DS);
define('PAGES', ABSPATH . "template" . DS . THEME_NAME . DS . "pages" . DS);
define('QUERYS', ABSPATH . "querys" . DS);
define('HEAD', ABSPATH . "template" . DS . THEME_NAME . DS . "head" . DS);
define('FOOTER', ABSPATH . "template" . DS . THEME_NAME . DS . "footer" . DS);
define('PATH', SITE . "inc" . DS . "template" . DS . THEME_NAME . DS);
define('VERSION', "v1.6");

//------------------------------- --------------------------- -------------------------------//
//------------------------------- --------------------------- -------------------------------//



//------------------------------- BACKEND ADMIN CONFIGURATION -------------------------------//
//------------------------------- --------------------------- -------------------------------//


//Admin Panel URL PATH
function siteURLA()
{
  $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
  $domainName = $_SERVER['HTTP_HOST'].'/'.'bk-admin/'; // bk-admin is subdirectory
  return $protocol.$domainName;
}
define( 'SITE_URL', siteURLA() );
define('WEBSITE_DOMAIN', SITE_URL);


//BACKEND ADMIN TITLE
define('WEBSITE_NAME', "Bookingo");


//SESSION CONFIGURATION
define('SESSION_NAME',"ac_session");
define('SESSION_SECURE', false);
define('SESSION_HTTP_ONLY', true);
define('SESSION_REGENERATE_ID', true);
define('SESSION_USE_ONLY_COOKIES', 1);


//LOGIN CONFIGURATION
define('LOGIN_MAX_LOGIN_ATTEMPTS', 7);
define('LOGIN_FINGERPRINT', true);


//PASSWORD CONFIGURATION
define('PASSWORD_ENCRYPTION', "bcrypt"); //available values: "sha512", "bcrypt"
define('PASSWORD_BCRYPT_COST', "13");
define('PASSWORD_SHA512_ITERATIONS', 25000);
define('PASSWORD_SALT', "s9fwZ7NiirpOVcmRM/mNlW"); //22 characters to be appended on first 7 characters that will be generated using PASSWORD_ info above


//REGISTRATION CONFIGURATION
define('REGISTER_CONFIRM', SITE_URL . "confirm.php"); 
define('REGISTER_PASSWORD_RESET', SITE_URL . "passwordreset.php"); 


//ERROR MESSAGES
define('ERROR_EMAIL_REQUIRED', "Email is required.");
define('ERROR_EMAIL_WRONG_FORMAT', "Please enter valid email.");
define('ERROR_EMAIL_NOT_EXIST', "This email doesn't exist in our database.");
define('ERROR_EMAIL_TAKEN',"User with this email is already registred.");
define('ERROR_USERNAME_REQUIRED', "Username is required.");
define('ERROR_USERNAME_TAKEN', "Username already in use.");
define('ERROR_USER_NOT_CONFIRMED', "Please confirm your email.");
define('ERROR_PASSWORD_REQUIRED', "Password is required.");
define('ERROR_WRONG_USERNAME_PASSWORD', "Wrong username/password combination.");
define('ERROR_PASSWORDS_DONT_MATCH', "Passwords don't match.");
define('ERROR_WRONG_SUM', "Wrong sum. Please check it again.");
define('ERROR_BRUTE_FORCE', "You exceeded maximum attempts limit for today. Try again tomorrow.");


//SUCCESS MESSAGES
define('SUCCESS_REGISTRATION', "Registration successful. Please check your email.");
define('SUCCESS_ADDUSER', "Registration successful.");


//CUSTOM APP DATA
define('APPNAME','Bookingo');
define('COMPANYNAME','Bookingo');
define('COPYRIGHT','2013 - 2014 &copy; Powered by Bookingo - '. VERSION);
define('LICENCE_KEY','BK8A-PDRL-9FVH-4VHT');
?>