<?php
include 'ASEngine/AS.php';
if(!$login->isLoggedIn())
    header("Location: login.php");
$user = new ASUser(ASSession::get("user_id"));
$userInfo = $user->getInfo();
$nav = '';
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title><?php echo WEBSITE_NAME;  ?></title>
    <meta name="author" content="Bookingo" />
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <meta name="application-name" content="Bookingo" />

    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <!-- Force IE9 to render in normla mode -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <!-- Le styles -->
    <!-- Use new way for google web fonts 
    http://www.smashingmagazine.com/2012/07/11/avoiding-faux-weights-styles-google-web-fonts -->
    <!-- Headings -->
    <!-- <link href='http://fonts.googleapis.com/css?family=Open+Sans:400,700' rel='stylesheet' type='text/css' />  -->
    <!-- Text -->
    <!-- <link href='http://fonts.googleapis.com/css?family=Droid+Sans:400,700' rel='stylesheet' type='text/css' /> --> 
    <!--[if lt IE 9]>
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:400" rel="stylesheet" type="text/css" />
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:700" rel="stylesheet" type="text/css" />
    <link href="http://fonts.googleapis.com/css?family=Droid+Sans:400" rel="stylesheet" type="text/css" />
    <link href="http://fonts.googleapis.com/css?family=Droid+Sans:700" rel="stylesheet" type="text/css" />
    <![endif]-->

    <!-- Core stylesheets do not remove -->
    <link id="bootstrap" href="<?php echo SITE_URL; ?>css/bootstrap/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link id="bootstrap-responsive" href="<?php echo SITE_URL; ?>css/bootstrap/bootstrap-responsive.min.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo SITE_URL; ?>css/supr-theme/jquery.ui.supr.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo SITE_URL; ?>css/icons.css" rel="stylesheet" type="text/css" />


    <!-- Plugin stylesheets -->
    <link href="<?php echo SITE_URL; ?>plugins/misc/qtip/jquery.qtip.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo SITE_URL; ?>plugins/forms/uniform/uniform.default.css" type="text/css" rel="stylesheet" />        
    <link href="<?php echo SITE_URL; ?>plugins/tables/dataTables/jquery.dataTables.css" type="text/css" rel="stylesheet" />
    <link href="<?php echo SITE_URL; ?>plugins/tables/dataTables/TableTools.css" type="text/css" rel="stylesheet" />

    <!-- Main stylesheets -->
    <link href="<?php echo SITE_URL; ?>css/main.css" rel="stylesheet" type="text/css" /> 

    <!-- Custom stylesheets ( Put your own changes here ) -->
    <link href="<?php echo SITE_URL; ?>css/custom.css" rel="stylesheet" type="text/css" /> 

    <!--[if IE 8]><link href="css/ie8.css" rel="stylesheet" type="text/css" /><![endif]-->

    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script type="text/javascript" src="js/libs/excanvas.min.js"></script>
      <script type="text/javascript" src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
      <script type="text/javascript" src="js/libs/respond.min.js"></script>
    <![endif]-->

    <!-- Le fav and touch icons -->
    <link rel="shortcut icon" href="<?php echo SITE_URL; ?>images/favicon.ico" />
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo SITE_URL; ?>images/apple-touch-icon-144-precomposed.png" />
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo SITE_URL; ?>images/apple-touch-icon-114-precomposed.png" />
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo SITE_URL; ?>images/apple-touch-icon-72-precomposed.png" />
    <link rel="apple-touch-icon-precomposed" href="<?php echo SITE_URL; ?>images/apple-touch-icon-57-precomposed.png" />
    
    <!-- Windows8 touch icon ( http://www.buildmypinnedsite.com/ )-->
    <meta name="msapplication-TileColor" content="#3399cc"/> 

    <!-- Load modernizr first -->
    <script type="text/javascript" src="<?php echo SITE_URL; ?>js/libs/modernizr.js"></script>
	
    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="js/html5shiv.js"></script>
    <![endif]-->
    
    </head>
      
    <body>
    <!-- loading animation -->
    <div id="qLoverlay"></div>
    <div id="qLbar"></div>
    
    <div id="header" class="fixed">

        <?php include 'inc/header.php'; ?><!-- /navbar --> 

    </div><!-- End #header -->

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
        <div id="sidebar">
			<?php include 'inc/sidebar.php'; ?><!-- /sidebar -->
        </div><!-- End #sidebar -->

        <!--Body content-->
        <div id="content" class="clearfix">
            <div class="contentwrapper"><!--Content wrapper-->

                <div class="heading">
				<!--Content Title-->
                    <h3>Users List</h3>                    

                    <div class="resBtnSearch">
                        <a href="#"><span class="icon16 icomoon-icon-search-3"></span></a>
                    </div>

                    <ul class="breadcrumb">
                        <li>
                            <a href="./" class="tip" title="back to dashboard">
                                <span class="icon16 icomoon-icon-screen-2"></span>
                            </a> 
                            <span class="divider">
                                <span class="icon16 icomoon-icon-arrow-right-3"></span>
                            </span>
                        </li>
                        <li class="active"><a href="javascript: history.go(-1)">Go Back</a></li>
                    </ul>

                </div><!-- End .heading-->


                <!-- Build page from here: -->
                <div class="row-fluid">
					
                        <div class="span12">

                            <div class="box gradient">

                                <div class="title">
                                    <h4>
                                        <span>Users</span>
                                    </h4>
                                </div>
                                <div class="content noPad clearfix">
                                    <?php $users = $db->select("SELECT * FROM `as_users` WHERE `user_id` != '1' ORDER BY `register_date` DESC"); ?>
                                    <table cellpadding="0" cellspacing="0" border="0" class="tableTools display table table-bordered stdtable" width="100%">
                                        <thead>
                                            <tr>
                                                <th>Username</th>
                                                <th>Role</th>
                                                <th>Register Date</th>
                                                <th>Last Login</th>
                                                <th>Confirmed</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        
                                        <?php foreach ($users as $user): ?>
										  <?php $tmpUser = new ASUser($user['user_id']); ?>
                                          <?php $userRole = $tmpUser->getRole(); ?>
                                            <tr class="user-row">
                                                <td><?php echo htmlentities($user['username']); ?></td>
                                                <td><?php echo ucfirst($userRole); ?></td>
                                                <td><?php echo $user['register_date']; ?></td>
                                                <td><?php echo $user['last_login']; ?></td>
                                                <td>
													<?php echo $user['confirmed'] == "Y" 
                                                        ? "<p class='text-success'>Yes</p>" 
                                                        : "<p class='text-error'>No</p>" 
                                                    ?>
                                                </td>
                                                <td>
                                                <button data-toggle="modal" class="btn btn-mini" href="#myModal1" 
                                   onclick="users.displayInfo(<?php echo $user['user_id']; ?>);">Details</button> 
                                   <button data-toggle="modal" class="btn btn-primary btn-mini" href="#myModal2" 
                                   onclick="users.roleChanger(this,<?php echo $user['user_id'];  ?>);">Change Role</button> 
                                   <button class="btn btn-danger btn-mini" href="javascript:void(0);" 
                                   onclick="users.deleteUser(this,<?php echo $user['user_id']; ?>);">Delete</button>
                                   <a href="edit_user.php?user_id=<?php echo $user['user_id']; ?>" class="toggle"><button class="btn btn-success btn-mini">Edit</button></a>
                                   				
                                                </td>
                                            </tr>
                                          <?php endforeach; ?>
                                          
                                        </tbody>
                                    </table>
                                </div>

                            </div><!-- End .box -->

                        </div><!-- End .span12 -->

                    
                    
                <div class="modal fade hide" id="myModal1">
                <div id="modal-user-details" style="display: none;">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">×</button>
                        <h4 class="modal-title" id="modal-username">Loading...</h4>
                    </div>
                    <div class="modal-body" id="details-body">
                     
                      <dl class="dl-horizontal">
                        <dt>Email</dt>
                        <dd id="modal-email"></dd>
                        <dt>First Name</dt>
                        <dd id="modal-first-name"></dd>
                        <dt>Last Name</dt>
                        <dd id="modal-last-name"></dd>
                        <dt>Address</dt>
                        <dd id="modal-address"></dd>
                        <dt>Phone</dt>
                        <dd id="modal-phone"></dd>
                      </dl>
                    
                    </div>
                    <div align="center" id="ajax-loading"><img src="images/loaders/circular/059.gif" /></div>
                    <div class="modal-footer">
                        <a href="#" class="btn" data-dismiss="modal">Close</a>
                    </div>
                </div>
                </div>
                
                <div class="modal fade hide" id="myModal2">
                    <div id="modal-change-role">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">×</button>
                        <h4 class="modal-title" id="modal-username">Pick User Role</h4>
                    </div>
                    <div class="modal-body" id="details-body">
                     
                    <?php $roles = $db->select("SELECT * FROM `as_user_roles`"); ?>
                    <?php if(count($roles) > 0): ?>
                      <p>Select new role:</p>
                      <select id="select-user-role" style="width: 100%;">
                      <option value="">Select..</option>
					  <?php foreach($roles as $role): ?>
                          <option value="<?php echo $role['role_id']; ?>">
                            <?php echo ucfirst($role['role']); ?>
                          </option>
                      <?php endforeach; ?>
                      </select>
                    <?php endif; ?>
                    
                    </div>
                    <div class="modal-footer">
                    	<a href="javascript:void(0);" class="btn btn-default" data-dismiss="modal" aria-hidden="true">Cancel</a>
                  		<a href="javascript:void(0);" class="btn btn-primary" id="change-role-button" data-dismiss="modal" aria-hidden="true">Ok</a>
                    </div>
                </div>
                </div>
                
                
                </div><!-- End .row-fluid -->
                <!--End page -->
                
                
            </div><!-- End contentwrapper -->
        </div><!-- End #content -->
           
    <footer>
    	<?php include 'inc/footer.php'; ?><!-- /footer -->
    </footer>
    
    </div><!-- End #wrapper -->
    
    <!-- Le javascript
    ================================================== -->
    <!-- Important plugins put in all pages -->
    <script  type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
    <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.10.2/jquery-ui.min.js"></script>
    <script type="text/javascript" src="http://code.jquery.com/jquery-migrate-1.2.1.min.js"></script>
    <script type="text/javascript" src="<?php echo SITE_URL; ?>js/bootstrap/bootstrap.js"></script>  
    <script type="text/javascript" src="<?php echo SITE_URL; ?>js/jquery.mousewheel.js"></script>
    <script type="text/javascript" src="<?php echo SITE_URL; ?>js/libs/jRespond.min.js"></script>


    <!-- Misc plugins -->
    <script type="text/javascript" src="<?php echo SITE_URL; ?>plugins/misc/qtip/jquery.qtip.min.js"></script><!-- Custom tooltip plugin -->
    <script type="text/javascript" src="<?php echo SITE_URL; ?>plugins/misc/totop/jquery.ui.totop.min.js"></script> 
    
    
    <!-- Search plugin -->
    <script type="text/javascript" src="plugins/misc/search/tipuesearch_set.js"></script>
    <script type="text/javascript" src="plugins/misc/search/tipuesearch_data.js"></script><!-- JSON for searched results -->
    <script type="text/javascript" src="plugins/misc/search/tipuesearch.js"></script>
    
    
    <!-- Form plugins -->
    <script type="text/javascript" src="<?php echo SITE_URL; ?>plugins/forms/uniform/jquery.uniform.min.js"></script>

	
    <!-- Table plugins -->
    <script type="text/javascript" src="<?php echo SITE_URL; ?>plugins/tables/dataTables/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="<?php echo SITE_URL; ?>plugins/tables/dataTables/TableTools.min.js"></script>
    <script type="text/javascript" src="<?php echo SITE_URL; ?>plugins/tables/dataTables/ZeroClipboard.js"></script>
    <script type="text/javascript" src="<?php echo SITE_URL; ?>plugins/tables/responsive-tables/responsive-tables.js"></script><!-- Make tables responsive -->
    

    <!-- Init plugins -->
    <script type="text/javascript" src="<?php echo SITE_URL; ?>js/main.js"></script><!-- Core js functions -->
    <script type="text/javascript" src="<?php echo SITE_URL; ?>js/datatable.js"></script><!-- Init plugins only for page -->


    <script src="<?php echo SITE_URL; ?>ASLibrary/js/users.js" type="text/javascript" charset="utf-8"></script>
    <script src="<?php echo SITE_URL; ?>ASLibrary/js/index.js" type="text/javascript" charset="utf-8"></script>
    <script type="text/javascript" src="<?php echo SITE_URL; ?>ASLibrary/js/logout.js" charset="utf-8"></script>
    <script type="text/javascript" src="<?php echo SITE_URL; ?>plugins/ajaxedit/tables.js"></script> 
    
    </body>
</html>