$(document).ready(function () {
	$(".form-horizontal").submit(function () {
    	return false;
    });
	$("#update_user").click(function () {
        profile.updateUser();
    });
	$("#update_password").click(function () { 
        if(profile.validatePasswordUpdate())
            profile.updatePass(); 
    });
});



/** PROFILE NAMESPACE
 ======================================== */

var profile = {};


/**
 * Updates User.
 */
profile.updateUser = function () {
        //remove error messages if there are any
	asengine.removeErrorMessages();
	var email = $("#email");

	if($.trim(email.val()) == "") {
		asengine.displayErrorMessage(email, "Field cannot be empty!");
		return;
	}
        
        //turn on button loading state
        asengine.loadingButton($("#update_user"), "Updating...");
        
        //prepare data that will be sent to server
	var data = {
		action: "updateUser",
    		userdata: {
			email: $("#email").val(),
			username: $("#username").val(),
			confirmed: $("#confirmed").val()
		}
	};
	
	
        //send data to server
	$.ajax({
		url: "ASEngine/ASAjax.php",
		type: "POST",
		data: data,
		success: function (result) {
                        //return button to normal state
                        asengine.removeLoadingButton($("#update_user"));
                        
			if(result == "") {
				asengine.displaySuccessMessage($("#successuser"),"Details updated successfully.");
			}
			else {
                                //display error messages
				console.log(result);
				asengine.displayErrorMessage($("#form-user input"));
				asengine.displayErrorMessage($("#email"), "Error while updating database. Please try again.");
			}
		}
	});
};


/**
 * Updates user password.
 */
profile.updatePass = function() {
        //turn on button loading state
        asengine.loadingButton($("#update_password"), "Updating...");
    
        //encrypt passwords before sending them through the network
	var newPass = CryptoJS.SHA512($("#new_password").val()).toString();
        
        //send data to server
	$.ajax({
		url: "ASEngine/ASAjax.php",
		type: "POST",
		data: {
			action	 : "updatePass",
			newpass  : newPass
		},
		success: function (result) {
                        //return button to normal state
                        asengine.removeLoadingButton($("#update_password"));
                        
			if(result == "") {
                                //display success message
				asengine.displaySuccessMessage(
                                        $("#form-updatepassword"),
                                        "Password updated successfully."
                                    );
			}
			
		}
	});
};


/**
 * Validate password update form.
 * @returns {Boolean} TRUE if form is valid, FALSE otherwise.
 */
profile.validatePasswordUpdate = function () {
    
        //remove all error messages if there are some
	asengine.removeErrorMessages();
	
        //get all data from form
	var newpass  = $("#new_password"),
            confpass = $("#new_password_confirm"),
            valid    = true;
		
        
	
        //check if field is empty
	if($.trim(newpass.val()) == "") {
		valid = false;
		asengine.displayErrorMessage(newpass, "Field cannot be empty!");
	}
	
        //check if field is empty
	if($.trim(confpass.val()) == "") {
		valid = false;
		asengine.displayErrorMessage(confpass, "Field cannot be empty!");
	}
	
        //check if password and confirm new password are equal
	if($.trim(confpass.val()) != $.trim(newpass.val()) ) {
		valid = false;
		asengine.displayErrorMessage(newpass);
		asengine.displayErrorMessage(confpass, "Passwords don't match.");
	}
	
	return valid;
	
};