<?php
include 'AS.php';

//csrf protection
if(empty($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest') 
    die("Sorry bro!");

$url = parse_url( isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '');
if( !isset( $url['host']) || ($url['host'] != $_SERVER['SERVER_NAME']))
    die("Sorry bro!");

$action = $_POST['action'];

switch ($action) {
	case 'checkLogin':
		$logged = $login->userLogin($_POST['username'], $_POST['password']);
        if($logged === true)
            echo "true";
		break;
        
    case "registerUser":
        $register->register($_POST['user']);
        break;
		
	case "addUser":
        $registeruser->registeruser($_POST['user']);
        break;
        
    case "resetPassword":
        $register->resetPassword($_POST['newPass'], $_POST['key']);
        break;
        
    case "forgotPassword":
        $register->forgotPassword($_POST['email']);
        break;
        
    case "logout":
        ASSession::destroySession();
        break;
        
    case "postComment":
        $ASComment = new ASComment();
        echo $ASComment->insertComment(ASSession::get("user_id"), $_POST['comment']);
        break;
        
    case "updatePassword":
        $user = new ASUser(ASSession::get("user_id"));
        $user->updatePassword($_POST['oldpass'], $_POST['newpass']);
        break;
        
    case "updateDetails":
        $user = new ASUser(ASSession::get("user_id"));
        $user->updateDetails($_POST['details']);
        break;
		
	case "updateEmail":
        $user = new ASUser(ASSession::get("user_id"));
        $user->updateEmail($_POST['email']);
        break;
		
	case "updateUser":
		$loggedUser = new ASUser(ASSession::get("user_id"));
		if(!$loggedUser->isAdmin()) exit();
		//$idusuario = ASSession::get("iduser");
		$username = $_POST['userdata']['username'];
		$result = $db->select("SELECT * FROM `as_users` WHERE `username` = :u", array( 'u' => $username ));
		$user = new ASUser($result[0]['user_id']);
		$user->updateUser($_POST['userdata']);
        break;
		
	case "updatePass":
        $loggedUser = new ASUser(ASSession::get("user_id"));
		if(!$loggedUser->isAdmin()) exit();
		$idusuario = ASSession::get("iduser");
		$result = $db->select("SELECT * FROM `as_users` WHERE `user_id` = :u", array( 'u' => $idusuario ));
		$user = new ASUser($result[0]['user_id']);
        $user->updatePass($_POST['newpass']);
        break;
		
    case "changeRole":
        $loggedUser = new ASUser(ASSession::get("user_id"));
        if(!$loggedUser->isAdmin()) exit();

        $user = new ASUser($_POST['userId']);
        echo ucfirst($user->changeRole());
        break;
        
    case "deleteUser":
        $loggedUser = new ASUser(ASSession::get("user_id"));
        if(!$loggedUser->isAdmin()) exit();

        $user = new ASUser($_POST['userId']);
        $user->deleteUser();
        break;
    
    case "getUserDetails":
        $user = new ASUser($_POST['userId']);
        $loggedUser = new ASUser(ASSession::get("user_id"));
        if(!$loggedUser->isAdmin()) exit();

        $info = $user->getInfo();
        
        //prepare and output result
        $result             = $user->getDetails();
        $result['email']    = $info['email'];
        $result['username'] = $info['username'];
        echo json_encode($result);
        break;

    case "addRole": 
        $loggedUser = new ASUser(ASSession::get("user_id"));
        if(!$loggedUser->isAdmin()) exit();

        $res = $db->select("SELECT * FROM `as_user_roles` WHERE `role` = :r", array( 'r' => $_POST['role'] ));
        if(count($res) == 0) {
            $db->insert("as_user_roles", array("role" => strtolower(strip_tags($_POST['role']))));
            $result = array(
                "status"   => "success",
                "roleName" => strip_tags($_POST['role']),
                "roleId"   => $db->lastInsertId()
            );
        }
        else {
            $result = array(
                "status" => "error",
                "message" => "Role already exists."
            );
        }
        echo json_encode($result);
        break;

    case "deleteRole":
        $loggedUser = new ASUser(ASSession::get("user_id"));
        if(!$loggedUser->isAdmin()) exit(); 
        
        //default user roles can't be deleted
        if(in_array($_POST['roleId'], array(1,2,3)) )
            exit();

        $db->delete("as_user_roles", "role_id = :id", array(
            "id" => $_POST['roleId']
        ));
        $db->update("as_users", array( 'user_role' => "1" ), "user_role = :r", array( "r" => $_POST['roleId'] ) );
        break;
        
	
	default:
		
		break;
}