<?php
defined('ABSPATH') or die();

function billio_shortcode_lang( $arr )
{
    $arr[] = dirname(__FILE__). '/customcodes.string.php';
    return $arr;
}


function add_billio_shortcode_plugin($plugin_array) { 

	if ( floatval(get_bloginfo('version')) >= 3.9){
	   $plugin_array['dtshortcode']=get_template_directory_uri().'/lib/customcodes.js.php';
	}else{
	   $plugin_array['dtshortcode']=get_template_directory_uri().'/lib/customcodes.js.old.php';
	}

	add_filter( 'mce_external_languages', 'billio_shortcode_lang', 10, 1 );
   return $plugin_array;  
}

function register_billio_shortcode_button($buttons) {  
   array_push($buttons, "dtshortcode");  
   return $buttons;  
}  



function add_billio_shortcode_button() {  

       if ( !current_user_can('edit_posts') &&  !current_user_can('edit_pages') )  {
       	return;
       }

		if ( 'true' == get_user_option( 'rich_editing' ) ) {
         add_filter('mce_external_plugins', 'add_billio_shortcode_plugin');  
         add_filter('mce_buttons', 'register_billio_shortcode_button');  
       }  
} 

add_action('admin_head', 'add_billio_shortcode_button'); 
add_action('wp_ajax_billio_get_shortcode','render_billio_shortcode_panel');


function render_billio_shortcode_panel(){

	locate_template('lib/shortcode_panel.php',true);
	die();
}

/* render shortcode on widget text */
add_filter('widget_text',create_function('$s', 'return do_shortcode($s);'));

?>