<?php
	////
	// query portfolio items
	////
	
	$arg=array (
		'post_type' => 'portfolio',
		'orderby' => 'menu_order',
		'order' => 'ASC',
		'posts_per_page' => -1
	);

	$sort=get_option('ompf_portfolio_sort');
	if($sort == 'date_asc') {
		$arg['orderby'] = 'date';
		$arg['order'] = 'ASC';
	} elseif($sort == 'date_desc') {
		$arg['orderby'] = 'date';
		$arg['order'] = 'DESC';
	}
				
	$pagination=intval(get_option('ompf_portfolio_per_page'));
	if($pagination) {
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		$arg['posts_per_page']=$pagination;
		$arg['paged']=$paged;
	}
				
	$portfolio_category=intval(get_post_meta($portfolio_post_id, 'ompf_portfolio_categories', true));
	if($portfolio_category) {
		$arg['tax_query']=array(
			array('taxonomy'=>'portfolio-type', 'terms' => $portfolio_category),
		);
	}
	
	$arg=apply_filters('ompf_portfolio_query', $arg);
	
	$original_query = $wp_query;
	$wp_query = null;
	$wp_query = new WP_Query($arg);
	$max_num_pages=$wp_query->max_num_pages;

	////
	// query portfolio categories
	////
	
	$all_link='<a href="#portfolio-thumb" class="ompf-active"><span class="ompf-count">'. max($wp_query->post_count, $wp_query->found_posts) .'</span>'. __('All', 'om_portfolio') .'</a>';
	include $GLOBALS['omPortfolioPlugin']['path'] . 'includes/portfolio-categories.php';
	
	////
	// portfolio content
	////
	
	include $GLOBALS['omPortfolioPlugin']['path'] . 'includes/portfolio-content.php';

	$wp_query = null;
	$wp_query = $original_query;
	wp_reset_postdata();
		
	if($pagination) {
		echo ompf_pagination_links($paged, $max_num_pages);
	}