<?php
	
	if(has_action('ompf_portfolio_layout_random')) {
		
		do_action('ompf_portfolio_layout_random');
		
	} else {

		$ratio=get_option('ompf_portfolio_single_random_ratio');
		if(!$ratio)
			$ratio=1.5;

		$size=get_option('ompf_portfolio_single_show_random');
		if(!$size)
			$size='medium';

		if(isset($GLOBALS['omPortfolioPlugin']['config']['thumbnail_sizes'][$size]['width']))
			$thumb_width=$GLOBALS['omPortfolioPlugin']['config']['thumbnail_sizes'][$size]['width'];
		else
			$thumb_width=300;
		
		$thumb_height=round($thumb_width/$ratio);
		
		while ( have_posts() ) {
			the_post(); 
			
			//$item_preview_layout=get_post_meta($post->ID, 'ompf_portfolio_preview_layout', true);
			//if(!$item_preview_layout || $item_preview_layout == 'inherit')
				$item_preview_layout='full';
				
			$link=get_post_meta($post->ID, 'ompf_portfolio_custom_link', true);
			if(!$link)
				$link=get_permalink();
			elseif($link == 'none')
				$link=false;
				
			$img=false;
			if ( has_post_thumbnail() ) {
				$img = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full');
				if($img) {
					$img=omaq_resize($img[0],$thumb_width,$thumb_height,true,true);
				}
			}
			
			$item_classes=array(
				'ompf-portfolio-thumb',
				'ompf-size-'.$size,
			);
			
			$term_classes=ompf_item_term_classes($post->ID);
			if($term_classes)
				$item_classes[]=$term_classes;
				
			if($link) {
				$item_classes[]='ompf-with-link';
			} else {
				$item_classes[]='ompf-no-link';
			}
			
			/*
			if($item_preview_layout != 'full') {
				$item_classes[]='ompf-no-desc';
			}
			*/
		
			if(has_filter('ompf_portfolio_layout_random_item')) {
				
				echo apply_filters('ompf_portfolio_layout_random_item', array(
					'post' => $post,
					'item_classes' => $item_classes,
					'item_preview_layout' => $item_preview_layout,
					'ratio' => $ratio,
					'size' => $size,
					'link' => $link,
					'img' => $img,
				));
				
			} else {
				?>
				<div class="<?php echo implode(' ',$item_classes) ?>" id="post-<?php the_ID(); ?>">
					<a<?php if($link) echo ' href="'.$link.'"'; ?>>
						<span class="ompf-pic-wrapper">
							<span class="ompf-pic" style="padding-top:<?php echo (1/$ratio * 100) ?>%">
								<span class="ompf-pic-inner">
									<?php
										if($img) {
											if($GLOBALS['omPortfolioPlugin']['config']['enable_lazyload_markup'])
												echo '<img src="'.$GLOBALS['omPortfolioPlugin']['config']['lazyload_placeholder'].'" data-original="'.$img.'" class="lazyload" alt="'.esc_attr($post->post_title).'" />';
											else
												echo '<img src="'.$img.'" alt="'.esc_attr($post->post_title).'" />';
										} 
									?>
								</span>
							</span>
						</span>
						<?php if($item_preview_layout != 'thumbnail') { ?>
						<span class="ompf-desc-wrapper">
							<span class="ompf-desc">
								<span class="ompf-title"><?php the_title(); ?></span>
							</span>
						</span>
						<?php } ?>
					</a>
				</div>
				<?php
			}
			
		}
		
	}