<?php
	$link=get_post_meta($post->ID, 'ompf_portfolio_custom_link', true);
	if(!$link)
		$link=get_permalink();
	elseif($link == 'none')
		$link=false;
		
	$img=false;
	if ( has_post_thumbnail() ) {
		$img = wp_get_attachment_image_src( get_post_thumbnail_id(), 'thumbnail');
		if($img) {
			$img=$img[0];
		}
	}
?>
<div class="ompf-portfolio-archive-item">
	<?php if($img) { ?>
		<div class="ompf-portfolio-archive-item-pic">
			<?php if($link) { ?>
				<a href="<?php echo $link ?>"><img src="<?php echo $img ?>" alt="<?php echo esc_attr(get_the_title())?>" /></a>
			<?php } else { ?>
				<img src="<?php echo $img ?>" alt="<?php echo esc_attr(get_the_title())?>" />
			<?php } ?>
		</div>
	<?php } ?>
	<div class="ompf-portfolio-archive-item-desc">
		<?php if($link) { ?>
			<h3><a href="<?php echo $link ?>"><?php the_title() ?></a></h3>
		<?php } else { ?>
			<h3><?php the_title() ?></h3>
		<?php } ?>
		<?php echo $content ?>
	</div>
	<div class="ompf-clear"></div>
</div>