<?php

/*************************************************************************************
 *	Recent Portfolios
 *************************************************************************************/

function ompf_sc_portfolio( $atts, $content = null ) {

	if(has_filter('ompf_sc_portfolio'))
		return apply_filters('ompf_sc_portfolio', $atts, $content);	

	global $post, $wp_query;
		
	extract(shortcode_atts(array(
		'size' => 'medium',
		'count' => 3,
		'category' => 0,
		'ids' => '',
		'ratio' => '3:2',
		'layout' => 'thumbnail_title',
		'randomize' => false,
		'widget_mode' => false,
	), $atts));
	
	if(!isset($GLOBALS['omPortfolioPlugin']['config']['thumbnail_sizes'][$size]))
		$size='medium';
		
	if(isset($GLOBALS['omPortfolioPlugin']['config']['preview_items_per_row'][$size]))
		$per_row=$GLOBALS['omPortfolioPlugin']['config']['preview_items_per_row'][$size];
	else
		$per_row=3;

	$ratio=explode(':',$ratio);
	if(@$ratio[1]) {
		$ratio=$ratio[0]/$ratio[1];
		if(!$ratio) {
			$ratio=3/2;
		}
	} else {
		$ratio=3/2;
	}

	$out='';

	$args=array(
		'posts_per_page' => -1,
		'post_type' => 'portfolio',
		'orderby' => 'menu_order',
		'order' => 'ASC',
	);
	
	$sort=get_option('ompf_portfolio_sort');
	if($sort == 'date_asc') {
		$args['orderby'] = 'date';
		$args['order'] = 'ASC';
	} elseif($sort == 'date_desc') {
		$args['orderby'] = 'date';
		$args['order'] = 'DESC';
	}
	
	if($ids) {
		$args['post__in']=explode(',',$ids);
		$args['orderby']='post__in';		
	} else {
		$count=intval($count);
		$category=intval($category);
	
		$args['posts_per_page']=$count;
		if($category > 0) {
			$args['tax_query']=array(
				array('taxonomy'=>'portfolio-type', 'terms' => $category),
			);
		}
	}
	
	if($randomize) {
		$args['orderby']='rand';
	}

	$original_query = $wp_query;
	$wp_query = null;
	$wp_query = new WP_Query($args);
	
	ob_start();
			
	$uberwrapper_classes=array('ompf-portfolio-wrapper');
	$uberwrapper_classes=apply_filters('ompf_portfolio_sc_wrapper_classes', $uberwrapper_classes);
	
	$wrapper_classes=array('ompf-portfolio', 'ompf-sc-portfolio');
	if($widget_mode)
		$wrapper_classes[]='ompf-widget-mode';
	$wrapper_classes[]='ompf-layout-fixed';
	$wrapper_classes[]='ompf-size-'.$size;
	$wrapper_classes[]='ompf-preview-layout-full';
	$wrapper_classes=apply_filters('ompf_portfolio_sc_classes', $wrapper_classes);	
		
	$tmp = '
	<div class="'. implode(' ',$uberwrapper_classes) .'">
		<div class="'. implode(' ',$wrapper_classes) .'"'.($GLOBALS['omPortfolioPlugin']['config']['fit_thumbnails_height']?' data-fit-height="true"':'').'>
	';
	$tmp=apply_filters('ompf_portfolio_sc_header', $tmp);
	echo $tmp;
			
	if(isset($GLOBALS['omPortfolioPlugin']['config']['thumbnail_sizes'][$size]['width']))
		$thumb_width=$GLOBALS['omPortfolioPlugin']['config']['thumbnail_sizes'][$size]['width'];
	else
		$thumb_width=300;
	
	$thumb_height=round($thumb_width/$ratio);
	
	$i=1;
	
	while ( have_posts() ) {
		the_post(); 
		
		$item_preview_layout=$layout;
			
		$link=get_post_meta($post->ID, 'ompf_portfolio_custom_link', true);
		if(!$link)
			$link=get_permalink();
		elseif($link == 'none')
			$link=false;
			
		$img=false;
		if ( has_post_thumbnail() ) {
			$img = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full');
			if($img) {
				$img=omaq_resize($img[0],$thumb_width,$thumb_height,true,true);
			}
		}
		
		$item_classes=array(
			'ompf-portfolio-thumb',
			'ompf-size-'.$size,
		);
		
		$term_classes=ompf_item_term_classes($post->ID);
		if($term_classes)
			$item_classes[]=$term_classes;
			
		if($link) {
			$item_classes[]='ompf-with-link';
		} else {
			$item_classes[]='ompf-no-link';
		}
		
		if(has_filter('ompf_portfolio_layout_sc_item')) {
			
			echo apply_filters('ompf_portfolio_layout_sc_item', array(
				'post' => $post,
				'item_classes' => $item_classes,
				'item_preview_layout' => $item_preview_layout,
				'ratio' => $ratio,
				'size' => $size,
				'link' => $link,
				'img' => $img,
			));
			
		} else {
			?>
			<div class="<?php echo implode(' ',$item_classes) ?>" id="post-<?php the_ID(); ?>">
				<a<?php if($link) echo ' href="'.$link.'"'; ?>>
					<span class="ompf-pic-wrapper">
						<span class="ompf-pic" style="padding-top:<?php echo (1/$ratio * 100) ?>%">
							<span class="ompf-pic-inner">
								<?php
									if($img) {
										if($GLOBALS['omPortfolioPlugin']['config']['enable_lazyload_markup'])
											echo '<img src="'.$GLOBALS['omPortfolioPlugin']['config']['lazyload_placeholder'].'" data-original="'.$img.'" class="lazyload" alt="'.esc_attr($post->post_title).'" />';
										else
											echo '<img src="'.$img.'" alt="'.esc_attr($post->post_title).'" />';
									} 
								?>
							</span>
						</span>
					</span>
					<?php if($item_preview_layout != 'thumbnail') { ?>
					<span class="ompf-desc-wrapper">
						<span class="ompf-desc">
							<span class="ompf-title"><?php the_title(); ?></span>
							<?php if ($item_preview_layout == 'full' && $text=get_post_meta($post->ID, 'ompf_portfolio_short_desc', true)) { ?><span class="ompf-text"><?php echo $text ?></span><?php } ?>
						</span>
					</span>
					<?php } ?>
				</a>
			</div>
			<?php
		}
		
		if(($i % $per_row) == 0)
			echo '<div class="ompf-clear"></div>';
		$i++;
	}
	
	$tmp = '
			<div class="ompf-clear"></div>
		</div>	
	</div>
	';
	$tmp=apply_filters('ompf_portfolio_sc_footer', $tmp);
	echo $tmp;

	$out .= ob_get_contents();
	ob_end_clean();
	
	$wp_query = null;
	$wp_query = $original_query;	
	wp_reset_postdata();
		
	return $out;
}
add_shortcode('portfolio', 'ompf_sc_portfolio');
