<?php

/**
 * Include Styles & Scripts
 */

function ompf_enqueue_scripts() {
	
	$min_postfix='';
	if($GLOBALS['omPortfolioPlugin']['config']['include_min_scripts']) {
		$min_postfix='.min';
	}
	
	if($GLOBALS['omPortfolioPlugin']['config']['include_front_css']){
		wp_enqueue_style('ompf-portfolio', $GLOBALS['omPortfolioPlugin']['path_url'].'assets/css/portfolio.css');
	}

	if($GLOBALS['omPortfolioPlugin']['config']['include_isotope_js']) {
		wp_enqueue_script('ompf-isotope', $GLOBALS['omPortfolioPlugin']['path_url'].'assets/js/jquery.isotope.om'.$min_postfix.'.js', array('jquery'), false, $GLOBALS['omPortfolioPlugin']['config']['scripts_in_footer']);
	}
	
	if($GLOBALS['omPortfolioPlugin']['config']['include_front_js']) {
		wp_enqueue_script('jquery');
		wp_enqueue_script('ompf-portfolio', $GLOBALS['omPortfolioPlugin']['path_url'].'assets/js/portfolio'.$min_postfix.'.js', array('jquery'), false, $GLOBALS['omPortfolioPlugin']['config']['scripts_in_footer']);
	}
	
	if($GLOBALS['omPortfolioPlugin']['config']['responsive_mode']) {
		if(is_array($GLOBALS['omPortfolioPlugin']['config']['responsive_bounds'])) {
			foreach($GLOBALS['omPortfolioPlugin']['config']['responsive_bounds'] as $k=>$v) {
				if(!isset($v['from']))
					$v['from']=false;
				if(!isset($v['to']))
					$v['to']=false;
				if($v['from'] || $v['to'])
					wp_enqueue_style('omsc-portfolio-'.$k, $GLOBALS['omPortfolioPlugin']['path_url'].'assets/css/portfolio-'.$k.'.css', array(), false, 'screen'.($v['from']?' and (min-width: '.$v['from'].'px)':'').($v['to']?' and (max-width: '.$v['to'].'px)':''));
			}
		}
	}

}
add_action('wp_enqueue_scripts', 'ompf_enqueue_scripts');

/**
 * Append Portfolio block to the page
 */

function ompf_init_append_portfolio_content() {
	
	if( ! $GLOBALS['omPortfolioPlugin']['config']['theme_supplies_page_template'] ) {
		add_filter('the_content', 'ompf_append_portfolio_content');
	}
	
}
add_action('init', 'ompf_init_append_portfolio_content');

function ompf_append_portfolio_content($content) {
	if(isset($GLOBALS['post']) && $GLOBALS['post']->ID) {
		$portfolio_display=get_post_meta($GLOBALS['post']->ID, 'ompf_portfolio_display', true);
		if($portfolio_display) {
			$content .= ompf_the_content();
		}
	}
	
	return $content;
}

/**
 * Portfolio page content
 */

function ompf_the_content($portfolio_post_id = false) {
	
	global $wp_query, $post;
	
	if(!$portfolio_post_id)
		$portfolio_post_id=$GLOBALS['post']->ID;
	
	ob_start();
	
	include $GLOBALS['omPortfolioPlugin']['path'] . 'includes/portfolio.php';
	
	return ob_get_clean();

}