<?php

function ompf_portfolio_archive_item_the_content( $content ) {
	
	if(is_tax('portfolio-type')) {
		
		global $post;
		
		ob_start();
		include $GLOBALS['omPortfolioPlugin']['path']. 'includes/portfolio-archive-item.php';
		$content = ob_get_clean();
		
	}
	
	return $content;
}

function ompf_init_portfolio_archive_item_the_content() {
	
	if( ! $GLOBALS['omPortfolioPlugin']['config']['theme_supplies_portfolio_archive_template'] ) {
		add_filter('the_content', 'ompf_portfolio_archive_item_the_content');
	}

}
add_action('init', 'ompf_init_portfolio_archive_item_the_content');

function ompf_portfolio_archive_posts_per_page($posts_per_page) {
	
	if(is_tax('portfolio-type')) {
		$pagination=intval(get_option('ompf_portfolio_per_page'));
		if($pagination) {
			$posts_per_page=$pagination;
		}
	}
	
	return $posts_per_page;
}
add_filter('pre_option_posts_per_page', 'ompf_portfolio_archive_posts_per_page');


function ompf_portfolio_archive_page($portfolio_root_page_id = false, $portfolio_root_cat_id = false) {
	
	global $post;
	
	if($portfolio_root_page_id) {

		$portfolio_category=false;
		if($portfolio_root_cat_id)
			$portfolio_category=$portfolio_root_cat_id;

		$portfolio_post_id=$portfolio_root_page_id;
		$pagination=true;

		if($portfolio_root_cat_id) {
			$tmp_q = new WP_Query(array(
				'post_type' => 'portfolio',
				'posts_per_page' => -1,
				'tax_query' => array(
					array(
						'taxonomy' => 'portfolio-type',
						'field' => 'term_id',
						'terms' => $portfolio_root_cat_id
					)
				),
			));
			$portfolio_count=$tmp_q->post_count;
		} else {
			$portfolio_count=wp_count_posts( 'portfolio');
			$portfolio_count=$portfolio_count->publish;
		}
		$all_link='<a href="'. get_permalink($portfolio_root_page_id). '"><span class="ompf-count">'. $portfolio_count .'</span>'. __('All', 'om_portfolio') .'</a>';
		
		$queried_object=get_queried_object();
		$category_selected_id=$queried_object->term_id;

		include $GLOBALS['omPortfolioPlugin']['path'] . 'includes/portfolio-categories.php';

		include $GLOBALS['omPortfolioPlugin']['path'] . 'includes/portfolio-content.php';

		echo ompf_pagination_links();
		
	} else {

		add_filter('the_content', 'ompf_portfolio_archive_item_the_content');
		if (have_posts()) {
			?>
        <div class="ompf-archive">
					<?php while (have_posts()) : the_post(); ?>
				    <?php the_content(); ?>
				  <?php endwhile; ?>
				</div>
			<?php
			echo ompf_pagination_links();
		}
		remove_filter('the_content', 'ompf_portfolio_archive_item_the_content');
		
	}
	
}