<?php

/*************************************************************************************
 *	Add MetaBox to Page edit page
 *************************************************************************************/

$ompf_page_meta_box=array (
	
	'portfolio' => array (
		'id' => 'ompf-page-meta-box-portfolio',
		'name' => __('Portfolio options', 'om_portfolio'),
		'fields' => array (
			'ompf_portfolio_display' => array (
				'name' => __('Display Portfolio on this page','om_portfolio'),
				'desc' => '',
				'id' => 'ompf_portfolio_display',
				'type' => 'select',
				'std' => '0',
				'options' => array(
					'0' => __('No', 'om_portfolio'),
					'1' => __('Yes', 'om_portfolio'),
				)
			),
			'ompf_portfolio_layout' => array (
				'name' => __('Portfolio layout','om_portfolio'),
				'desc' => '',
				'id' => 'ompf_portfolio_layout',
				'type' => 'select',
				'std' => 'fixed',
				'options' => array(
					'fixed' => __('Table view (fixed cells)', 'om_portfolio'),
					'masonry' => __('Masonry (usefull for images with different width/height ratio)', 'om_portfolio'),
				)
			),
			'ompf_portfolio_thumbs_size' => array (
				'name' => __('Thumbnail size','om_portfolio'),
				'desc' => '',
				'id' => 'ompf_portfolio_thumbs_size',
				'type' => 'select',
				'std' => 'medium',
				'options' => array(
					'xsmall' => __('X-Small','om_portfolio'),
					'small' => __('Small','om_portfolio'),
					'medium' => __('Medium','om_portfolio'),
					'large' => __('Large','om_portfolio'),
				)
			),
			'ompf_portfolio_fixed_ratio' => array (
				'name' => __('Thumbnail width/height ratio','om_portfolio'),
				'desc' => __('If fixed cells layout chosen above choose the ratio','om_portfolio'),
				'id' => 'ompf_portfolio_fixed_ratio',
				'type' => 'select',
				'std' => '1.5',
				'options' => array(
					'2' => '2:1',
					'1.77777777' => '16:9',
					'1.5' => '3:2',
					'1.33333333' => '4:3',
					'1' => '1:1',
					'0.75' => '3:4',
					'0.66666666' => '2:3',
					'0.5625' => '9:16',
					'0.5' => '1:2',
				)
			),
			'ompf_portfolio_preview_layout' => array (
				'name' => __('Preview layout','om_portfolio'),
				'desc' => '',
				'id' => 'ompf_portfolio_preview_layout',
				'type' => 'select',
				'std' => 'full',
				'options' => array(
					'full' => __('Display thumbnail/ title/ description','om_portfolio'),
					'full-hover' => __('Display thumbnail; title/ description on hover','om_portfolio'),
					'thumbnail' => __('Display only thumbnail','om_portfolio'),
				)
			),
			'ompf_portfolio_categories' => array (
				'name' => __('Choose the category to display','om_portfolio'),
				'desc' => __('You can create multiple portfolio pages and show different categories on the each page. If you want to display specific portfolio category firstly create it, then add child sub-categories for it and choose the root category here','om_portfolio'),
				'id' => 'ompf_portfolio_categories',
				'type' => 'portfolio_root_cats',
				'std' => ''
			),
		),
	),
	
);
 
function ompf_add_page_meta_box() {
	global $ompf_page_meta_box;

	if( $GLOBALS['omPortfolioPlugin']['config']['theme_supplies_page_template'] )	
		unset($ompf_page_meta_box['portfolio']['fields']['ompf_portfolio_display']);
			
	$ompf_page_meta_box=apply_filters('ompf_page_meta_box', $ompf_page_meta_box);
	
	ompfmb_add_meta_boxes($ompf_page_meta_box, 'page');
 
}
add_action('add_meta_boxes', 'ompf_add_page_meta_box');

/*************************************************************************************
 *	Save MetaBox data
 *************************************************************************************/

function ompf_save_page_metabox($post_id) {
	global $ompf_page_meta_box;
 
	ompfmb_save_metabox($post_id, $ompf_page_meta_box);

}
add_action('save_post', 'ompf_save_page_metabox');

/*************************************************************************************
 *	Load JS Scripts and Styles
 *************************************************************************************/
 
function ompf_page_meta_box_scripts($hook) {

	if( 'post.php' != $hook && 'post-new.php' != $hook )
		return;
			
	if( $GLOBALS['omPortfolioPlugin']['config']['theme_supplies_page_template'] )	
		wp_enqueue_script('ompf-admin-page-meta', $GLOBALS['omPortfolioPlugin']['path_url'] . 'assets/js/page-meta.js', array('jquery'));
}
add_action('admin_enqueue_scripts', 'ompf_page_meta_box_scripts');
