<?php

$ompf_portfolio_options=array(

	'portfolio_sort' => array(
		'name' => __('Portfolio sort type', 'om_portfolio'),
		'desc' => __('If custom sort chosen, porfolio items should be sorted in "Portfolio Sort" page', 'om_portfolio'),
		'id' =>  'ompf_portfolio_sort',
		'std' => 'custom',
		'options'=>array(
			'custom' => __('Custom','om_portfolio'),
			'date_desc' => __('by Date newer on the top','om_portfolio'),
			'date_asc' => __('by Date older on the top','om_portfolio'),
		),
		'type' => 'select',
	),

	'portfolio_prev_next' => array(
		'name' => __('Previous/next item links on single portfolio page', 'om_portfolio'),
		'desc' => '',
		'id' =>  'ompf_portfolio_prev_next',
		'std' => 'all',
		'options'=>array(
				'all' => __('Show Prev/next links on all portfolio items','om_portfolio'),
				'category' => __('Show Prev/next links on portfolio items only from the same category','om_portfolio'),
				'none' => __('Hide links','om_portfolio'),
		),
		'type' => 'select',
	),
		                    
	'portfolio_categories_sort' => array(
		'name' => __('Portfolio categories sort type', 'om_portfolio'),
		'desc' => '',
		'id' =>  'ompf_portfolio_categories_sort',
		'std' => 'name',
		'options'=>array(
			'name' => __('by Name','om_portfolio'),
			'count' => __('by Count of the posts','om_portfolio'),
			'slug' => __('by Slug','om_portfolio'),
		),
		'type' => 'select',
	),
		                    		                    
	'portfolio_per_page' => array(
		'name' => __('Portfolio pagination (items per page)', 'om_portfolio'),
		'desc' => __('If you have a huge number of portfolio items you can apply pagination. Please note, if you apply pagination an animation effect when sorting items by category does not work. If you do not want to apply pagination enter zero value.', 'om_portfolio').' <b>'.__('If you have 404 page error on single portfolio pages after changing pagination option, please, navigate to Settings-Permalinks and click "Save changes".', 'om_portfolio').'</b>',
		'id' =>  'ompf_portfolio_per_page',
		'std' => '0',
		'type' => 'text'
	),
		                    
	'pagination_notice' => array(
		"name" => '',
		'message'=> __('<b style="color:red">Important notice.</b> If you are using portfolio pagination and permalinks setting is not default, due to WordPress core particularity the "Custom portfolio URL directory" (see below) must differ from the root portfolio page URL slug. Otherwise you will get an 404 error on the root portfolio paginated pages.','om_portfolio'),
		"type" => "intro",
	),

	'portfolio_slug' => array(
		'name' => __('Custom portfolio URL directory', 'om_portfolio'),
		'desc' => __('when using custom permalinks wordpress mode you can change the "portfolio" key in URLs like website.com/portfolio/item-name/', 'om_portfolio'),
		'id' =>  'ompf_portfolio_slug',
		'std' => '',
		'type' => 'text'
	),

	'portfolio_cat_slug' => array(
		'name' => __('Custom portfolio category URL directory', 'om_portfolio'),
		'desc' => __('when using custom permalinks wordpress mode you can change the "portfolio-type" key in URLs like website.com/portfolio-type/category-name/', 'om_portfolio'),
		'id' =>  'ompf_portfolio_cat_slug',
		'std' => '',
		'type' => 'text',
	),

	'random_notice' => array(
		"name" => "",
		"message" => '<b style="font-size:130%">'.__('Random items on single page:','om_portfolio').'</b>',
		"type" => "intro"
	),
							
	'portfolio_single_show_random' => array(
		'name' => __('Show random portfolio items on single portfolio page', 'om_portfolio'),
		'desc' => '',
		'id' =>  'ompf_portfolio_single_show_random',
		'std' => '',
		'options' => array(
			'' => __('No','om_portfolio'),
			'xsmall' => __('X-Small size','om_portfolio'),
			'small' => __('Small size','om_portfolio'),
			'medium' => __('Medium size','om_portfolio'),
			'large' => __('Large size','om_portfolio'),
		),
		'type' => 'select',
	),
		                    
	'portfolio_single_random_ratio' => array(
		'name' => __('Random portfolio items thumbnail width/height ratio', 'om_portfolio'),
		'desc' => '',
		'id' =>  'ompf_portfolio_single_random_ratio',
		'std' => '1.5',
		'options' => array(
			'2' => '2:1',
			'1.77777777' => '16:9',
			'1.5' => '3:2',
			'1.33333333' => '4:3',
			'1' => '1:1',
			'0.75' => '3:4',
			'0.66666666' => '2:3',
			'0.5625' => '9:16',
			'0.5' => '1:2',
		),
		'type' => 'select'
	),

	'portfolio_random_title' => array(
		'name' => __('Title for random items', 'om_portfolio'),
		'desc' => '',
		'id' =>  'ompf_portfolio_random_title',
		'std' => __('Random Items','om_portfolio'),
		'type' => 'text',
	),
	
);

function ompf_portfolio_set_default_options() {
	global $ompf_portfolio_options;
	
	if( is_admin() && get_option('ompf_plugin_just_activated')) {
		delete_option('ompf_plugin_just_activated');

		foreach($ompf_portfolio_options as $option) {
			if(isset($option['id']) && isset($option['std'])) {
				$db_option = get_option($option['id']);
				if($db_option === false){
					update_option($option['id'], $option['std']);
				}
			}
		}
	}
}
add_action('admin_init','ompf_portfolio_set_default_options');

function ompf_portfolio_options_modify() {
	global $ompf_portfolio_options;

	$ompf_portfolio_options = apply_filters('ompf_portfolio_options', $ompf_portfolio_options);
		
}
add_action('admin_init', 'ompf_portfolio_options_modify');