jQuery(function($){

	if(jQuery().isotopeOm) {
		
		var $container=jQuery('#ompf-portfolio').not('.ompf-portfolio-random-items');
		if($container.length) {
	    var args={ 
		    itemSelector: '.ompf-isotope-item',
		    animationEngine: 'best-available',
		    itemClass: 'ompf-isotope-item',
		    hiddenClass: 'ompf-isotope-hidden',
		    containerClass: 'ompf-isotope',
		    resizable: true
		  };
		  
	    if($container.hasClass('ompf-layout-fixed')) {
	    	
	    	jQuery.extend(args, {
	    		layoutMode: 'fitRows',
			    itemPositionDataEnabled: true
			  });
			  if($container.data('fit-height') && $container.hasClass('ompf-preview-layout-full')) {
		    	jQuery.extend(args, {
				    beforeLayout: function( $elems ) {
				    	$elems.each(function(){
				    		var $desc=$(this).find('.ompf-desc-wrapper');
				    		if($desc.length)
				    			$desc.data('last-height',$desc.css('height'));
				    	})
				    	$elems.find('.ompf-desc-wrapper').css('height','auto');
				    },
						beforeAnimation: function( $elems, instance ) {
							
							var groups=[];
							var max_heights=[];
							var last_top=-1;
							var group_id=-1;
							$elems.each(function( index ){
								var pos=$(this).data('isotope-item-position');
								pos=pos.y;
									
								if(pos != last_top) {
									group_id++;
									groups[group_id]=[];
									max_heights[group_id]=0;
									last_top=pos;
								}
								groups[group_id].push(index);
								var h=$(this).find('.ompf-desc-wrapper').height();
								if(h > max_heights[group_id])
									max_heights[group_id]=h;
							});
							
							var i,j;
							for (i=0; i<groups.length; i++) {
								for(j=0; j<groups[i].length; j++) {
									var $el=$elems.eq(groups[i][j]).find('.ompf-desc-wrapper');
									var lh=$el.data('last-height');
									if(lh)
										$el.css('height',lh);
								 	$el.animate({height: max_heights[i]+'px'}, {duration: 600, queue: false});
								}
							}
						}
					});
				}
				
	    } else if($container.hasClass('ompf-layout-masonry')) {
	    	jQuery.extend(args, {
	    		layoutMode: 'masonry'
				});
	    }
		  
			var $links=jQuery('.ompf-isotope-sort').find('a');
      $links.click(function(){
      	if(jQuery(this).hasClass('ompf-active'))
      		return false;
        $links.removeClass('ompf-active');
        jQuery(this).addClass('ompf-active');

        var selector = jQuery(this).attr('href').split('#');
        selector=selector[1];

				args.filter='.ompf-'+selector;
        
        // enable transition effects
        $container.removeClass('no-transition');
        $container.isotopeOm(args);
        
        document.location.hash=selector;
        
        return false;
      });
      
      // remove transition effect on first load of the page
      $container.addClass('no-transition');

			$container.isotopeOm(args);

			if(document.location.hash) {
				$links.filter('[href$='+document.location.hash+']').click();
			}
			
			jQuery(window).bind('load',function(){
				// when webfonts loaded the container sizes could change
				$container.isotopeOm('reLayout');
			});
			
			$(window).smartresize(function(){
			  $container.isotopeOm('reLayout');
			});

    }
	}
	
	/**
	 * Responsive embed
	 */
 
	$('.ompf-responsive-embed').each(function(){
		var $obj=$(this).children(':first');
		if($obj.length) {
			var w=parseInt($obj.attr('width'));
			var h=parseInt($obj.attr('height'));
			if(!isNaN(w) && !isNaN(h) && w > 0 && h > 0) {
				var r=h/w;
				$(this).css('padding-bottom',(r*100)+'%');
			}
		}
	});
		

});