<?php
/*
Template Name: Sitemap
*/

om_custom_sidebar_setup($post->ID);
get_header();

$slider=om_get_page_slider(get_the_ID());
?>
	<?php om_tpl_header_slider($slider) ?>
	<?php om_tpl_page_title($post->ID, the_title('','',false)) ?>
	<div class="content">
		<div class="container">
			<div class="container-inner">
				
				<div class="content-column-content">
					
					<?php echo do_shortcode( get_option(OM_THEME_PREFIX . 'code_after_page_h1') ); ?>
					<article>
					<?php while (have_posts()) : the_post(); ?>
		
						<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
							<?php the_content(); ?>
							<div class="clear"></div>
						</div>
						
					<?php endwhile; ?>

	        <div class="sitemap">
	
						<div class="one-third">
	
						<h3><?php _e('Site Feeds','om_theme'); ?></h3>
						<ul>
							<li><a href="<?php bloginfo('rss2_url'); ?>"><?php _e('Main RSS Feed','om_theme'); ?></a></li>
							<li><a href="<?php bloginfo('comments_rss2_url'); ?>"><?php _e('Comments RSS Feed','om_theme'); ?></a></li>
						</ul>
						
						<?php $list=wp_list_pages('title_li=&echo=0'); ?>
						<?php if($list) : ?>
							<h3><?php _e('Pages','om_theme'); ?></h3>
							<ul>
								<?php echo $list ?>
							</ul>
						<?php endif; ?>
						
						</div>
						
						<div class="one-third">
	
							<?php $list=get_posts('numberposts=-1&orderby=title&order=ASC'); ?>
							<?php if(!empty($list)) : ?>
								<h3><?php _e('Posts','om_theme'); ?></h3>
								<ul>
									<?php
										foreach($list as $item) {
											echo '<li><a href="'. get_permalink($item->ID) .'">'.$item->post_title.'</a></li>';
										}
									?>
								</ul>
							<?php endif; ?>			
	
							<?php $list=wp_list_categories('title_li=&echo=0'); ?>
							<?php $list2=wp_list_categories('title_li=&taxonomy=portfolio-type&echo=0'); ?>
							<?php $list3=wp_list_categories('title_li=&taxonomy=product_cat&echo=0'); ?>
							<?php if($list || $list2 || $list3) : ?>
								<h3><?php _e('Categories','om_theme'); ?></h3>
								<ul>
									<?php if($list) : ?>
										<li>
											<?php _e('Blog','om_theme'); ?>
											<ul>
												<?php echo $list; ?>
											</ul>
										</li>
									<?php endif; ?>
									<?php if($list2) : ?>
										<li>
											<?php _e('Portfolio','om_theme'); ?>
											<ul>
												<?php echo $list2; ?>
											</ul>
										</li>
									<?php endif; ?>
									<?php if($list3) : ?>
										<li>
											<?php _e('Products','om_theme'); ?>
											<ul>
												<?php echo $list3; ?>
											</ul>
										</li>
									<?php endif; ?>
								</ul>
							<?php endif; ?>
		
							<?php
								$tags = get_terms( 'post_tag' );
								if( !empty($tags) ) {
									?>
									<h3><?php _e('Tags','om_theme'); ?></h3>
									<ul>
									<?php
									foreach( $tags as $tag ) {
										$url = esc_attr( get_tag_link( $tag->term_id ) );
										echo '<li><a href="' . $url . '">' . $tag->name . '</a></li>';
									}
									?>
									</ul>
									<?php
								}
							?>		
							
							<?php $list=wp_get_archives('type=monthly&echo=0'); ?>
							<?php if($list) : ?>
								<h3><?php _e('Monthly Archives','om_theme'); ?></h3>
								<ul>
									<?php echo $list ?>
								</ul>
							<?php endif; ?>
							
																
						</div>
						
						<div class="one-third last">
							
							<?php $list=get_posts('numberposts=-1&orderby=title&order=ASC&post_type=portfolio'); ?>
							<?php if(!empty($list)) : ?>
								<h3><?php _e('Portfolio','om_theme'); ?></h3>
								<ul>
									<?php
										foreach($list as $item) {
											echo '<li><a href="'. get_permalink($item->ID) .'">'.$item->post_title.'</a></li>';
										}
									?>
								</ul>
							<?php endif; ?>		
							
							<?php $list=get_posts('numberposts=-1&orderby=title&order=ASC&post_type=testimonials'); ?>
							<?php if(!empty($list)) : ?>
								<h3><?php _e('Testimonials','om_theme'); ?></h3>
								<ul>
									<?php
										foreach($list as $item) {
											echo '<li><a href="'. get_permalink($item->ID) .'">'.$item->post_title.'</a></li>';
										}
									?>
								</ul>
							<?php endif; ?>
							
						</div>		
						
						<div class="clear"></div>
						
					</div>					
					
					</article>
					<?php echo do_shortcode( get_option(OM_THEME_PREFIX . 'code_after_page_content') ); ?>
	
					<?php om_wp_link_pages();	?>
					
					<?php get_template_part( 'includes/comments' ); ?>
					
				</div>
								
				<?php get_sidebar(); ?>
				
				<div class="clear"></div>
				
			</div>
		</div>
	</div>
<?php get_footer();