<?php

	// if current category is subcategory, find out and store root category
	$portfolio_root_cat=false;
	if($wp_query->queried_object->parent) {
		$portfolio_root_cat=get_term($wp_query->queried_object->parent,'portfolio-type');
		while($portfolio_root_cat->parent)
			$portfolio_root_cat=get_term($portfolio_root_cat->parent,'portfolio-type');
	}

	// trying to find portfolio index page related to this portfolio category
	$in=array('0','');
	if($portfolio_root_cat) {
		$in[]=$portfolio_root_cat->term_id;
	} else {
		$in[]=$wp_query->queried_object->term_id;
	}
	$args = array(
		'post_type' => 'page',
		'posts_per_page' => 1,
		'meta_query' => array(
			array(
				'key' => '_wp_page_template',
				'value' => 'template-portfolio.php',
			),
			array(
				'key' => 'ompf_portfolio_categories',
				'value' => $in,
				'compare' => 'IN',
			),
		)
	);
	$tmp_q = new WP_Query($args);
	if($tmp_q->post_count)
		$portfolio_root_page=$tmp_q->posts[0];
	else
		$portfolio_root_page=false;
		
	$portfolio_root_page_id=false;
	if($portfolio_root_page)
		$portfolio_root_page_id=$portfolio_root_page->ID;
		
om_custom_sidebar_setup(false);
get_header();
?>
	<?php om_tpl_page_title($wp_query->queried_object->term_id, single_term_title('',false)) ?>
	
	<div class="content">
		<div class="container">
			<div class="container-inner">
				
				<div class="content-column-content">
					<?php
						
						echo term_description();

						if(function_exists('ompf_portfolio_archive_page')) {
							
							echo ompf_portfolio_archive_page($portfolio_root_page_id, ( $portfolio_root_cat ? $portfolio_root_cat->term_id : false ) );
							
						} else {
							echo '<p><i><b style="color:red">'.__('Please install and activate Olevmedia Portfolio plugin to display the portfolio content.','om_theme').'</b></i></p>';
						}

					?>

				</div>
				
				<?php //get_sidebar(); ?>
				
				<div class="clear"></div>
				
			</div>
		</div>
	</div>		
<?php get_footer();