<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
	<?php if(get_option(OM_THEME_PREFIX . 'responsive') == 'true') : ?><meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" /><?php endif; ?>
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?><link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>"><?php endif; ?>
	<!--[if lt IE 9]>
	<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/html5shiv.js"></script>
	<![endif]-->
	<?php wp_head(); ?>
</head>
<body <?php body_class( array( OM_THEME_SHORT_PREFIX .'theme', OM_THEME_PREFIX. 'theme' ) ) ?>>
<!--[if lt IE 8]><p class="chromeframe"><?php _e('You are using an <strong>outdated</strong> browser. Please, <a href="http://browsehappy.com/">upgrade to a different browser</a> or <a href="http://www.google.com/chromeframe/?redirect=true">install Google Chrome Frame</a> to experience this site.','om_theme'); ?></p><![endif]-->
	<div class="bg-overlay">
		<div class="container-wrapper">
			<?php $header_layout=get_option(OM_THEME_PREFIX . 'header_layout'); if(!$header_layout) $header_layout=1; ?>
			<header>
				<div class="header header-layout-<?php echo $header_layout ?>">
					<?php
						$wpml_selector=( get_option( OM_THEME_PREFIX . 'show_wpml_language_selector' ) == 'true' && defined('ICL_SITEPRESS_VERSION') );
						$header_social_icons = (get_option(OM_THEME_PREFIX . 'social_icons_header') == 'true') ? om_get_social_icons_html() : false;
					?>
					<?php if(get_option(OM_THEME_PREFIX . 'intro_text') || $header_social_icons || $wpml_selector) { ?>
						<div class="header-top">
							<div class="container">
								<div class="container-inner">
									<?php if( $wpml_selector ) { ?><div class="header-wpml-selector"><?php do_action('icl_language_selector'); ?><div class="clear"></div></div><?php } ?>
									<div class="header-intro-text">
										<?php echo get_option(OM_THEME_PREFIX . 'intro_text'); ?>
									</div>
									<?php if($header_social_icons) { ?>
										<div class="header-socials<?php if( $color = get_option( OM_THEME_PREFIX . 'social_icons_color_header') ) echo ' '.$color.'-social-icons' ?>">
											<?php echo $header_social_icons ?>
										</div>
									<?php } ?>
									<div class="clear"></div>
								</div>
							</div>
						</div>
					<?php } ?>
	
					<?php if ( has_nav_menu( 'secondary-menu' ) ) { ?>				
						<div class="header-secondary-menu">
							<div class="container">
								<div class="container-inner">
									<nav>
									<?php
										wp_nav_menu( array(
											'theme_location' => 'secondary-menu',
											'container' => false,
											'menu_class' => 'secondary-menu sf-menu clearfix'.(get_option(OM_THEME_PREFIX . 'show_dropdown_symbol')=='true'?' show-dropdown-symbol':'')
										) );
									?>
									</nav>
								</div>
							</div>
						</div>
					<?php } ?>

					<?php
						$logo='';	
						$logo_type=get_option(OM_THEME_PREFIX . 'site_logo_type');
						$logo_image=( $logo_type == 'image' ? get_option(OM_THEME_PREFIX . 'site_logo_image') : false );
						$logo_image_2x=( $logo_type == 'image' ? get_option(OM_THEME_PREFIX . 'site_logo_image_2x') : false );
						$logo_text=( $logo_type == 'text' ? get_option(OM_THEME_PREFIX . 'site_logo_text') : false );
						$logo_image_atts= ($logo_image ? getimagesize(om_http2local($logo_image)) : false );
						$logo_height=0;
					?>					
					<div class="header-mid logo-type-<?php echo $logo_type ?>">
					<?php
						// logo
						if(($logo_type == 'image' && $logo_image) || ($logo_type == 'text' && $logo_text)) {
							$logo .= '<div class="logo-box"'. ($logo_image_atts ? 'style="width:'.$logo_image_atts[0].'px"' : '' ).'>';
								if($logo_type == 'text') {
									$logo .= '<div class="logo-text"><a href="' . home_url() .'">'. $logo_text .'</a></div>';
								} else {
									if($logo_image_atts) {
										$logo_height=$logo_image_atts[1];
									}	else {
										$logo_image_atts[3]='style="max-height:25px"';
									}
									$logo .= '<div class="logo-image"><a href="' . home_url() .'">';
									if($logo_image_2x) {
										$logo .= '<img class="non-retina" src="'.$logo_image.'" alt="'.htmlspecialchars( get_bloginfo( 'name' ) ).'" '.(@$logo_image_atts[3]).' />';
										$logo .= '<img class="only-retina" src="'.$logo_image_2x.'" alt="'.htmlspecialchars( get_bloginfo( 'name' ) ).'" '.(@$logo_image_atts[3]).' />';
									} else {
										$logo .= '<img src="'.$logo_image.'" alt="'.htmlspecialchars( get_bloginfo( 'name' ) ).'" '.(@$logo_image_atts[3]).' />';
									}
									$logo .= '</a></div>';
								}
							$logo .= '</div>';
						}
						if($logo_height < 25)
							$logo_height=25;
						
						//menu
						$menu = wp_nav_menu( array(
							'theme_location' => 'primary-menu',
							'container' => false,
							'fallback_cb' => 'om_primary_menu_fallback',
							'menu_class' => 'primary-menu sf-menu clearfix'.(get_option(OM_THEME_PREFIX . 'show_dropdown_symbol')=='true'?' show-dropdown-symbol':''),
							'echo' => false,
						) );
						
						if(get_option(OM_THEME_PREFIX . 'show_header_search') == 'true') {
							$search='
								<div class="header-search">
									<a href="'. home_url() .'/?s=" class="search-popup-link"></a>
									<div class="search-popup">
										'.get_search_form(false).'
									</div>
								</div>
							';
						} else {
							$search='';
						}
						if($menu) {
							if($header_layout == 1 && $logo_height)
								$menu = '<div class="menu-box" style="line-height:'.$logo_height.'px"><nav>' . $menu . $search .'</nav></div>';
							else
								$menu = '<div class="menu-box"><nav>' . $menu . $search . '</nav></div>';
						}
						
						if($header_layout == 1) {
							?>
								<div class="header-logo-menu-wrapper menu-sticky-node">
									<div class="container-wrapper">
										<div class="header-logo-menu">
											<div class="container">
												<div class="container-inner">
													<div class="logo-menu-wrapper">
														<?php echo $logo ?>
														<?php echo $menu ?>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							<?php
						} else {
							if($logo) {
							?>
								<div class="header-logo">
									<div class="container">
										<div class="container-inner">
											<div class="logo-wrapper">
												<?php echo $logo ?>
											</div>
										</div>
									</div>
								</div>
							<?php
							}
							if($menu) {
							?>
								<div class="header-menu-wrapper menu-sticky-node">
									<div class="container-wrapper">
										<div class="header-menu">
											<div class="container">
												<div class="container-inner">
													<div class="menu-wrapper">
														<?php echo $menu ?>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							<?php
							}
						}
					?>
					</div>
					
					<div class="header-mobile-menu">
						<div class="container">
							<div class="container-inner">
								<div class="mobile-header-menu-wrapper">
									<div class="mobile-header-menu-control"> <?php _e('Menu', 'om_theme') ?></div>
									<div class="mobile-header-menu-container">
										<?php
												wp_nav_menu( array(
													'theme_location' => 'primary-menu',
													'container' => false,
													'fallback_cb' => 'om_primary_menu_fallback',
													'menu_class' => 'header-menu-mobile sf-menu clearfix'.(get_option(OM_THEME_PREFIX . 'show_dropdown_symbol')=='true'?' show-dropdown-symbol':''),
												) );
												if ( has_nav_menu( 'secondary-menu' ) ) {
													wp_nav_menu( array(
														'theme_location' => 'secondary-menu',
														'container' => false,
														'menu_class' => 'header-menu-mobile sf-menu clearfix'.(get_option(OM_THEME_PREFIX . 'show_dropdown_symbol')=='true'?' show-dropdown-symbol':'')
													) );
												}
												if(get_option(OM_THEME_PREFIX . 'show_header_search') == 'true') {
													get_search_form();
												}
										?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</header>
			
