<?php

if ( class_exists( 'WooCommerce' ) ) {

	add_theme_support( 'woocommerce' );
	
	/*************************************************************************************
	 *	Hooks
	 *************************************************************************************/
	 
	remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
	remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
	
	function om_wc_before_main_content() {
		echo '<div class="content-column-content">';
	}
	add_action('woocommerce_before_main_content', 'om_wc_before_main_content', 10);
	
	function om_wc_after_main_content() {
	  echo '</div>';
	}
	add_action('woocommerce_after_main_content', 'om_wc_after_main_content', 10);
	
	/* Page titles and breadcrumbs */
	
	function om_woocommerce_show_page_title($val) {
		return false;
	}
	add_filter('woocommerce_show_page_title','om_woocommerce_show_page_title');
	
	remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
	
	function om_woocommerce_breadcrumb_defaults($args) {
		
		$args['delimiter']=' / ';
		$args['wrap_before']='';
		$args['wrap_after']='';
		$args['home']='';
		$args['before']=get_option(OM_THEME_PREFIX . 'breadcrumbs_caption');
		
		return $args;
	}
	add_filter('woocommerce_breadcrumb_defaults', 'om_woocommerce_breadcrumb_defaults');
	
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
	function om_woocommerce_template_loop_product_thumbnail() {
		global $post;
	
		$size = 'shop_catalog';
		
		$thumb='';
	
		if ( has_post_thumbnail() )
			$thumb = get_the_post_thumbnail( $post->ID, $size );
		elseif ( wc_placeholder_img_src() )
			$thumb = wc_placeholder_img( $size );
			
		if($thumb)
			echo '<div class="wc-product-thumb-container"><div class="wc-product-thumb-inner">'.$thumb.'</div></div>';
	}
	add_action( 'woocommerce_before_shop_loop_item_title', 'om_woocommerce_template_loop_product_thumbnail', 10 );
	
	function om_woocommerce_enable_lightbox($val) {
		return 'false';
	}
	if(get_option( OM_THEME_PREFIX . 'prettyphoto_lightbox') == 'enabled')
		add_filter('pre_option_woocommerce_enable_lightbox', 'om_woocommerce_enable_lightbox');
	
	
	function om_get_product_search_form($s) {
		
		$s=str_replace('<form','<form class="woocommerce-search-widget"',$s);
		
		$s=preg_replace('#<label class="screen-reader-text" for="s">[\s\S]*?</label>#','',$s);
		$s=preg_replace('#<input type="submit"[^>]*?>#','',$s);
		
		return $s;
	}
	add_filter('get_product_search_form', 'om_get_product_search_form');
	
	
	/**
	 * Thumbnail sizes
	 */
	global $pagenow;
	if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' )
		add_action( 'init', 'om_woocommerce_image_dimensions', 1 );
	 
	function om_woocommerce_image_dimensions() {
		$catalog = array(
			'width' => '557',	// px
			'height'	=> '557',	// px
			'crop'	=> 1 // true
		);
		 
		$single = array(
			'width' => '557',	// px
			'height'	=> '557',	// px
			'crop'	=> 1 // true
		);
		 
		$thumbnail = array(
			'width' => '171',	// px
			'height'	=> '171',	// px
			'crop'	=> 1 // false
		);
		 
		// Image sizes
		update_option( 'shop_catalog_image_size', $catalog ); // Product category thumbs
		update_option( 'shop_single_image_size', $single ); // Single product image
		update_option( 'shop_thumbnail_image_size', $thumbnail ); // Image gallery thumbs
	}
	
	/*************************************************************************************
	 *	Product page meta
	 *************************************************************************************/
	 
	require_once (TEMPLATE_DIR . '/functions/woocommerce-meta.php');
	
}