<?php

if (!function_exists('om_get_options_template')) {
	
	function om_get_options_template($id_as_key=false) {

		// Set the Options Array
		$options = array();
		
		$options[] = array( "name" => __('General settings','om_theme'),
		                    "type" => "heading");

		$options[] = array( "name" => "",
							"message" => __('You can import demo content in a one click:','om_theme').' <a href="'.admin_url('tools.php?page=om_import_tool').'" class="button button-primary" style="text-shadow:none">'.__('Demo Content Import Tool &rarr;','om_theme').'</a>',
							"type" => "intro");


		$options[] = array( "name" => __('Site favicon','om_theme'),
					"desc" => __('Upload an *.ico file or 16px x 16px Png/Gif image that will for your website\'s favicon.','om_theme'),
					"id" => OM_THEME_PREFIX."favicon",
					"std" => "",
					"type" => "upload");

		$options[] = array( "name" => __('Intro text line','om_theme'),
					"desc" => '',
					"id" => OM_THEME_PREFIX."intro_text",
					"std" => "",
					"type" => "textarea",
					"rows" => 5);

		$options[] = array( "name" => __('Sub-footer text line','om_theme'),
					"desc" => '',
					"id" => OM_THEME_PREFIX."subfooter_text",
					"std" => "",
					"type" => "textarea",
					"rows" => 5);

		/*										
		$options[] = array( 'name' => __('Exclude featured image from post/portfolio item page galleries', 'om_theme'),
		                    'desc' => __('Check if you want to exclude image, which was chosen as featured image for post/portfolio item, from the post/portfolio item gallery on the single page', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'exclude_featured_image',
		                    'std' => '',
		                    'type' => 'checkbox');
		*/
		                    
		                    
		$options[] = array( 'name' => __('Use lazy load for images', 'om_theme'),
		                    'desc' => __('Check if you want to load images on scroll to the view area', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'lazyload',
		                    'std' => 'true',
		                    'type' => 'checkbox');

		$options[] = array( 'name' => __('Replace default WordPress Gallery with the Theme&#39;s custom gallery', 'om_theme'),
		                    'desc' => __('Check if you want the theme to replace standard WordPress gallery', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'do_replace_gallery',
		                    'std' => '',
		                    'type' => 'checkbox');
		                    
		$options[] = array( 'name' => __('Display search box in the header', 'om_theme'),
		                    'desc' => __('Check if you want to display search button in the header', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'show_header_search',
		                    'std' => '',
		                    'type' => 'checkbox');
		                    
		/////////////////////////////////////////////////////////////
		                    
		$options[] = array( "name" => __('Logo','om_theme'),
		                    "type" => "heading");

		$options[] = array( 'name' => __('Site logo type', 'om_theme'),
		                    'desc' => __('Choose what do you want to use as site logo: image or plain text.', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'site_logo_type',
		                    'std' => 'text',
		                    'options'=>array(
		                    	'text'=>__('Plain text', 'om_theme'),
		                    	'image'=>__('Image', 'om_theme'),
		                    	'none'=>__('No logo', 'om_theme'),
		                    ),
		                    'type' => 'radio');
		                    
		$options[] = array( "name" => __('Site logo text','om_theme'),
							"desc" => __('Specify logo text, if "Plain text" Logo used.','om_theme'),
							"id" => OM_THEME_PREFIX."site_logo_text",
							"std" => "Beep Theme",
							"type" => "text");

		$options[] = array( "name" => __('Site logo image','om_theme'),
							"desc" => __('Choose a logo for your theme, or specify the image address of your online logo (http://example.com/logo.png).','om_theme'),
							"id" => OM_THEME_PREFIX."site_logo_image",
							"std" => "",
							"type" => "upload");

		$options[] = array( "name" => __('Site logo image for retina displays (optional)','om_theme'),
							"desc" => __('Choose double sized image for retina displays for better quality','om_theme'),
							"id" => OM_THEME_PREFIX."site_logo_image_2x",
							"std" => "",
							"type" => "upload");

		/////////////////////////////////////////////////////////////
		
		$options[] = array( "name" => __('Layout','om_theme'),
		                    "type" => "heading");

		                    
		$options[] = array( 'name' => __('Activate responsive mode for mobile devices', 'om_theme'),
		                    'desc' => __('Check if you want your site to be fitted by width on mobile devices', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'responsive',
		                    'std' => 'true',
		                    'type' => 'checkbox');

		$options[] = array( 'name' => __('Overall layout', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'overall_layout',
		                    'std' => 'wide',
		                    'options'=>array(
		                    	'wide' => __('Wide','om_theme'),
		                    	'boxed' => __('Boxed','om_theme'),
		                    ),
		                    'type' => 'select2');

		$options[] = array( "name" => __('Header layout','om_theme'),
							"desc" => __('Select header layout.','om_theme'),
							"id" => OM_THEME_PREFIX."header_layout",
							"std" => "1",
							"type" => "images",
							"options" => array(
								'1' => TEMPLATE_DIR_URI . '/admin/images/header-1.png',
								'2' => TEMPLATE_DIR_URI . '/admin/images/header-2.png',
								'3' => TEMPLATE_DIR_URI . '/admin/images/header-3.png',
							)
						);
						
		$options[] = array( 'name' => __('Footer layout', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'footer_layout',
		                    'std' => '1v4-1v4-1v4-1v4',
		                    'options'=>array(
		                    	'1v4-1v4-1v4-1v4' => __('4 Columns 1/4 + 1/4 + 1/4 + 1/4', 'om_theme'),
		                    	'2v4-1v4-1v4' => __('3 Columns 2/4 + 1/4 + 1/4', 'om_theme'),
		                    	'1v4-1v4-2v4' => __('3 Columns 1/4 + 1/4 + 2/4', 'om_theme'),
		                    	'1v3-1v3-1v3' => __('3 Columns 1/3 + 1/3 + 1/3', 'om_theme'),
		                    	'2v3-1v3' => __('2 Columns 2/3 + 1/3', 'om_theme'),
		                    	'1v3-2v3' => __('2 Columns 1/3 + 2/3', 'om_theme'),
		                    	'1v2-1v2' => __('2 Columns 1/2 + 1/2', 'om_theme'),
		                    	'1v1' => __('1 Column', 'om_theme'),
		                    ),
		                    'type' => 'select2');
		                    		                    

		/////////////////////////////////////////////////////////////
		
		$options[] = array( "name" => __('Menu','om_theme'),
		                    "type" => "heading");		                    

		$options[] = array( 'name' => __('Menu position', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'menu_position',
		                    'std' => 'top',
		                    'options'=>array(
		                    	'top' => __('At the top, not fixed', 'om_theme'),
		                    	'top_fixed' => __('Fixed on top', 'om_theme'),
		                    ),
		                    'type' => 'select2');

		$options[] = array( 'name' => __('Display drop down symbol for menu items with sublevels', 'om_theme'),
		                    'desc' => __('Check if you want to display drop down symbol in primary menu for items which has sublevels', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'show_dropdown_symbol',
		                    'std' => 'true',
		                    'type' => 'checkbox');

		$options[] = array( 'name' => __('Highlight active menu item', 'om_theme'),
		                    'desc' => __('Check if you want to highlight active menu item of primary menu', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'menu_highlight_active',
		                    'std' => '',
		                    'type' => 'checkbox');
		                    
		////////////////////////////////////////////////////////////


		$options[] = array( "name" => __('Styling','om_theme'),
		                    "type" => "heading");
		                    
		$options[] = array( 'name' => '',
		                    'desc' => __('Apply custom styling by inline code (check this option if you have problems with styling because of styling file rewrite permissions)', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'use_inline_css',
		                    'std' => '',
		                    'type' => 'checkbox');

		$options[] = array( "name" => "",
							"message" => __('Style Presets:','om_theme'),
							"type" => "subheader");

		                    
		$options[] = array( 'name' => '',
		                    'desc' => __('Choose one of the preseted styles or create your own one', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'styling_presets',
		                    'std' => unserialize('a:12:{s:10:"Light Blue";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#2c80c9";s:31:"om_beep_header_background_color";s:7:"#ffffff";s:19:"om_beep_intro_color";s:7:"#a3a3a3";s:33:"om_beep_social_icons_color_header";s:4:"dark";s:24:"om_beep_menu_items_color";s:7:"#4d4d4d";s:30:"om_beep_menu_items_color_hover";s:7:"#000000";s:37:"om_beep_background_main_content_color";s:7:"#ffffff";s:23:"om_beep_main_text_color";s:7:"#666666";s:23:"om_beep_side_text_color";s:7:"#9c9c9c";s:31:"om_beep_background_footer_color";s:7:"#4c4c4c";s:27:"om_beep_footer_titles_color";s:7:"#e5e5e5";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#7c7c7c";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#f1f1f1";s:32:"om_beep_default_title_text_color";s:7:"#4d4d4d";}s:12:"Light Orange";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#e86320";s:31:"om_beep_header_background_color";s:7:"#ffffff";s:19:"om_beep_intro_color";s:7:"#a3a3a3";s:33:"om_beep_social_icons_color_header";s:4:"dark";s:24:"om_beep_menu_items_color";s:7:"#4d4d4d";s:30:"om_beep_menu_items_color_hover";s:7:"#000000";s:37:"om_beep_background_main_content_color";s:7:"#ffffff";s:23:"om_beep_main_text_color";s:7:"#666666";s:23:"om_beep_side_text_color";s:7:"#9c9c9c";s:31:"om_beep_background_footer_color";s:7:"#4c4c4c";s:27:"om_beep_footer_titles_color";s:7:"#e5e5e5";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#7c7c7c";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#f1f1f1";s:32:"om_beep_default_title_text_color";s:7:"#4d4d4d";}s:10:"Light Teal";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#1f99b7";s:31:"om_beep_header_background_color";s:7:"#ffffff";s:19:"om_beep_intro_color";s:7:"#a3a3a3";s:33:"om_beep_social_icons_color_header";s:4:"dark";s:24:"om_beep_menu_items_color";s:7:"#4d4d4d";s:30:"om_beep_menu_items_color_hover";s:7:"#000000";s:37:"om_beep_background_main_content_color";s:7:"#ffffff";s:23:"om_beep_main_text_color";s:7:"#666666";s:23:"om_beep_side_text_color";s:7:"#9c9c9c";s:31:"om_beep_background_footer_color";s:7:"#4c4c4c";s:27:"om_beep_footer_titles_color";s:7:"#e5e5e5";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#7c7c7c";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#f1f1f1";s:32:"om_beep_default_title_text_color";s:7:"#4d4d4d";}s:12:"Light Purple";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#c91480";s:31:"om_beep_header_background_color";s:7:"#ffffff";s:19:"om_beep_intro_color";s:7:"#a3a3a3";s:33:"om_beep_social_icons_color_header";s:4:"dark";s:24:"om_beep_menu_items_color";s:7:"#4d4d4d";s:30:"om_beep_menu_items_color_hover";s:7:"#000000";s:37:"om_beep_background_main_content_color";s:7:"#ffffff";s:23:"om_beep_main_text_color";s:7:"#666666";s:23:"om_beep_side_text_color";s:7:"#9c9c9c";s:31:"om_beep_background_footer_color";s:7:"#4c4c4c";s:27:"om_beep_footer_titles_color";s:7:"#e5e5e5";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#7c7c7c";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#f1f1f1";s:32:"om_beep_default_title_text_color";s:7:"#4d4d4d";}s:10:"Light Gray";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#6d6d6d";s:31:"om_beep_header_background_color";s:7:"#ffffff";s:19:"om_beep_intro_color";s:7:"#a3a3a3";s:33:"om_beep_social_icons_color_header";s:4:"dark";s:24:"om_beep_menu_items_color";s:7:"#4d4d4d";s:30:"om_beep_menu_items_color_hover";s:7:"#000000";s:37:"om_beep_background_main_content_color";s:7:"#ffffff";s:23:"om_beep_main_text_color";s:7:"#666666";s:23:"om_beep_side_text_color";s:7:"#9c9c9c";s:31:"om_beep_background_footer_color";s:7:"#4c4c4c";s:27:"om_beep_footer_titles_color";s:7:"#e5e5e5";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#7c7c7c";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#f1f1f1";s:32:"om_beep_default_title_text_color";s:7:"#4d4d4d";}s:11:"Light Brown";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#91650e";s:31:"om_beep_header_background_color";s:7:"#ffffff";s:19:"om_beep_intro_color";s:7:"#a3a3a3";s:33:"om_beep_social_icons_color_header";s:4:"dark";s:24:"om_beep_menu_items_color";s:7:"#4d4d4d";s:30:"om_beep_menu_items_color_hover";s:7:"#000000";s:37:"om_beep_background_main_content_color";s:7:"#ffffff";s:23:"om_beep_main_text_color";s:7:"#666666";s:23:"om_beep_side_text_color";s:7:"#9c9c9c";s:31:"om_beep_background_footer_color";s:7:"#4c4c4c";s:27:"om_beep_footer_titles_color";s:7:"#e5e5e5";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#7c7c7c";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#f1f1f1";s:32:"om_beep_default_title_text_color";s:7:"#4d4d4d";}s:15:"Light Dark Blue";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#064c89";s:31:"om_beep_header_background_color";s:7:"#ffffff";s:19:"om_beep_intro_color";s:7:"#a3a3a3";s:33:"om_beep_social_icons_color_header";s:4:"dark";s:24:"om_beep_menu_items_color";s:7:"#4d4d4d";s:30:"om_beep_menu_items_color_hover";s:7:"#000000";s:37:"om_beep_background_main_content_color";s:7:"#ffffff";s:23:"om_beep_main_text_color";s:7:"#666666";s:23:"om_beep_side_text_color";s:7:"#9c9c9c";s:31:"om_beep_background_footer_color";s:7:"#4c4c4c";s:27:"om_beep_footer_titles_color";s:7:"#e5e5e5";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#7c7c7c";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#f1f1f1";s:32:"om_beep_default_title_text_color";s:7:"#4d4d4d";}s:18:"Dark Grey + Orange";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#e87c35";s:31:"om_beep_header_background_color";s:7:"#565656";s:19:"om_beep_intro_color";s:7:"#b5b5b5";s:33:"om_beep_social_icons_color_header";s:5:"light";s:24:"om_beep_menu_items_color";s:7:"#d6d6d6";s:30:"om_beep_menu_items_color_hover";s:7:"#ffffff";s:37:"om_beep_background_main_content_color";s:7:"#565656";s:23:"om_beep_main_text_color";s:7:"#e2e2e2";s:23:"om_beep_side_text_color";s:7:"#bcbcbc";s:31:"om_beep_background_footer_color";s:7:"#3d3d3d";s:27:"om_beep_footer_titles_color";s:7:"#f7f7f7";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#a0a0a0";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#696969";s:32:"om_beep_default_title_text_color";s:7:"#dddddd";}s:13:"Black + Green";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#27ae61";s:31:"om_beep_header_background_color";s:7:"#333333";s:19:"om_beep_intro_color";s:7:"#b5b5b5";s:33:"om_beep_social_icons_color_header";s:5:"light";s:24:"om_beep_menu_items_color";s:7:"#d6d6d6";s:30:"om_beep_menu_items_color_hover";s:7:"#ffffff";s:37:"om_beep_background_main_content_color";s:7:"#3a3a3a";s:23:"om_beep_main_text_color";s:7:"#e2e2e2";s:23:"om_beep_side_text_color";s:7:"#bcbcbc";s:31:"om_beep_background_footer_color";s:7:"#4c4c4c";s:27:"om_beep_footer_titles_color";s:7:"#e5e5e5";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#7c7c7c";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#696969";s:32:"om_beep_default_title_text_color";s:7:"#dddddd";}s:13:"Blue + Orange";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#e29031";s:31:"om_beep_header_background_color";s:7:"#1f7bc1";s:19:"om_beep_intro_color";s:7:"#d3d3d3";s:33:"om_beep_social_icons_color_header";s:5:"light";s:24:"om_beep_menu_items_color";s:7:"#d6d6d6";s:30:"om_beep_menu_items_color_hover";s:7:"#ffffff";s:37:"om_beep_background_main_content_color";s:7:"#1f7bc1";s:23:"om_beep_main_text_color";s:7:"#ffffff";s:23:"om_beep_side_text_color";s:7:"#bcbcbc";s:31:"om_beep_background_footer_color";s:7:"#1f7bc1";s:27:"om_beep_footer_titles_color";s:7:"#ffffff";s:30:"om_beep_footer_main_text_color";s:7:"#e5e5e5";s:30:"om_beep_footer_side_text_color";s:7:"#a0a0a0";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#f1f1f1";s:32:"om_beep_default_title_text_color";s:7:"#4d4d4d";}s:11:"Light Green";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#27ae61";s:31:"om_beep_header_background_color";s:7:"#ffffff";s:19:"om_beep_intro_color";s:7:"#a3a3a3";s:33:"om_beep_social_icons_color_header";s:4:"dark";s:24:"om_beep_menu_items_color";s:7:"#4d4d4d";s:30:"om_beep_menu_items_color_hover";s:7:"#000000";s:37:"om_beep_background_main_content_color";s:7:"#ffffff";s:23:"om_beep_main_text_color";s:7:"#666666";s:23:"om_beep_side_text_color";s:7:"#9c9c9c";s:31:"om_beep_background_footer_color";s:7:"#4c4c4c";s:27:"om_beep_footer_titles_color";s:7:"#e5e5e5";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#7c7c7c";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#f1f1f1";s:32:"om_beep_default_title_text_color";s:7:"#4d4d4d";}s:26:"Light Orange + Dark header";a:24:{s:24:"om_beep_background_color";s:7:"#999999";s:22:"om_beep_background_img";s:4:"none";s:29:"om_beep_background_img_custom";s:0:"";s:22:"om_beep_background_pos";s:5:"cover";s:25:"om_beep_background_attach";s:5:"fixed";s:31:"om_beep_background_dots_overlay";N;s:26:"om_beep_background_dimming";s:1:"0";s:32:"om_beep_background_dimming_color";s:5:"black";s:24:"om_beep_hightlight_color";s:7:"#e86320";s:31:"om_beep_header_background_color";s:7:"#4c4c4c";s:19:"om_beep_intro_color";s:7:"#a0a0a0";s:33:"om_beep_social_icons_color_header";s:5:"light";s:24:"om_beep_menu_items_color";s:7:"#bfbfbf";s:30:"om_beep_menu_items_color_hover";s:7:"#e8e8e8";s:37:"om_beep_background_main_content_color";s:7:"#ffffff";s:23:"om_beep_main_text_color";s:7:"#666666";s:23:"om_beep_side_text_color";s:7:"#9c9c9c";s:31:"om_beep_background_footer_color";s:7:"#4c4c4c";s:27:"om_beep_footer_titles_color";s:7:"#e5e5e5";s:30:"om_beep_footer_main_text_color";s:7:"#a0a0a0";s:30:"om_beep_footer_side_text_color";s:7:"#7c7c7c";s:33:"om_beep_social_icons_color_footer";s:5:"light";s:30:"om_beep_default_title_bg_color";s:7:"#f1f1f1";s:32:"om_beep_default_title_text_color";s:7:"#4d4d4d";}}'),
		                    'options' => array(
		                    	OM_THEME_PREFIX . 'background_color',
		                    	OM_THEME_PREFIX . 'background_img',
		                    	OM_THEME_PREFIX . 'background_img_custom',
		                    	OM_THEME_PREFIX . 'background_pos',
		                    	OM_THEME_PREFIX . 'background_attach',
		                    	OM_THEME_PREFIX . 'background_dots_overlay',
		                    	OM_THEME_PREFIX . 'background_dimming',
		                    	OM_THEME_PREFIX . 'background_dimming_color',
		                    	OM_THEME_PREFIX . 'hightlight_color',
		                    	OM_THEME_PREFIX . 'header_background_color',
		                    	OM_THEME_PREFIX . 'intro_color',
		                    	OM_THEME_PREFIX . 'social_icons_color_header',
		                    	OM_THEME_PREFIX . 'menu_items_color',
		                    	OM_THEME_PREFIX . 'menu_items_color_hover',
		                    	OM_THEME_PREFIX . 'background_main_content_color',
		                    	OM_THEME_PREFIX . 'main_text_color',
		                    	OM_THEME_PREFIX . 'side_text_color',
		                    	OM_THEME_PREFIX . 'background_footer_color',
		                    	OM_THEME_PREFIX . 'footer_titles_color',
		                    	OM_THEME_PREFIX . 'footer_main_text_color',
		                    	OM_THEME_PREFIX . 'footer_side_text_color',
		                    	OM_THEME_PREFIX . 'social_icons_color_footer',
		                    	
		                    	OM_THEME_PREFIX . 'default_title_bg_color',
		                    	OM_THEME_PREFIX . 'default_title_text_color',
		                    ),
		                    'type' => 'styling_presets');		
		                    
		$options[] = array( "name" => "",
							"message" => __('Overall Background:','om_theme'),
							"type" => "subheader");
							
		$options[] = array( "name" => __('Background color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."background_color",
		                    "std" => "#4c4c4c",
		                    "type" => "color");
		                    
		$options[] = array( 'name' => __('Background pattern', 'om_theme'),
		                    'desc' => __('Choose one of the built-in background', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'background_img',
		                    'std' => 'none',
		                    'options'=>array(
		                    	'none' => 'none',
		                    	'bg-1.png' => 'Pattern #1',
		                    	'bg-2.jpg' => 'Pattern #2',
		                    	'bg-3.png' => 'Pattern #3',
		                    	'bg-4.png' => 'Pattern #4',
		                    	'bg-5.png' => 'Pattern #5',
		                    	'bg-6.png' => 'Pattern #6',
		                    	'bg-7.png' => 'Pattern #7',
		                    	'bg-8.png' => 'Pattern #8',
		                    	'bg-9.png' => 'Pattern #9',
		                    	'bg-10.png' => 'Pattern #10',
		                    	'bg-11.png' => 'Pattern #11',
		                    	'bg-12.png' => 'Pattern #12',
		                    	'bg-13.png' => 'Pattern #13',
		                    	'bg-14.png' => 'Pattern #14',
		                    	'bg-15.png' => 'Pattern #15',
		                    	'bg-16.png' => 'Pattern #16',
		                    	'bg-17.png' => 'Pattern #17',
		                    	'bg-18.png' => 'Pattern #18',
		                    	'bg-19.png' => 'Pattern #19',
		                    	'bg-20.png' => 'Pattern #20',
		                    	'bg-21.png' => 'Pattern #21',
		                    	'bg-22.png' => 'Pattern #22',
		                    	'bg-23.png' => 'Pattern #23',
		                    	'bg-24.png' => 'Pattern #24',
		                    	'bg-25.png' => 'Pattern #25',
		                    	'bg-26.png' => 'Pattern #26',
		                    	'bg-27.png' => 'Pattern #27',
		                    	'bg-28.png' => 'Pattern #28',
		                    	'bg-29.png' => 'Pattern #29',
		                    	'bg-30.png' => 'Pattern #30',
		                    ),
		                    'type' => 'select2');
		$mess='<a href="#" onclick="jQuery(\'#om_patterns_preview\').slideToggle();return false"><b>'.__('Background pattern preview','om_theme').' (+)</b></a><div id="om_patterns_preview" style="display:none">';
		for($i=1;$i<=30;$i++) {
			$mess.='<div style="width:70px;height:70px;background:url('.TEMPLATE_DIR_URI.'/img/bg/bg-'.$i.'.png);display:inline-block;margin:0 10px 10px 0;padding:5px;">Pattern #'.$i.'</div>';
		}
		$mess.='</div>';
		$options[] = array( "name" => "",
							"message" => $mess,
							"type" => "intro");
		                    
		$options[] = array( 'name' => __('Custom Background image', 'om_theme'),
		                    'desc' => __('Upload your background, or leave this field empty to choose one of the above dropdown', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'background_img_custom',
		                    'std' => '',
		                    'type' => 'upload');
		                    
		$options[] = array( 'name' => __('Custom Background position', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'background_pos',
		                    'std' => 'repeat',
		                    'options'=>array(
		                    	'repeat' => 'Repeat image',
		                    	'repeat_x_top' => 'Repeat-x image top',
		                    	'repeat_x_center' => 'Repeat-x image center',
		                    	'repeat_x_bottom' => 'Repeat-x image bottom',
		                    	'repeat_y_left' => 'Repeat-y image left',
		                    	'repeat_y_center' => 'Repeat-y image center',
		                    	'repeat_y_right' => 'Repeat-y image right',
		                    	'cover' => 'Cover (Full Screen)',
		                    	'no_repeat_left_top' => 'No-Repeat Left Top',
		                    	'no_repeat_top' => 'No-Repeat Top',
		                    	'no_repeat_right_top' => 'No-Repeat Right Top',
		                    	'no_repeat_right' => 'No-Repeat Right',
		                    	'no_repeat_right_bottom' => 'No-Repeat Right Bottom',
		                    	'no_repeat_bottom' => 'No-Repeat Bottom',
		                    	'no_repeat_left_bottom' => 'No-Repeat Left Bottom',
		                    	'no_repeat_left' => 'No-Repeat Left',
		                    ),
		                    'type' => 'select2');
		                    
		$options[] = array( 'name' => __('Background attachment', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'background_attach',
		                    'std' => 'fixed',
		                    'options'=>array(
		                    	'fixed' => 'Fixed',
		                    	'scroll' => 'Scroll',
		                    ),
		                    'type' => 'select2');
		                    
		$options[] = array( 'name' => __('Enable additional dots overlay layer', 'om_theme'),
		                    'desc' => __('Useful for full screen background images', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'background_dots_overlay',
		                    'std' => '',
		                    'type' => 'checkbox');
		                    
		$options[] = array( 'name' => __('Background image dimmer (percent)', 'om_theme'),
		                    'desc' => __('Value between 0 and 100 to dim background image. 0 - no dim, 100 - maximum dim', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'background_dimming',
		                    'std' => '0',
		                    'type' => 'text');

		$options[] = array( 'name' => __('Background image dimmer color', 'om_theme'),
		                    'desc' => __('Choose the dimming color', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'background_dimming_color',
		                    'std' => 'black',
		                    'options' => array(
		                    	'black'=>'Black',
		                    	'white'=>'White',
		                    ),
		                    'type' => 'select2');

		$options[] = array( "name" => "",
							"message" => __('Common:','om_theme'),
							"type" => "subheader");
							
		$options[] = array( "name" => __('Hightlight color', 'om_theme'),
		                    "desc" => 'For highlighted blocks, text, links, controls',
		                    "id" => OM_THEME_PREFIX."hightlight_color",
		                    "std" => "#27ae61",
		                    "type" => "color");
							
		$options[] = array( "name" => "",
							"message" => __('Header:','om_theme'),
							"type" => "subheader");

		$options[] = array( "name" => __('Header background color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."header_background_color",
		                    "std" => "#ffffff",
		                    "type" => "color");

		$options[] = array( "name" => __('Intro text color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."intro_color",
		                    "std" => "#a3a3a3",
		                    "type" => "color");
		                    
		$options[] = array( 'name' => __('Social Icons color in the header', 'om_theme'),
		                    'desc' => __('With light overall background use dark icons and vice versa.','om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'social_icons_color_header',
		                    'std' => 'dark',
		                    'options' => array(
		                    	'dark'=>__('Dark','om_theme'),
		                    	'light'=>__('Light','om_theme'),
		                    ),
		                    'type' => 'select2');
		                    
		$options[] = array( "name" => "",
							"message" => __('Header menu:','om_theme'),
							"type" => "subheader");

		$options[] = array( "name" => __('Menu items color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."menu_items_color",
		                    "std" => "#4d4d4d",
		                    "type" => "color");

		$options[] = array( "name" => __('Menu items color by hover', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."menu_items_color_hover",
		                    "std" => "#000000",
		                    "type" => "color");

/*
		$options[] = array( "name" => __('Menu items background color by hover', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."menu_items_background_color_hover",
		                    "std" => "#585858",
		                    "type" => "color");
*/
/*
		$options[] = array( "name" => __('Sub-menu items color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."menu_sub_items_color",
		                    "std" => "#c2c2c2",
		                    "type" => "color");
*/
/*
		$options[] = array( "name" => __('Sub-menu dividers color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."menu_items_divider_color",
		                    "std" => "#999999",
		                    "type" => "color");
*/		                    
		                    
		$options[] = array( "name" => "",
							"message" => __('Main Content:','om_theme'),
							"type" => "subheader");

		$options[] = array( "name" => __('Main content background color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."background_main_content_color",
		                    "std" => "#ffffff",
		                    "type" => "color");

		$options[] = array( "name" => __('Main text color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."main_text_color",
		                    "std" => "#666666",
		                    "type" => "color");
		                    
		$options[] = array( "name" => __('Side text color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."side_text_color",
		                    "std" => "#9c9c9c",
		                    "type" => "color");

/*		                    
		$options[] = array( "name" => __('Side text color (less inportant information)', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."side_text_color2",
		                    "std" => "#dedede",
		                    "type" => "color");
*/

/*
		$options[] = array( 'name' => __('Main content panes background transparency', 'om_theme'),
		                    'desc' => __('Value between 0 and 100. 0 - opaque, 100 - transparent', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'background_main_content_opacity',
		                    'std' => '0',
		                    'type' => 'text');
*/

/*		                    
		$options[] = array( "name" => '',
		                    "desc" => __('Check this option if you chose dark background for content panes (needed for adjusting few blocks)', 'om_theme'),
		                    "id" => OM_THEME_PREFIX."content_panes_dark_bg",
		                    "std" => "",
		                    "type" => "checkbox");
*/
/*
		$options[] = array( "name" => __('Sidebar panes background color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."background_sidebar_color",
		                    "std" => "#ffffff",
		                    "type" => "color");

*/

		$options[] = array( "name" => "",
							"message" => __('Footer:','om_theme'),
							"type" => "subheader");

		$options[] = array( "name" => __('Footer background color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."background_footer_color",
		                    "std" => "#4c4c4c",
		                    "type" => "color");
		                    
		$options[] = array( "name" => __('Footer titles color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."footer_titles_color",
		                    "std" => "#e5e5e5",
		                    "type" => "color");

		$options[] = array( "name" => __('Footer text color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."footer_main_text_color",
		                    "std" => "#a0a0a0",
		                    "type" => "color");

		                    
		$options[] = array( "name" => __('Footer side text color', 'om_theme'),
		                    "desc" => '',
		                    "id" => OM_THEME_PREFIX."footer_side_text_color",
		                    "std" => "#7c7c7c",
		                    "type" => "color");

/*		                    
		$options[] = array( "name" => __('Footer hightlight color', 'om_theme'),
		                    "desc" => 'For highlighted text, links, controls',
		                    "id" => OM_THEME_PREFIX."footer_hightlight_color",
		                    "std" => "#2bb08f",
		                    "type" => "color");
*/
		                    
		$options[] = array( 'name' => __('Social Icons color in the footer', 'om_theme'),
		                    'desc' => __('With light footer background use dark icons and vice versa.','om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'social_icons_color_footer',
		                    'std' => 'light',
		                    'options' => array(
		                    	'dark'=>__('Dark','om_theme'),
		                    	'light'=>__('Light','om_theme'),
		                    ),
		                    'type' => 'select2');

		////////////////////////////////////////////////////////////


		$options[] = array( "name" => __('Sliders','om_theme'),
		                    "type" => "heading");

		$options[] = array( "name" => "",
							"message" => __('LayerSlider','om_theme'),
							"type" => "subheader");
							
		if(isset($GLOBALS['lsPluginVersion']) || defined('LS_PLUGIN_VERSION')){
			$options[] = array( "name" => "",
								"message" => __('LayerSlider can be deactivated via <a href="plugins.php">plugins manager tool</a>.','om_theme'),
								"type" => "note");
		} else {
			$options[] = array( "name" => "",
								"message" => __('LayerSlider can be installed and activated via <a href="themes.php?page=install-required-plugins">theme plugins manager tool</a>.','om_theme'),
								"type" => "note");
		}
		                    
		$options[] = array( "name" => "",
							"message" => __('Revolution slider','om_theme'),
							"type" => "subheader");

		if(class_exists('RevSlider')){
			$options[] = array( "name" => "",
								"message" => __('Revolution slider can be deactivated via <a href="plugins.php">plugins manager tool</a>.','om_theme'),
								"type" => "note");
		} else {
			$options[] = array( "name" => "",
								"message" => __('Revolution slider can be installed and activated via <a href="themes.php?page=install-required-plugins">theme plugins manager tool</a>.','om_theme'),
								"type" => "note");
		}
		
		////////////////////////////////////////////////////////////


		$options[] = array( "name" => __('Fonts','om_theme'),
		                    "type" => "heading");
		                    		                    
/*							
		$options[] = array( "name" => __('Uppercase', 'om_theme'),
		                    "desc" => __('Use uppercase for titles and some blocks', 'om_theme'),
		                    "id" => OM_THEME_PREFIX."titles_uppercase",
		                    "std" => "true",
		                    "type" => "checkbox");
*/
									                    
		$options[] = array( 'name' => __('Base font', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'base_font',
		                    'std' => array(
		                    	'type'=>'standard',
		                    	'standard'=>array('family'=>'Arial'),
		                    ),
		                    'options'=>array(
		                    	'Arial' => 'Arial',
		                    	'Times New Roman' => 'Times New Roman',
		                    	'Verdana' => 'Verdana',
		                    	'Tahoma' => 'Tahoma',
		                    	'Courier' => 'Courier',
		                    	'Courier New' => 'Courier New',
		                    	'Georgia' => 'Georgia',
		                    	'Impact' => 'Impact',
		                    	'Lucida Console' => 'Lucida Console',
		                    	'Trebuchet MS' => 'Trebuchet MS',
		                    ),
		                    'type' => 'font');
		                    
		$options[] = array( 'name' => __('Highlight font', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'sec_font',
		                    'std' => array(
		                    	'type'=>'google',
		                    	'google'=>array('family'=>'Open Sans'),
		                    ),
		                    'options'=>array(
		                    	'Arial' => 'Arial',
		                    	'Times New Roman' => 'Times New Roman',
		                    	'Verdana' => 'Verdana',
		                    	'Tahoma' => 'Tahoma',
		                    	'Courier' => 'Courier',
		                    	'Courier New' => 'Courier New',
		                    	'Georgia' => 'Georgia',
		                    	'Impact' => 'Impact',
		                    	'Lucida Console' => 'Lucida Console',
		                    	'Trebuchet MS' => 'Trebuchet MS',
		                    ),
		                    'type' => 'font');

		$tmp=array();
		for($i=80;$i<=160;$i++)
			$tmp[$i]=$i.'%';
		$options[] = array( 'name' => __('Font scaling', 'om_theme'),
		                    'desc' => __('You can scale all font sizes in the theme by this selector', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'font_scale',
		                    'std' => '100',
		                    'options' => $tmp,
		                    'type' => 'select2');
		unset($tmp);
		
		$tmp=array();
		for($i=1;$i<3.01;$i+=0.05)
			$tmp[]=sprintf('%01.2f',$i);
		$options[] = array( 'name' => __('Text Line Height', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'line_height',
		                    'std' => '1.60',
		                    'options' => $tmp,
		                    'type' => 'select');
		unset($tmp);
														                    
		////////////////////////////////////////////////////////////
		
		$options[] = array( "name" => __('Comments','om_theme'),
		                    "type" => "heading");

		$options[] = array( 'name' => __('Hide comments block on pages', 'om_theme'),
		                    'desc' => __('Check if you want to hide comments block on single pages. To hide comments on post pages and portfolio - see sections "Post options" and "Portfolio options"', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'hide_comments_page',
		                    'std' => '',
		                    'type' => 'checkbox');

		$options[] = array( 'name' => __('Hide comments block on the post pages', 'om_theme'),
		                    'desc' => __('Check if you want to hide comments block on the post pages.', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'hide_comments_post',
		                    'std' => '',
		                    'type' => 'checkbox');
		                    
		if(isset($GLOBALS['omPortfolioPlugin'])) {
			$options[] = array( 'name' => __('Hide comments block on the portfolio pages', 'om_theme'),
			                    'desc' => __('Check if you want to hide comments block on the portfolio pages.', 'om_theme'),
			                    'id' =>  OM_THEME_PREFIX . 'hide_comments_portfolio',
			                    'std' => '',
			                    'type' => 'checkbox');
		}

		$options[] = array( "name" => "",
							"message" => __('Facebook comments','om_theme'),
							"type" => "subheader");
									                    
		$options[] = array( 'name' => __('Moderator Facebook user ID', 'om_theme'),
		                    'desc' => __('The easiest way to moderate comments - insert Facebook user ID who can moderate comments. To add multiple moderators, separate the uids by comma without spaces.', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'fb_comments_admin_id',
		                    'std' => '',
		                    'type' => 'text');

		$options[] = array( 'name' => __('Your Facebook application ID', 'om_theme'),
		                    'desc' => __('Second way to moderate comments - insert Facebook application ID. You will be able to moderate comments with Facebook Comment Moderation Tool <a href="http://developers.facebook.com/tools/comments" target="_blank">http://developers.facebook.com/tools/comments</a>', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'fb_comments_app_id',
		                    'std' => '',
		                    'type' => 'text');
		                    
		$options[] = array( 'name' => __('Number of posts to display by default', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'fb_comments_count',
		                    'std' => '2',
		                    'type' => 'text');
		                    
		$options[] = array( 'name' => __('Facebook comments color scheme', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'fb_comments_color',
		                    'std' => '',
		                    'options'=>array(
		                    	'' => 'Light',
		                    	'dark' => 'Dark',
		                    ),
		                    'type' => 'select2');

		$options[] = array( 'name' => __('Show Facebook comments on pages', 'om_theme'),
		                    'desc' => __('Check to show Facebook comments block on single pages', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'fb_comments_page',
		                    'std' => '',
		                    'type' => 'checkbox');

		$options[] = array( 'name' => __('Show Facebook comments on post pages', 'om_theme'),
		                    'desc' => __('Check to show Facebook comments block on single post pages', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'fb_comments_post',
		                    'std' => '',
		                    'type' => 'checkbox');

		if(isset($GLOBALS['omPortfolioPlugin'])) {
			$options[] = array( 'name' => __('Show Facebook comments on portfolio pages', 'om_theme'),
			                    'desc' => __('Check to show Facebook comments block on single portfolio pages', 'om_theme'),
			                    'id' =>  OM_THEME_PREFIX . 'fb_comments_portfolio',
			                    'std' => '',
			                    'type' => 'checkbox');
		}
		                    
		$options[] = array( 'name' => __('Position of Facebook comments', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'fb_comments_position',
		                    'std' => '',
		                    'options'=>array(
		                    	'' => 'Before Wordrpess Comments',
		                    	'after' => 'After Wordpress Comments',
		                    ),
		                    'type' => 'select2');

		////////////////////////////////////////////////////////////

		
		$options[] = array( "name" => __('Page titles','om_theme'),
		                    "type" => "heading");
		                    
		$options[] = array( "name" => "",
							"message" => __('You can set default page titles layout here. Also it\'s possible to set custom page title layout for a specific page when edit it.','om_theme'),
							"type" => "intro");
		
		$options[] = array ( "name" => __('Page Title Layout','om_theme'),
					"desc" => '',
					"id" => OM_THEME_PREFIX."default_page_title",
					"type" => "select2",
					"std" => 'standard',
					'options' => array(
						'standard' => __('Standard', 'om_theme'),
						'hide' => __('Hide', 'om_theme'),
						'color' => __('Custom background color', 'om_theme'),
						'image' => __('Custom background image', 'om_theme'),
						'parallax' => __('Predefined parallax effect', 'om_theme'),
					),
					'code' => '<script>
						jQuery(function($){
							$("#'.OM_THEME_PREFIX.'default_page_title").change(function(){
								$("#'.OM_THEME_PREFIX.'default_title_align").parents(".om-options-section").hide();
								$("#'.OM_THEME_PREFIX.'default_title_margins").parents(".om-options-section").hide();
								$("#'.OM_THEME_PREFIX.'default_title_bg_color").parents(".om-options-section").hide();
								$("#'.OM_THEME_PREFIX.'default_title_text_color").parents(".om-options-section").hide();
								$("#'.OM_THEME_PREFIX.'default_title_bg_img").parents(".om-options-section").hide();
								$("#'.OM_THEME_PREFIX.'default_title_bg_img_pos").parents(".om-options-section").hide();
								$("#'.OM_THEME_PREFIX.'default_title_bg_img_att").parents(".om-options-section").hide();
								$("#'.OM_THEME_PREFIX.'default_title_parallax").parents(".om-options-section").hide();
								
								if($(this).val() == "standard") {
									$("#'.OM_THEME_PREFIX.'default_title_align").parents(".om-options-section").show();
								} else if($(this).val() == "color") {
									$("#'.OM_THEME_PREFIX.'default_title_align").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_margins").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_bg_color").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_text_color").parents(".om-options-section").show();
								} else if($(this).val() == "image") {
									$("#'.OM_THEME_PREFIX.'default_title_align").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_bg_color").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_bg_img").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_bg_img_pos").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_bg_img_att").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_margins").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_text_color").parents(".om-options-section").show();
								} else if($(this).val() == "parallax") {
									$("#'.OM_THEME_PREFIX.'default_title_align").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_bg_color").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_margins").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_text_color").parents(".om-options-section").show();
									$("#'.OM_THEME_PREFIX.'default_title_parallax").parents(".om-options-section").show();
								}
							}).change();
						});
					</script>',
			);
			
		$options[] = array ( "name" => __('Title align','om_theme'),
					"desc" => '',
					"id" => OM_THEME_PREFIX."default_title_align",
					"type" => "select2",
					"std" => '',
					'options' => array(
						'' => __('Left', 'om_theme'),
						'center' => __('Center', 'om_theme'),
					),
			);
			
		$options[] = array ( "name" => __('Title Margins','om_theme'),
					"desc" => '',
					"id" => OM_THEME_PREFIX."default_title_margins",
					"type" => "select2",
					"std" => '',
					'options' => array(
						'' => __('Standard', 'om_theme'),
						'large' => __('Large', 'om_theme'),
						'xlarge' => __('X-Large', 'om_theme'),
					),
			);
			
		$options[] = array ( "name" => __('Title background color','om_theme'),
					"desc" => __('To automatically apply theme Hightlight color from Theme Options type "theme" or click "default"'),
					"id" => OM_THEME_PREFIX."default_title_bg_color",
					"type" => "color",
					"std" => 'theme',
			);
			
		$options[] = array ( "name" => __('Title text color','om_theme'),
					"desc" => __('To automatically apply theme Hightlight color from Theme Options type "theme"'),
					"id" => OM_THEME_PREFIX."default_title_text_color",
					"type" => "color",
					"std" => '#FFFFFF',
			);
			
		$options[] = array ( "name" => __('Title background image','om_theme'),
					"desc" => '',
					"id" => OM_THEME_PREFIX."default_title_bg_img",
					"type" => "upload",
					"std" => '',
					"library" => 'image',
			);
			
		$options[] = array ( "name" => __('Title background image position','om_theme'),
					"desc" => '',
					"id" => OM_THEME_PREFIX."default_title_bg_img_pos",
					"type" => "select2",
					"std" => '',
          'options'=>array(
          	'repeat' => 'Repeat image',
          	'repeat_x_top' => 'Repeat-x image top',
          	'repeat_x_center' => 'Repeat-x image center',
          	'repeat_x_bottom' => 'Repeat-x image bottom',
          	'repeat_y_left' => 'Repeat-y image left',
          	'repeat_y_center' => 'Repeat-y image center',
          	'repeat_y_right' => 'Repeat-y image right',
          	'cover' => 'Cover',
          	'no_repeat_center' => 'No-Repeat Center',
          	'no_repeat_left_top' => 'No-Repeat Left Top',
          	'no_repeat_top' => 'No-Repeat Top',
          	'no_repeat_right_top' => 'No-Repeat Right Top',
          	'no_repeat_right' => 'No-Repeat Right',
          	'no_repeat_right_bottom' => 'No-Repeat Right Bottom',
          	'no_repeat_bottom' => 'No-Repeat Bottom',
          	'no_repeat_left_bottom' => 'No-Repeat Left Bottom',
          	'no_repeat_left' => 'No-Repeat Left',
          ),
			);
			
		$options[] = array ( "name" => __('Title background image attachment','om_theme'),
					"desc" => '',
					"id" => OM_THEME_PREFIX."default_title_bg_img_att",
					"type" => "select2",
					"std" => 'scroll',
          'options'=>array(
          	'scroll' => __('Scroll','om_theme'),
          	'fixed' => __('Fixed','om_theme'),
          ),
			);
			
		$options[] = array ( "name" => __('Parallax effect','om_theme'),
					"desc" => '',
					"id" => OM_THEME_PREFIX."default_title_parallax",
					"type" => "select2",
					"std" => '',
					'options' => array(
						'' => __('Lines', 'om_theme'),
						'geometry' => __('Geometry', 'om_theme'),
						'circles' => __('Circles', 'om_theme'),
					),
			);

		                    		                    
		////////////////////////////////////////////////////////////

		
		$options[] = array( "name" => __('Blog options','om_theme'),
		                    "type" => "heading");
		                    
		$options[] = array( 'name' => __('Excerpt mode', 'om_theme'),
		                    'desc' => __('&lt;!--more--&gt; tag can be inserted with "Insert More Tag" button at the toolbar pane. Custom excerpt field can be enabled under "Screen options - Excerpt" when you edit the post','om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'blog_excerpt_mode',
		                    'std' => 'more',
		                    'options'=>array(
		                    	'more' => __('Excerpt separated by &lt;!--more--&gt; tag or set by custom excerpt field','om_theme'),
		                    	'auto' => __('Excerpt generated automatically if not set by custom excerpt field','om_theme'),
		                    ),
		                    'type' => 'select2');
		                    
		$options[] = array( 'name' => __('Auto excerpt length', 'om_theme'),
		                    'desc' => __('Specify the length of excerpt in number of words, if the automatically generated excerpt chosen above', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'blog_excerpt_length',
		                    'std' => '30',
		                    'type' => 'text');

		$options[] = array( 'name' => __('Hide post author', 'om_theme'),
		                    'desc' => __('If checked, if you want to hide post author', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'post_hide_author',
		                    'std' => '',
		                    'type' => 'checkbox');

		$options[] = array( 'name' => __('Hide post categories', 'om_theme'),
		                    'desc' => __('Check, if you want to hide categories for posts', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'post_hide_categories',
		                    'std' => '',
		                    'type' => 'checkbox');
		                    
		$options[] = array( 'name' => __('Hide post tags', 'om_theme'),
		                    'desc' => __('Check, if you want to hide tags for posts', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'post_hide_tags',
		                    'std' => '',
		                    'type' => 'checkbox');
		                    
		$options[] = array( 'name' => __('Hide post date', 'om_theme'),
		                    'desc' => __('Check, if you want to hide post date', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'post_hide_date',
		                    'std' => '',
		                    'type' => 'checkbox');

		$options[] = array( 'name' => __('Show featured image on the post page', 'om_theme'),
		                    'desc' => __('Check to show the featured image at the beginning of the post on the single post page', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'post_single_show_thumb',
		                    'std' => '',
		                    'type' => 'checkbox');
		                    
		$options[] = array( 'name' => __('Previous/next navigation links', 'om_theme'),
		                    'desc' => __('Show previous/next links on post pages', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'show_prev_next_post',
		                    'std' => '',
		                    'type' => 'checkbox');
		                    
		$options[] = array( 'name' => __('Pagination mode', 'om_theme'),
		                    'desc' => __('Choose the pagination mode for blog (number of posts per page can be set under "Settings - Reading")', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'blog_pagination',
		                    'std' => '',
		                    'options'=>array(
		                    	'' => __('Older/Newer links','om_theme'),
		                    	'pages' => __('Links to pages (1, 2, 3, ...)','om_theme'),
		                    ),
		                    'type' => 'select2');

		$options[] = array( "name" => "",
							"message" => __('Archive/Category Options','om_theme'),
							"type" => "subheader");

		$options[] = array( 'name' => __('Pull sidebar/slider settings for Archive/Category pages from page:', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'archive_category_page_settings',
		                    'std' => '',
		                    'type' => 'select-page');
		                    
		$options[] = array( "name" => "",
							"message" => __('Frontpage displays latest posts','om_theme'),
							"type" => "subheader");

		$options[] = array( 'name' => __('Pull sidebar/slider settings for Frontpage from page:', 'om_theme'),
		                    'desc' => __('Use this option if Frontpage displays latest posts','om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'front_page_settings',
		                    'std' => '',
		                    'type' => 'select-page');
		                    
		////////////////////////////////////////////////////////////

		$options[] = array( "name" => __('Lightbox','om_theme'),
		                    "type" => "heading");
		                    
		$options[] = array( 'name' => __('PrettyPhoto Lightbox', 'om_theme'),
		                    'desc' => __('Check to show navigation chain', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'prettyphoto_lightbox',
		                    'std' => 'enabled',
		                    'options'=>array(
													'enabled' => __('Use Lightbox for images and galleries', 'om_theme'),
													'disabled' => __('Disable Lightbox', 'om_theme'),
													'disabled_no_action' => __('Disable Lightbox and disable click on image in galleries', 'om_theme'),
		                    ),
		                    'type' => 'select2');

		$options[] = array( 'name' => '',
		                    'desc' => __('Show title', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'prettyphoto_show_title',
		                    'std' => 'true',
		                    'type' => 'checkbox');
		                    
		$options[] = array( 'name' => '',
		                    'desc' => __('Show social buttons', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'prettyphoto_social_tools',
		                    'std' => 'false',
		                    'type' => 'checkbox');

		$options[] = array( 'name' => '',
		                    'desc' => __('Overlay gallery on the fullscreen image on mouse over', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'prettyphoto_overlay_gallery',
		                    'std' => 'false',
		                    'type' => 'checkbox');
		                    		                    
		                    
		                    
		////////////////////////////////////////////////////////////

		$options[] = array( "name" => __('Breadcrumbs','om_theme'),
		                    "type" => "heading");
		                    
		$options[] = array( 'name' => __('Show breadcrumbs', 'om_theme'),
		                    'desc' => __('Check to show navigation chain', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'show_breadcrumbs',
		                    'std' => 'true',
		                    'type' => 'checkbox');

		$options[] = array( 'name' => __('Breadcrumbs caption', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'breadcrumbs_caption',
		                    'std' => '',
		                    'type' => 'text');

		$options[] = array( 'name' => __('Current page title', 'om_theme'),
		                    'desc' => __('Check to include current page title to breadcrumbs', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'breadcrumbs_show_current',
		                    'std' => '',
		                    'type' => 'checkbox');
		                    
	
		////////////////////////////////////////////////////////////
		

		$options[] = array( "name" => __('Sidebars','om_theme'),
		                    "type" => "heading");

		$options[] = array( "name" => __('Sidebar position','om_theme'),
							"desc" => __('Select sidebar alignment.','om_theme'),
							"id" => OM_THEME_PREFIX."sidebar_position",
							"std" => "right",
							"type" => "images",
							"options" => array(
								'right' => TEMPLATE_DIR_URI . '/admin/images/2cr.png',
								'left' => TEMPLATE_DIR_URI . '/admin/images/2cl.png'
							)
						);
						
		$options[] = array( "name" => "",
							"message" => __('You can set the number of available alternative sidebars, set them up at the "Appearance > Widgets" section and choose for every page one of them at the page settings.','om_theme'),
							"type" => "intro");
							
		$options[] = array( "name" => __('Number of alternative sidebars','om_theme'),
					"desc" => '',
					"id" => OM_THEME_PREFIX."sidebars_num",
					"std" => "3",
					"type" => "text");


		$options[] = array( "name" => __('Sidebar sliding','om_theme'),
							"desc" => __('Check to enable sidebar sliding up and down when it\'s height less than page content height.','om_theme'),
							"id" => OM_THEME_PREFIX."sidebar_sliding",
							"std" => "true",
							"type" => "checkbox",
						);
						
		$options[] = array( "name" => __('Sidebar delay before sliding','om_theme'),
					"desc" => __('Value in milliseconds','om_theme'),
					"id" => OM_THEME_PREFIX."sidebar_sliding_delay",
					"std" => "1200",
					"type" => "text");


					
		////////////////////////////////////////////////////////////

		$options[] = array( "name" => __('Social icons','om_theme'),
		                    "type" => "heading");

		$options[] = array( "name" => __('Social icons in the header','om_theme'),
							"desc" => __('Check to display social icons in the header.','om_theme'),
							"id" => OM_THEME_PREFIX . 'social_icons_header',
							"std" => "true",
							"type" => "checkbox",
						);

		$options[] = array( "name" => __('Social icons in the footer','om_theme'),
							"desc" => __('Check to display social icons in the footer.','om_theme'),
							"id" => OM_THEME_PREFIX . 'social_icons_footer',
							"std" => "true",
							"type" => "checkbox",
						);
								                    
		$options[] = array( "name" => '',
												"message" => __('Specify necessary links and icons will be shown in the header. Note, that link should begins with http://','om_theme'),
		                    "type" => "intro");

		$options[] = array( "name" => '',
												"message" => '<b>'.__('You can set order of icons for the front page <a href="options.php?page=social_icons_sort">here</a>','om_theme').'</b>',
		                    "type" => "note");

		
		$icons=om_social_icons_list();
		foreach($icons as $k=>$v) {
			$options[] = array( 'name' => $v.' '.__('link','om_theme'),
			                    'id' =>  OM_THEME_PREFIX . 'social_'.$k,
			                    'std' => '',
			                    'type' => 'text');
		}                    
		
					
		////////////////////////////////////////////////////////////

		                    
		$options[] = array( "name" => __('Extra code blocks, counters','om_theme'),
		                    "type" => "heading");
		                    
		$options[] = array( 'name' => __('Code block for custom CSS', 'om_theme'),
		                    'desc' => __('Here you can add you custom CSS classes', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'code_custom_css',
		                    'std' => '',
		                    'type' => 'textarea');
		                    
		$options[] = array( 'name' => __('Code block before &lt;/head&gt;', 'om_theme'),
		                    'desc' => __('Here you can add Google.Analytics code', 'om_theme'),
		                    'id' =>  OM_THEME_PREFIX . 'code_before_head',
		                    'std' => '',
		                    'type' => 'textarea');
		                    
		$options[] = array( 'name' => __('Code block before &lt;/body&gt;', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'code_before_body',
		                    'std' => '',
		                    'type' => 'textarea');
		                    
		$options[] = array( 'name' => __('Code block after page header (&lt;/H1&gt;)', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'code_after_page_h1',
		                    'std' => '',
		                    'type' => 'textarea');

		$options[] = array( 'name' => __('Code block after page content', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'code_after_page_content',
		                    'std' => '',
		                    'type' => 'textarea');
		                    
		$options[] = array( 'name' => __('Code block after post header (&lt;/H1&gt;) on the single page', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'code_after_post_h1',
		                    'std' => '',
		                    'type' => 'textarea');

		$options[] = array( 'name' => __('Code block after post content on the single page', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'code_after_post_content',
		                    'std' => '',
		                    'type' => 'textarea');

		if(isset($GLOBALS['omPortfolioPlugin'])) {		                    
			$options[] = array( 'name' => __('Code block after portfolio header (&lt;/H1&gt;) on the single page', 'om_theme'),
			                    'desc' => '',
			                    'id' =>  OM_THEME_PREFIX . 'code_after_portfolio_h1',
			                    'std' => '',
			                    'type' => 'textarea');
	
			$options[] = array( 'name' => __('Code block after portfolio content on the single page', 'om_theme'),
			                    'desc' => '',
			                    'id' =>  OM_THEME_PREFIX . 'code_after_portfolio_content',
			                    'std' => '',
			                    'type' => 'textarea');

			$options[] = array( 'name' => __('Code block after portfolio description on the single page', 'om_theme'),
			                    'desc' => '',
			                    'id' =>  OM_THEME_PREFIX . 'code_after_portfolio_description',
			                    'std' => '',
			                    'type' => 'textarea');
		}

		if(defined('ICL_SITEPRESS_VERSION')) {

			$options[] = array( "name" => __('WPML','om_theme'),
			                    "type" => "heading");
			                    
			$options[] = array( 'name' => '',
			                    'desc' => __('Show WPML language selector in the header', 'om_theme'),
			                    'id' =>  OM_THEME_PREFIX . 'show_wpml_language_selector',
			                    'std' => '',
			                    'type' => 'checkbox');
			                    
		}
			
		////////////////////////////////////////////////////////////


		$options[] = array( "name" => __('Theme updates','om_theme'),
		                    "type" => "heading");

		$options[] = array( "name" => "",
								"message" => __('If you want to receive notifications about new Theme versions in WordPress Dashboard, please, specify your ThemeForest(Envato) username and API key below.','om_theme'),
								"type" => "note");		                    
								
		$options[] = array( 'name' => __('Your ThemeForest(Envato) username', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'envato_username',
		                    'std' => '',
		                    'type' => 'text');
		                    
		$options[] = array( 'name' => __('Your ThemeForest(Envato) API key', 'om_theme'),
		                    'desc' => '',
		                    'id' =>  OM_THEME_PREFIX . 'envato_api',
		                    'std' => '',
		                    'type' => 'text');
		
		if($id_as_key) {
			$options_=array();
			foreach($options as $v) {
				if(isset($v['id'])) {
					$options_[$v['id']]=$v;
				}
			}
			$options=$options_;
		}
		
		return $options;
	}
}