<?php

if( !function_exists( 'om_include_fonts' ) ) {
	function om_include_fonts() {

		$charsets=array(
			'latin_ext',
			'arabic',
			'cyrillic',
			'cyrillic_ext',
			'devanagari',
			'greek',
			'greek_ext',
			'hebrew',
			'khmer',
			'telugu',
			'vietnamese',
		);
		
		$fonts=array();
		
		$base_font=get_option(OM_THEME_PREFIX . 'base_font');
		if(isset($base_font['type']) && $base_font['type'] == 'google' && isset($base_font['google']))
			$fonts[]=$base_font['google'];

		$sec_font=get_option(OM_THEME_PREFIX . 'sec_font');
		if(isset($sec_font['type']) && $sec_font['type'] == 'google' && isset($sec_font['google']))
			$fonts[]=$sec_font['google'];

		foreach($fonts as $arr) {
			
			$charsets_include=array();
			foreach($charsets as $charset) {
				if( isset($arr[$charset]) && $arr[$charset] ) {
					$charsets_include[]=str_replace('_','-',$charset);
				}
			}

			$subset='';			
			if(!empty($charsets_include)) {
				$subset='&subset=latin,'.implode(',',$charsets_include);
			}

			$weight_normal=400;
			if(isset($arr['weight_normal']))
				$weight_normal=$arr['weight_normal'];
			$weight_bold=700;
			if(isset($arr['weight_bold']))
				$weight_bold=$arr['weight_bold'];
			
			$family=urlencode($arr['family']).':'.$weight_normal.','.$weight_bold.$subset;
			wp_enqueue_style(sanitize_title($family), '//fonts.googleapis.com/css?family='.$family);

		}
	}
}
add_action('wp_enqueue_scripts', 'om_include_fonts');

if( !function_exists( 'om_theme_get_styling' ) ) {
	
	function om_theme_get_styling() {
		
		/**
		 * Fonts
		 */
		 
		ob_start();
		
		$base_font=get_option(OM_THEME_PREFIX . 'base_font');
		$sec_font=get_option(OM_THEME_PREFIX . 'sec_font');
		
		$base_font_f=@$base_font[@$base_font['type']]['family'];
		$sec_font_f=@$sec_font[@$sec_font['type']]['family'];
		
		$base_weight_normal=400;
		$base_weight_bold=700;
		if(@$base_font['type'] == 'google') {
			if(isset($base_font['google']['weight_normal']))
				$base_weight_normal=$base_font['google']['weight_normal'];
			if(isset($base_font['google']['weight_bold']))
				$base_weight_bold=$base_font['google']['weight_bold'];
		}
		$sec_weight_normal=400;
		$sec_weight_bold=700;
		if(@$sec_font['type'] == 'google') {
			if(isset($sec_font['google']['weight_normal']))
				$sec_weight_normal=$sec_font['google']['weight_normal'];
			if(isset($sec_font['google']['weight_bold']))
				$sec_weight_bold=$sec_font['google']['weight_bold'];
		}
		
		if($base_font_f) {
			echo '
				body,
				input,
				textarea,
				.blockquote-author,
				.omsc-blockquote-author
				{font-family:'.$base_font_f.'}';
				
			if($base_weight_normal != 400) {
				echo '
					body
					{font-weight:'.$base_weight_normal.'}';
			}
			if($base_weight_bold != 700) {
				echo '
					b, strong, dt,
					.logo-text,
					.comment-meta .author
					{font-weight:'.$base_weight_bold.'}';
			}
		}
		
		if($sec_font_f) {
			echo '
				h1,h2,h3,h4,h5,h6,
				.primary-menu,
				.sidebar-widget-title,
				.footer-widget-title,
				blockquote,
				.blockquote,
				.omsc-box-title,
				.ompf-portfolio-thumb .ompf-title,
				.omsc-pricing-title,
				.omsc-counter-title,
				.testimonial-text
				{font-family:'.$sec_font_f;
			if($sec_weight_normal != 400) {
				echo ';font-weight:'.$sec_weight_normal;
			}
			echo '}';
			
			if($sec_weight_bold != 700) {
				echo '
					h1,h2,h3,h4,h5,h6,
					.primary-menu > li > a,
					.footer-widget-title,
					.sidebar-widget-title,
					.omsc-box-title,
					.ompf-portfolio-thumb .ompf-title,
					.omsc-pricing-title
					{font-weight:'.$sec_weight_bold.'}';
			}
		}
		
		/* Font scale */
		
		$font_scale=intval(get_option(OM_THEME_PREFIX . 'font_scale'));
		if(!$font_scale)
			$font_scale=100;
		if($font_scale != 100) {
			$font_scale/=100;
			
			echo 'body{font-size:'.round(12*$font_scale).'px}';
		}
		
		$line_height=floatval(get_option(OM_THEME_PREFIX . 'line_height'));
		if($line_height) {
			echo '
				body {line-height:'.$line_height.'}
			';

			echo '
				h1,h2,h3,h4,h5,h6 {line-height:'.($line_height*0.85).'}
			';
			
			echo '
				a.more-link:before {width: '.$line_height.'em}
			';
			
			echo '
				a.more-link {
					-webkit-border-radius:'.($line_height/2).'em;
					-moz-border-radius:'.($line_height/2).'em;
					border-radius:'.($line_height/2).'em;
				}
			';
			
		}
			
		/**
		 * Overall Background
		 */ 
		 
		$bg_color=get_option(OM_THEME_PREFIX . 'background_color');
		$bg_img=get_option(OM_THEME_PREFIX . 'background_img');
		$bg_img_custom=get_option(OM_THEME_PREFIX . 'background_img_custom');
		$bg_pos=get_option(OM_THEME_PREFIX . 'background_pos');
		$attach=get_option(OM_THEME_PREFIX . 'background_attach');
	
		$style=array();
	
		if($bg_color)
			$style[]='background-color:'.$bg_color;
	
		if($bg_img_custom)
			$style[]='background-image:url('.$bg_img_custom.')';
		elseif($bg_img!='none' && $bg_img!='')
			$style[]='background-image:url('.TEMPLATE_DIR_URI.'/img/bg/'.$bg_img.')';
		
			
			
		if($bg_img_custom || $bg_img) {
			$style=array_merge($style,om_bg_img_pos_style($bg_pos));
			
			if($attach == 'fixed')
				$style[]='background-attachment:fixed';
			elseif($attach == 'scroll')
				$style[]='background-attachment:scroll';
		}
	
		if(!empty($style))
			$style=implode(';',$style);
		else
			$style='';
		
		echo 'body{'.$style.'}';


		if(get_option(OM_THEME_PREFIX . 'background_dots_overlay') == 'true')
			echo '.bg-overlay{background-image:url('.TEMPLATE_DIR_URI.'/img/bg-overlay.png);}';
			
		$dimming=intval(trim(get_option(OM_THEME_PREFIX . 'background_dimming')));
		if($dimming) {
			if($dimming > 100)
				$dimming=100;
			$dimming/=100;
			$dimming_color=get_option(OM_THEME_PREFIX . 'background_dimming_color');
			if($dimming_color == 'white')
				echo '.bg-overlay{background-color:rgba(255,255,255,'.$dimming.');} ';
			elseif($dimming_color == 'black')
				echo '.bg-overlay{background-color:rgba(0,0,0,'.$dimming.');} ';
		}
		
		/**
		 * Common
		 */
		 
		$hightlight_color=get_option(OM_THEME_PREFIX . 'hightlight_color');
		echo '
			.primary-menu > li > a:hover,
			.primary-menu-highlight-active .primary-menu > li.current-menu-item > a,
			.primary-menu > li.sfHover > a,
			.primary-menu > li > ul,
			.primary-menu ul a:hover,
			.primary-menu li.sfHover > a,
			.primary-menu-highlight-active .primary-menu ul li.current-menu-item > a,
			.header .search-popup,
			.header .header-mobile-menu #s,
			input[type=text]:focus,
			input[type=email]:focus,
			input[type=password]:focus,
			textarea:focus,
			#wp-calendar th,
			.omsc-style-border,
			.omsc-button,
			.omsc-infobox,
			.omsc-biginfobox,
			.omsc-box,
			.omsc-icon-style-border .omsc-box-icon,
			.omsc-icon.omsc-border-color-theme,
			.woocommerce #content input.button.alt, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce-page #content input.button.alt, .woocommerce-page #respond input#submit.alt, .woocommerce-page a.button.alt, .woocommerce-page button.button.alt, .woocommerce-page input.button.alt,
			.woocommerce #content table.cart a.remove, .woocommerce table.cart a.remove, .woocommerce-page #content table.cart a.remove, .woocommerce-page table.cart a.remove,
			.woocommerce #content input.button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce-page #content input.button:hover, .woocommerce-page #respond input#submit:hover, .woocommerce-page a.button:hover, .woocommerce-page button.button:hover, .woocommerce-page input.button:hover,
			.woocommerce .widget_layered_nav_filters ul li a, .woocommerce-page .widget_layered_nav_filters ul li a,
			.woocommerce .widget_layered_nav ul li.chosen a, .woocommerce-page .widget_layered_nav ul li.chosen a,
			.testimonials-block
			{border-color:'.$hightlight_color.'}';

		echo '
			.search-popup:before
			{border-bottom-color:'.$hightlight_color.'}';			

		echo '
			.omsc-pricing-column li.omsc-pricing-title
			{border-top-color:'.$hightlight_color.'}';				

		echo '
			.woocommerce span.onsale:after, .woocommerce-page span.onsale:after
			{border-top-color:'.$hightlight_color.';border-left-color:'.$hightlight_color.'}';

		echo '
			.woocommerce ul.products li.product .onsale:after, .woocommerce-page ul.products li.product .onsale:after
			{border-top-color:'.$hightlight_color.';border-right-color:'.$hightlight_color.'}';
						
		echo '
			.primary-menu ul a:hover,
			.primary-menu ul li.sfHover > a,
			.primary-menu-highlight-active .primary-menu ul li.current-menu-item > a,
			.page-title-wrapper.tpl-color,
			.page-title-wrapper.tpl-image,
			.page-title-wrapper.tpl-parallax,
			#wp-calendar th,
			input[type=button],
			input[type=submit],
			input[type=reset],
			#wp-calendar caption,
			.navigation-prev a:before,
			.navigation-next a:after,
			.navigation-prev a:hover,
			.navigation-next a:hover,
			.navigation-pages a:hover span,
			.navigation-pages-inner > span.current,
			a.more-link:before,
			.mejs-container .mejs-controls,
			.om_theme .ompf-portfolio-categories li a:hover .ompf-count,
			.om_theme .ompf-portfolio-categories li a.ompf-active,
			.om_theme .ompf-portfolio-categories li a.ompf-active .ompf-count,
			.om_theme .ompf-portfolio-categories li a:before,
			.omsc-button,
			.omsc-dropcap.omsc-bgcolor-theme,
			.omsc-infobox,
			.omsc-biginfobox,
			.omsc-marker,
			.om_theme .omsc-pricing-column li.omsc-pricing-price,
			.om_theme .content .omsc-pricing-column li.omsc-pricing-price,
			.omsc-custom-table.omsc-style-3 th, .omsc-custom-table-wrapper.omsc-style-3 table th,
			.omsc-box.omsc-bg-color-theme,
			.omsc-box.omsc-icon-style-bg .omsc-box-icon,
			.omsc-icon.omsc-bg-color-theme,
			.om_theme .ompf-preview-layout-full .ompf-portfolio-thumb a:hover,
			.sidebar-widget.widget_nav_menu .menu li a:hover,
			.sidebar-widget.widget_nav_menu .menu li.current-menu-item a,
			.woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce-page .widget_price_filter .ui-slider .ui-slider-range,
			.woocommerce #content table.cart a.remove:hover, .woocommerce table.cart a.remove:hover, .woocommerce-page #content table.cart a.remove:hover, .woocommerce-page table.cart a.remove:hover,
			.woocommerce .widget_layered_nav_filters ul li a, .woocommerce-page .widget_layered_nav_filters ul li a,
			.woocommerce .widget_layered_nav ul li.chosen a, .woocommerce-page .widget_layered_nav ul li.chosen a,
			.testimonials-controls .prev,
			.testimonials-controls .next
			{background-color:'.$hightlight_color.'}';
			
		echo '
			.om_theme .mejs-controls .mejs-time-rail .mejs-time-loaded,
			.om_theme .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current,
			.woocommerce span.onsale, .woocommerce-page span.onsale,
			.woocommerce #content .quantity .minus:hover, .woocommerce #content .quantity .plus:hover, .woocommerce .quantity .minus:hover, .woocommerce .quantity .plus:hover, .woocommerce-page #content .quantity .minus:hover, .woocommerce-page #content .quantity .plus:hover, .woocommerce-page .quantity .minus:hover, .woocommerce-page .quantity .plus:hover,
			.woocommerce #content input.button.alt:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce-page #content input.button.alt:hover, .woocommerce-page #respond input#submit.alt:hover, .woocommerce-page a.button.alt:hover, .woocommerce-page button.button.alt:hover, .woocommerce-page input.button.alt:hover,
			.woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce-page .widget_price_filter .ui-slider .ui-slider-handle
			{background:'.$hightlight_color.'}';

		echo '
			.hightlight-color,
			.hightlight-color.page-title-wrapper,
			.mobile-header-menu-control.active,
			.search-popup-link:hover,
			.search-popup-link.active,
			.footer a:hover,
			.content a,
			.post-title h2 a:hover,
			.omsc-recent-posts-title h3 a:hover,
			blockquote,
			.blockquote,
			.post-link-box a:before,
			.post-link-box a:hover,
			.content .post-link-box a:hover,
			.om_theme .ompf-portfolio-categories li a:hover,
			.omsc-icon-color-theme,
			.omsc-icons-color-theme,
			.omsc-icon-style-border .omsc-box-icon,
			.omsc-theme-color,
			.blogroll .post.sticky .post-title h2:before,
			.woocommerce .star-rating, .woocommerce-page .star-rating,
			.woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price,
			.woocommerce #content input.button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce-page #content input.button:hover, .woocommerce-page #respond input#submit:hover, .woocommerce-page a.button:hover, .woocommerce-page button.button:hover, .woocommerce-page input.button:hover,
			.woocommerce a.added_to_cart:hover, .woocommerce-page a.added_to_cart:hover,
			.woocommerce #content div.product p.price, .woocommerce #content div.product span.price, .woocommerce div.product p.price, .woocommerce div.product span.price, .woocommerce-page #content div.product p.price, .woocommerce-page #content div.product span.price, .woocommerce-page div.product p.price, .woocommerce-page div.product span.price,
			.woocommerce #content input.button.alt, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce-page #content input.button.alt, .woocommerce-page #respond input#submit.alt, .woocommerce-page a.button.alt, .woocommerce-page button.button.alt, .woocommerce-page input.button.alt,
			.woocommerce #content table.cart a.remove, .woocommerce table.cart a.remove, .woocommerce-page #content table.cart a.remove, .woocommerce-page table.cart a.remove,
			.footer-widget ul.menu a:hover
			{color:'.$hightlight_color.'}';

		echo '
			blockquote:after,
			.blockquote:after,
			.testimonials-block:after
			{background-image: url(\'data:image/svg+xml;base64,'.base64_encode('<svg xmlns="http://www.w3.org/2000/svg" width="35" height="30"><polygon fill="'.$hightlight_color.'" points="0,0 15,0, 15,15 0,30"/><polygon fill="'.$hightlight_color.'" points="20,0 35,0, 35,15 20,30"/></svg>').'\');}';

		echo '
			.more-link {
				background-image: -moz-linear-gradient(top,  '.$hightlight_color.' 0%, '.$hightlight_color.' 100%);
				background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0%,'.$hightlight_color.'), color-stop(100%,'.$hightlight_color.'));
				background-image: -webkit-linear-gradient(top,  '.$hightlight_color.' 0%,'.$hightlight_color.' 100%);
				background-image: -o-linear-gradient(top,  '.$hightlight_color.' 0%,'.$hightlight_color.' 100%);
				background-image: -ms-linear-gradient(top,  '.$hightlight_color.' 0%,'.$hightlight_color.' 100%);
				background-image: linear-gradient(to bottom,  '.$hightlight_color.' 0%,'.$hightlight_color.' 100%);
			}
		';

		// lighter highlight color
		$hsl=om_rgb2hsl(om_hex2rgb($hightlight_color));
		$hsl[2]+=0.1;
		if($hsl[2] > 1) {
			$hsl[2]=1;
		}
		$rgb=om_hsl2rgb($hsl);
		
		echo '
			input[type=button]:hover,
			input[type=submit]:hover,
			input[type=reset]:hover
			{background-color:rgb('.$rgb[0].','.$rgb[1].','.$rgb[2].')}';

		// lighter highlight color
		$rgb=om_hex2rgb($hightlight_color);
		
		echo '
			.custom-gallery .control-prev .prev,
			.custom-gallery .control-next .next,
			.custom-gallery .control-progress,
			.ompf-preview-layout-full-hover .ompf-portfolio-thumb .ompf-desc-wrapper
			{background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.65)}';

		echo '
			.hover-image-extra .over,
			.om_theme .ompf-portfolio-thumb a .ompf-pic-inner:after,
			.woocommerce ul.products li.product .wc-product-thumb-inner:after
			{background: rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.65);
				background: -moz-radial-gradient(center, ellipse cover,  rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.85) 0%, rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.1) 100%);
				background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.85)), color-stop(100%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.1)));
				background: -webkit-radial-gradient(center, ellipse cover,  rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.85) 0%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.1) 100%);
				background: -o-radial-gradient(center, ellipse cover,  rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.85) 0%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.1) 100%);
				background: -ms-radial-gradient(center, ellipse cover,  rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.85) 0%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.1) 100%);
				background: radial-gradient(ellipse at center,  rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.85) 0%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.1) 100%);}';
					
		/**
		 * Header
		 */
		
		$intro_color=get_option(OM_THEME_PREFIX . 'intro_color');
		echo '
			.header-intro-text,
			.header-wpml-selector #lang_sel_list a,
			.header-wpml-selector #lang_sel_list a:hover,
			.header-wpml-selector #lang_sel a,
			.header-wpml-selector #lang_sel a:hover,
			.header-wpml-selector #lang_sel ul ul a,
			.header-wpml-selector #lang_sel ul ul a:hover
			{color:'.$intro_color.'}';
			
		$header_bg_color=get_option(OM_THEME_PREFIX . 'header_background_color');
		echo '
			.header,
			.secondary-menu ul,
			.primary-menu ul,
			.search-popup,
			.header-menu,
			.header-logo-menu,
			.header-wpml-selector #lang_sel a,
			.header-wpml-selector #lang_sel ul ul a
			{background-color:'.$header_bg_color.'}';
			
		echo '
			.search-popup:after
			{border-bottom-color:'.$header_bg_color.'}';	

		$menu_color=get_option(OM_THEME_PREFIX . 'menu_items_color');
		$menu_color_hover=get_option(OM_THEME_PREFIX . 'menu_items_color_hover');
		$menu_bg_color_hover=get_option(OM_THEME_PREFIX . 'menu_items_background_color_hover');

		echo '
		.header,
		.header a,
		.search-popup input
		{color:'.$menu_color.'}';

		echo '
		.secondary-menu a:hover,
		.primary-menu a:hover,
		.primary-menu-highlight-active .primary-menu li.current-menu-item > a
		{color:'.$menu_color_hover.'}';

		$rgb=om_hex2rgb($menu_color);

		echo '
		.header *,
		.header-wpml-selector #lang_sel a,
		.header-wpml-selector #lang_sel ul ul a
		{border-color:'.$menu_color.';border-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.1)}';

		/**
		 * Content
		 */
		 
		$bg_color=get_option(OM_THEME_PREFIX . 'background_main_content_color');
		echo '
		.content,
		.header-slider,
		.page-title-wrapper,
		.content .image-hover-links-inner,
		.omsc-box.omsc-with-border.omsc-icon-style-border .omsc-box-icon,
		.omsc-box.omsc-with-bg-color.omsc-icon-style-border .omsc-box-icon,
		.content .ompf-portfolio-thumb,
		.content .omsc-pricing-column,
		.woocommerce #content div.product .woocommerce-tabs ul.tabs li.active, .woocommerce div.product .woocommerce-tabs ul.tabs li.active, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs li.active, .woocommerce-page div.product .woocommerce-tabs ul.tabs li.active
		{background-color:'.$bg_color.'}';

		echo '
		.om_theme .ompf-portfolio-categories li a .ompf-count
		{color:'.$bg_color.'}';		
		
		echo '
		a.more-link:before
		{border-right-color:'.$bg_color.'}';
		
		echo '
		.woocommerce #content div.product .woocommerce-tabs ul.tabs li.active, .woocommerce div.product .woocommerce-tabs ul.tabs li.active, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs li.active, .woocommerce-page div.product .woocommerce-tabs ul.tabs li.active
		{border-bottom-color:'.$bg_color.'}';
		
		$color=get_option(OM_THEME_PREFIX . 'main_text_color');
		
		echo '
		.content,
		.header-slider,
		.page-title-wrapper,
		.post-title h2,
		.om_theme .ompf-portfolio-thumb a
		{color:'.$color.'}';

		echo '
		.content .omsc-custom-table.omsc-style-2 th,
		.content .omsc-custom-table-wrapper.omsc-style-2 table th
		{border-color:'.$color.'}';

		
		$rgb=om_hex2rgb($color);
		
		echo '
		.sidebar-widget,
		.content select,
		.content input,
		.content textarea,
		#wp-calendar tbody td,
		.comments-section,
		.comment-inner,
		.navigation-prev,
		.navigation-next,
		.navigation-pages a,
		.navigation-pages-inner > span.dots,
		.blogroll .post,
		.om_theme .ompf-portfolio-categories li,
		.search-results li,
		.sidebar-widget .menu li a,
		.content .omsc-toggle,
		.content .omsc-toggle-title,
		.content .omsc-accordion,
		.content .omsc-tabs-control li,
		.content .omsc-tabs-tabs,
		.content hr,
		.content .omsc-custom-table.omsc-style-1,
		.content .omsc-custom-table-wrapper.omsc-style-1 table,
		.content .omsc-custom-table.omsc-style-1 th,
		.content .omsc-custom-table-wrapper.omsc-style-1 table th,
		.content .omsc-custom-table.omsc-style-2 td,
		.content .omsc-custom-table-wrapper.omsc-style-2 table td,
		.content .omsc-custom-table.omsc-style-3 td,
		.content .omsc-custom-table-wrapper.omsc-style-3 table td,
		.content .omsc-custom-table.omsc-style-3 th,
		.content .omsc-custom-table-wrapper.omsc-style-3 table th,
		.woocommerce ul.products li.product,
		.woocommerce #content input.button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce-page #content input.button, .woocommerce-page #respond input#submit, .woocommerce-page a.button, .woocommerce-page button.button, .woocommerce-page input.button,
		.woocommerce #content input.button.loading, .woocommerce #respond input#submit.loading, .woocommerce a.button.loading, .woocommerce button.button.loading, .woocommerce input.button.loading, .woocommerce-page #content input.button.loading, .woocommerce-page #respond input#submit.loading, .woocommerce-page a.button.loading, .woocommerce-page button.button.loading, .woocommerce-page input.button.loading,
		.woocommerce #content .quantity input.qty, .woocommerce .quantity input.qty, .woocommerce-page #content .quantity input.qty, .woocommerce-page .quantity input.qty,
		.woocommerce #content div.product .woocommerce-tabs ul.tabs:before, .woocommerce div.product .woocommerce-tabs ul.tabs:before, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs:before, .woocommerce-page div.product .woocommerce-tabs ul.tabs:before,
		.woocommerce #content div.product .woocommerce-tabs ul.tabs li, .woocommerce div.product .woocommerce-tabs ul.tabs li, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs li, .woocommerce-page div.product .woocommerce-tabs ul.tabs li,
		.woocommerce .widget_shopping_cart .total, .woocommerce-page .widget_shopping_cart .total, .woocommerce-page.widget_shopping_cart .total, .woocommerce.widget_shopping_cart .total,
		.woocommerce ul.cart_list li, .woocommerce ul.product_list_widget li, .woocommerce-page ul.cart_list li, .woocommerce-page ul.product_list_widget li,
		.woocommerce .cart_totals th,
		.woocommerce .cart_totals td
		{border-color:'.$color.';border-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.15)}';

		echo '		
		.woocommerce .woocommerce-message, .woocommerce-page .woocommerce-message,
		.woocommerce .woocommerce-info, .woocommerce-page .woocommerce-info,
		.woocommerce .woocommerce-error, .woocommerce-page .woocommerce-error
		{border-left-color:'.$color.';border-left-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.15);
		border-right-color:'.$color.';border-right-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.15);
		border-bottom-color:'.$color.';border-bottom-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.15)}';
		
		echo '
		.custom-gallery,
		.gallery-sliced .img-box,
		.content .omsc-toggle-title:hover,
		.content .omsc-toggle.omsc-expanded .omsc-toggle-title,
		.content .omsc-pricing-column li:nth-child(even),
		.content .omsc-custom-table.omsc-style-1 th,
		.content .omsc-custom-table-wrapper.omsc-style-1 table th,
		.woocommerce #content .quantity .minus, .woocommerce #content .quantity .plus, .woocommerce .quantity .minus, .woocommerce .quantity .plus, .woocommerce-page #content .quantity .minus, .woocommerce-page #content .quantity .plus, .woocommerce-page .quantity .minus, .woocommerce-page .quantity .plus,
		.woocommerce #content div.product .woocommerce-tabs ul.tabs li, .woocommerce div.product .woocommerce-tabs ul.tabs li, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs li, .woocommerce-page div.product .woocommerce-tabs ul.tabs li
		{background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.1)}';

		echo '
		.content .omsc-custom-table.omsc-style-1 td,
		.content .omsc-custom-table-wrapper.omsc-style-1 table td
		{background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.03)}';

		echo '
		.content .omsc-custom-table.omsc-style-1 tr:nth-child(even) td,
		.content .omsc-custom-table-wrapper.omsc-style-1 table tr:nth-child(even) td,
		.content .omsc-custom-table.omsc-style-2 tr:nth-child(odd) td,
		.content .omsc-custom-table-wrapper.omsc-style-2 table tr:nth-child(odd) td,
		.content .omsc-tabs-control li a,
		.woocommerce #payment, .woocommerce-page #payment,
		.woocommerce #payment div.payment_box, .woocommerce-page #payment div.payment_box
		{background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.06)}';

		echo '
		.woocommerce #payment div.payment_box:after, .woocommerce-page #payment div.payment_box:after
		{border-bottom-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.06)}';		
		

		echo '
		blockquote,
		.blockquote,
		.post-link-box a,
		.testimonials-block
		{
			background: rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.05);
			background: -moz-linear-gradient(top,  rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.03) 0%, rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.08) 100%);
			background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.03)), color-stop(100%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.08)));
			background: -webkit-linear-gradient(top,  rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.03) 0%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.08) 100%);
			background: -o-linear-gradient(top,  rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.03) 0%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.08) 100%);
			background: -ms-linear-gradient(top,  rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.03) 0%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.08) 100%);
			background: linear-gradient(to bottom,  rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.03) 0%,rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.08) 100%);
			}';
		
		$side_color=get_option(OM_THEME_PREFIX . 'side_text_color');

		echo '
		.comment-meta,
		.comment-notes,
		.navigation-prev a,
		.navigation-next a,
		.post-date-author,
		.post-meta,
		.content .post-link-box a,
		.blockquote-author,
		.omsc-blockquote-author,
		.ompf-portfolio-single-categories,
		.ompf-portfolio-single-categories a,
		.omsc-recent-posts-date,
		.navigation-pages-inner > span.dots,
		.sidebar-widget .tweet-time a,
		.content .wp-caption-text,
		.comments-section .nocomments,
		.woocommerce .star-rating:before, .woocommerce-page .star-rating:before,
		.woocommerce ul.products li.product .price del, .woocommerce-page ul.products li.product .price del,
		.woocommerce #content div.product p.price del, .woocommerce #content div.product span.price del, .woocommerce div.product p.price del, .woocommerce div.product span.price del, .woocommerce-page #content div.product p.price del, .woocommerce-page #content div.product span.price del, .woocommerce-page div.product p.price del, .woocommerce-page div.product span.price del,
		.woocommerce-result-count,
		.woocommerce.widget_products del,
		.woocommerce.widget_top_rated_products del,
		.testimonial-author
		{color:'.$side_color.'}';		

		echo '
		.om_theme .ompf-portfolio-categories li a .ompf-count,
		.woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content, .woocommerce-page .widget_price_filter .price_slider_wrapper .ui-widget-content
		{background-color:'.$side_color.'}';				
		
		echo '
			select
			{background-image: url(\'data:image/svg+xml;base64,'.base64_encode('<svg xmlns="http://www.w3.org/2000/svg" width="17" height="4"><polygon fill="'.$side_color.'" points="0,0 9,0, 5,4"/></svg>').'\');}';

		
		/**
		 * Footer
		 */

		$bg_color=get_option(OM_THEME_PREFIX . 'background_footer_color');
		
		echo '
		.footer
		{background-color:'.$bg_color.'}';
		
		echo '
		.footer a.more-link:before
		{border-right-color:'.$bg_color.'}';	

		$color=get_option(OM_THEME_PREFIX . 'footer_main_text_color');
		
		echo '
		.footer,
		.footer a,
		.footer .testimonials-controls .prev,
		.footer .testimonials-controls .prev:hover,
		.footer .testimonials-controls .next,
		.footer .testimonials-controls .next:hover
		{color:'.$color.'}';
		
		$rgb=om_hex2rgb($color);
		
		echo '
		.footer *
		{border-color:'.$color.';border-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.15)}';

		echo '
		.footer .testimonials-controls .prev,
		.footer .testimonials-controls .next
		{background-color:'.$color.';background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].',0.15)}';		
			

		$side_color=get_option(OM_THEME_PREFIX . 'footer_side_text_color');
		echo '
		.footer-widget .tweet-time a,
		.footer .blockquote-author,
		.footer .omsc-blockquote-author,
		.footer .omsc-recent-posts-date,
		.footer .testimonial-author
		{color:'.$side_color.'}';

		echo '
			.footer select
			{background-image: url(\'data:image/svg+xml;base64,'.base64_encode('<svg xmlns="http://www.w3.org/2000/svg" width="17" height="4"><polygon fill="'.$side_color.'" points="0,0 9,0, 5,4"/></svg>').'\');}';


		$color=get_option(OM_THEME_PREFIX . 'footer_titles_color');

		echo '
		.footer-widget-title
		{color:'.$color.'}';
						
		/***/
		
		$out = ob_get_contents();
    ob_end_clean();

		$out=preg_replace('/\s*([\{\},;])\s*/','$1',$out);
		$out=str_replace(',{','{',$out);
		$out=trim($out);
		    
    return $out;
	}
	
}

if( !function_exists( 'om_custom_style_file_name' ) ) {
	
	function om_custom_style_file_path() {
		
		if ( is_multisite() ) {
			return '/style-custom-' . get_current_blog_id() . '.css';
		} else {
			return '/style-custom.css';
		}
		
	}
}

if( !function_exists( 'om_theme_custom_styling' ) ) {
	
	function om_theme_custom_styling() {

		add_action('wp_head','om_theme_custom_styling_fonts');
		
		// echo custom styling
		if( get_option( OM_THEME_PREFIX . 'use_inline_css' ) == 'true' || !file_exists(TEMPLATE_DIR . om_custom_style_file_path() ) ) {
			add_action('wp_head','om_theme_custom_styling_inline_css');
		} else {
			add_action('wp_enqueue_scripts', 'om_theme_custom_styling_css_file');
		}

	}
}
add_action('init', 'om_theme_custom_styling');

if( !function_exists( 'om_theme_custom_styling_fonts' ) ) {
	function om_theme_custom_styling_fonts() {
		// embed fonts
		$base_font=get_option(OM_THEME_PREFIX . 'base_font');
		$sec_font=get_option(OM_THEME_PREFIX . 'sec_font');
		if(isset($base_font['type']) && $base_font['type'] == 'external' && isset($base_font['external']['embed']))
			echo $base_font['external']['embed'];
		if(isset($sec_font['type']) && $sec_font['type'] == 'external' && isset($sec_font['external']['embed']))
			echo $sec_font['external']['embed'];		
	}
}

if( !function_exists( 'om_theme_custom_styling_inline_css' ) ) {
	function om_theme_custom_styling_inline_css() {
		$css=om_theme_get_styling();
		echo '<style>' . $css . '</style>';
	}
}
		
if( !function_exists( 'om_theme_custom_styling_css_file' ) ) {
	function om_theme_custom_styling_css_file() {
		$salt=get_option( OM_THEME_PREFIX . 'style-custom-salt' );
		if($salt != '')
			$salt='?rev='.$salt;
		wp_enqueue_style('style-custom', TEMPLATE_DIR_URI . om_custom_style_file_path() . $salt);
	}
}

if( !function_exists( 'om_theme_update_custom_style_file' ) ) {
	
	function om_theme_update_custom_style_file() {
		
		$f=@fopen(TEMPLATE_DIR . om_custom_style_file_path(), 'w+');
		if($f) {
			$css=om_theme_get_styling();
			fwrite($f,$css);
			fclose($f);
		}
		
		update_option( OM_THEME_PREFIX . 'style-custom-salt', rand(10000, 99999) ); 
		
	}
	add_action('om_options_updated','om_theme_update_custom_style_file');
}


if( !function_exists( 'om_body_styling_classes' ) ) {
	
	function om_body_styling_classes($classes) {
	
		if( ( $layout = get_option(OM_THEME_PREFIX . 'overall_layout') ) ) {
			om_body_add_class('layout-'.$layout);
		} else {
			om_body_add_class('layout-wide');
		}
		
		if(get_option(OM_THEME_PREFIX.'sidebar_position')=='left') {
			om_body_add_class('flip-sidebar');
		}
		
		om_body_add_class('om-animation-enabled');

		if(get_option(OM_THEME_PREFIX . 'menu_highlight_active') == 'true') {
			om_body_add_class('primary-menu-highlight-active');
		}	
		
		om_body_add_class('menu-position-'.get_option(OM_THEME_PREFIX . 'menu_position'));
	
	}
	add_action('get_header','om_body_styling_classes');
	
}