<?php

/*************************************************************************************
 * Helper
 ************************************************************************************/ 
 
function om_omsc_insert_before ($array, $key, $new) {
	$keys = array_keys($array);
	$pos = (int) array_search($key, $keys);
	return array_merge(
		array_slice($array, 0, $pos),
		$new,
		array_slice($array, $pos)
	);
}

/*************************************************************************************
 * Config
 ************************************************************************************/ 

function om_omsc_plugin_config($config) {
	
	$config['theme_support']['theme_color']=true;
	$config['theme_support']['animation']=true;
	$config['theme_support']['full_width']=true;
	$config['load_font_awesome_files']=false;

	if(get_option(OM_THEME_PREFIX . 'responsive') != 'true') {
		$config['responsive_mode']=false;
	}
		
	return $config;
	
}
add_filter('omsc_config','om_omsc_plugin_config');

/*************************************************************************************
 * Modify some options in visual editor and buttons in shortcodes menu and generators
 ************************************************************************************/
 
function om_omsc_shortcodes_options($options) {

	$options['table']['options']=om_omsc_insert_before($options['table']['options'], 'omsc_table_note', array(
		'omsc_table_style' => array(
			'title' => __('Style','om_theme'),
			'type' => 'select',
			'std' => '1',
			'options' => array(
				'1'=>__('Style-1','om_theme'),
				'2'=>__('Style-2','om_theme'),
				'3'=>__('Style-3','om_theme'),
			)
		)
	) );


	$options['custom_table'] = array(
		'options'=>array(
			'omsc_custom_table_info' => array(
				'desc' => __('Use this shortcode to apply styling for any custom table. Just wrap a table with this shortcode.','om_shortcodes'),
				'type' => 'info',
			),
			'omsc_custom_table_style' => array(
				'title' => __('Style','om_theme'),
				'type' => 'select',
				'std' => '1',
				'options' => array(
					'1'=>__('Style-1','om_theme'),
					'2'=>__('Style-2','om_theme'),
					'3'=>__('Style-3','om_theme'),
				)
			),
		)
	);

	$options['testimonials'] = array(
		'options'=>array(
			'omsc_testimonials' => array(
				'desc' => sprintf( __('Testimonials are managed under <a href="%s">"Testimonials"</a> section.','om_theme'), admin_url('edit.php?post_type=testimonials') ),
				'type' => 'info',
				'std' => '',
			),
			'omsc_testimonials_category' => array(
				'title' => __('Testimonials category','om_theme'),
				'desc' => __('Specify an ID or a Slug of category, to display testimonials from certain category. To display all testimonials leave this field blank.','om_theme'),
				'type' => 'text',
				'std' => '',
			),
			'omsc_testimonials_ids' => array(
				'title' => __('Testimonials by ID','om_theme'),
				'desc' => __('Specify a list of testimonials ID separated with a comma to display certain testimonials.','om_theme'),
				'type' => 'text',
				'std' => '',
			),
			'omsc_testimonials_mode' => array(
				'title' => __('Layout mode','om_theme'),
				'type' => 'select',
				'std' => '',
				'options' => array(
					''=>__('In one box with sliding','om_theme'),
					'list'=>__('Full list','om_theme'),
				)
			),
			'omsc_testimonials_timeout' => array(
				'title' => __('Autorotate for box mode','om_theme'),
				'desc' => __('interval in milliseconds or 0 - to disable autorotate','om_theme'),
				'type' => 'text',
				'std' => '0',
			),
			'omsc_testimonials_pause' => array(
				'title' => __('Pause on hover','om_theme'),
				'type' => 'checkbox',
				'std' => '',
			),
			'omsc_testimonials_randomize' => array(
				'title' => __('Randomize testimonials','om_theme'),
				'type' => 'checkbox',
				'std' => '',
			),
		)
	);
	    	
	return $options;
	
}
add_filter('omsc_shortcodes_options','om_omsc_shortcodes_options');


function om_omsc_shortcodes_button_menu($menu){
	
	$menu['table_group']['childs']['custom_table']['type']='addPopup';
	
	$menu=om_omsc_insert_before ($menu, 'utilities', array(
		'testimonials' => array(
			'title' => __('Testimonials','om_theme'),
			'type' => 'addPopup',
		),
	));
	
	return $menu;
}
add_filter('omsc_shortcodes_button_menu','om_omsc_shortcodes_button_menu');

function om_omsc_shortcodes_generators ($generators) {
	
	$generators['table']=str_replace("code.before+='[table]';","code.before+='[table style=\"'+$('#omsc_table_style').val()+'\"]';",$generators['table']);
	
	$generators['custom_table'] = <<<EOF
	var style=$('#omsc_custom_table_style').val();
					
	code.before+='[custom_table style="'+style+'"]YOUR CUSTOM TABLE HTML CODE GOES HERE';
	code.after+='[/custom_table]';
	
EOF;

	$generators['testimonials'] = <<<EOF
		var lmode=$('#omsc_testimonials_mode').val();
		var timeout=$('#omsc_testimonials_timeout').val();
		var pause=$('#omsc_testimonials_pause').attr('checked');
		var randomize=$('#omsc_testimonials_randomize').attr('checked');
		var category=$('#omsc_testimonials_category').val();
		var ids=$('#omsc_testimonials_ids').val();
		
		code.before+='[testimonials'+(lmode == 'list'?' mode="list"':'')+(timeout != 0?' timeout="'+timeout+'"':'')+(pause?' pause="true"':'')+(randomize?' randomize="true"':'')+(category?' category="'+category+'"':'')+(ids?' ids="'+ids+'"':'')+']';
EOF;
	
	return $generators;
}
add_filter('omsc_shortcodes_generators','om_omsc_shortcodes_generators');

/*************************************************************************************
 * Filters for shortcodes
 ************************************************************************************/
 
/**
 * Full width section
 */
 
function om_omsc_sc_full_width_section($atts, $content = null) {

	extract(shortcode_atts(array(
		'color' => '',
		'textcolor' => '',
		'image' => '',
		'bgpos' => '',
		'bgatt' => '',
		'video' => '',
		'video_mp4' => '',
		'video_m4v' => '',
		'video_webm' => '',
		'video_ogv' => '',
		'video_wmv' => '',
		'video_flv' => '',
		'no_paddings' => '',
		'class' => '',
	), $atts));
	
	$out='';
	
	$classes=array('omsc-full-width-section');
	$styles=array();
	
	if($class)
		$classes[]=$class;
	
	if($color)
		$styles[]='background-color:'.$color;
		
	if($textcolor)
		$styles[]='color:'.$textcolor;
		
	if($image)
		$styles[]='background-image:url('.$image.')';

	if($bgpos) {
		$styles=array_merge($styles,om_bg_img_pos_style($bgpos));
	}
		
	if($bgatt)
		$styles[]='background-attachment:'.$bgatt;
	
	if($no_paddings)
		$classes[]='omsc-no-paddings';
		
	$out.='<div class="'.implode(' ',$classes).'"'.(!empty($styles)?' style="'.implode(';',$styles).'"':'').'><div class="omsc-full-width-section-inner">';
	
	if($video || $video_mp4 || $video_m4v || $video_webm || $video_ogv || $video_wmv || $video_flv) {
		$out .= '<div class="omsc-full-width-section-video om-video-bg-container">';
		$out .= '<video loop="loop" autoplay="autoplay"'.($image?' poster="'.$image.'"':'').'>';
		if($video)
   		$out.='<source src="'.$video.'">';
		if($video_mp4)
   		$out.='<source src="'.$video_mp4.'" type="video/mp4">';
		if($video_m4v)
   		$out.='<source src="'.$video_m4v.'" type="video/mp4">';
		if($video_webm)
   		$out.='<source src="'.$video_webm.'" type="video/webm">';
		if($video_ogv)
   		$out.='<source src="'.$video_ogv.'" type="video/ogg">';
		if($video_wmv)
   		$out.='<source src="'.$video_wmv.'" type="video/wmv">';
		if($video_flv)
   		$out.='<source src="'.$video_flv.'" type="video/x-flv">';
  	$out .= '</video>';
		$out .= '</div>';
	}
	
	if($no_paddings)
		$content='<div class="clear">&nbsp;</div>'.$content.'<div class="clear">&nbsp;</div>';
	
	$out.='<div class="omsc-full-width-section-content"><div class="container"><div class="container-inner">'.do_shortcode($content).'</div></div></div>';	
	$out.='</div></div>';
		
		
	return $out;
}
add_filter('omsc_sc_full_width_section','om_omsc_sc_full_width_section',10,2);

/**
 * Recent posts
 */
 
function om_omsc_sc_recent_posts_img($html,$args) {
	
  $args['img_src']=om_img_resize($args['img_src'], 'post-media-medium');
	
  if( get_option(OM_THEME_PREFIX . 'lazyload') == 'true') {
  	$img='<img src="'. TEMPLATE_DIR_URI .'/img/e.png" class="lazyload" data-original="'.$args['img_src'].'" alt="'.esc_attr($args['alt']).'" />';
	} else {
		$img='<img src="'.$args['img_src'].'" alt="'.esc_attr($args['alt']).'" />';
	}
	
 	return om_hover_extras(
  	$img,
  	false,
  	$args['link']
  );
	
}
add_filter('omsc_sc_recent_posts_img','om_omsc_sc_recent_posts_img',10,2);

function om_omsc_sc_recent_posts_excerpt($excerpt) {
	
	if(has_excerpt())
		$excerpt = om_custom_excerpt_more( $excerpt , true );
	
	return $excerpt;
}
add_filter('omsc_sc_recent_posts_excerpt','om_omsc_sc_recent_posts_excerpt');

function om_omsc_sc_recent_posts_img_size($size) {
	
	return 'full';
}
add_filter('omsc_sc_recent_posts_img_size','om_omsc_sc_recent_posts_img_size');

/**
 * Standard WordPress Gallery
 */
 
function om_shortcode_atts_gallery($atts) {
	
	if(!isset($atts['size']))
		$atts['size']='thumbnail';
		
	if(!isset($atts['columns']))
		$atts['columns']=3;

	if($atts['columns'] == 1) {
		$atts['size']='full';
	} elseif($atts['columns'] < 4 && ($atts['size'] == 'thumbnail' || $atts['size'] == 'medium')) {
		$atts['size']='large';
	} elseif($atts['columns'] < 6 && $atts['size'] == 'thumbnail') {
		$atts['size']='medium';
	}
		
	return $atts;
}
add_filter('shortcode_atts_gallery','om_shortcode_atts_gallery');

function om_use_default_gallery_style($v) {
	return false;
}
add_filter('use_default_gallery_style','om_use_default_gallery_style');

/*************************************************************************************
 * Extra shortcodes
 ************************************************************************************/
 
/*************************************************************************************
 *	Testimonials
 *************************************************************************************/

function om_omsc_testimonials( $atts, $content = null ) {
	global $post;

	extract(shortcode_atts(array(
		'mode' => '',
		'timeout' => '0',
		'pause' => false,
		'randomize' => false,
		'category' => 0,
		'ids' => false,
	), $atts));
	
	$out='';

	$args=array (
		'post_type' => 'testimonials',
		'orderby' => 'menu_order',
		'order' => 'ASC',
		'posts_per_page' => -1
	);
	if($ids) {
		$args['post__in']=explode(',',$ids);
		$args['orderby']='post__in';	
	} else {
		$category=trim($category);
		if($category) {
			if(is_numeric($category)) {
				$args['tax_query']=array(
					array('taxonomy'=>'testimonials-type', 'terms' => $category),
				);
			} else {
				$args['tax_query']=array(
					array('taxonomy'=>'testimonials-type', 'field' => 'slug', 'terms' => $category),
				);
			}
		}
	}
	if($randomize) {
		$args['orderby']='rand';
	}
	$query = new WP_Query($args);
	
	if( $query->have_posts() ) {
		
		
		$timeout=intval($timeout);
		$out .= '<div class="testimonials-block'.($mode=='list'?' testimonials-list':' testimonials-slider').'"'.($timeout?' data-timeout="'.$timeout.'"':'').($pause?' data-pause="1"':'').'>';

		$out .= '<div class="items">';
	
		while ( $query->have_posts() ) {
			
			$query->the_post(); 

			$out .= '<div class="item">';
				$author=get_post_meta($post->ID, OM_THEME_SHORT_PREFIX.'testimonial_author_desc', true);
	
				$out.='<div class="testimonial-inner'.( has_post_thumbnail() ?' with-pic':' no-pic'  ).'">';
				
				if ( has_post_thumbnail() ) {
					$out .= '<div class="testimonial-pic">'. get_the_post_thumbnail() .'</div>';
				}
	
				$out .= '<div class="testimonial-text">'.get_the_content().'</div>';

				if($author)
					$out .= '<div class="testimonial-author">'.$author.'</div>';
				
				$out .= '<div class="clear"></div></div>';
			
			$out .= '</div>';
		}
		
		$out .= '</div>';

		if($mode!='list')
			$out .= '<div class="testimonials-controls"><a href="#" class="prev"></a><a href="#" class="next"></a></div>';

		$out .= '</div>';
	}
		
	wp_reset_postdata();
		
	return $out;
	
}
add_shortcode('testimonials', 'om_omsc_testimonials');