<?php

/*************************************************************************************
 *	Add MetaBox to Post edit page
 *************************************************************************************/

$om_post_meta_box=array (

	'pagetitle' => array (
		'id' => 'om-page-meta-box-pagetitle',
		'name' => __('Page Title', 'om_theme'),
		'fields' => array (
			array ( "name" => __('Page Title','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."page_title",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Standard', 'om_theme'),
						'hide' => __('Hide', 'om_theme'),
						'color' => __('Custom background color', 'om_theme'),
						'image' => __('Custom background image', 'om_theme'),
						'parallax' => __('Predefined parallax effect', 'om_theme'),
					),
					'code' => '<script>
						jQuery(function($){
							$("#'.OM_THEME_SHORT_PREFIX.'page_title").change(function(){
								$("#'.OM_THEME_SHORT_PREFIX.'title_align").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_margins").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_bg_color").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_text_color").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img_pos").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img_att").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_parallax").parents("tr").hide();
								
								if($(this).val() == "") {
									$("#'.OM_THEME_SHORT_PREFIX.'title_align").parents("tr").show();
								} else if($(this).val() == "color") {
									$("#'.OM_THEME_SHORT_PREFIX.'title_align").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_margins").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_color").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_text_color").parents("tr").show();
								} else if($(this).val() == "image") {
									$("#'.OM_THEME_SHORT_PREFIX.'title_align").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_color").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img_pos").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img_att").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_margins").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_text_color").parents("tr").show();
								} else if($(this).val() == "parallax") {
									$("#'.OM_THEME_SHORT_PREFIX.'title_align").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_color").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_margins").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_text_color").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_parallax").parents("tr").show();
								}
							}).change();
						});
					</script>',
			),
			
			array ( "name" => __('Title align','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_align",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Left', 'om_theme'),
						'center' => __('Center', 'om_theme'),
					),
			),
			
			array ( "name" => __('Title Margins','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_margins",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Standard', 'om_theme'),
						'large' => __('Large', 'om_theme'),
						'xlarge' => __('X-Large', 'om_theme'),
					),
			),
			
			array ( "name" => __('Title background color','om_theme'),
					"desc" => __('To automatically apply theme Hightlight color from Theme Options type "default"'),
					"id" => OM_THEME_SHORT_PREFIX."title_bg_color",
					"type" => "color",
					"std" => 'default',
			),
			
			array ( "name" => __('Title text color','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_text_color",
					"type" => "color",
					"std" => '#FFFFFF',
			),
			
			array ( "name" => __('Title background image','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_bg_img",
					"type" => "text_browse",
					"std" => '',
					"library" => 'image',
			),
			
			array ( "name" => __('Title background image position','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_bg_img_pos",
					"type" => "select",
					"std" => '',
          'options'=>array(
          	'repeat' => 'Repeat image',
          	'repeat_x_top' => 'Repeat-x image top',
          	'repeat_x_center' => 'Repeat-x image center',
          	'repeat_x_bottom' => 'Repeat-x image bottom',
          	'repeat_y_left' => 'Repeat-y image left',
          	'repeat_y_center' => 'Repeat-y image center',
          	'repeat_y_right' => 'Repeat-y image right',
          	'cover' => 'Cover',
          	'no_repeat_center' => 'No-Repeat Center',
          	'no_repeat_left_top' => 'No-Repeat Left Top',
          	'no_repeat_top' => 'No-Repeat Top',
          	'no_repeat_right_top' => 'No-Repeat Right Top',
          	'no_repeat_right' => 'No-Repeat Right',
          	'no_repeat_right_bottom' => 'No-Repeat Right Bottom',
          	'no_repeat_bottom' => 'No-Repeat Bottom',
          	'no_repeat_left_bottom' => 'No-Repeat Left Bottom',
          	'no_repeat_left' => 'No-Repeat Left',
          ),
			),
			
			array ( "name" => __('Title background image attachment','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_bg_img_att",
					"type" => "select",
					"std" => 'scroll',
          'options'=>array(
          	'scroll' => __('Scroll','om_theme'),
          	'fixed' => __('Fixed','om_theme'),
          ),
			),
			
			array ( "name" => __('Parallax effect','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_parallax",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Lines', 'om_theme'),
						'geometry' => __('Geometry', 'om_theme'),
						'circles' => __('Circles', 'om_theme'),
					),
			),

		),
	),

	'sidebar' => array (
		'id' => 'om-page-meta-box-sidebar',
		'name' => __('Sidebar', 'om_theme'),
		'fields' => array (
			array ( "name" => __('Sidebar','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."sidebar_show",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Display Sidebar', 'om_theme'),
						'hide' => __('Hide Sidebar', 'om_theme'),
					),
					'code' => '<script>
						jQuery(function($){
							$("#'.OM_THEME_SHORT_PREFIX.'sidebar_show").change(function(){
								if($(this).val() == "hide") {
									$("#'.OM_THEME_SHORT_PREFIX.'sidebar").parents("tr").hide();
									$("#'.OM_THEME_SHORT_PREFIX.'sidebar_custom_pos").parents("tr").hide();
								} else {
									$("#'.OM_THEME_SHORT_PREFIX.'sidebar").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'sidebar_custom_pos").parents("tr").show();
								}
							}).change();
						});
					</script>',
			),

			array (
				'name' => __('Choose the sidebar','om_theme'),
				'desc' => '',
				'id' => OM_THEME_SHORT_PREFIX.'sidebar',
				'type' => 'sidebar',
				'std' => ''
			),

			array ( "name" => __('Page Individual Sidebar Position','om_theme'),
					"desc" => __('Normally sidebar position for all pages can be specified under "Appearance > Theme Options > Sidebars", but you can set sidebar position for current page manually.','om_theme'),
					"id" => OM_THEME_SHORT_PREFIX."sidebar_custom_pos",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Default (As in "Theme Options")', 'om_theme'),
						'left' => __('Left Side', 'om_theme'),
						'right' => __('Right Side', 'om_theme'),
					)
			),
		),
	),
	
	'quote' => array (
		'id' => 'om-post-meta-box-quote',
		'name' => __('Quote Settings', 'om_theme'),
		'fields' => array (
			array (
				'name' => __('The Quote','om_theme'),
				'desc' => __('Write your quote in this field','om_theme'),
				'id' => OM_THEME_SHORT_PREFIX.'quote',
				'type' => 'textarea',
				'std' => ''
			),
			array (
				'name' => __('Quote author','om_theme'),
				'desc' => '',
				'id' => OM_THEME_SHORT_PREFIX.'quote_author',
				'type' => 'text',
				'std' => ''
			),
		),
	),
	
	'link' => array(
		'id' => 'om-post-meta-box-link',
		'name' => __('Link Settings', 'om_theme'),
		'fields' => array (
			array (
				'name' => __('The URL','om_theme'),
				'desc' => __('Insert the URL you wish to link to','om_theme'),
				'id' => OM_THEME_SHORT_PREFIX.'link_url',
				'type' => 'text',
				'std' => ''
			),
		),
	),
	
	'video' => array (
		'id' => 'om-post-meta-box-video',
		'name' =>  __('Video Settings', 'om_theme'),
		'fields' => array (
			array ( "name" => __('HTML Embed code or link to YouTube, Vimeo, etc.','om_theme'),
					"desc" => __('If your video is hosted by video service insert the link to the video or HTML embed code.<br/>If you want to insert video file from WordPress Media library, use the fields below','om_theme'),
					"id" => OM_THEME_SHORT_PREFIX."video_embed",
					"type" => "textarea",
					"rows" => 3,
					"std" => ''
			),
			array ( "name" => __('Video File URL','om_theme'),
					"desc" => __('The URL to the video file','om_theme'),
					"id" => OM_THEME_SHORT_PREFIX."video_src",
					"type" => "text_browse",
					"std" => '',
					"library" => 'video',
			),
			array ( "name" => __('Poster Image','om_theme'),
					"desc" => __('The preivew image, only for self hosted videos','om_theme'),
					"id" => OM_THEME_SHORT_PREFIX."video_poster",
					"type" => "text_browse",
					"std" => '',
					"library" => 'image',
			),
			array ( "name" => '',
					"desc" => __('Fields below are not necessary if the "Video File URL" is specified, but can be used as a fallback video sources if the browser does not support format of the video chosen above.','om_theme'),
					"id" => OM_THEME_SHORT_PREFIX."videoformat_info",
					"type" => "info",
			),
			array ( "name" => __('MP4 File URL','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."video_mp4",
					"type" => "text_browse",
					"std" => '',
					"library" => 'video',
			),
			array ( "name" => __('M4V File URL','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."video_m4v",
					"type" => "text_browse",
					"std" => '',
					"library" => 'video',
			),
			array ( "name" => __('WebM File URL','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."video_webm",
					"type" => "text_browse",
					"std" => '',
					"library" => 'video',
			),
			array ( "name" => __('OGV File URL','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."video_ogv",
					"type" => "text_browse",
					"std" => '',
					"library" => 'video',
			),
			array ( "name" => __('WMV File URL','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."video_wmv",
					"type" => "text_browse",
					"std" => '',
					"library" => 'video',
			),
			array ( "name" => __('FLV File URL','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."video_flv",
					"type" => "text_browse",
					"std" => '',
					"library" => 'video',
			),
		),
	),
	
	'audio' => array (
		'id' => 'om-post-meta-box-audio',
		'name' =>  __('Audio Settings', 'om_theme'),
		'fields' => array (
			array ( "name" => __('HTML Embed code or link to SoundCloud, etc.','om_theme'),
					"desc" => __('If your audio is hosted by audio service insert the link to the audio or HTML embed code.<br/>If you want to insert audio file from WordPress Media library, use the fields below','om_theme'),
					"id" => OM_THEME_SHORT_PREFIX."audio_embed",
					"type" => "textarea",
					"rows" => 3,
					"std" => ''
			),
			array( "name" => __('Audio File URL','om_theme'),
				"desc" => __('The URL to the audio file','om_theme'),
				"id" => OM_THEME_SHORT_PREFIX."audio_src",
				"type" => "text_browse",
				"std" => '',
				"library" => 'audio',
			),
			array ( "name" => '',
					"desc" => __('Fields below are not necessary if the "Audio File URL" is specified, but can be used as a fallback audio sources if the browser does not support format of the audio chosen above.','om_theme'),
					"id" => OM_THEME_SHORT_PREFIX."audioformat_info",
					"type" => "info",
			),
			array( "name" => __('MP3 File URL','om_theme'),
				"desc" => '',
				"id" => OM_THEME_SHORT_PREFIX."audio_mp3",
				"type" => "text_browse",
				"std" => '',
				"library" => 'audio',
			),
			array( "name" => __('M4A File URL','om_theme'),
				"desc" => '',
				"id" => OM_THEME_SHORT_PREFIX."audio_m4a",
				"type" => "text_browse",
				"std" => '',
				"library" => 'audio',
			),
			array( "name" => __('OGG File URL','om_theme'),
				"desc" => '',
				"id" => OM_THEME_SHORT_PREFIX."audio_ogg",
				"type" => "text_browse",
				"std" => '',
				"library" => 'audio',
			),
			array( "name" => __('WAV File URL','om_theme'),
				"desc" => '',
				"id" => OM_THEME_SHORT_PREFIX."audio_wav",
				"type" => "text_browse",
				"std" => '',
				"library" => 'audio',
			),
			array( "name" => __('WMA File URL','om_theme'),
				"desc" => '',
				"id" => OM_THEME_SHORT_PREFIX."audio_wma",
				"type" => "text_browse",
				"std" => '',
				"library" => 'audio',
			),
		),
	),
	
	'gallery' => array (
		'id' => 'om-post-meta-box-gallery',
		'name' => __('Gallery Settings', 'om_theme'),
		'fields' => array (

			array ( "name" => __('Gallery mode on the single page','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."gallery_mode",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Standard (slider)', 'om_theme'),
						'sliced' => __('Sliced', 'om_theme'),
						'masonry' => __('Masonry', 'om_theme'),
					)
			),
			
			array ( "name" => __('Captions','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."gallery_captions",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Hide', 'om_theme'),
						'true' => __('Display image captions', 'om_theme'),
					)
			),

			array ( "name" => __('Gallery','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."gallery",
					"type" => "gallery",
					"std" => '',
			),

		),
	),
);

if( ommb_check_slider_exists() ){

	$om_post_meta_box['slider'] = array (
		'id' => 'om-post-meta-box-slider',
		'name' => __('Slider', 'om_theme'),
		'fields' => array (

			array (
				'name' => __('Choose the slider','om_theme'),
				'desc' => '',
				'id' => OM_THEME_SHORT_PREFIX.'slider_id',
				'type' => 'slider',
				'std' => ''
			),

			array ( "name" => __('Slider layout','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."slider_layout",
					"type" => "select",
					"std" => 'boxed',
					'options' => array(
						'full' => __('Full width slider', 'om_theme'),
						'boxed' => __('Boxed width slider', 'om_theme'),
					)
			),
			
		),
	);
	
}
 
function om_add_post_meta_box() {
	global $om_post_meta_box;
	
	ommb_add_meta_boxes($om_post_meta_box, 'post');
 
}
add_action('add_meta_boxes', 'om_add_post_meta_box');


/*************************************************************************************
 *	Save MetaBox data
 *************************************************************************************/

function om_save_post_metabox($post_id) {
	global $om_post_meta_box;
 
	ommb_save_metabox($post_id, $om_post_meta_box);

}
add_action('save_post', 'om_save_post_metabox');


/*************************************************************************************
 *	Load JS Scripts and Styles
 *************************************************************************************/

function om_post_meta_box_scripts($hook) {
	if( 'post.php' != $hook && 'post-new.php' != $hook )
		return;
		
	wp_enqueue_script('om-admin-post-meta', TEMPLATE_DIR_URI . '/admin/js/post-meta.js', array('jquery'));

}
add_action('admin_enqueue_scripts', 'om_post_meta_box_scripts');
