<?php

/**
 * Config
 */

function om_ompf_plugin_config($config) {
	
	$config['include_isotope_js']=false;
	$config['theme_supplies_page_template']=true;
	$config['theme_supplies_portfolio_archive_template']=true;
	$config['theme_supplies_portfolio_single_template']=true;
	if(get_option(OM_THEME_PREFIX."lazyload") == 'true') {
		$config['enable_lazyload_markup']=true;
		$config['lazyload_placeholder']=TEMPLATE_DIR_URI . '/img/e.png';
	}
	if(get_option(OM_THEME_PREFIX . 'responsive') != 'true') {
		$config['responsive_mode']=false;
	}
	//$config['theme_support_width100']=true;
	//$config['single_page_image_sizes']['width100']['width']=5000;
	//$config['fit_thumbnails_height']=false;
	
	return $config;
	
}
add_filter('ompf_config','om_ompf_plugin_config');


/**
 * Portfolio template <-> display portfolio options
 */
 
function om_ompf_after_switch_theme($theme) {

	// apply Portfolio template for pages with "display portfolio" option enabled	
	if(isset($GLOBALS['omPortfolioPlugin'])) {
		$q = new WP_Query(array(
			'post_type' => 'page',
			'posts_per_page' => -1,
			'meta_query' => array(
				array(
					'key' => 'ompf_portfolio_display',
					'value' => '1',
				)
			)
		));
		if($q->post_count) {
			foreach($q->posts as $post) {
				update_post_meta($post->ID, '_wp_page_template', 'template-portfolio.php');
			}
		}
	}
	
}
add_action('after_switch_theme', 'om_ompf_after_switch_theme'); 


function om_ompf_save_post($post_id) {

	// if portfolio template chosen, "display portfolio" page meta should be also updated
	if(isset($_POST['page_template']) && $_POST['page_template'] == 'template-portfolio.php')
		update_post_meta($post_id, 'ompf_portfolio_display', '1');

}
add_action('save_post', 'om_ompf_save_post');

/**
 * Pagination, navigation
 */
 
function om_ompf_portfolio_paginate_links_template($template) {

	$template=array_merge($template,array(
		'before' => '<div class="navigation-pages wp-link-pages ompf-portfolio-pagination"><div class="navigation-pages-inner">',
		'after' => '</div><div class="clear"></div></div>',
		'before_item' => ' ',
		'after_item' => ' ',
	));
							
	return $template;
}
add_filter('ompf_portfolio_paginate_links_template','om_ompf_portfolio_paginate_links_template');

function om_ompf_portfolio_pagination($links_html, $links) {
	
	if(!empty($links)) {
		foreach($links as $v) {
			if(strpos($v,'<a') !== false) {
				$v_=str_replace("'>","'><span>",$v);
				$v_=str_replace('</a','</span></a',$v_);
				$links_html=str_replace($v,$v_,$links_html);
			}
		}
	}
	
	return $links_html;
	
}
add_filter('ompf_portfolio_pagination', 'om_ompf_portfolio_pagination', 10, 2);

function om_ompf_portfolio_paginate_links_arg($args) {
	
	$args['prev_text']='<span>&laquo;</span>';
	$args['next_text']='<span>&raquo;</span>';
	
	return $args;
	
}
add_filter('ompf_portfolio_paginate_links_arg', 'om_ompf_portfolio_paginate_links_arg');

function om_ompf_prev_next_single_navigation($template) {
	
	$template=array_merge($template,array(
		'before' => '<div class="navigation-prev-next">',
		'after' => '<div class="clear"></div></div>',
		'before_prev' => '<div class="navigation-prev">',
		'after_prev' => '</div>',
		'before_next' => '<div class="navigation-next">',
		'after_next' => '</div>',
		'title_tpl_prev' => '%title',
		'title_tpl_next' => '%title',
	));
	
	return $template;
}
add_filter('ompf_prev_next_single_navigation', 'om_ompf_prev_next_single_navigation');

/**
 * Helper
 */ 
 
function om_ompf_insert_before ($array, $key, $new) {
	$keys = array_keys($array);
	$pos = (int) array_search($key, $keys);
	return array_merge(
		array_slice($array, 0, $pos),
		$new,
		array_slice($array, $pos)
	);
}

/**
 * Gallery options
 */

function om_ompf_portfolio_meta_box($arr) {
	
	$arr['type']['fields']=om_ompf_insert_before($arr['type']['fields'], 'ompf_portfolio_gallery_columns', array(
		'ompf_portfolio_gallery_mode' => array (
			'name' => __('Gallery mode','om_theme'),
			'desc' => '',
			'id' => OM_THEME_SHORT_PREFIX.'gallery_mode',
			'type' => 'select',
			'std' => '',
			'options' => array(
				'' => __('Standard (slider)', 'om_theme'),
				'sliced' => __('Sliced', 'om_theme'),
				'masonry' => __('Masonry', 'om_theme'),
			),
			'code' => '
				<script>
					jQuery(function($){
						$("#ompf_portfolio_type").change(function(){
							if($(this).val() == "gallery") {
								$("#'.OM_THEME_SHORT_PREFIX.'gallery_mode").parents("tr").show();
							} else {
								$("#'.OM_THEME_SHORT_PREFIX.'gallery_mode").parents("tr").hide();
							}
						}).change();
					});
				</script>
			',
		),
		
		'ompf_portfolio_gallery_captions' => array (
			'name' => __('Gallery Image Captions','om_theme'),
			'desc' => '',
			'id' => OM_THEME_SHORT_PREFIX.'gallery_captions',
			'type' => 'select',
			'std' => '',
			'options' => array(
				'' => __('Hide', 'om_theme'),
				'true' => __('Display image captions', 'om_theme'),
			),
			'code' => '
				<script>
					jQuery(function($){
						$("#ompf_portfolio_type").change(function(){
							if($(this).val() == "gallery") {
								$("#'.OM_THEME_SHORT_PREFIX.'gallery_captions").parents("tr").show();
							} else {
								$("#'.OM_THEME_SHORT_PREFIX.'gallery_captions").parents("tr").hide();
							}
						}).change();
					});
				</script>
			', 
		),
		
	));
	
	unset($arr['type']['fields']['ompf_portfolio_gallery_columns']);
	
	global $om_page_meta_box;
	
	if(isset($om_page_meta_box['pagetitle']))
		$arr['pagetitle']=$om_page_meta_box['pagetitle'];

	if(isset($om_page_meta_box['slider']))
		$arr['slider']=$om_page_meta_box['slider'];	
	
	
	$arr['pagetemplate'] = array (
		'id' => 'ompf-portfolio-meta-box-page-template',
		'name' =>  __('Page template', 'om_portfolio'),
		'fields' => array (
			'ompf_page_template' => array ( "name" => __('Page template','om_portfolio'),
					'desc' =>  __('Use "100% Width" template in combination with "Full Width Custom Page" Portfolio Format and "Full Width Section" shortcode', 'om_portfolio'),
					"id" => "ompf_page_template",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Default', 'om_theme'),
						'100width' => __('100% Width', 'om_theme'),
					),
			),
		),
	);	
	
	return $arr;
} 
add_filter('ompf_portfolio_meta_box', 'om_ompf_portfolio_meta_box');

function om_ompf_single_media_gallery($args) {

	$size='post-media-large';
	//if(isset($args['width100']) && $args['width100'])
	//	$size='unlimit';
		
	$gallery = om_get_custom_gallery(
		get_the_ID(),
		array(
			'image_size' => $size,
			'show_captions' => (get_post_meta(get_the_ID(), OM_THEME_SHORT_PREFIX.'gallery_captions', true) == 'true'),
			'mode' => get_post_meta(get_the_ID(), OM_THEME_SHORT_PREFIX.'gallery_mode', true),
			'custom_gallery_field_name' => 'ompf_gallery',
		)
	);
	if($gallery) {
		echo '<div class="ompf-portfolio-gallery-block">'.$gallery.'</div>';
	}
	
}
add_filter('ompf_single_media_gallery','om_ompf_single_media_gallery');

function om_ompf_single_media_image_block($html, $arr) {
	
	//if($arr['width100'])
	//	return '<img src="'.$arr['img_src'].'" alt="'.esc_attr($arr['img_alt']).'" />';
	//else
		return om_hover_extras('<img src="'.$arr['img_src'].'" alt="'.esc_attr($arr['img_alt']).'" />', $arr['full_link']);

}
add_filter('ompf_single_media_image_block','om_ompf_single_media_image_block', 10, 2);

/**
 * 100% Width Media
 */

/* 
function om_ompf_portfolio_single_inner($html, $args) {
	
	if($args['width100']) {
		$html='';
		
		$html.='
					</div>
				</div>
			</div>
						
			<div class="container container-100width">
				<div class="container-inner">
					
					<div class="content-column-content">
						
						<div class="clear">&nbsp;</div>
							<div class="omsc-full-width-section"><div class="omsc-full-width-section-inner">
						
		';
		
		$html.=$args['header_html'].'<div class="ompf-portfolio-single-media">'.$args['media'].'</div>'.$args['footer_html'];

		$html.='
							</div></div>
						<div class="clear">&nbsp;</div>
					</div>
				</div>
			</div>
	
			<div class="container">
				<div class="container-inner">
					<div class="content-column-content">
						<div class="clear">&nbsp;</div>		
		';
		
		$html.=$args['header_html'].'<div class="ompf-portfolio-single-description"><div class="ompf-portfolio-single-description-inner">'.$args['terms'].$args['content'].'</div></div>'.$args['footer_html'];
	}
	
	return $html;
}
add_filter('ompf_portfolio_single_inner','om_ompf_portfolio_single_inner',10,2);
*/