<?php

$_OM_THEME_THUMBNAIL_SIZES=array(

	'unlimit' => array(
		'width' => false,
		'height' => false,
		'crop' => false
	),

	'post-media-small' => array(
		'width' => 346,
		'height' => false,
		'crop' => false
	),
	'post-media-medium' => array(
		'width' => 555,
		'height' => false,
		'crop' => false
	),
	'post-media-large' => array(
		'width' => 1160,
		'height' => false,
		'crop' => false
	),
	
	'sliced-gallery-1-1' => array(
		'width'=>1160,
		'height'=>0,
		'crop'=>false,
	),
	
	'sliced-gallery-2-1' => array(
		'width'=>383,
		'height'=>510,
		'crop'=>true,
	),
	'sliced-gallery-2-2' => array(
		'width'=>766,
		'height'=>510,
		'crop'=>true,
	),
	
	'sliced-gallery-3-1' => array(
		'width'=>766,
		'height'=>511,
		'crop'=>true,
	),
	'sliced-gallery-3-2' => array(
		'width'=>383,
		'height'=>250,
		'crop'=>true,
	),
	'sliced-gallery-3-3' => array(
		'width'=>383,
		'height'=>250,
		'crop'=>true,
	),
	
	'sliced-gallery-4-1' => array(
		'width'=>766,
		'height'=>670,
		'crop'=>true,
	),
	'sliced-gallery-4-2' => array(
		'width'=>383,
		'height'=>216,
		'crop'=>true,
	),
	'sliced-gallery-4-3' => array(
		'width'=>383,
		'height'=>216,
		'crop'=>true,
	),
	'sliced-gallery-4-4' => array(
		'width'=>383,
		'height'=>216,
		'crop'=>true,
	),
	
	'sliced-gallery-5-1' => array(
		'width'=>379,
		'height'=>252,
		'crop'=>true,
	),
	'sliced-gallery-5-2' => array(
		'width'=>379,
		'height'=>252,
		'crop'=>true,
	),
	'sliced-gallery-5-3' => array(
		'width'=>379,
		'height'=>252,
		'crop'=>true,
	),
	'sliced-gallery-5-4' => array(
		'width'=>574,
		'height'=>382,
		'crop'=>true,
	),
	'sliced-gallery-5-5' => array(
		'width'=>574,
		'height'=>382,
		'crop'=>true,
	),

	'masonry-gallery' => array(
		'width'=>383,
		'height'=>false,
		'crop'=>false,
	),	

);

/*************************************************************************************
 * Post gallery images
 *************************************************************************************/
 
if ( !function_exists( 'om_get_post_gallery_images' ) ) {
	function om_get_post_gallery_images($post_id, $params=array()) {

		$attachments=array();
		
		$gallery_field_name=OM_THEME_SHORT_PREFIX.'gallery';
		if(isset($params['custom_gallery_field_name']) && $params['custom_gallery_field_name'])
			$gallery_field_name=$params['custom_gallery_field_name'];
					
		$custom_gallery=get_post_meta($post_id, $gallery_field_name, true);
		if(is_array($custom_gallery) && $custom_gallery['type'] == 'custom') {
			
			$ids=explode(',',$custom_gallery['images']);
			if(!empty($ids)) {
				
				if(isset($params['only_first']) && $params['only_first'])
					$ids=array_slice($ids,0,1);

				$attachments = get_posts(array(
					'post_type' => 'attachment',
					'orderby' => 'post__in',
					'post__in' => $ids,
					'post_mime_type' => 'image',
					'post_status' => null,
					'numberposts' => -1
				));				
				
			}
			
		} else {
		
			$args=array(
				'orderby' => 'menu_order',
				'order' => 'ASC',
				'post_type' => 'attachment',
				'post_parent' => $post_id,
				'post_mime_type' => 'image',
				'post_status' => null,
				'numberposts' => -1,
			);
			if(isset($params['only_first']) && $params['only_first'])
				$args['numberposts']=1;

			if(get_option(OM_THEME_PREFIX.'exclude_featured_image') == 'true') {
				if( has_post_thumbnail($post_id) ) {
					$thumbid = get_post_thumbnail_id($post_id);
		
					$args['post__not_in']=array($thumbid);
				}
			}

			$attachments = get_posts($args);
			
		}

		return $attachments;
		
	}
}

/*************************************************************************************
 * Custom Gallery
 *************************************************************************************/


if ( !function_exists( 'om_custom_gallery' ) ) {
	function om_custom_gallery($attachments, $args=array()) {
		echo om_get_custom_gallery($attachments, $args);
	}
}

if ( !function_exists( 'om_get_custom_gallery' ) ) {
	function om_get_custom_gallery($attachments, $args=array()) {
		
		if(!isset($args['mode'])) {
			$args['mode']='slider';
		}
		
		if($args['mode'] == 'sliced') {
			return om_get_gallery_sliced($attachments, $args);
		} elseif($args['mode'] == 'masonry') {
			return om_get_gallery_masonry($attachments, $args);
		} else {
			return om_get_gallery_slider($attachments, $args);
		}
		
	}
}


/*************************************************************************************
 * Slides Gallery
 *************************************************************************************/

if ( !function_exists( 'om_gallery_slider' ) ) {
	function om_gallery_slider($attachments, $args=array()) { 
		
		echo om_get_gallery_slider($attachments, $args);
		
	}
}

if ( !function_exists( 'om_get_gallery_slider' ) ) {
	function om_get_gallery_slider($attachments, $args=array()) { 
		
		$args = wp_parse_args( $args, array(
			'image_size' => 'full',
			'show_captions' => false,
			'url_link' => false,
			'custom_gallery_field_name' => false,
			'link_to' => 'file',
		) );
	
		if(empty($attachments))
			return '';
			
		if(!is_array($attachments)) { // that means that passed not attachments array but post id
			$attachments=intval($attachments);
			if(!$attachments)
				return '';
			$attachments = om_get_post_gallery_images($attachments, array('custom_gallery_field_name' => $args['custom_gallery_field_name']) );
		}
		
		$out = '';
		
		if( !empty($attachments) ) {
			
			if($args['link_to'] == 'none' || $args['link_to'] == 'post') {
				$use_link=false;
			} else {
				$use_link = !(get_option(OM_THEME_PREFIX . 'prettyphoto_lightbox') == 'disabled_no_action');
			}
			$gallery_unique_id=rand(0,getrandmax());
			
			$out .= '<div class="custom-gallery gallery-slider'.($args['show_captions']?' gallery-with-captions':' gallery-without-captions').'"><div class="items">';
			$i=0;
			foreach( $attachments as $attachment ) {
		    $src_full = wp_get_attachment_image_src( $attachment->ID, 'full' );
		    
				$alt=trim(strip_tags( get_post_meta($attachment->ID, '_wp_attachment_image_alt', true) ));
				if ( empty($alt) )
					$alt = trim(strip_tags( $attachment->post_excerpt )); // If not, Use the Caption
				if ( empty($alt) )
					$alt = trim(strip_tags( $attachment->post_title )); // Finally, use the title
				
				$caption='';
				if($args['show_captions']) {
					$caption = trim(strip_tags( $attachment->post_excerpt ));
					if ( empty($caption) )
						$caption = trim(strip_tags( $attachment->post_title ));
				}
				
		    $src=om_img_resize($src_full[0], $args['image_size'], false);
		    if(!$src)
		    	$src=$src_full;
		    
		    if( get_option(OM_THEME_PREFIX . 'lazyload') == 'true' && $i > 0) {
		    	$img='<img height="'.$src[2].'" width="'.$src[1].'" src="'. TEMPLATE_DIR_URI .'/img/e.png" class="lazyload lazyload-hidden" data-original="'.$src[0].'" alt="'.esc_attr($alt).'" />';
		  	} else {
		  		$img='<img height="'.$src[2].'" width="'.$src[1].'" src="'.$src[0].'" alt="'.esc_attr($alt).'" />';
		  	}
		  	
		  	if($args['link_to'] == 'post') {
		  		$args['url_link']=get_permalink($attachment->ID);
		  	}
		  	
		    $img_html=om_hover_extras(
		    	$img.($caption!=''?'<span class="item-caption">'.$caption.'</span>':''),
		    	($use_link ? $src_full[0] : false),
		    	$args['url_link'],
		    	'rel="prettyPhoto[postgal_'.$gallery_unique_id.']"'
		    );
		    
	    	$out .= 
	    		'<div class="item" rel="slide-'.$attachment->ID.'">'.
	    			$img_html.
	    		'</div>
	    	';
	    	
	    	$i++;
			}
			$out .= '</div></div>';
		}
		
		return $out;
	}
}


/*************************************************************************************
 * Slides Gallery Sliced
 *************************************************************************************/

if ( !function_exists( 'om_gallery_sliced' ) ) {
	function om_gallery_sliced($attachments, $args=array()) {
		
		echo om_get_gallery_sliced($attachments, $args);
		
	}
}

if ( !function_exists( 'om_get_gallery_sliced' ) ) {
	function om_get_gallery_sliced($attachments, $args=array()) { 

		$args = wp_parse_args( $args, array(
			'only_1_row' => false,
			'show_captions' => false,
			'custom_gallery_field_name' => false,
			'link_to' => 'file',
			'url_link' => false,
		) );	
		
		if(empty($attachments))
			return '';

		if(!is_array($attachments)) { // that means that passed not attachments array but post id
			$attachments=intval($attachments);
			if(!$attachments)
				return '';
			$attachments = om_get_post_gallery_images($attachments, array('custom_gallery_field_name' => $args['custom_gallery_field_name']) );
		}
		
		$out = '';
		
		if( !empty($attachments) ) {
			$images_left=count($attachments);

			if($args['link_to'] == 'none' || $args['link_to'] == 'post') {
				$use_link=false;
			} else {
				$use_link = !(get_option(OM_THEME_PREFIX . 'prettyphoto_lightbox') == 'disabled_no_action');
			}
			$gallery_unique_id=rand(0,getrandmax());
			
			$out .= '<div class="gallery-sliced'.($args['show_captions']?' gallery-with-captions':' gallery-without-captions').'">';

			$row=1;
			while($images_left) {
				$n=$images_left;
				if($n > 5)
					$n=5;
				
				if($args['only_1_row'] && $row > 1) {
					
					// just output links for lightbox
					for($i=1;$i<=$n;$i++) {
						$attachment=current($attachments);
						$src_full = wp_get_attachment_image_src( $attachment->ID, 'full' );

						if($use_link)
				    	$out .= '<a href="'.$src_full[0].'" rel="prettyPhoto[postgal_'.$gallery_unique_id.']" class="dn"></a>';
				    	
						next($attachments);
						$images_left--;
					}
					
				} else {
					$out.= '<div class="gallery-sliced-box-row gallery-sliced-box-'.$n.'">';
					for($i=1;$i<=$n;$i++) {
						$attachment=current($attachments);
						$src_full = wp_get_attachment_image_src( $attachment->ID, 'full' );
						
						$alt=trim(strip_tags( get_post_meta($attachment->ID, '_wp_attachment_image_alt', true) ));
						if ( empty($alt) )
							$alt = trim(strip_tags( $attachment->post_excerpt )); // If not, Use the Caption
						if ( empty($alt) )
							$alt = trim(strip_tags( $attachment->post_title )); // Finally, use the title

						$caption='';
						if($args['show_captions']) {
							$caption = trim(strip_tags( $attachment->post_excerpt ));
							if ( empty($caption) )
								$caption = trim(strip_tags( $attachment->post_title ));
						}							
						
				    $src=om_img_resize($src_full[0], 'sliced-gallery-'.$n.'-'.$i, false);
				    if(!$src)
				    	$src=$src_full;
				    
				    if( get_option(OM_THEME_PREFIX . 'lazyload') == 'true' ) {
				    	$img='<img width="'.$src[1].'" height="'.$src[2].'" src="'. TEMPLATE_DIR_URI .'/img/e.png" data-original="'.$src[0].'" alt="'.htmlspecialchars($alt).'" class="lazyload" />';
				    } else {
				    	$img='<img width="'.$src[1].'" height="'.$src[2].'" src="'.$src[0].'" alt="'.htmlspecialchars($alt).'"/>';
						}

				  	if($args['link_to'] == 'post') {
				  		$args['url_link']=get_permalink($attachment->ID);
				  	}
				  	
						$img=om_hover_extras(
				    	$img.($caption!=''?'<span class="item-caption">'.$caption.'</span>':''),
				    	($use_link ? $src_full[0] : false),
				    	$args['url_link'],
				    	'rel="prettyPhoto[postgal_'.$gallery_unique_id.']"'
				    );
				    
				    $out .=	'<div class="img-box img-'.$i.'">' . $img . '</div>';

						next($attachments);
						$images_left--;
						
						if($n==5&&$i==3)
							$out .= '<div class="clear"></div>';
					}
					$out .= '<div class="clear"></div></div>';
				}
				$row++;
			}
			
			$out .= '</div>';
		}
		
		return $out;
	}
}

/*************************************************************************************
 * Masonry Gallery
 *************************************************************************************/

if ( !function_exists( 'om_gallery_masonry' ) ) {
	function om_gallery_masonry($attachments, $args=array()) { 
		
		echo om_get_gallery_masonry($attachments, $args);
		
	}
}

if ( !function_exists( 'om_get_gallery_masonry' ) ) {
	function om_get_gallery_masonry($attachments, $args=array()) { 
		
		$args = wp_parse_args( $args, array(
			/*'image_size' => 'masonry-gallery',*/
			'show_captions' => false,
			'custom_gallery_field_name' => false,
			'link_to' => 'file',
			'url_link' => false,
		) );
	
		if(empty($attachments))
			return '';
			
		if(!is_array($attachments)) { // that means that passed not attachments array but post id
			$attachments=intval($attachments);
			if(!$attachments)
				return '';
			$attachments = om_get_post_gallery_images($attachments, array('custom_gallery_field_name' => $args['custom_gallery_field_name']) );
		}
		
		$out = '';
		
		if( !empty($attachments) ) {

			if($args['link_to'] == 'none' || $args['link_to'] == 'post') {
				$use_link=false;
			} else {
				$use_link = !(get_option(OM_THEME_PREFIX . 'prettyphoto_lightbox') == 'disabled_no_action');
			}
			$gallery_unique_id=rand(0,getrandmax());
			
			$out .= '<div class="gallery-masonry'.($args['show_captions']?' gallery-with-captions':' gallery-without-captions').'"><div class="items">';
			foreach( $attachments as $attachment ) {
		    $src_full = wp_get_attachment_image_src( $attachment->ID, 'full' );
		    
				$alt=trim(strip_tags( get_post_meta($attachment->ID, '_wp_attachment_image_alt', true) ));
				if ( empty($alt) )
					$alt = trim(strip_tags( $attachment->post_excerpt )); // If not, Use the Caption
				if ( empty($alt) )
					$alt = trim(strip_tags( $attachment->post_title )); // Finally, use the title
				
				$caption='';
				if($args['show_captions']) {
					$caption = trim(strip_tags( $attachment->post_excerpt ));
					if ( empty($caption) )
						$caption = trim(strip_tags( $attachment->post_title ));
				}
				
		    $src=om_img_resize($src_full[0], 'masonry-gallery', false);
		    if(!$src)
		    	$src=$src_full;
		    
		    if( get_option(OM_THEME_PREFIX . 'lazyload') == 'true' ) {
		    	$img='<img height="'.$src[2].'" width="'.$src[1].'" src="'. TEMPLATE_DIR_URI .'/img/e.gif" data-original="'.$src[0].'" alt="'.htmlspecialchars($alt).'" class="lazyload" />';
		    } else {
		    	$img='<img height="'.$src[2].'" width="'.$src[1].'" src="'.$src[0].'" alt="'.htmlspecialchars($alt).'" />';
				}

		  	if($args['link_to'] == 'post') {
		  		$args['url_link']=get_permalink($attachment->ID);
		  	}
		  			    
		    $img_html=om_hover_extras(
		    	$img.($caption!=''?'<span class="item-caption">'.$caption.'</span>':''),
		    	($use_link ? $src_full[0] : false),
		    	$args['url_link'],
		    	'rel="prettyPhoto[postgal_'.$gallery_unique_id.']"'
		    );
		    
	    	$out .= 
	    		'<div class="item" rel="slide-'.$attachment->ID.'">'.
	    			$img_html.
	    		'</div>
	    	';
			}
			$out .= '</div><div class="clear"></div></div>';
		}
		
		return $out;
	}
}

/*************************************************************************************
 * Get Post Image
 *************************************************************************************/
/*
if ( !function_exists( 'om_get_post_image' ) ) {
	function om_get_post_image($post_id) { 
	
		$attachments = om_get_post_gallery_images($post_id, array(
			'only_first' => true
		));

		if( !empty($attachments) ) {
			foreach( $attachments as $attachment ) {
				
		    $src = wp_get_attachment_image_src( $attachment->ID, 'full' );
		    $src['alt'] = ( empty($attachment->post_content) ) ? $attachment->post_title : $attachment->post_content;
		    return $src;
			}
		}
		
		return false;
	}
}
*/
/*************************************************************************************
 * Image resize on fly
 *************************************************************************************/

if ( !function_exists( 'om_img_resize' ) ) {  
	function om_img_resize($url,$thumb_size,$single=true) {
		global $_OM_THEME_THUMBNAIL_SIZES;
		
		if(isset($_OM_THEME_THUMBNAIL_SIZES[$thumb_size]) && function_exists('omaq_resize')) {
			return omaq_resize($url,$_OM_THEME_THUMBNAIL_SIZES[$thumb_size]['width'],$_OM_THEME_THUMBNAIL_SIZES[$thumb_size]['height'],$_OM_THEME_THUMBNAIL_SIZES[$thumb_size]['crop'],$single);
		} else {
			if($single)
				return $url;
			else
				return false;
		}
	}
}

if ( !function_exists( 'om_img_custom_resize' ) ) {  
	function om_img_custom_resize($url, $width, $height = null, $crop = null, $single=true) {
		if(function_exists('omaq_resize')) {
			return omaq_resize($url,$width,$height,$crop,$single);
		} else {
			if($single)
				return $url;
			else
				return false;
		}
	}
}

if ( !function_exists( 'om_post_thumbnail' ) ) { 
	function om_post_thumbnail($thumb_size) {
		
		echo om_get_post_thumbnail($thumb_size);
		
	}
}

if ( !function_exists( 'om_get_post_thumbnail' ) ) { 
	function om_get_post_thumbnail($thumb_size, $single=true) {
		
		$html='';
		$full_image=false;
		$post_id=get_the_ID();
		$post_thumbnail_id = get_post_thumbnail_id( $post_id );
		if($post_thumbnail_id) {
			
			$image = wp_get_attachment_image_src($post_thumbnail_id, 'full');
			if($image) {
				$full_image=$image;
				list($src, $width, $height) = $image;
				$image_resized=om_img_resize($src, $thumb_size, false);
				if($image_resized) {
					list($src, $width, $height) = $image_resized;
				}
				$hwstring = image_hwstring($width, $height);
				$attachment = get_post($post_thumbnail_id);
				$default_attr = array(
					'src'   => $src,
					'class' => "attachment-".$thumb_size,
					'alt'   => trim(strip_tags( get_post_meta($post_thumbnail_id, '_wp_attachment_image_alt', true) )), // Use Alt field first
				);
				if ( empty($default_attr['alt']) )
					$default_attr['alt'] = trim(strip_tags( $attachment->post_excerpt )); // If not, Use the Caption
				if ( empty($default_attr['alt']) )
					$default_attr['alt'] = trim(strip_tags( $attachment->post_title )); // Finally, use the title

		    if( get_option(OM_THEME_PREFIX . 'lazyload') == 'true' ) {
		    	$default_attr['data-original']=$default_attr['src'];
		    	$default_attr['src']=TEMPLATE_DIR_URI .'/img/e.png';
		    	$default_attr['class'].=' lazyload';
		    }
		    
				$attr = $default_attr;
				$attr = apply_filters( 'wp_get_attachment_image_attributes', $attr, $attachment );
				$attr = array_map( 'esc_attr', $attr );
				$html = rtrim("<img $hwstring");
				foreach ( $attr as $name => $value ) {
					$html .= " $name=" . '"' . $value . '"';
				}
				$html .= ' />';
			}
			
		}
		
		if($single) {
			return $html;
		} else {
			return array(
				'html' => $html,
				'full_image' => $full_image,
			);
		}
			
	}
}

/*************************************************************************************
 * Hover Extras
 *************************************************************************************/

if ( !function_exists( 'om_hover_extras' ) ) { 
	function om_hover_extras($content, $zoom_link=false, $url_link=false, $zoom_link_attr='', $url_link_attr='') {
		
		$out='';
		
		if($zoom_link || $url_link ) {
			if($zoom_link && $url_link)
				$out.='<div class="hover-image-extra two-links">';
			else
				$out.='<div class="hover-image-extra single-link">';
			
				$out .= '<span class="back">'.$content.'</span>';
				$out .= '<span class="over">';
				if($zoom_link)
					$out.='<a href="'.$zoom_link.'" class="link-zoom" '.$zoom_link_attr.'></a>';
				if($url_link)
					$out.='<a href="'.$url_link.'" class="link-url" '.$url_link_attr.'></a>';
				$out.='</span>';
				
			$out.='</div>';
		} else {
			$out .= $content;
		}
		
		return $out;
		
	}
}

/*************************************************************************************
 * LazyLoad for inline images
 *************************************************************************************/

if(get_option(OM_THEME_PREFIX."lazyload") == 'true') { 
	
	if ( !function_exists( 'om_inline_lazyload' ) ) { 
		function om_inline_lazyload($content) {
			
			$matches = array();
			preg_match_all( '/<img\s+.*?>/', $content, $matches );
			
			$search = array();
			$replace = array();
	
			foreach ( $matches[0] as $imgHTML ) {
				
				if(strpos($imgHTML,'data-original=') !== false)
					continue;
					
				// replace the src and add the data-src attribute
				$replaceHTML = preg_replace( '/<img(.*?)src=/i', '<img$1data-original=', $imgHTML );
				
				// add the lazy class to the img element
				if ( preg_match( '/class=["\']/i', $replaceHTML ) ) {
					$replaceHTML = preg_replace( '/class=(["\'])(.*?)["\']/i', 'class=$1lazyload $2$1', $replaceHTML );
				} else {
					$replaceHTML = str_ireplace( '<img', '<img class="lazyload"', $replaceHTML );
				}
				
				array_push( $search, $imgHTML );
				array_push( $replace, $replaceHTML );
				
			}

							
			$content = str_replace( $search, $replace, $content);
			
			return $content;
		}
		add_filter('the_content', 'om_inline_lazyload');
	}
	
}