<?php

function om_template_custom_gallery_settings() {
	?>
	<script type="text/html" id="tmpl-om-gallery-settings">
		<label class="setting">
			<span>Gallery Layout</span>
			<select class="layout" name="layout" data-setting="layout">
				<?php
					$options = array(
						'default' => __('WordPress Default','om_theme'),
						'slider' => __('Slider','om_theme'),
						'sliced' => __('Sliced','om_theme'),
						'masonry' => __('Masonry','om_theme'),
					);
					
					foreach ( $options as $v => $n ) {
						?><option value="<?php echo esc_attr( $v ); ?>"><?php echo esc_html( $n ); ?></option><?php
					}
				?>
			</select>
		</label>
		<label class="setting">
			<span>Captions</span>
			<select class="captions" name="captions" data-setting="captions">
				<?php
					$options = array(
						'yes' => __('Display','om_theme'),
						'no' => __('Hide','om_theme'),
					);
					
					foreach ( $options as $v => $n ) {
						?><option value="<?php echo esc_attr( $v ); ?>"><?php echo esc_html( $n ); ?></option><?php
					}
				?>
			</select>
		</label>
	</script>
	
  <?php
}
add_action( 'print_media_templates', 'om_template_custom_gallery_settings' );


function om_gallery_settings_scripts($hook) {
	if( 'post.php' != $hook && 'post-new.php' != $hook )
		return;
	wp_enqueue_script('om-gallery-settings',TEMPLATE_DIR_URI.'/admin/js/om-gallery-settings.js', array( 'media-views' ), OM_THEME_VERSION	);
}
add_action('admin_enqueue_scripts', 'om_gallery_settings_scripts');


/**
 * Standard Gallery Shortcode
 */
 
function om_custom_gallery_shortcode($atts) {

	if((!isset($atts['layout']) || $atts['layout'] == 'default') && get_option(OM_THEME_PREFIX . 'do_replace_gallery') == 'true') {
		$atts['layout'] = 'sliced';
	}

	if(!isset($atts['layout']) || $atts['layout'] == 'default') {

		return '<div class="gallery-wrapper">'.gallery_shortcode($atts).'</div>';
		
	} else {
		
		if(!isset($atts['captions']))
			$atts['captions']='yes';
			
		if(!isset($atts['link']))
			$atts['link']='post';
		
		$args=array(
			'mode' => $atts['layout'],
			'show_captions' => ($atts['captions'] != 'no'),
			'link_to' => $atts['link'],
		);
		
		$attachments=false;
		if(isset($atts['ids']) && $atts['ids']) {
			$attachments=explode(',',$atts['ids']);
		}
		if(empty($attachments)) {
			global $post;
			if(isset($post) && is_object($post))
				$attachments=$post->ID;
		} else {
			$attachments = get_posts(array(
				'post_type' => 'attachment',
				'orderby' => (isset($atts['orderby']) && $atts['orderby'] == 'rand') ? 'rand' : 'post__in',
				'post__in' => $attachments,
				'post_mime_type' => 'image',
				'post_status' => null,
				'numberposts' => -1
			));	
		}

		return '<div class="om-inline-gallery-wrapper">'.om_get_custom_gallery($attachments, $args).'</div>';
		
	}
	
}
remove_shortcode('gallery', 'gallery_shortcode');
add_shortcode('gallery', 'om_custom_gallery_shortcode');