<?php


/*************************************************************************************
 *	Add MetaBox to Product page
 *************************************************************************************/

$om_bbpress_meta_box=array (

	'pagetitle' => array (
		'id' => 'om-bbpress-meta-box-pagetitle',
		'name' => __('Page Title', 'om_theme'),
		'fields' => array (
			array ( "name" => __('Page Title Layout','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."page_title",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Default (as in Theme Options)', 'om_theme'),
						'standard' => __('Standard', 'om_theme'),
						'hide' => __('Hide', 'om_theme'),
						'color' => __('Custom background color', 'om_theme'),
						'image' => __('Custom background image', 'om_theme'),
						'parallax' => __('Predefined parallax effect', 'om_theme'),
					),
					'code' => '<script>
						jQuery(function($){
							$("#'.OM_THEME_SHORT_PREFIX.'page_title").change(function(){
								$("#'.OM_THEME_SHORT_PREFIX.'title_align").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_margins").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_bg_color").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_text_color").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img_pos").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img_att").parents("tr").hide();
								$("#'.OM_THEME_SHORT_PREFIX.'title_parallax").parents("tr").hide();
								
								if($(this).val() == "standard") {
									$("#'.OM_THEME_SHORT_PREFIX.'title_align").parents("tr").show();
								} else if($(this).val() == "color") {
									$("#'.OM_THEME_SHORT_PREFIX.'title_align").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_margins").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_color").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_text_color").parents("tr").show();
								} else if($(this).val() == "image") {
									$("#'.OM_THEME_SHORT_PREFIX.'title_align").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_color").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img_pos").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_img_att").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_margins").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_text_color").parents("tr").show();
								} else if($(this).val() == "parallax") {
									$("#'.OM_THEME_SHORT_PREFIX.'title_align").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_bg_color").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_margins").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_text_color").parents("tr").show();
									$("#'.OM_THEME_SHORT_PREFIX.'title_parallax").parents("tr").show();
								}
							}).change();
						});
					</script>',
			),
			
			array ( "name" => __('Title align','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_align",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Left', 'om_theme'),
						'center' => __('Center', 'om_theme'),
					),
			),
			
			array ( "name" => __('Title Margins','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_margins",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Standard', 'om_theme'),
						'large' => __('Large', 'om_theme'),
						'xlarge' => __('X-Large', 'om_theme'),
					),
			),
			
			array ( "name" => __('Title background color','om_theme'),
					"desc" => __('To automatically apply theme Hightlight color from Theme Options type "theme" or click "default"'),
					"id" => OM_THEME_SHORT_PREFIX."title_bg_color",
					"type" => "color",
					"std" => 'theme',
			),
			
			array ( "name" => __('Title text color','om_theme'),
					"desc" => __('To automatically apply theme Hightlight color from Theme Options type "theme"'),
					"id" => OM_THEME_SHORT_PREFIX."title_text_color",
					"type" => "color",
					"std" => '#FFFFFF',
			),
			
			array ( "name" => __('Title background image','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_bg_img",
					"type" => "text_browse",
					"std" => '',
					"library" => 'image',
			),
			
			array ( "name" => __('Title background image position','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_bg_img_pos",
					"type" => "select",
					"std" => '',
          'options'=>array(
          	'repeat' => 'Repeat image',
          	'repeat_x_top' => 'Repeat-x image top',
          	'repeat_x_center' => 'Repeat-x image center',
          	'repeat_x_bottom' => 'Repeat-x image bottom',
          	'repeat_y_left' => 'Repeat-y image left',
          	'repeat_y_center' => 'Repeat-y image center',
          	'repeat_y_right' => 'Repeat-y image right',
          	'cover' => 'Cover',
          	'no_repeat_center' => 'No-Repeat Center',
          	'no_repeat_left_top' => 'No-Repeat Left Top',
          	'no_repeat_top' => 'No-Repeat Top',
          	'no_repeat_right_top' => 'No-Repeat Right Top',
          	'no_repeat_right' => 'No-Repeat Right',
          	'no_repeat_right_bottom' => 'No-Repeat Right Bottom',
          	'no_repeat_bottom' => 'No-Repeat Bottom',
          	'no_repeat_left_bottom' => 'No-Repeat Left Bottom',
          	'no_repeat_left' => 'No-Repeat Left',
          ),
			),
			
			array ( "name" => __('Title background image attachment','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_bg_img_att",
					"type" => "select",
					"std" => 'scroll',
          'options'=>array(
          	'scroll' => __('Scroll','om_theme'),
          	'fixed' => __('Fixed','om_theme'),
          ),
			),
			
			array ( "name" => __('Parallax effect','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."title_parallax",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Lines', 'om_theme'),
						'geometry' => __('Geometry', 'om_theme'),
						'circles' => __('Circles', 'om_theme'),
					),
			),

		),
	),
	
	'sidebar' => array (
		'id' => 'om-bbpress-meta-box-sidebar',
		'name' => __('Sidebar', 'om_theme'),
		'fields' => array (
			array ( "name" => __('Sidebar','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."sidebar_show",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Display Sidebar', 'om_theme'),
						'hide' => __('Hide Sidebar', 'om_theme'),
					)
			),

			array (
				'name' => __('Choose the sidebar','om_theme'),
				'desc' => '',
				'id' => OM_THEME_SHORT_PREFIX.'sidebar',
				'type' => 'sidebar',
				'std' => ''
			),

			array ( "name" => __('Page Individual Sidebar Position','om_theme'),
					"desc" => __('Normally sidebar position for all pages can be specified under "Appearance > Theme Options > Sidebars", but you can set sidebar position for current page manually.','om_theme'),
					"id" => OM_THEME_SHORT_PREFIX."sidebar_custom_pos",
					"type" => "select",
					"std" => '',
					'options' => array(
						'' => __('Default (As in "Theme Options")', 'om_theme'),
						'left' => __('Left Side', 'om_theme'),
						'right' => __('Right Side', 'om_theme'),
					)
			),
		),
	),
	
);

if( ommb_check_slider_exists() ){

	$om_wc_product_meta_box['slider'] = array (
		'id' => 'om-wp-product-meta-box-slider',
		'name' => __('Slider', 'om_theme'),
		'fields' => array (

			array (
				'name' => __('Choose the slider','om_theme'),
				'desc' => '',
				'id' => OM_THEME_SHORT_PREFIX.'slider_id',
				'type' => 'slider',
				'std' => ''
			),

			array ( "name" => __('Slider layout','om_theme'),
					"desc" => '',
					"id" => OM_THEME_SHORT_PREFIX."slider_layout",
					"type" => "select",
					"std" => 'boxed',
					'options' => array(
						'full' => __('Full width slider', 'om_theme'),
						'boxed' => __('Boxed width slider', 'om_theme'),
					)
			),
			
		),
	);
	
}

function om_add_bbpress_meta_box() {
	global $om_bbpress_meta_box;

	if(function_exists('bbp_get_forum_post_type'))
		ommb_add_meta_boxes($om_bbpress_meta_box, bbp_get_forum_post_type());
	
}
add_action('add_meta_boxes', 'om_add_bbpress_meta_box');

 
/*************************************************************************************
 *	Save MetaBox data
 *************************************************************************************/

function om_save_bbpress_metabox($post_id) {
	global $om_bbpress_meta_box;
 
	ommb_save_metabox($post_id, $om_bbpress_meta_box);

}
add_action('save_post', 'om_save_bbpress_metabox');
