<?php

if(!defined('ABSPATH')) die('-1');

class AwesomeLiveChat_Metabox extends AwesomeLiveChat
{
    /**
     * Boots object
     *
     * @since  1.0.0
     * @access private
     * @var object
     */
    private $Boots;

    /**
     * Settings/Options
     *
     * @since  1.0.0
     * @access private
     * @var array
     */
    private $Options;

    /**
     * Library
     *
     * @since  1.0.0
     * @access private
     * @var object
     */
    private $_;

    /**
     * Boots Metabox Extension
     *
     * @since  1.0.0
     * @access private
     * @var object
     */
    private $Metabox;

    /**
     * Get the Boots framework object.
     * Get the plugin settings.
     * Get the plugin library.
     *
     * @since  1.0.0
     * @uses   AwesomeLiveChat::boots()
     *         return boots object
     * @uses   AwesomeLiveChat::options()
     *         return options
     * @uses   AwesomeLiveChat_Library
     *         plugin library/helper
     * @access public
     * @param  void
     * @return void
     */
    public function __construct()
    {
        $this->Boots    = $this->boots();
        $this->Options  = $this->options();
        $this->_        = new AwesomeLiveChat_Library();
        $this->Metabox  = $this->Boots->Metabox;

        add_action('add_meta_boxes', array($this, 'meta'));

        // Woocommerce product save
        add_action('save_post', array($this, 'woocommerceProductMetaboxSave'));
    }

    public function meta()
    {
        global $post;
        $id = $post->ID;

        $Posttypes = get_post_types(array(
            'public' => true,
            '_builtin' => false
        ));
        $Posttypes[] = 'post';
        $Posttypes[] = 'page';

        $saved = $this->Boots->Database
            ->term('_alc_show')
            ->get($id);

        if($saved) $value = $saved;
        else
        {
            $Placement = $this->_->settings('general', 'placement');
            $Screen = get_current_screen();
            $value = in_array($Screen->post_type, $Placement)
                ? 'yes'
                : 'no';
        }

        // Manually show for woocommerce product type due to select2 bug.
        add_meta_box(
            'alc_metabox',
            'Awesome Live Chat',
            array($this, 'woocommerceProductMetabox'),
            'product',
            'side',
            'high',
            array($value)
        );

        $Posttypes = array_diff($Posttypes, array('product'));

        // For the rest, we will use boots metabox.
        $this->Metabox->create('alc_metabox', 'Awesome Live Chat')
        ->in($Posttypes)
        ->context('side')
        ->priority('high')
        ->add('select', array(
            'title' => __('Show Chat', 'awesome-live-chat'),
            'name'  => '_alc_show',
            'data'  => array(
                'yes'  => __('Yes', 'awesome-live-chat'),
                'no'   => __('No', 'awesome-live-chat')
            ), 'value' => $value
        ))->done();
    }

    public function woocommerceProductMetabox($product, $args)
    {
        wp_nonce_field('alc_metabox', 'alc_metabox_nonce');

        $value = $args['args'][0];

        echo '<h4>';
        _e('Show Chat', 'awesome-live-chat');
        echo '</h4>';
        echo '<label><input type="radio" name="_alc_show" value="yes"' . ($value == 'yes' ? ' checked="checked"' : '') . '> Yes</label>';
        echo '&nbsp;&nbsp;';
        echo '<label><input type="radio" name="_alc_show" value="no"' . ($value == 'no' ? ' checked="checked"' : '') . '> No</label>';
    }

    public function woocommerceProductMetaboxSave($id)
    {
        if (! isset($_POST['alc_metabox_nonce'])) {
            return $id;
        }

        if (! wp_verify_nonce($_POST['alc_metabox_nonce'], 'alc_metabox')) {
            return $id;
        }

        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $id;
        }

        if ($_POST['post_type'] !== 'product') {
            return $id;
        }

        if (! current_user_can('edit_post', $id)) {
            return $id;
        }

        $value = sanitize_text_field($_POST['_alc_show']);

        update_post_meta($id, '_alc_show', $value);
    }
}
new AwesomeLiveChat_Metabox();